<?php

namespace App\Modelos;

use Core\Database;

class TablerosListasTareas extends Database
{
    protected $table    = 'app_tableros_listas_tareas';
    protected $id       = 'tar_id';

    public function obtenerTareas(int $list_id)
    {
        return $this->consultar("SELECT tar_id, tar_nombre, tar_orden, tar_descripcion, tar_fecha_vencimiento, tar_hora_vencimiento, tar_recordatorio
        FROM app_tableros_listas_tareas        
        WHERE tar_listid = $list_id
        AND tar_eliminado = 0
        ORDER BY tar_orden DESC")->all();
    }

    public function obtenerTotalesItem(int $id_tar)
    {
        return $this->consultar("SELECT COUNT(item.item_estatus) total, item.item_estatus 
        FROM app_tableros_listas_tareas_checklist checklist
        JOIN app_tableros_listas_tareas_checklist_items item ON item.item_checklistid = checklist.checklist_id 
        WHERE checklist.checklist_tarid = $id_tar
        GROUP by item.item_estatus")->all();
    }

    public function obtenerCliente($id_tar)
    {
        return $this->consultar("SELECT cli_id, cli_dni, cli_razon_social
        FROM app_tableros_listas_tareas
        JOIN app_clientes ON cli_id = tar_cliente
        WHERE tar_id = $id_tar")->row();
    }

    public function rutaDocumento($id)
    {
        return $this->consultar("SELECT *
        FROM app_ruta_documento rd 
        JOIN app_documentos d ON d.doc_id = rd.rd_docid_conversion
        JOIN app_empleados emp ON emp.emp_id = rd.rd_empleadoid
        WHERE rd.rd_facid_procedencia = $id AND rd.rd_docid_procedencia  = 13")->all();
    }
}
