<?php

namespace App\Modelos;

use Core\Database;

class TablerosHistoricos extends Database
{
    protected $table    = 'app_tableros_historicos';
    protected $id       = 'tabhis_id';

    public function obtenerHistorico()
    {
        return $this->consultar("SELECT tabhis.*, einfo.einfo_nombres, einfo.einfo_apellidos, tab_nombre
        FROM $this->table tabhis
        JOIN app_tableros tab ON tab.tab_id = tabhis.tabhis_tabid
        JOIN app_empleados_info einfo ON einfo_id = tabhis_empid
        ORDER BY tabhis_fecha DESC")->all();
    }

    public function fechasHistoricosTablero(int $id_tablero)
    {
        return $this->consultar("SELECT DATE(tabhis_fecha) fecha, tabhis_fecha tiempo
        FROM app_tableros_historicos tabhis
        WHERE tabhis.tabhis_tabid = $id_tablero
        group by (DAYOFMONTH(tabhis_fecha))
        ORDER BY tabhis_fecha DESC")->all();
    }

    public function obtenerHistoricoTablero(int $id_tablero, string $fecha)
    {
        return $this->consultar("SELECT tabhis.*, einfo.einfo_nombres, einfo.einfo_apellidos, tab_nombre
        FROM $this->table tabhis
        JOIN app_tableros tab ON tab.tab_id = tabhis.tabhis_tabid
        JOIN app_empleados_info einfo ON einfo_id = tabhis_empid
        WHERE tabhis.tabhis_tabid = $id_tablero
        AND DATE(tabhis_fecha) = '$fecha'
        ORDER BY tabhis_fecha DESC")->all();
    }
}
