<?php

namespace App\Modelos;

use Core\Database;

class TablerosGrupos extends Database
{
    protected $table    = 'app_tableros_grupos';
    protected $id       = 'grup_id';

    public function obtenerGrupo($tab_id)
    {
        return $this->consultar("SELECT grup_id, grup_empid, grup_tabid, grup_creado, einfo_nombres nombre, einfo_apellidos apellido
        FROM app_tableros t
        JOIN app_tableros_grupos tg ON t.tab_id = tg.grup_tabid
        LEFT JOIN app_empleados ON emp_id = tg.grup_empid
        LEFT JOIN app_empleados_info ON emp_edatosid = einfo_id
        WHERE tg.grup_tabid = $tab_id")->all();
    }

    public function chequearAdministrador($tab_id, $emp_id)
    {
        return $this->consultar("SELECT grup_id, grup_empid, grup_tabid
        FROM app_tableros_grupos 
        WHERE grup_empid = $emp_id AND grup_tabid = $tab_id")->row();
    }
}
