<?php

namespace App\Modelos;

use Core\Database;

class Tableros extends Database
{
    protected $table    = 'app_tableros';
    protected $id       = 'tab_id';

    public function obtenerTableros()
    {
        $this->consultar("SET lc_time_names = 'es_ES'")->run();
        return $this->consultar("SELECT tab_id, tab_nombre, tab_color, tab_empid, tab.tab_actualizado modificacion, tab_favorite
        FROM app_tableros tab 
        WHERE tab_eliminado = 0
        ORDER BY tab.tab_actualizado DESC")->all();
    }

    public function buscarEmpleados(string $buscar)
    {
        $buscar = strtolower($buscar);
        return $this->consultar("SELECT emp_id, einfo_nombres, einfo_apellidos
        FROM app_empleados_info
        JOIN app_empleados ON einfo_id = emp_edatosid
        WHERE (LOWER(einfo_nombres) LIKE  '%$buscar%' OR LOWER(einfo_apellidos) LIKE '%$buscar%')")->all();
    }

    public function buscarMiembros(string $buscar, int $tar_id)
    {
        $buscar = strtolower($buscar);
        return $this->consultar("SELECT einfo_id, einfo_nombres, einfo_apellidos
        FROM app_empleados_info
        JOIN app_empleados ON einfo_id = emp_edatosid
        WHERE (LOWER(einfo_nombres) LIKE '%$buscar%' OR LOWER(einfo_apellidos) LIKE '%$buscar%')
        AND einfo_id NOT IN (SELECT miemb_empid_miembro FROM app_tableros_listas_tareas_miembros WHERE miemb_tarid = $tar_id)")->all();
    }

    public function buscarClientes(string $buscar)
    {
        $buscar = strtolower($buscar);
        $trozos = explode(" ", $buscar);
        $numero = count($trozos);
        if ($numero == 1) {
            $sql = "SELECT cli_id, cli_dni, cli_razon_social FROM app_clientes WHERE cli_estatus = 1 AND (LOWER(cli_dni) LIKE '%$buscar%' OR LOWER(cli_razon_social) LIKE '%$buscar%') LIMIT 50";
        } elseif ($numero > 1) {
            $sql = "SELECT cli_id, cli_dni, cli_razon_social, MATCH(cli_razon_social) AGAINST('$buscar') AS puntuacion 
            FROM app_clientes WHERE cli_estatus = 1 AND MATCH(cli_razon_social) AGAINST('$buscar') ORDER BY puntuacion DESC LIMIT 50";
        }
        return $this->consultar("$sql")->all();
    }

    public function obtenerIncidencias()
    {
        return $this->consultar("SELECT tab.tab_id, tab.tab_nombre, tablist_orden, list.tablist_nombre, DATE_FORMAT(tar.tar_creado, '%d-%m-%Y') fecha, tar.tar_id, tar.tar_nombre, cli.cli_razon_social
        FROM app_tableros tab
        JOIN app_tableros_listas list ON list.tablist_tabid = tab.tab_id 
        JOIN app_tableros_listas_tareas tar ON tar.tar_listid = list.tablist_id 
        LEFT JOIN app_clientes cli ON cli.cli_id = tar.tar_cliente 
        WHERE YEAR(tar.tar_creado) = YEAR(CURRENT_DATE())
        ORDER BY tab_id,tar_actualizado desc")->all();
    }

    public function administradorTablero(int $id_tablero)
    {
        return $this->consultar("SELECT tab_administrador
        FROM app_tableros 
        WHERE tab_id = $id_tablero")->row();
    }

    public function obtenerVencimientos()
    {
        return $this->consultar("SELECT tab.tab_id, tab.tab_nombre, tablist_orden, list.tablist_nombre, tar.tar_creado, tar_actualizado, tar.tar_nombre, tar.tar_fecha_vencimiento
        FROM app_tableros tab
        JOIN app_tableros_listas list ON list.tablist_tabid = tab.tab_id 
        JOIN app_tableros_listas_tareas tar ON tar.tar_listid = list.tablist_id         
        WHERE tar.tar_fecha_vencimiento is not null
        ORDER BY tar.tar_dia_vencimiento")->all();
    }

    public function obtenerFavorito()
    {
        $this->consultar("SET lc_time_names = 'es_ES'")->run();
        return $this->consultar("SELECT tab_id, tab_nombre, tab_color, tab_empid, tab.tab_actualizado modificacion
        FROM app_tableros tab 
        WHERE tab_eliminado = 0 AND tab_favorite=1
        ORDER BY tab.tab_actualizado DESC")->all();
    }
}
