<?php

namespace App\Controladores;

use Core\Librerias\Solicitud;
use Core\ManejadorSession;
use Core\Vista;
use App\Modelos\Generico;

final class SeleccionControlador
{
    public function index()
    {
        if (!isset($_SESSION['user_data']['emp_id'])) {
            header('Location: ' . ruta_base());
        }
        
        $generico = new Generico();
        exit(Vista::viewAJAX('seleccion/seleccion', [
            'sucursales' => $generico->obtenerSucursalesTodos($_SESSION['user_data']['emp_id']),
            'todosucursales' => $generico->consultar("SELECT * FROM app_permissions_actions WHERE emp_id = {$_SESSION['user_data']['emp_id']} AND module_id = 'facturacion' AND action_id = 'todosucursales'")->row()
        ]));
    }

    public function acceso()
    {
        $solicitud = new Solicitud();
        $id = $solicitud->sanitize($_POST['sucursal'], FILTER_VALIDATE_INT);

        return ManejadorSession::seleccionarSucursal($id);
    }

    public function salir()
    {
        return ManejadorSession::destruirSession();
    }
}
