<div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal_buscar_cliente">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Buscar o registrar clientes</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <v-select id="tututut" v-model="selected_cli" label="cliente" :filterable="false" :options="clientes" @search="onSearch" @input="seleccioncliente()">
                        <template slot="no-options">
                            Escribe para buscar el cliente
                        </template>
                        <template slot="option" slot-scope="option">
                            <div class="d-flex ml-0 pl-0">
                                <div class="flex-1 pt-1 ml-2">
                                    <h6 class="fw-bold mb-1"><b class="">{{ option.dni }}</b> {{ option.cliente.toUpperCase() }}</h6>
                                </div>
                            </div>
                        </template>
                    </v-select>
                </div>
            </div>
            <form action="#" autocomplete="off" @submit.prevent="guardarCliente">
                <div class="modal-body" v-show="!clienteEncontrado">
                    <div class="form-row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="tipodoc">Tipo de documento:</label>
                                <select class="form-control" v-model="dataForm.cli_tipodoc" @change="formatearSelect()">
                                    <option value="" disabled>selecione un documento</option>
                                    <?php foreach ($tipos_de_documentos as $row) : ?>
                                        <option value="<?= $row['tipodoc_id'] ?>"><?= $row['tipodoc_codigo'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="dni">Nº de documento:</label>
                                <div class="input-group">
                                    <input type="text" id="dni" v-if="dataForm.cli_tipodoc==2" name="cli_dni" class="form-control" v-mask="'A########'" v-model="dataForm.cli_dni" @keyup="dataForm.cli_dni='V'+dataForm.cli_dni.toUpperCase()">
                                    <input type="text" id="dni" v-else name="cli_dni" class="form-control" v-mask="'A#########'" v-model="dataForm.cli_dni" @keyup="dataForm.cli_dni=dataForm.cli_dni.toUpperCase()">
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button" id="btncne" @click="cne()">CNE</button>
                                    </div>
                                </div>
                                <small class="form-text text-muted" v-if="dataForm.cli_tipodoc==2">V00000000</small>
                                <small class="form-text text-muted" v-if="dataForm.cli_tipodoc==3">J000000000</small>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="razon_social">Razón social:</label>
                        <input type="text" id="razon_social" class="form-control" v-model="dataForm.cli_razon_social" maxlength="150" @keyup="dataForm.cli_razon_social=dataForm.cli_razon_social.toUpperCase()">
                    </div>
                    <div class="form-row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="telefono">Teléfono:</label>
                                <input type="tel" v-mask="'(####) ###-####'" id="telefono" class="form-control" v-model="dataForm.cli_telefono">
                                <small class="form-text text-muted">(0000) 000-0000</small>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="correo">Correo electrónico:</label>
                                <input type="text" id="correo" class="form-control" v-model="dataForm.cli_email">
                                <small class="form-text text-muted">usuario@ejemplo.com</small>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="direccion_uno">Dirección:</label>
                        <input type="text" id="direccion_uno" class="form-control" v-model="dataForm.cli_direccion">
                    </div>
                    <div class="form-check">
                        <label class="form-check-label">
                            <input class="form-check-input" type="checkbox" value="TRUE" v-model="dataForm['cli_natural']">
                            <span class="form-check-sign">Persona natural (no jurídica)</span>
                        </label>
                    </div>
                    <div class="alert alert-warning" v-if="errorForm.length>0">
                        <h4 class="alert-heading">Por favor, corrija el(los) siguiente(s) error(es):</h4>
                        <p class="mb-1" v-for="row in errorForm">{{ row }}</p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary  btn-sm" data-dismiss="modal">Cerrar</button>
                    <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                        <i class="loader loader-info"></i>
                    </button>
                    <button v-else type="submit" class="btn btn-primary  btn-sm">Registrar</button>
                </div>
            </form>
        </div>
    </div>
</div>