<form autocomplete="off" id="modal_form_pagar" @submit.prevent="pagar">
    <div class="modal fade" id="modal_pagar" role="dialog" tabindex="-1" aria-labelledby="pagar" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Pagar Compra</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row col-sm-12" style="margin: 0 auto;">
                        <div class="col-sm-4 mb-2">
                            <?php if ($cambiar_factor) : ?>
                                <div class="card card-invoice mb-2" v-if="divisa_predeterminada!=divisa_pagar && divisa_pagar==1">
                                    <div class="invoice-detail">
                                        <div class="invoice-top text-center" style="background-color: rgba(222, 222, 222, 0.4);">
                                            <h6 class="title"><strong>Factor</strong></h6>
                                        </div>
                                        <div class="invoice-item">
                                            <fieldset class="form-group row">
                                                <div class="col m-2">
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <div class="input-group-text btn-light" id="num"><i class="fa fa-balance-scale"></i></div>
                                                        </div>
                                                        <input type="text" name="factor" class="form-control" id="monto_factor" v-money="moneyPagar" v-model="div_conv_factor" @keyup="factor_b">
                                                    </div>
                                                </div>
                                            </fieldset>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <h5 class="title"><strong>Detalles del Pago</strong></h5>
                            <div class="card card-invoice">
                                <div class="card-body" style="width: 100%; padding: 0.5rem">
                                    <div class="invoice-detail" v-if="creditos.length > 0">
                                        <div class="invoice-top text-center" style="background-color: rgba(222, 222, 222, 0.4);">
                                            <h6 class="title"><strong>Credito</strong></h6>
                                        </div>
                                        <div class="invoice-item">
                                            <fieldset class="form-group row">
                                                <div class="col">
                                                    <div class="form-check form-check-inline">
                                                        <input v-model="select_credito" class="form-check-input" type="radio" name="credito" id="credito" value="" @change="pagarConCredito">
                                                        <label class="form-check-label" for="credito">
                                                            Ninguno
                                                        </label>
                                                    </div>
                                                    <div class="form-check form-check-inline" v-for="row in creditos">
                                                        <input v-model="select_credito" class="form-check-input" type="radio" name="credito" id="credito" :value="row.id" @change="pagarConCredito">
                                                        <label class="form-check-label" for="credito">
                                                            {{ row.monto }}
                                                        </label>
                                                    </div>
                                                </div>
                                            </fieldset>
                                        </div>
                                    </div>
                                    <div id="contenerdor_campos_pagar" v-show="ver_contenedor_campos_pagar">
                                        <div class="invoice-detail">
                                            <div class="invoice-top text-center" style="background-color: rgba(222, 222, 222, 0.4);">
                                                <h6 class="title"><strong>Divisa</strong></h6>
                                            </div>
                                            <div class="invoice-item">
                                                <fieldset class="form-group row">
                                                    <div class="col">
                                                        <?php foreach ($divisas as $row) : ?>
                                                            <div class="form-check form-check-inline">
                                                                <input v-model="divisa_pagar" class="form-check-input" type="radio" name="divisa" id="divisa1" value="<?= $row['div_id'] ?>" @change="obtenerMetodosSegunDivisa()">
                                                                <label class="form-check-label" for="divisa1">
                                                                    <?= $row['div_nombre'] ?>
                                                                </label>
                                                            </div>
                                                        <?php endforeach; ?>
                                                    </div>
                                                </fieldset>
                                            </div>
                                        </div>
                                        <div class="invoice-detail">
                                            <div class="invoice-top text-center" style="background-color: rgba(222, 222, 222, 0.4);">
                                                <h6 class="title"><strong>Método de Pago</strong></h6>
                                            </div>
                                            <div class="invoice-item">
                                                <fieldset class="form-group row">
                                                    <div class="col">
                                                        <div class="form-check" v-for="row in metodos_de_pagos">
                                                            <input class="form-check-input" type="radio" v-model="metodo_pagar" name="metodo" id="metodo1" :value="row.md_id" @change="obtenerCuentasSegunMetodo()">
                                                            <label class="form-check-label" for="metodo1">
                                                                {{ row.mp_nombre }}
                                                            </label>
                                                        </div>
                                                    </div>
                                                </fieldset>
                                            </div>
                                        </div>
                                        <div class="invoice-detail">
                                            <div class="invoice-top text-center" style="background-color: rgba(222, 222, 222, 0.4);">
                                                <h6 class="title"><strong>Cuenta</strong></h6>
                                            </div>
                                            <div class="invoice-item">
                                                <fieldset class="form-group row">
                                                    <div class="col">
                                                        <div class="form-check" v-for="row in cuentas">
                                                            <input class="form-check-input" type="radio" name="cuenta" id="cuenta1" :value="row.cmp_id" v-model="cuenta_pagar" @change="obtenerNombreCuenta()">
                                                            <label class="form-check-label" for="metodo1">
                                                                {{ row.bc_alias }} - {{ row.bc_tipo }} - {{ row.ban_codigo }}
                                                            </label>
                                                        </div>
                                                    </div>
                                                </fieldset>
                                            </div>
                                        </div>
                                        <div class="invoice-detail">
                                            <div class="invoice-top text-center" style="background-color: rgba(222, 222, 222, 0.4);">
                                                <h6 class="title"><strong>Referencia Operación</strong></h6>
                                            </div>
                                            <div class="invoice-item">
                                                <fieldset class="form-group row">
                                                    <div class="col">
                                                        <div class="input-group">
                                                            <div class="input-group-prepend">
                                                                <div class="input-group-text btn-light" id="num">#</div>
                                                            </div>
                                                            <input type="text" name="referencia" class="form-control" v-model="referencia" style="text-align: right;">
                                                        </div>
                                                    </div>
                                                </fieldset>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-8">
                            <div class="row" style="border-bottom: 1px solid rgb(222, 222, 222);">
                                <div class="col-sm-4" style="border-right: 1px solid rgb(222, 222, 222);">
                                    <h6 class="title text-center"><strong>Total Factura</strong></h6>
                                    <h6 class="title text-right text-info"><strong>{{ moneda(total_pagar, this.moneyPagar.locale, this.moneyPagar.prefix, this.moneyPagar.precision) }}</strong></h6>
                                    <p class="title text-right text-info mb-1" v-for="row1 in factor_divisas">({{ moneda(total_pagar * row1.factor, row1.div_locale, row1.div_simbolo, row1.div_decimal) }})</p>
                                </div>
                                <div class="col-sm-4" style="border-right: 1px solid rgb(222, 222, 222);">
                                    <h6 class="title text-center"><strong>Total Pagado</strong></h6>
                                    <h6 class="title text-right text-primary"><strong>{{ moneda(total_pagado_div, this.moneyPagar.locale, this.moneyPagar.prefix, this.moneyPagar.precision) }}</strong></h6>
                                    <p class="title text-right text-primary mb-1" v-for="row2 in factor_divisas">({{ moneda(total_pagado_div * row2.factor, row2.div_locale, row2.div_simbolo, row2.div_decimal) }})</p>
                                </div>
                                <div class="col-sm-4" @click="colocarEnMonto" style="cursor: pointer;">
                                    <h6 class="title text-center"><strong>Total Pendiente</strong></h6>
                                    <h6 class="title text-right text-danger"><strong>{{ balance }}</strong></h6>
                                    <p class="title text-right text-danger mb-1" v-for="row3 in factor_divisas">({{ moneda(balance_n * row3.factor, row3.div_locale, row3.div_simbolo, row3.div_decimal) }})</p>
                                </div>
                            </div>
                            <div class="row" style="border-bottom: 1px solid rgb(222, 222, 222);">
                                <div class="row mt-2 col-12" style="background-color: rgba(222, 222, 222, 0.4); margin: 0 auto;">
                                    <h5 class="title text-center mb-0" style="font-size: 18px;"><strong>Pago: </strong>{{divisa_nombre}} - {{metodo_nombre}} - {{cuenta_nombre}}</h5>
                                </div>
                                <div class="row mt-2" v-if="estatus!=1">
                                    <div class="col">
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text btn-light" id="rif"><small>Monto ($)</small></div>
                                            </div>
                                            <input type="text" id="pagarmonto" name="pagarmonto" class="form-control" style="text-align: right; font-size: 50px;" v-money="moneyPagar" v-model="monto" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="row col-sm-12 mt-2 mb-2" v-if="diferencia_n > 0">
                                    <div class="input-group">
                                        <div class="form-check">
                                            <input type="checkbox" class="form-check-input" id="exampleCheck1" v-model="generar_credito" @click="borrarSeleccionCredito()">
                                            <label class="form-check-label" for="exampleCheck1">Generar credito</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row col-sm-12 mt-2 mb-2" v-if="diferencia_n > 0 && divisa_pagar==2">
                                    <div class="input-group">
                                        <div class="form-check">
                                            <input type="checkbox" class="form-check-input" id="exampleCheck1" v-model="compra_dolares" @click="borrarSeleccionCompra()">
                                            <label class="form-check-label" for="exampleCheck1">Compra de dolares</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col row mt-2 mb-2" v-if="diferencia_n > 0 && compra_dolares==true">
                                    <br>
                                    <b class="badge badge-danger ml-2 mb-1" style="font-size: 16px;" v-for="row3 in factor_divisas">PAGAR $ {{pagomovil}}= {{ moneda(pagomovil * row3.factor, row3.div_locale, row3.div_simbolo, row3.div_decimal) }}</b>
                                    <template>
                                        <div class="multi-text">
                                            <div class="form-inputs">
                                                <div class="row" v-for="(campo, index) in campos" :key="index">
                                                    <div class="col-sm-6 m-2">
                                                        <div class="form-group form-floating-label" v-if="diferencia_n > 0" v-show="ver_contenedor_campos_pagar">
                                                            <label for="pagarcuenta" class="placeholder">Cuenta </label>
                                                            <select class="form-control input-border-bottom" v-model="campo.id" id="pagarDolares">
                                                                <option disabled value="">Seleccione una cuenta</option>
                                                                <?php foreach ($cuentaCompraBolivares as $row) : ?>
                                                                    <option value="<?= $row['cmp_id'] ?>"><?= $row['bc_alias'] . '-' . $row['bc_tipo'] . '-' . $row['ban_codigo']; ?></option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-3 m-2">
                                                        <div class="form-group form-floating-label" v-if="diferencia_n > 0" v-show="ver_contenedor_campos_pagar">
                                                            <label for="descontarcuenta" class="placeholder">Descontar </label>
                                                            <input type="text" v-money="moneyBs" class="form-control input-border-bottom" v-model="campo.valor" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-2  m-2">
                                                        <br><br>
                                                        <div class="form-group form-floating-label" v-if="diferencia_n > 0" v-show="ver_contenedor_campos_pagar">
                                                            <button type="button" class="btn-sm btn-danger" title="Quitar" @click.prevent="deleteValue(index)" v-show="numeroCampos > 1">
                                                                <i class="fa fa-trash"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-sm-3">
                                                        <button type="button" class="btn-sm btn-primary" title="Añadir" @click.prevent="addValue">
                                                            <i class="fa fa-plus"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </template>
                                </div>
                                <div class="row col-sm-12 mt-2 mb-2" style="margin: 0 auto;" v-if="estatus==2">
                                    <button class="btn btn-primary btn-round btn-block" disabled v-if="cargando">
                                        <i class="loader loader-info"></i>
                                    </button>
                                    <button type="submit" id="btn_pagar" class="btn btn-primary btn-block" title="Pagar">Pagar</button>
                                </div>
                                <div class="row col-sm-12 mt-2 mb-2" style="margin: 0 auto;">
                                    <button type="button" @click="modal_imprimir" class="btn btn-info btn-border btn-block"><i class="fas fa-print"></i> Imprimir</button>
                                </div>
                            </div>
                            <div class="row mb-2" v-if='abonos.length > 0'>
                                <div class="row mt-2 col-12 d-flex justify-content-center" style="background-color: rgba(222, 222, 222, 0.4); margin: 0 auto;">
                                    <h5 class="title text-center mb-0"><strong>Resumen de Pagos</strong></h5>
                                </div>
                                <div class="row col mt-2" style="margin: 0 auto;">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-sm">
                                            <thead>
                                                <tr>
                                                    <th></th>
                                                    <th class="text-center">Fecha</th>
                                                    <th class="text-center">Pago</th>
                                                    <th class="text-center">Monto</th>
                                                    <th class="text-center">Factor</th>
                                                    <th class="text-center">Referencia</th>
                                                    <th class="text-center">Monto</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="row in abonos" :class="[row.fab_retiro == 1 ? 'bg-danger': '', row.credito == '1' ? 'bg-primary': '']">
                                                    <td>
                                                        <?php if ($eliminar_pago) : ?>
                                                            <a v-if="row.fab_retiro==0 && row.credito != '1'" href="#" @click.prevent="eliminarPago(row.fab_id)">
                                                                <i class="fa fa-trash text-danger"></i>
                                                            </a>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="text-center">{{ row.fab_fecha }}</td>
                                                    <td><small>{{ row.bc_alias }}</small></td>
                                                    <td class="text-center">{{ row.fab_monto }}</td>
                                                    <td class="text-center">{{row.fab_factor}}</td>
                                                    <td class="text-center">{{row.referencia}}</td>
                                                    <td class="text-right">{{ row.fab_conversion }}</td>
                                                </tr>
                                                <tr>
                                                    <th colspan="6" class="text-right text-primary">Total Pagado</th>
                                                    <th class="text-right text-primary">{{ moneda(total_pagado, money.locale, money.prefix, money.precision) }}</th>
                                                </tr>
                                                <tr>
                                                    <th colspan="6" class="text-right text-danger">Vuelto</th>
                                                    <th class="text-right text-danger">{{ diferencia }}</th>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-2" v-if='ComprarDolares.length > 0'>
                                <div class="row mt-2 col-12 d-flex justify-content-center" style="background-color: rgba(222, 222, 222, 0.4); margin: 0 auto;">
                                    <h5 class="title text-center mb-0"><strong>Compra de dolares</strong></h5>
                                </div>
                                <div class="row col mt-2" style="margin: 0 auto;">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-sm">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">Fecha</th>
                                                    <th class="text-center">Pago</th>
                                                    <th class="text-center">Monto</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="row in ComprarDolares">
                                                    <td class="text-center">{{ row.fab_fecha }}</td>
                                                    <td><small>{{ row.bc_alias }}</small></td>
                                                    <td class="text-center">{{ moneda(row.fab_monto, row.div_locale, row.div_simbolo, row.div_decimal) }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                        <button type="button" @click.prevent="modalCorreo" class="btn btn-info btn-border"><i class="far fa-envelope"></i> Enviar correo</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>