<div class="container" id="AppProveedores" v-cloak>
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Proveedores</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('proveedores') ?>">Proveedores</a>
                </li>
            </ul>
            <div class="ml-md-auto" style="display: flex;">
                <div class="dropdown d-inline mr-3 mr-md-2">
                    <button class="btn btn-info btn-border btn-round dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        Acciones
                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton" x-placement="top-start" style="position: absolute; transform: translate3d(0px, -7px, 0px); top: 0px; left: 0px; will-change: transform;">
                        <a class="dropdown-item" href="<?= url('fabricantes') ?>">Fabricantes</a>
                        <a class="dropdown-item" href="<?= url('categorias') ?>">Categorias</a>
                        <a class="dropdown-item" href="<?= url('tarifas') ?>">Tarifas</a>
                        <a class="dropdown-item" href="<?= url('almacenes') ?>">Almacenes</a>
                    </div>
                </div>
                <a href="<?= url('proveedores/crear'); ?>" class="btn btn-info btn-border btn-round mr-2">Nuevo proveedor</a>
                <a href="<?= url('proveedores/lista'); ?>" class="btn btn-secondary btn-round mr-2"><i class="fas fa-question-circle"></i> Lista de proveedores</a>
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <div class="table-responsive" :class="cargando_tabla">
                    <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_proveedores">
                        <thead>
                            <tr>
                                <th>Código</th>
                                <th>Nº identificacion</th>
                                <th>Nombre</th>
                                <th>Teéfono</th>
                                <th>Correo</th>
                                <th class="text-center">Estatus</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in proveedores">
                                <td><a :href="'proveedores/editar/'+row.id">{{ row.codigo }}</a></td>
                                <td>{{ row.identificacion }}</td>
                                <td>{{ row.proveedor }}</td>
                                <td>{{ row.telefono }}</td>
                                <td>{{ row.correo }}</td>
                                <td class="text-center">
                                    <a href="#" title="Modificar estatus" @click.prevent="modificarEstatus(row)">
                                        <i :class="row.estatus ? 'fa fa-check text-success' : 'fa fa-times text-danger'"></i>
                                    </a>
                                </td>
                                <td>
                                    <div class="form-button-action">
                                        <div class="input-group-append">
                                            <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                            <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                <a class="dropdown-item" href="#" @click.prevent="cliente(row)">Cliente</a>
                                                <a class="dropdown-item" href="#" @click.prevent="eliminar(row)">Eliminar</a>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="<?= ruta_base() ?>public/assetsvuejs/proveedores/proveedores.js"></script>
