<style>
    tr.group,
    tr.group:hover {
        background-color: #c1bfba !important;
    }
</style>
<div class="container" id="AppEditarProveedor" v-cloak>
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Proveedores</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('proveedores') ?>">Proveedores</a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= ruta_base() ?>proveedores/editar/<?= $proveedor ?>">{{ dataForm.razonsocial }}</a>
                </li>
            </ul>
        </div>
        <div class="row">
            <div class="col-sm-2">
                <div class="nav flex-column nav-pills nav-secondary nav-pills-no-bd nav-pills-icons" id="v-pills-tab-with-icon" role="tablist" aria-orientation="vertical">
                    <a class="nav-link active" id="v-pills-home-tab-icons" data-toggle="pill" href="#tab_datos" role="tab" aria-controls="tab_datos" aria-selected="true">
                        <i class="flaticon-user-4"> </i>
                        Datos
                    </a>
                    <a class="nav-link" id="v-pills-profile-tab-icons" data-toggle="pill" href="#tab_general" role="tab" aria-controls="tab_general" aria-selected="false">
                        <i class="far fa-chart-bar"></i>
                        Reporte General
                    </a>
                    <a class="nav-link" id="v-pills-profile-tab-icons" data-toggle="pill" href="#tab_facturas" role="tab" aria-controls="tab_facturas" aria-selected="false" @click.prevent="obtenerFacturas">
                        <i class="flaticon-interface-6"></i>
                        Facturas
                    </a>
                    <a class="nav-link" id="v-pills-profile-tab-icons" data-toggle="pill" href="#tab_notas" role="tab" aria-controls="tab_notas" aria-selected="false" @click.prevent="obtenerNotasdeEntrega">
                        <i class="flaticon-interface-6"></i>
                        Notas de entrega
                    </a>
                    <a class="nav-link" id="v-pills-profile-tab-icons" data-toggle="pill" href="#tab_abonos" role="tab" aria-controls="tab_abonos" aria-selected="false" @click.prevent="">
                        <i class="far fa-chart-bar"></i>
                        Abonos
                    </a>
                </div>
            </div>
            <div class="col-sm-10">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="tab_datos" role="tabpanel">
                        <form autocomplete="off" @submit.prevent="guardar">
                            <input type="hidden" value="<?= $proveedor ?>" id="id_proveedor" />
                            <div class="card">
                                <div class="card-body">
                                    <div class="form-row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Código</label>
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text"><i class="fas fa-hashtag fa-fw"></i></span>
                                                    </div>
                                                    <input type="text" class="form-control" v-model="dataForm.codigo">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="tipoidfiscal">Id. Fiscal</label>
                                                <select id="tipoidfiscal" class="form-control" v-model="dataForm.tipoidfiscal">
                                                    <option disabled value="">Seleccione un elemento</option>
                                                    <?php foreach ($tipo_de_documentos as $row) : ?>
                                                        <option value="<?= $row['tipodoc_id'] ?>"><?= $row['tipodoc_codigo'] ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="cifnif">Núm. fiscal</label>
                                                <input type="text" id="cifnif" class="form-control" maxlength="30" v-model="dataForm.cifnif">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="">Nombre</label>
                                                <input type="text" id="nombre" class="form-control" maxlength="100" v-model="dataForm.nombre" @keyup="dataForm.nombre=dataForm.nombre.toUpperCase()">
                                                <small class="form-text text-muted">Nombre por el que es conocido el proveedor. Para uso interno.</small>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="razonsocial">Razón Social</label>
                                                <input type="text" class="form-control" maxlength="100" v-model="dataForm.razonsocial" @keyup="dataForm.razonsocial=dataForm.razonsocial.toUpperCase()">
                                                <small class="form-text text-muted">Descripción nombre de empresa de proveedor</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="telefono1">Teléfono</label>
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text"><i class="fas fa-phone fa-fw"></i></span>
                                                    </div>
                                                    <input type="tel" id="telefono1" class="form-control" v-mask="'(####) ###-####'" v-model="dataForm.telefono1">
                                                </div>
                                            </div>
                                            <small class="form-text text-muted">(0000) 000-0000</small>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="telefono2">Teléfono 2</label>
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text">
                                                            <i class="fas fa-mobile-alt fa-fw"></i>
                                                        </span>
                                                    </div>
                                                    <input type="tel" id="telefono2" class="form-control" v-mask="'(####) ###-####'" v-model="dataForm.telefono2">
                                                </div>
                                                <small class="form-text text-muted">(0000) 000-0000</small>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="email">Email</label>
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text">
                                                            <i class="fas fa-envelope fa-fw"></i>
                                                        </span>
                                                    </div>
                                                    <input type="email" id="email" class="form-control" maxlength="100" v-model="dataForm.email">
                                                </div>
                                                <small class="form-text text-muted">usuario@ejemplo.com</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="pais">Pais</label>
                                                <select id="pais" class="form-control" v-model="dataForm.pais">
                                                    <?php foreach ($pais as $row) : ?>
                                                        <option value="<?= $row['pa_id'] ?>"><?= $row['pa_nombre'] ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="estado">Estado</label>
                                                <input type="text" id="estado" class="form-control" v-model="dataForm.estado">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="ciudad">Ciudad</label>
                                                <input type="text" id="ciudad" class="form-control" v-model="dataForm.ciudad">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="codigo_postal">Código postal</label>
                                                <input type="text" id="codigo_postal" class="form-control" v-model="dataForm.codigo_postal">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="web">Web</label>
                                                <input type="text" class="form-control" maxlength="100" v-model="dataForm.web">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="direccion">Dirección</label>
                                        <input type="text" id="direccion" class="form-control" v-model="dataForm.direccion">
                                    </div>
                                    <?php /*
                    <div class="form-row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="codserie">Serie</label>
                                <select class="form-control" v-model="dataForm.serie">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <?php foreach ($series as $row) : ?>
                                        <option value="<?= $row->ser_id; ?>"><?= $row->ser_descripcion; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="codpago">Forma de pago</label>
                                <select id="codpago" class="form-control" v-model="dataForm.mpid">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <?php foreach ($metodos_pago as $row) : ?>
                                        <option value="<?= $row->mp_id; ?>"><?= $row->mp_descripcion; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="codimpuestoportes">Impuestos del transporte</label>
                                <select id="codimpuestoportes" class="form-control" v-model="dataForm.impid">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <?php foreach ($impuestos as $impuesto) : ?>
                                        <option value="<?= $impuesto['imp_id']; ?>"><?= $impuesto['imp_descripcion']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="subcuenta">Subcuenta</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-balance-scale fa-fw"></i></span>
                                    </div>
                                    <input type="text" class="form-control" maxlength="15" v-model="dataForm.subcuenta">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="regimeniva">Régimen IVA</label>
                                <select id="regimeniva" class="form-control" v-model="dataForm.regimeniva">
                                    <option value="1">Exento</option>
                                    <option value="2" selected="">General</option>
                                    <option value="3">Recargo de equivalencia</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="retencion">Retención</label>
                                <select id="retencion" class="form-control" v-model="dataForm.retencion">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <?php foreach ($retencion as $row) : ?>
                                        <option value="<?= $row['imp_id'] ?>"><?= $row['imp_descripcion'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    */ ?>
                                    <div class="form-group">
                                        <label for="observaciones">Observaciones</label>
                                        <textarea rows="3" class="form-control" v-model="dataForm.observaciones"></textarea>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-sm-3">
                                            <div class="form-check">
                                                <label class="form-check-label">
                                                    <input class="form-check-input" type="checkbox" v-model="dataForm.personafisica" id="personafisica">
                                                    <span class="form-check-sign">Persona natural (no jurídica)</span>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-check">
                                                <label class="form-check-label">
                                                    <input class="form-check-input" type="checkbox" v-model="dataForm.acreedor" id="acreedor">
                                                    <span class="form-check-sign">Es acreedor</span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-12">
                                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                                {{ row }}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col text-right">
                                            <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                                                <i class="loader loader-info"></i>
                                            </button>
                                            <button v-else class="btn btn-sm btn-primary" type="submit">
                                                <i class="fas fa-save fa-fw" aria-hidden="true"></i>
                                                <span class="d-none d-sm-inline-block">Actualizar</span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="tab-pane fade" id="tab_general" role="tabpanel">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-title">
                                        <div class="form-group form-group-default">
                                            <label for="mdivisas">Año</label>
                                            <select name="aniocompras" class="form-control custom-select" id="aniocompraMes" onchange="obtenerIngresosDiariosComprasMes()">
                                                <?php for ($m = date('o'); $m >= 2019; $m--) {
                                                    if ($m == date('o')) {
                                                        echo '<option value="' . $m . '" selected>' . $m . '</option>';
                                                    } else {
                                                        echo '<option value="' . $m . '">' . $m . '</option>';
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <canvas id="ventasSemanalescompraMes" height="400"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="tab_facturas" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex align-items-left flex-column">
                                    <div class="nav-scroller d-flex">
                                        <div class="nav nav-line nav-color-success d-flex align-items-center justify-contents-center">
                                            <a class="nav-link active" data-toggle="pill" href="#fac_pagas" role="tab" aria-controls="fac_pagas" aria-selected="true">Pagadas ({{ facturas.length }})</a>
                                            <a class="nav-link" data-toggle="pill" href="#fac_pendientes" role="tab" aria-controls="fac_pendientes" aria-selected="false">Pendientes ({{ facturasPendientes.length }}) </a>
                                            <a class="nav-link" data-toggle="pill" href="#fac_anuladas" role="tab" aria-controls="fac_anuladas" aria-selected="false">Anuladas ({{ facturasAnuladas.length }})</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-content mt-3">
                                    <div class="tab-pane fade show active" id="fac_pagas">
                                        <div class="table-responsive" :class="cargando_tabla">
                                            <table class="table table-hover bg-white" id="table_facturas_pagadas">
                                                <thead>
                                                    <tr>
                                                        <th>Codigo</th>
                                                        <th>Proveedor</th>
                                                        <th>Total</th>
                                                        <th>Fecha</th>
                                                        <th>Acción</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in facturas">
                                                        <td><a :href="'<?= ruta_base() ?>cmpfacturaeditar/verFactura/'+row.id" target="_blank">FACC{{ row.correlativo }}</a></td>
                                                        <td>{{ row.cliente }}</td>
                                                        <td class="text-right">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-center">{{ row.fecha }}</td>
                                                        <td class="text-center">
                                                            <div class="form-button-action">
                                                                <div class="input-group-append">
                                                                    <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                                    <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                                        <a class="dropdown-item" :href="'<?= ruta_base() ?>cmpfacturaeditar/pdf/'+row.id" target="_blank">PDF completo</a>
                                                                        <a class="dropdown-item" :href="'<?= ruta_base() ?>cmpfacturaeditar/pdfMP/'+row.id" target="_blank">PDF media pagina</a>
                                                                        <a class="dropdown-item" :href="'<?= ruta_base() ?>cmpfacturaeditar/pdfFMP/'+row.id" target="_blank">PDF pagos</a>
                                                                        <a class="dropdown-item" href="" @click.prevent="finalizarFactura(row, '2')">Pendiente</a>
                                                                        <a class="dropdown-item" href="" @click.prevent="finalizarFactura(row, '3')">Anulado</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th>Total:</th>
                                                        <th></th>
                                                        <th class="text-right"></th>
                                                        <th></th>
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="fac_pendientes">
                                        <div class="table-responsive" :class="cargando_tabla">
                                            <table class="table table-hover bg-white" id="table_facturas_pendientes">
                                                <thead>
                                                    <tr>
                                                        <th>Codigo</th>
                                                        <th>Proveedor</th>
                                                        <th>Acumulado</th>
                                                        <th>Pendiente</th>
                                                        <th>Total</th>
                                                        <th>Fecha</th>
                                                        <th>Acción</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in facturasPendientes">
                                                        <td><a :href="'<?= ruta_base() ?>cmpfacturaeditar/verFactura/'+row.id" target="_blank">FACC{{ row.correlativo }}</a></td>
                                                        <td>{{ row.cliente }}</td>
                                                        <td class="text-right">{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right">{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-center">{{ row.fecha }}</td>
                                                        <td>
                                                            <div class="form-button-action">
                                                                <div class="input-group-append">
                                                                    <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                                    <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                                        <a class="dropdown-item" :href="'<?= ruta_base() ?>cmpfacturaeditar/pdf/'+row.id" target="_blank">PDF completo</a>
                                                                        <a class="dropdown-item" :href="'<?= ruta_base() ?>cmpfacturaeditar/pdfMP/'+row.id" target="_blank">PDF media pagina</a>
                                                                        <a class="dropdown-item" :href="'<?= ruta_base() ?>cmpfacturaeditar/pdfFMP/'+row.id" target="_blank">PDF pagos</a>
                                                                        <a class="dropdown-item" href="" @click.prevent="finalizarFactura(row, '1')">Finalizado</a>
                                                                        <a class="dropdown-item" href="" @click.prevent="finalizarFactura(row, '3')">Anulado</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th>Total:</th>
                                                        <th></th>
                                                        <th class="text-right"></th>
                                                        <th class="text-right"></th>
                                                        <th class="text-right"></th>
                                                        <th></th>
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="fac_anuladas">
                                        <div class="table-responsive" :class="cargando_tabla">
                                            <table class="table table-hover bg-white" id="table_facturas_anuladas">
                                                <thead>
                                                    <tr>
                                                        <th>Codigo</th>
                                                        <th>Proveedor</th>
                                                        <th>Acumulado</th>
                                                        <th>Pendiente</th>
                                                        <th>Total</th>
                                                        <th>Fecha</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in facturasAnuladas">
                                                        <td><a :href="'<?= ruta_base() ?>cmpfacturaeditar/verFactura/'+row.id" target="_blank">FACC{{ row.correlativo }}</a></td>
                                                        <td>{{ row.cliente }}</td>
                                                        <td class="text-right">{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right">{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-center">{{ row.fecha }}</td>
                                                    </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th>Total:</th>
                                                        <th></th>
                                                        <th class="text-right"></th>
                                                        <th class="text-right"></th>
                                                        <th class="text-right"></th>
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="tab_notas" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex align-items-left flex-column">
                                    <div class="nav-scroller d-flex">
                                        <div class="nav nav-line nav-color-success d-flex align-items-center justify-contents-center">
                                            <a class="nav-link active" data-toggle="pill" href="#notas_pagas" role="tab" aria-controls="fac_pagas" aria-selected="true">Pagadas ({{ notasdeentrega.length }})</a>
                                            <a class="nav-link" data-toggle="pill" href="#notas_pendientes" role="tab" aria-controls="fac_pendientes" aria-selected="false">Pendientes ({{ notasdeentregaPendientes.length }}) </a>
                                            <a class="nav-link" data-toggle="pill" href="#notas_anuladas" role="tab" aria-controls="fac_anuladas" aria-selected="false">Anuladas ({{ notasdeentregaAnuladas.length }})</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-content mt-3">
                                    <div class="tab-pane fade show active" id="notas_pagas">
                                        <div class="table-responsive" :class="cargando_tabla">
                                            <table class="table table-hover bg-white" id="table_notasdeentrega_pagadas">
                                                <thead>
                                                    <tr>
                                                        <th>Codigo</th>
                                                        <th>Proveedor</th>
                                                        <th>Total</th>
                                                        <th>Fecha</th>
                                                        <th>Acción</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in notasdeentrega">
                                                        <td><a :href="'<?= ruta_base() ?>cmpnotaseditar/verFactura/'+row.id" target="_blank">FACC{{ row.correlativo }}</a></td>
                                                        <td>{{ row.cliente }}</td>
                                                        <td class="text-right">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-center">{{ row.fecha }}</td>
                                                        <td class="text-center">
                                                            <div class="form-button-action">
                                                                <div class="input-group-append">
                                                                    <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                                    <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                                        <a class="dropdown-item" :href="'<?= ruta_base() ?>cmpnotaseditar/pdf/'+row.id" target="_blank">PDF completo</a>
                                                                        <a class="dropdown-item" :href="'<?= ruta_base() ?>cmpnotaseditar/pdfMP/'+row.id" target="_blank">PDF media pagina</a>
                                                                        <a class="dropdown-item" :href="'<?= ruta_base() ?>cmpnotaseditar/pdfFMP/'+row.id" target="_blank">PDF pagos</a>
                                                                        <a class="dropdown-item" href="" @click.prevent="finalizarNota(row, '2')">Pendiente</a>
                                                                        <a class="dropdown-item" href="" @click.prevent="finalizarNota(row, '3')">Anulado</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th>Total:</th>
                                                        <th></th>
                                                        <th class="text-right"></th>
                                                        <th></th>
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="notas_pendientes">
                                        <div class="table-responsive" :class="cargando_tabla">
                                            <table class="table table-hover bg-white" id="table_notasdeentrega_pendientes">
                                                <thead>
                                                    <tr>
                                                        <th>Codigo</th>
                                                        <th>Proveedor</th>
                                                        <th>Acumulado</th>
                                                        <th>Pendiente</th>
                                                        <th>Total</th>
                                                        <th>Fecha</th>
                                                        <th>Acción</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in notasdeentregaPendientes">
                                                        <td><a :href="'<?= ruta_base() ?>cmpnotaseditar/verFactura/'+row.id" target="_blank">FACC{{ row.correlativo }}</a></td>
                                                        <td>{{ row.cliente }}</td>
                                                        <td class="text-right">{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right">{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-center">{{ row.fecha }}</td>
                                                        <td>
                                                            <div class="form-button-action">
                                                                <div class="input-group-append">
                                                                    <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                                    <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                                        <a class="dropdown-item" :href="'<?= ruta_base() ?>cmpnotaseditar/pdf/'+row.id" target="_blank">PDF completo</a>
                                                                        <a class="dropdown-item" :href="'<?= ruta_base() ?>cmpnotaseditar/pdfMP/'+row.id" target="_blank">PDF media pagina</a>
                                                                        <a class="dropdown-item" :href="'<?= ruta_base() ?>cmpnotaseditar/pdfFMP/'+row.id" target="_blank">PDF pagos</a>
                                                                        <a class="dropdown-item" href="" @click.prevent="finalizarNota(row, '1')">Finalizado</a>
                                                                        <a class="dropdown-item" href="" @click.prevent="finalizarNota(row, '3')">Anulado</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th>Total:</th>
                                                        <th></th>
                                                        <th class="text-right"></th>
                                                        <th class="text-right"></th>
                                                        <th class="text-right"></th>
                                                        <th></th>
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="notas_anuladas">
                                        <div class="table-responsive" :class="cargando_tabla">
                                            <table class="table table-hover bg-white" id="table_notasdeentrega_anuladas">
                                                <thead>
                                                    <tr>
                                                        <th>Codigo</th>
                                                        <th>Proveedor</th>
                                                        <th>Acumulado</th>
                                                        <th>Pendiente</th>
                                                        <th>Total</th>
                                                        <th>Fecha</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in notasdeentregaAnuladas">
                                                        <td><a :href="'<?= ruta_base() ?>cmpnotaseditar/verFactura/'+row.id" target="_blank">FACC{{ row.correlativo }}</a></td>
                                                        <td>{{ row.cliente }}</td>
                                                        <td class="text-right">{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right">{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-center">{{ row.fecha }}</td>
                                                    </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th>Total:</th>
                                                        <th></th>
                                                        <th class="text-right"></th>
                                                        <th class="text-right"></th>
                                                        <th class="text-right"></th>
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="tab_abonos" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <table class="table table-hover bg-white" id="table_abonos" style="width: 100%;">
                                    <thead>
                                        <tr>
                                            <th>Fecha</th>
                                            <th>Proveedor</th>
                                            <th>Documento</th>
                                            <th>Total</th>
                                            <th>Divisa</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="row in abonos">
                                            <td>{{row.fecha}}</td>
                                            <td style="width: 40%;">{{row.prov_razonsocial}}</td>
                                            <td>
                                                <div >
                                                    <span style="width: 30%;"><a :href="row.ruta_documento">{{row.correlativo}}</a></span>
                                                    <b class="text-primary mr-3" style="float: right;">TOTAL: {{row.total}}</b><b class=" ml-3 mr-5" style="float: right;"> ACUMULADO: {{row.acumulado}} </b><b class="text-danger ml-4 mr-4" style="float: right;">PENDIENTE: {{row.pendiente}}</b>
                                                </div>
                                            </td>
                                            <td>{{row.monto}}</td>
                                            <td>{{row.divisa}}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="<?= asset('assets/moment.min.js') ?>"></script>
<script src="<?= asset('assets/vue-the-mask.js') ?>"></script>

<script src="<?= asset('assets/js/plugin/chart.js/Chart.min.js') ?>"></script>
<script src="<?= asset('assetsvuejs/proveedores/editarproveedor.js') ?>"></script>
<script>
    var chartVentasSemanalescompraMes = '';
    var ventasSemanalescompraMes = document.getElementById('ventasSemanalescompraMes').getContext('2d');

    function obtenerIngresosDiariosComprasMes() {
        chartVentasSemanalescompraMes.destroy();
        ///if(document.getElementById('sucursal').value!=''){
        _ingresosDiarioscompraMes();
        //}
    }

    function _ingresosDiarioscompraMes() {

        let anio = document.getElementById("aniocompraMes").value;
        let prov = document.getElementById('id_proveedor').value;

        axios({
            method: 'post',
            url: 'proveedores/reporteGeneralMensual',
            data: {
                anio: anio,
                prov: prov
            },
            transformRequest: serializar(),
        }).then(response => {
            let ingreso_dsm = response.data.meses;

            let tit = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
            let dsm_venta = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
            let dsm_documento = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

            Object.keys(ingreso_dsm).forEach(function(k) {
                for (let i = 0; i < 12; i++) {
                    if (ingreso_dsm[k].mes == tit[i]) {
                        dsm_venta[i] = ingreso_dsm[k].venta;
                        dsm_documento[i] = ingreso_dsm[k].documentos;
                    }
                }
            });

            chartVentasSemanalescompraMes = new Chart(ventasSemanalescompraMes, {
                type: 'bar',
                data: {
                    labels: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
                    datasets: [{
                            label: "Compras",
                            data: dsm_venta,
                            backgroundColor: '#f9972f',
                            borderColor: '#f9972f91',
                            borderWidth: 1
                        },
                        {
                            label: "Documentos",
                            data: dsm_documento,
                            backgroundColor: '#fbee29',
                            borderColor: '#fbee295e',
                            borderWidth: 1
                        }
                    ]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    title: {
                        display: true,
                        text: 'Compras mensuales'
                    },
                    legend: {
                        position: 'bottom'
                    },
                    tooltips: {
                        mode: 'index',
                        intersect: false,
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                if (tooltipItem.datasetIndex === 0) {
                                    var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                    return datasetLabel + ' ' + monedaMoneda(tooltipItem.yLabel, response.data.div_locale, response.data.div_simbolo);
                                } else {
                                    var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                    return datasetLabel + ' ' + tooltipItem.yLabel;
                                }

                            },
                        }
                    },
                    responsive: true,
                    scales: {
                        xAxes: [{
                            stacked: true,
                        }],
                        yAxes: [{
                            stacked: true
                        }]
                    }
                    /* tooltips: {
                         callbacks: {
                             label: function(tooltipItem, chart) {
                                 if(tooltipItem.datasetIndex===0){
                                     var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                     return datasetLabel + ' ' + monedaMoneda(tooltipItem.yLabel, response.data.div_locale, response.data.div_simbolo);
                                 }else{
                                     var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                     return datasetLabel + ' ' + tooltipItem.yLabel;
                                 }
                                
                             },
                         }
                     },
                     scales: {
                         yAxes: [{
                             ticks: {
                                 beginAtZero: true,
                                 callback: function(value, index, values) {
                                     return value;
                                 }
                             }
                         }]
                     }*/
                }
            });

        });
    }

    window.onload = _ingresosDiarioscompraMes();
</script>