<div class="card">
    <div class="card-body" :class="cargando">
        <div class="row">
            <div class="col-12">
                <form @submit.prevent="buscar($event)">
                    <div class="form-row">
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="sucursal">Sucursal</label>
                                <select id="sucursal" v-model="sucursal_predeterminada" class="form-control input-border-bottom" @click.prevent="obtenerSeriesAlmacenesEmpleado()" :disabled="disabled">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <option v-for="row in sucursales_empleado" :value="row.su_id"><span v-if="disabled==false">Sucursal: </span>{{row.su_nombre}}</option>
                                </select>
                                <label for="sucursal" class="placeholder" v-if="disabled===false"></label>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group">
                                <label for="almacen">Almacén</label>
                                <select id="almacen" ref="almacen_predeterminado" class="form-control" v-model="almacen_predeterminado">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <option v-for="row in almacenes"  @change="obtenerAlmacennombre(row)" :value="row.alm_id">{{row.alm_nombre}}</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group">
                                <label for="buscar">Filtrar por</label>
                                <select id="buscar" class="form-control" v-model="stock">
                                    <option value="0">Stock</option>
                                    <option value="1">Stock bajo</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <br>
                            <div class="form-group">
                                <div class="input-group-append">
                                    <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-body" :class="cargando">
        <div class="table-responsive">
            <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tab_proalm">
                <thead>
                    <tr>
                        <th style="width: 15%;" class="text-left">Producto</th>
                        <th class="text-center">Costo</th>
                        <th class="text-center">Precio</th>
                        <th class="text-right">Cantidad</th>
                        <th class="text-right">Reservado</th>
                        <th class="text-right">Stock mín.</th>
                        <th class="text-right">Stock máx.</th>
                    </tr>
                </thead>
                <tbody>
                    <tr v-for="row in productosAlmacenes">
                        <td style="width: 15%;" class="text-left">{{ row.descripcion }}</td>
                        <td class="text-right" v-html="row.costo"></td>
                        <td class="text-right">{{row.precio}}</td>
                        <td class="text-left">{{ row.disponible }}</td>
                        <td class="text-center">{{ row.reservada }}</td>
                        <td class="text-right">{{ row.min}}</td>
                        <td class="text-right">{{ row.max }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>