<form autocomplete="off" @submit.prevent="buscarLineas" id="form_modal_lineas">
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal_lineas">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Buscar en las lineas</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text bg-white"><i class="fa fa-search"></i></span>
                            </div>
                            <input type="text" id="input_buscar_lineas" class="form-control" placeholder="Buscar..." @keyup="buscarLineas($event)">
                            <div class="input-group-append">
                                <button class="btn btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Filtrar</button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="#" @click.prevent="filtrarPor(1)">Articulo</a>
                                    <a class="dropdown-item" href="#" @click.prevent="filtrarPor(2)">Almacen destino</a>
                                </div>
                            </div>

                        </div>
                        <small class="form-text text-muted">{{ lineas.length }} resultados</small>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-hover table-striped" :class="cargando_lineas">
                            <thead>
                                <tr>
                                    <th class="text-left">Código + Origen</th>
                                    <th class="text-left">Destino</th>
                                    <th class="text-left">Cantidad</th>
                                    <th class="text-left">Articulo</th>
                                    <th class="text-center">Estatus</th>
                                    <th class="text-right">Fecha</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="row in lineas">
                                    <td style="width: 20%;"><a :href="row.ruta" target="_blank" rel="noopener noreferrer">{{ row.id }}</a> {{ row.origen }}</td>
                                    <td style="width: 20%;" class="text-left">{{ row.destino }}</td>
                                    <td class="text-left">{{ row.cantidad }}</td>
                                    <td><a :href="row.ruta_producto" target="_blank" rel="noopener noreferrer">{{ row.art_codigo }}</a> {{ row.art_nombre }}</td>
                                    <td>
                                        <span v-if="row.estatus == 1" class="text-warning">PENDIENTE</span>
                                        <span v-if="row.estatus == 2" class="text-success">PROCESADO</span>
                                        <span v-else class="text-warning">DENEGADO</span>
                                    </td>
                                    <td class="text-right">{{ row.fecha }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>
</form>