<div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form @submit.prevent="obtenerClientes" id="form_clientes">
                        <div class="form-row">
                            <div class="col-sm-6">
                                <div class="form-group form-floating-label">
                                    <input id="pvfecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha_desde">
                                    <label for="pvfecha_desde" class="placeholder">Fecha desde</label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group input-group form-floating-label">
                                    <input id="pvfecha_hasta" type="date" class="form-control input-border-bottom" v-model="fecha_hasta">
                                    <label for="pvfecha_hasta" class="placeholder">Fecha hasta</label>
                                    <div class="input-group-append">
                                        <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                    {{ row }}
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <div class="col-12">
         <div class="card">
            <div class="card-body" :class="cargando_tabla">
                <div class="table-responsive">
                    <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_clients">
                        <thead>
                            <tr>
                                <th class="text-left">Fecha</th>
                                <th class="text-center">Cliente</th>
                                <th class="text-center">Telefono</th>
                                <th class="text-center">Correo Electrónico</th>
                                <th class="text-center">Precio vendido</th>
                                <th class="text-center">Cantidad</th>
                                <th class="text-center">Total</th>
                                <th class="text-center">Documento</th>
                                <th class="text-center">Sucursal</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in clientes">
                                <td class="text-left">{{row.fecha}}</td>
                                <td class="text-center"><a :href="row.uri_clients"> {{row.cliente}} ({{row.dni}}) </a></td>
                                <td class="text-center">{{row.telefono}}</td>
                                <td class="text-center">{{row.email}}</td>
                                <td class="text-center">{{row.precio_factura}}</td>
                                <td class="text-center">{{row.cantidad}}</td>
                                <td class="text-center">{{row.total}}</td>
                                <td class="text-center"><a :href="row.url" target="_blank">{{ row.tipo }}{{ row.correlativo }}</a></td>               
                                <td class="text-center">{{row.sucursal}}</td>
                            </tr>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>TOTAL</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
