<div class="p-0 m-0">
    <div class="card">
        <form @submit.prevent="actualizarPrecios">
            <div class="card-body">
                <div class="form-row ">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Precio de coste</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <i class="fas fa-dollar-sign fa-fw"></i>
                                    </span>
                                </div>
                                <input type="number" id="pro_costo" value="<?= $producto['pro_costo']; ?>" class="form-control" step="any" @keyup="calcular">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>
                                <?php if ($producto['pro_tipo'] != 3) :  ?>
                                    Precio venta
                                <?php else : ?>
                                    Precio
                                <?php endif; ?>
                            </label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <i class="fas fa-dollar-sign fa-fw"></i>
                                    </span>
                                </div>
                                <input type="number" id="pro_precio" value="<?= $producto['pro_precio']; ?>" class="form-control" step="any" @keyup="calcular">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><a href="<?= url('configuracion'); ?>">Impuesto</a></label>
                            <select id="iva" class="form-control" @change.prevent="calcularImpuesto">
                                <option value="">Seleccione...</option>
                                <?php foreach ($impuestos as $impuesto) : ?>
                                    <?php if ($impuesto['imp_id'] == $producto['pro_impid']) : ?>
                                        <option selected value="<?php echo $impuesto['imp_id']; ?>">
                                            <?php echo strtoupper($impuesto['imp_descripcion']); ?>
                                        </option>
                                    <?php else : ?>
                                        <option value="<?php echo $impuesto['imp_id']; ?>">
                                            <?php echo strtoupper($impuesto['imp_descripcion']); ?>
                                        </option>
                                <?php endif;
                                endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Precio + Impuesto</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <i class="fas fa-dollar-sign fa-fw"></i>
                                    </span>
                                </div>
                                <input type="number" id="venta_impuesto" class="form-control" step="any" @keyup="calcularPrecioImpuesto">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Porcentaje de Ganancia</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <i class="fas fa-percentage fa-fw"></i>
                                    </span>
                                </div>
                                <input type="text" id="porcentaje_ganancia" class="form-control" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                         <div class="form-group">
                            <br>
                            <div class="input-group">
                        <a class="btn btn-warning btn-round m-2" @click="modal_producto()"><i class="fa fa-print"></i>Imprimir Ticket</a>
                         </div>
                          </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col text-right">
                       
                            <a class="btn btn-sm btn-secondary" href="<?= ruta_base() ?>productos/sticket_unproducto_pdf/<?= $producto['pro_id'];?>" target="_new"><i class="fa fa-print" aria-hidden="true"></i>
                            <span class="d-none d-sm-inline-block">Ticket</span></a>&nbsp;
                      
                        <button class="btn btn-sm btn-secondary" type="reset">
                            <i class="fas fa-undo fa-fw" aria-hidden="true"></i>
                            <span class="d-none d-sm-inline-block">Deshacer</span>
                        </button>
                        <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                            <i class="loader loader-info"></i>
                        </button>
                        <button v-else class="btn btn-sm btn-primary" type="submit">
                            <i class="fas fa-save fa-fw" aria-hidden="true"></i>
                            <span class="d-none d-sm-inline-block">Guardar</span>
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <div class="card">
        <div class="card-body">
            <div class="card-title mb-4">Historial de compras</div>
            <div class="table-responsive">
                <table class="table table-hover no-footer dataTable" id="tabla_historial">
                    <thead>
                        <tr>
                            <th>Fecha</th>
                            <th>Documento</th>
                            <th>Precio</th>
                            <th>Proveedor</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="row in historial">
                            <td>{{row.fecha}}</td>
                            <td><a :href="row.uri">{{row.documento}}</a></td>
                            <td><span class="badge badge-danger">{{row.precio}}</span></td>
                            <td>{{row.proveedor}}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <div class="card-title">Calculo de precio en base a las tarifas</div>
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Código</th>
                        <th>Nombre</th>
                        <th>Formula</th>
                        <th>Precio</th>
                        <th class="text-center">
                            <label for="checkbox-general" class="form-check-label">
                                <input class="form-check-input" type="checkbox" class="checkbox-general" @change="checkgeneral($event)">
                                <span class="form-check-sign"></span>
                            </label>
                        </th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <tr v-for="row in tarifasPro">
                        <td>{{ row.codigo }}</td>
                        <td>{{ row.nombre }}</td>
                        <td v-html="row.formula"></td>
                        <td>
                            <b><span class="badge badge-danger">{{ row.precio }}</span></b>
                        </td>
                        <td class="text-center">
                            <label :for="'check'+row.id" class="form-check-label">
                                <input class="form-check-input" type="checkbox" v-model="row.checked" :id="'part'+row.id" @change="actualizarCheckTarifaid(row.id)">
                                <span class="form-check-sign"></span>
                            </label>
                        </td>
                        <td class="text-center">
                            <input @keyup="actualizarMontTarifas(row.id)" v-if="row.checked==1" :value="row.precio_tarifa" type="number" :id="'precio_tarifa'+row.id" class="form-control">
                            <input v-else type="text" value="0" id="tarif" class="form-control" disabled>

                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>