<script src="<?= ruta_base() ?>public/assets/js/vue-treeselect.umd.min.js"></script>
<link rel="stylesheet" href="<?= ruta_base() ?>public/assets/css/vue-treeselect.min.css">
<div class="container" id="appCrearProductos" v-cloak>
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Productos</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('productos') ?>">Productos</a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('productos/crear') ?>">Crear</a>
                </li>
            </ul>
        </div>
        <div class="card">
            <div class="card-body">
                <form id="form_crear_productos" autocomplete="off" @submit.prevent="guardar">
                    <div class="form-row">
                        <div class="col-sm-3">
                            <div class="form-group">
                                <label for="referencia">Referencia</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-hashtag fa-fw"></i>
                                        </span>
                                    </div>
                                    <input type="text" id="referencia" class="form-control" maxlength="30" v-model="dataForm.codigo">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group">
                                <label for="pro_nombre">Nombre corto</label>
                                <input type="text" id="pro_nombre" class="form-control" v-model="dataForm.nombrecorto" maxlength="33">
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="descripcion">Nombre</label>
                                <input type="text" id="pro_descripcion" class="form-control" v-model="dataForm.descripcion">
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-sm-3">
                            <div class="form-group">
                                <label for="tipo">Tipo</label>:
                                <select id="tipo" class="form-control" v-model="dataForm.tipo" @change="cambiarFormulario()">
                                    <option value="" disabled>Seleccione un elemento</option>
                                    <option value="1">Producto simple </option>
                                    <option value="2">Producto compuesto </option>
                                    <option value="3">Servicio tecnico</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-3 producto_form">
                            <div class="form-group">
                                <label for="numerodeparte">Numero de Parte:</label>
                                <div class="input-group">
                                    <span class="input-group-addon">
                                        <span class="glyphicon glyphicon-tag" aria-hidden="true"></span>
                                    </span>
                                    <input class="form-control" type="text" id="numerodeparte" v-model="dataForm.partnumber">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 producto_form">
                            <div class="form-group">
                                <label for="codigodeequivalencia">Código de equivalencia:</label>
                                <input class="form-control" type="text" id="codigodeequivalencia" v-model="dataForm.equivalencia">
                                <small class="form-text text-muted">Dos o más artículos son equivalentes si tienen el mismo código de equivalencia.</small>
                            </div>
                        </div>
                    </div>
                    <div class="form-row ">
                        <div class="col-sm-4 producto_form">
                            <div class="form-group">
                                <label for="fabricantes"><a href="<?= url('fabricantes') ?>" target="_blank">Fabricante</a> <i @click="recargarFabricantes" style="cursor: pointer;" class="fas fa-sync-alt"></i></label>
                                <v-select id="fabricantes" v-model="dataForm.fabid" :options="optionsFabricantes" :reduce="row => row.fa_id" label="fa_nombre" />
                            </div>
                        </div>
                        <div class="col-sm-4 producto_form">
                            <div class="form-group">
                                <label for="provid"><a href="<?php url('proveedores'); ?>" target="_blank">Proveedores</a> <i @click="recargarProveedores" style="cursor: pointer;" class="fas fa-sync-alt"></i> </label>
                                <v-select id="provid" multiple v-model="selectedProvid" :options="optionsProveedores" :reduce="row => row.prov_id" label="prov_nombre" />
                            </div>
                        </div>
                        <div class="col-sm-4 producto_form">
                            <div class="form-group">
                                <label for="catid"><a href="<?php url('categorias'); ?>" target="_blank">Categorias/familias</a> <i @click="recargarCategorias" style="cursor: pointer;" class="fas fa-sync-alt"></i> </label>
                                <!--<v-select id="catid" multiple v-model="selectedCatid" :options="optionsCategorias" :reduce="row => row.cat_id" label="cat_nombre" />-->
                                <treeselect :multiple="true" :options="optionsCategorias" placeholder="Seleccione la categoria" v-model="selectedCatid" />
                                <treeselect-value :value="selectedCatid" />
                            </div>
                        </div>
                    </div>
                    <div class="form-row ">
                        <div class="col-sm-4 producto_form">
                            <div class="form-group">
                                <label for="stock">Stock</label>
                                <input type="number" id="stock" class="form-control" v-model="dataForm.stockfis" disabled>
                            </div>
                        </div>
                        <div class="col-sm-4 producto_form">
                            <div class="form-group">
                                <label for="fechadeexpedicion">Fecha de Expedicion</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-calendar-alt fa-fw"></i>
                                        </span>
                                    </div>
                                    <input type="date" id="fechadeexpedicion" class="form-control" v-model="dataForm.expedicion">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 producto_form">
                            <div class="form-group">
                                <label for="fechadevencimiento">Fecha de Vencimiento</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-calendar-alt fa-fw"></i>
                                        </span>
                                    </div>
                                    <input type="date" id="fechadevencimiento" class="form-control" v-model="dataForm.vencimiento">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="observaciones">Descripción</label>
                        <textarea id="pro_observaciones" class="form-control" v-model="dataForm.observaciones"></textarea>
                    </div>
                    <div class="form-row ">
                        <div class="col-sm-2 producto_form">
                            <div class="form-check">
                                <label class="form-check-label">
                                    <input class="form-check-input" type="checkbox" id="pro_nostock" v-model="dataForm.nostock">
                                    <span class="form-check-sign">No controlar stock</span>
                                </label>
                            </div>
                        </div>
                        <div class="col-sm-2 producto_form">
                            <div class="form-check">
                                <label class="form-check-label">
                                    <input class="form-check-input" type="checkbox" id="pro_secompra" v-model="dataForm.secompra">
                                    <span class="form-check-sign">Se compra</span>
                                </label>
                            </div>
                        </div>
                        <div class="col-sm-2 producto_form">
                            <div class="form-check">
                                <label class="form-check-label">
                                    <input class="form-check-input" type="checkbox" id="pro_sevende" v-model="dataForm.sevende">
                                    <span class="form-check-sign">Se vende</span>
                                </label>
                            </div>
                        </div>
                        <div class="col-sm-2 producto_form">
                            <div class="form-check">
                                <label class="form-check-label">
                                    <input class="form-check-input" type="checkbox" id="pro_bloqueado" v-model="dataForm.bloqueado">
                                    <span class="form-check-sign">Bloqueado</span>
                                </label>
                            </div>
                        </div>
                        <div class="col-sm-2 producto_form">
                            <div class="form-check">
                                <label class="form-check-label">
                                    <input class="form-check-input" type="checkbox" id="pro_publico" v-model="dataForm.publico">
                                    <span class="form-check-sign">Público</span>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col text-right">
                            <button class="btn btn-sm btn-secondary" type="reset">
                                <i class="fas fa-undo fa-fw" aria-hidden="true"></i>
                                <span class="d-none d-sm-inline-block">Deshacer</span>
                            </button>
                            <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                                <i class="loader loader-info"></i>
                            </button>
                            <button v-else class="btn btn-sm btn-primary" type="submit">
                                <i class="fas fa-save fa-fw" aria-hidden="true"></i>
                                <span class="d-none d-sm-inline-block">Guardar</span>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script src="<?= ruta_base() ?>public/assets/vue-select.js"></script>
<link rel="stylesheet" href="<?= ruta_base() ?>public/assets/vue-select.css">
<script src="<?= ruta_base() ?>public/assetsvuejs/productos/crear.js"></script>