<?php

namespace App\Modelos;

use Core\Database;

class ProductoCategoria extends Database
{
    protected $table = 'app_productos_categorias';
    protected $id    = 'pc_id';

    public function eliminarCatProducto($pp_proid)
    {
        return $this->consultar("DELETE FROM app_productos_categorias WHERE pc_proid=$pp_proid")->run();
    }

    public function obtenerProductosCategoria($id_categoria)
    {
        return $this->consultar("SELECT pro_id, pro.pro_descripcion,pro.pro_codigo, ac.cat_nombre, pro.pro_costo, pro.pro_precio 
        FROM app_productos pro 
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro.pro_id  
        JOIN app_productos_categorias apc ON apc.pc_proid  = pro.pro_id
        JOIN app_categorias ac ON ac.cat_id = apc.pc_catid 
        WHERE pro_sevende = 1 AND (ps.ps_cantidad > 0 OR pro_nostock=1) AND ac.cat_id = $id_categoria GROUP BY pro.pro_id ORDER BY pro.pro_descripcion")->all();
    }

    public function obtenerSubCategorias($id_categoria)
    {
        return $this->consultar("SELECT * FROM app_categorias WHERE cat_padre=$id_categoria")->all();
    }

    public function obtenerProductosSubCategoria($id_categoria)
    {
        return $this->consultar("SELECT pro_id, pro.pro_descripcion,pro.pro_codigo, ac.cat_nombre, pro.pro_costo, pro.pro_precio 
        FROM app_productos pro 
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro.pro_id  
        JOIN app_productos_categorias apc ON apc.pc_proid  = pro.pro_id
        JOIN app_categorias ac ON ac.cat_id = apc.pc_catid 
        WHERE pro_sevende = 1 AND (ps.ps_cantidad > 0 OR pro_nostock=1) AND ac.cat_padre = $id_categoria GROUP BY pro.pro_id ORDER BY pro.pro_descripcion")->all();
    }
    
    public function obtenerProductosCategoriaC($id_categoria)
    {
        if ($id_categoria == 0) {
            return $this->consultar("SELECT pro_id, pro.pro_descripcion,pro.pro_codigo, ac.cat_nombre, pro.pro_costo, pro.pro_precio 
            FROM app_productos pro 
            LEFT JOIN app_productos_categorias apc ON apc.pc_proid  = pro.pro_id
            LEFT JOIN app_categorias ac ON ac.cat_id = apc.pc_catid 
            ORDER BY pro.pro_id")->all();
        } else {
            return $this->consultar("SELECT pro_id, pro.pro_descripcion,pro.pro_codigo, ac.cat_nombre, pro.pro_costo, pro.pro_precio 
            FROM app_productos pro  
            LEFT JOIN app_productos_categorias apc ON apc.pc_proid  = pro.pro_id 
            LEFT JOIN app_categorias ac ON ac.cat_id = apc.pc_catid 
            WHERE ac.cat_id = $id_categoria OR ac.cat_padre=$id_categoria ORDER BY pro.pro_id")->all();
        }
    }

    public function obtenerProductosSinServiciocateg($id_categoria)
    {
        if ($id_categoria == 0) {
            return $this->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, fa.fa_nombre, pro.pro_costo, pro.pro_precio, pro.pro_publico, sum(ps.ps_cantidad) as cantidad 
        FROM app_productos pro 
        LEFT JOIN app_fabricantes fa ON fa.fa_id=pro.pro_fabid
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
        LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
        WHERE pro_tipo != 3 
        GROUP BY pro.pro_id")->all();
        } else {
            return $this->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, fa.fa_nombre, pro.pro_costo, pro.pro_precio, pro.pro_publico, sum(ps.ps_cantidad) as cantidad 
            FROM app_productos pro 
            LEFT JOIN app_fabricantes fa ON fa.fa_id=pro.pro_fabid
            LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
            LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
            JOIN app_productos_categorias apc ON apc.pc_proid  = pro.pro_id
            JOIN app_categorias ac ON ac.cat_id = apc.pc_catid 
            WHERE ac.cat_id = $id_categoria AND pro_tipo != 3 
            GROUP BY pro.pro_id")->all();
        }
    }
    
    public function obtenerProductosCategoriaSticket($id_categoria)
    {
        if ($id_categoria == 0) {
            return $this->consultar("SELECT DISTINCT pro.pro_id,pro.*,fa.*   
            FROM app_productos pro 
            LEFT JOIN app_fabricantes fa ON fa.fa_id=pro.pro_fabid
            LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
            LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
            LEFT JOIN app_productos_categorias apc ON apc.pc_proid  = pro.pro_id
            LEFT JOIN app_categorias ac ON ac.cat_id = apc.pc_catid WHERE a.alm_garantia=0 AND ps.ps_cantidad > 0 
            ORDER BY pro.pro_id")->all();
        } else {
            return $this->consultar("SELECT DISTINCT pro.pro_id,pro.*,fa.*     
            FROM app_productos pro  
            LEFT JOIN app_fabricantes fa ON fa.fa_id=pro.pro_fabid
            LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
            LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
            LEFT JOIN app_productos_categorias apc ON apc.pc_proid  = pro.pro_id 
            LEFT JOIN app_categorias ac ON ac.cat_id = apc.pc_catid 
            WHERE (a.alm_garantia=0 AND ps.ps_cantidad > 0) AND (ac.cat_id = $id_categoria OR ac.cat_padre=$id_categoria) ORDER BY pro.pro_id")->all();
        }
    }

    public function obtenerCategoria($id_producto)
    {
        return $this->consultar("SELECT ac.cat_nombre
        FROM app_productos_categorias apc
        JOIN app_categorias ac ON ac.cat_id = apc.pc_catid 
        WHERE apc.pc_proid = $id_producto")->row();
    }

    public function obtenerCategoriasProducto($id_producto)
    {
        return $this->consultar("SELECT * FROM app_productos_categorias apc 
        LEFT JOIN app_categorias ac ON ac.cat_id = apc.pc_catid 
        WHERE apc.pc_proid = $id_producto")->all();
    }
}
