<div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal-asignar-trabajo">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header mh">
                <h4 class="modal-title">Asignar trabajo</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col table-responsive">
                        <table class="display table table-striped table-hover dataTable">
                            <thead>
                                <tr class="text-center">
                                    <th>PARTE/TRABAJO</th>
                                    <th>
                                        <div class="form-check">
                                            <label for="checkbox-todos-asignar-trabajo" class="form-check-label">
                                                <input class="form-check-input" type="checkbox" id="checkbox-todos-asignar-trabajo" @change="checktodosAsignarTrabajo">
                                                <span class="form-check-sign"></span>
                                            </label>
                                        </div>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="row in serviciosOrdenTodos">
                                    <td>
                                        {{row.servicio }}
                                    </td>
                                    <td class="text-center">
                                        <div class="form-check">
                                            <label :for="'serv'+row.id" class="form-check-label">
                                                <input class="form-check-input" type="checkbox" v-model="row.checked" :id="'serv'+row.id">
                                                <span class="form-check-sign"></span>
                                            </label>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="form-group">
                    <label for="e_categoria">Categorias</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text">
                                <i class="flaticon-mark-1"></i>
                            </span>
                        </div>
                        <select name="e_categoria" id="e_categoria" class="form-control" @change="selectCategoriaEmpleado($event)">
                            <option value="" disabled selected>Seleccionar categoria</option>
                            <option value="todas">TODOS LOS EMPLEADOS</option>
                            <?php foreach ($categorias as $row) : ?>
                                <option value="<?= $row['id'] ?>">
                                    <?= $row['categoria'] ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="select_empleado">Empleados</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text">
                                <i class="fas fa-user-tie"></i>
                            </span>
                        </div>
                        <v-select id="select_empleado" v-model="select_empleado" :options="empleados" :reduce="row => row.id" label="empleado" style="width: 410px;" />
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                            {{ row }}
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary  btn-sm" data-dismiss="modal">Cerrar</button>
                <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                    <i class="loader loader-info"></i>
                </button>
                <button v-else type="button" class="btn btn-primary btn-sm" @click="asignarServicioEmpleado">Registrar</button>
            </div>
        </div>
    </div>
</div>
