<div class="container" id="appPlanillas" v-cloak>
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Planilla orden</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('planilla') ?>">Planilla orden</a>
                </li>
            </ul>
            <div class="ml-md-auto" style="display: flex;">
                <div class="btn-group" role="group" aria-label="Button group with nested dropdown" style="box-shadow: 2px 6px 15px 0px rgba(69, 65, 78, 0.1);">
                    <button type="button" class="btn btn-light" data-toggle="modal" data-target="#modal_cliente_crear_orden">
                        <i class="fas fa-file-alt"></i> Nueva Orden
                    </button>
                    <div class="btn-group" role="group">
                        <button id="dropdownMenuButton" type="button" class="btn btn-light dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-cog"></i> Configuración
                        </button>
                        <div class="dropdown-menu" aria-labelledby="btnGroupDrop1">
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#modal-marcas">Marca</a>
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#modal-tipo-motor">Tipo de motor</a>
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#modal-motores">Motores</a>
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#modal-categorias">Categorías</a>
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#modal-partes">Partes</a>
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#modal-cat_emp">Empleados</a>
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#modal-servicios">Servicios</a>
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#modal-motor-servicios">Motor - servicios</a>
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#modal-tipomotor-servicios">Tipo de motor - servicios</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-primary card-round">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-4">
                                <div class="icon-big text-center">
                                    <i class="flaticon-pen"></i>
                                </div>
                            </div>
                            <div class="col-8 col-stats">
                                <div class="numbers">
                                    <p class="card-category">Ordenes creadas</p>
                                    <h4 class="card-title">{{dia.todos}}</h4>
                                    <b class="text-white"><?= date("d-m-Y") ?></b>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-4">
                                <div class="icon-big text-center">
                                    <i class="flaticon-list text-success"></i>
                                </div>
                            </div>
                            <div class="col-8 col-stats">
                                <div class="numbers">
                                    <p class="card-category">Terminados</p>
                                    <h4 class="card-title">{{dia.terminado}}</h4>
                                    <b class="text-success"><?= date("d-m-Y") ?></b>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-4">
                                <div class="icon-big text-center">
                                    <i class="flaticon-interface-1 text-info"></i>
                                </div>
                            </div>
                            <div class="col-8 col-stats">
                                <div class="numbers">
                                    <p class="card-category">Entregados</p>
                                    <h4 class="card-title">{{dia.entregado}}</h4>
                                    <b class="text-info"><?= date("d-m-Y") ?></b>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-4">
                                <div class="icon-big text-center">
                                    <i class="flaticon-error text-danger"></i>
                                </div>
                            </div>
                            <div class="col-8 col-stats">
                                <div class="numbers">
                                    <p class="card-category">Anulados</p>
                                    <h4 class="card-title">{{dia.anulada}}</h4>
                                    <b class="text-danger"><?= date("d-m-Y") ?></b>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row row-card-no-pd">
            <div class="col-lg-12">
                <form>
                    <div class="form-row">
                        <div class="col-md-8">
                            <!--<input type="text"> -->
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Filtrar por Mes</label>
                                <select name="mes" class="form-control custom-select" v-model="mes" @change="actualizarDatatab()">
                                    <option value="0">Todos los meses</option>
                                    <option value="01">Enero</option>
                                    <option value="02">Febrero</option>
                                    <option value="03">Marzo</option>
                                    <option value="04">Abril</option>
                                    <option value="05">Mayo</option>
                                    <option value="06">Junio</option>
                                    <option value="07">Julio</option>
                                    <option value="08">Agosto</option>
                                    <option value="09">Septiembre</option>
                                    <option value="10">Octubre</option>
                                    <option value="11">Noviembre</option>
                                    <option value="12">Diciembre</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Filtrar por Año</label>
                                <select name="anio" class="form-control custom-select" v-model="anio" @change="actualizarDatatab()">
                                    <?php for ($m = date('o'); $m >= 2019; $m--) {
                                        if ($m == date('o')) {
                                            echo '<option value="' . $m . '" selected>' . $m . '</option>';
                                        } else {
                                            echo '<option value="' . $m . '">' . $m . '</option>';
                                        }
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-lg-12">
                <ul class="nav nav-pills nav-secondary ml-4" id="pills-tab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="pills-todos-tab" data-toggle="pill" href="#pills-todos" role="tab" aria-controls="pills-todos" aria-selected="true" @click.prevent="obtenerOrdenesTodos()">Todos ({{todos}})</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="pills-porentregar-tab" data-toggle="pill" href="#pills-porentregar" role="tab" aria-controls="pills-porentregar" aria-selected="false" @click.prevent="obtenerOrdenesPreOrden()">Nuevas ({{nuevos}})</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="pills-pendientes-tab" data-toggle="pill" href="#pills-pendientes" role="tab" aria-controls="pills-pendientes" aria-selected="false" @click.prevent="obtenerOrdenesPendientes()">Pendientes ({{pendientes}})</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="pills-creditos-tab" data-toggle="pill" href="#pills-creditos" role="tab" aria-controls="pills-creditos" aria-selected="false" @click.prevent="obtenerOrdenesCreditos()">Creditos ({{creditos}})</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="pills-detenidos-tab" data-toggle="pill" href="#pills-detenidos" role="tab" aria-controls="pills-detenidos" aria-selected="false" @click.prevent="obtenerOrdenesDetenidos()">Detenidos ({{detenidos}})</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="pills-anuladas-tab" data-toggle="pill" href="#pills-anuladas" role="tab" aria-controls="pills-anuladas" aria-selected="false" @click.prevent="obtenerOrdenesAnuladas()">Anuladas ({{anuladas}})</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="pills-autorizado-tab" data-toggle="pill" href="#pills-autorizado" role="tab" aria-controls="pills-autorizado" aria-selected="false" @click.prevent="obtenerOrdenesAutorizados()">Autorizados ({{autorizado}})</a>
                    </li>
                    <!--<li class="nav-item">
                        <a class="nav-link" id="pills-abono-tab" data-toggle="pill" href="#pills-abono" role="tab" aria-controls="pills-abono" aria-selected="false" @click.prevent="obtenerOrdenesAbonado()">Abonos ({{abono}})</a>
                    </li>-->
                    <li class="nav-item">
                        <a class="nav-link" id="pills-entregados-tab" data-toggle="pill" href="#pills-entregados" role="tab" aria-controls="pills-entregados" aria-selected="false" @click.prevent="obtenerOrdenesCompletadas()">Terminados ({{terminados}})</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="pills-completados-tab" data-toggle="pill" href="#pills-completados" role="tab" aria-controls="pills-completados" aria-selected="false" @click.prevent="obtenerOrdensCompletadas()">Completados ({{completados}})</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="pills-entregadascompletas-tab" data-toggle="pill" href="#pills-entregadascompletas" role="tab" aria-controls="pills-entregadascompletas" aria-selected="false" @click.prevent="obtenerOrdenesentregadascompletas()">Entregados ({{entregadascompletas}})</a>
                    </li>
                </ul>
                <div class="tab-content mt-2 mb-3 ml-4" id="pills-tabContent">
                    <div class="tab-pane fade show active" id="pills-todos" role="tabpanel" aria-labelledby="pills-todos-tab">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_todos">
                                <thead>
                                    <tr>
                                        <th>N° orden</th>
                                        <th>Fecha</th>
                                        <th>Cliente</th>
                                        <th>Motor</th>
                                        <th>Presupuesto</th>
                                        <th>Pagado</th>
                                        <th>Estatus</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-porentregar" role="tabpanel" aria-labelledby="pills-porentregar-tab">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_pre_orden">
                                <thead>
                                    <tr>
                                        <th>N° orden</th>
                                        <th>Fecha</th>
                                        <th>Cliente</th>
                                        <th>Motor</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-pendientes" role="tabpanel" aria-labelledby="pills-pendientes-tab">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover table-head-bg-primary table-bordered-bd-primary" id="tabla_pendientes">
                                <thead>
                                    <tr>
                                        <th>N° orden</th>
                                        <th>Fecha</th>
                                        <th>Cliente</th>
                                        <th>Motor</th>
                                        <th>Presupuesto</th>
                                        <th>Pagado</th>
                                        <th></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-creditos" role="tabpanel" aria-labelledby="pills-creditos-tab">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_creditos">
                                <thead>
                                    <tr>
                                        <th>N° orden</th>
                                        <th>Fecha</th>
                                        <th>Cliente</th>
                                        <th>Motor</th>
                                        <th>Presupuesto</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-detenidos" role="tabpanel" aria-labelledby="pills-detenidos-tab">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_detenidos">
                                <thead>
                                    <tr>
                                        <th>N° orden</th>
                                        <th>Fecha</th>
                                        <th>Cliente</th>
                                        <th>Motor</th>
                                        <th>Presupuesto</th>
                                        <th></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-anuladas" role="tabpanel" aria-labelledby="pills-anuladas-tab">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_anuladas">
                                <thead>
                                    <tr>
                                        <th>N° orden</th>
                                        <th>Fecha</th>
                                        <th>Cliente</th>
                                        <th>Motor</th>
                                        <th>Presupuesto</th>
                                        <th>Estatus</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-autorizado" role="tabpanel" aria-labelledby="pills-autorizado-tab">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_autorizados">
                                <thead>
                                    <tr>
                                        <th>N° orden</th>
                                        <th>Fecha</th>
                                        <th>Cliente</th>
                                        <th>Motor</th>
                                        <th>Presupuesto</th>
                                        <th>Pagado</th>
                                        <th>Ticket</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in autorizados">
                                        <td><a :href="row.uri" target="_blank">{{ row.orden }}</a></td>
                                        <td>{{ row.creado }}</td>
                                        <td>{{ row.cliente }}</td>
                                        <td>{{ row.motor }}</td>
                                        <td>
                                            <?php if ($generar_orden) : ?>
                                                <div v-if="row.existe_presupuesto == true">
                                                    <a :href="row.uri_presupuesto" target="_blank" rel="noopener noreferrer">{{ row.presupuesto }}</a>
                                                </div>
                                                <div v-else>
                                                    No asignado
                                                </div>
                                            <?php else : ?>
                                                {{ row.presupuesto }}
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <span v-if="row.pagado == 'PENDIENTE'" class="text-danger">{{ row.pagado }}</span>
                                            <span v-else-if="row.pagado == 'ABONADO'" class="text-primary">{{ row.pagado }}</span>
                                            <span v-else-if="row.pagado == 'AUTORIZADO'" class="text-warning">{{ row.pagado }}</span>
                                            <span v-else class="text-success">{{ row.pagado }}</span>
                                        </td>
                                        <td>
                                            <div class="form-button-action">
                                                <div class="input-group-append">
                                                    <button class="btn btn-sm btn-light dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa fa-print text-dark"></i></button>
                                                    <div class="dropdown-menu" x-placement="top-start">
                                                        <?php foreach ($impresoras_de_ticket as $row) : ?>
                                                            <a class="dropdown-item" href="#" @click.prevent="imprimirTicket(row.id, '<?= $row['id'] ?>')"><?= $row['impresora'] ?></a>
                                                        <?php endforeach; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <div class="form-button-action">
                                                <?php if ($generar_orden) : ?>
                                                    <a v-if="row.existe_presupuesto == false" href="#" title="Generar Presupuesto" class="btn btn-link btn-primary" @click.prevent="abrirModalGenerarPresupuesto(row)">
                                                        <i class="fa fa-file text-dark"></i>
                                                    </a>
                                                <?php endif; ?>
                                                <a href="#" title="Anular" class="btn btn-link btn-primary" @click="anularOrden(row.id,row.orden)">
                                                    <i class="fa fa-times text-danger"></i>
                                                </a>
                                                <a href="#" title="Detener" class="btn btn-link btn-primary" @click="detenerOrden(row.id,row.orden)">
                                                    <i class="fa fa-stop-circle text-warning"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--<div class="tab-pane fade" id="pills-abono" role="tabpanel" aria-labelledby="pills-abono-tab">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_abonos">
                                <thead>
                                    <tr>
                                        <th>N° orden</th>
                                        <th>Fecha</th>
                                        <th>Cliente</th>
                                        <th>Motor</th>
                                        <th>Presupuesto</th>
                                        <th>Pagado</th>
                                        <th>Ticket</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in abonos">
                                        <td><a :href="row.uri" target="_blank">{{ row.orden }}</a></td>
                                        <td>{{ row.creado }}</td>
                                        <td>{{ row.cliente }}</td>
                                        <td>{{ row.motor }}</td>
                                        <td>
                                            <?php if ($generar_orden) : ?>
                                                <div v-if="row.existe_presupuesto == true">
                                                    <a :href="row.uri_presupuesto" target="_blank" rel="noopener noreferrer">{{ row.presupuesto }}</a>
                                                </div>
                                                <div v-else>
                                                    No asignado
                                                </div>
                                            <?php else : ?>
                                                {{ row.presupuesto }}
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <span v-if="row.pagado == 'PENDIENTE'" class="text-danger">{{ row.pagado }}</span>
                                            <span v-else-if="row.pagado == 'ABONADO'" class="text-primary">{{ row.pagado }}</span>
                                            <span v-else-if="row.pagado == 'AUTORIZADO'" class="text-warning">{{ row.pagado }}</span>
                                            <span v-else class="text-success">{{ row.pagado }}</span>
                                        </td>
                                        <td>
                                            <div class="form-button-action">
                                                <div class="input-group-append">
                                                    <button class="btn btn-sm btn-light dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa fa-print text-dark"></i></button>
                                                    <div class="dropdown-menu" x-placement="top-start">
                                                        <?php foreach ($impresoras_de_ticket as $row) : ?>
                                                            <a class="dropdown-item" href="#" @click.prevent="imprimirTicket(row.id, '<?= $row['id'] ?>')"><?= $row['impresora'] ?></a>
                                                        <?php endforeach; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <div class="form-button-action">
                                                <?php if ($generar_orden) : ?>
                                                    <a v-if="row.existe_presupuesto == false" href="#" title="Generar Presupuesto" class="btn btn-link btn-primary" @click.prevent="abrirModalGenerarPresupuesto(row)">
                                                        <i class="fa fa-file text-dark"></i>
                                                    </a>
                                                <?php endif; ?>
                                                <a href="#" title="Anular" class="btn btn-link btn-primary" @click="anularOrden(row.id,row.orden)">
                                                    <i class="fa fa-times text-danger"></i>
                                                </a>
                                                <a href="#" title="Detener" class="btn btn-link btn-primary" @click="detenerOrden(row.id,row.orden)">
                                                    <i class="fa fa-stop-circle text-warning"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>-->
                    <div class="tab-pane fade" id="pills-entregados" role="tabpanel" aria-labelledby="pills-entregados-tab">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table-completados">
                                <thead>
                                    <tr>
                                        <th>N° orden</th>
                                        <th>Fecha</th>
                                        <th>Cliente</th>
                                        <th>Motor</th>
                                        <th>Presupuesto</th>
                                        <th>Estatus</th>
                                        <th></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-completados" role="tabpanel" aria-labelledby="pills-completados-tab">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table-termcompletado">
                                <thead>
                                    <tr>
                                        <th>N° orden</th>
                                        <th>Fecha</th>
                                        <th>Cliente</th>
                                        <th>Motor</th>
                                        <th>Presupuesto</th>
                                        <th>Estatus</th>
                                        <th></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-entregadascompletas" role="tabpanel" aria-labelledby="pills-entregadascompletas-tab">
                        <div class="table-responsive">
                            <table class="table display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table-entregadascompletas">
                                <thead>
                                    <tr>
                                        <th>N° orden</th>
                                        <th>Fecha</th>
                                        <th>Cliente</th>
                                        <th>Motor</th>
                                        <th>Presupuesto</th>
                                        <th>Estatus</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modal_generar_presupuesto.php' ?>
    <?php include 'modal_imprimir.php' ?>
</div>

<script src="<?= asset('assetsvuejs/planillas/index.js') ?>"></script>
<link rel="stylesheet" href="<?= asset('assets/vue-select.css') ?>">
<script src="<?= asset('assets/vue-select.js') ?>"></script>

<?php include 'configuracion/modal_conf_marca.php' ?>
<?php include 'configuracion/modal_conf_motor.php' ?>
<?php include 'configuracion/modal_conf_categoria.php' ?>
<?php include 'configuracion/modal_conf_parte.php' ?>
<?php include 'configuracion/modal_conf_cat_emp.php' ?>
<?php include 'configuracion/modal_conf_servicios.php' ?>
<?php include 'configuracion/modal_conf_motor_servicio.php' ?>
<?php include 'configuracion/modal_conf_tipo_motor.php' ?>
<?php include 'configuracion/modal_conf_tipomotor_servicio.php' ?>

<?php include 'modal_cliente_crear_orden.php' ?>
