<div id="appMotorServicios">
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal-motor-servicios">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header mh">
                    <h4 class="modal-title">Servicios</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <form id="form_motor_servicio" @submit.prevent="guardarMotorServicios">
                                <div class="form-row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="s_motor">Motores</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">
                                                        <i class="flaticon-mark-1"></i>
                                                    </span>
                                                </div>
                                                <select name="ms_motor" id="ms_motor" class="form-control custom-select" style="padding: .4rem 1rem;" @change="defaultSelectCategoria">
                                                    <option value="" selected></option>
                                                    <option :value="row.id" v-for="row in motores">
                                                        {{ row.motor }} - {{ row.marca.marca }} - {{ row.modelo }}
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="s_categoria">Categorías</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">
                                                        <i class="flaticon-mark-1"></i>
                                                    </span>
                                                </div>
                                                <select name="ms_categoria" id="ms_categoria" class="form-control custom-select" style="padding: .4rem 1rem;" @click="obtenerServiciosPorCategoria($event)">
                                                    <option value="" disabled>Seleccionar categoría</option>
                                                    <option :value="row.id" v-for="row in categorias">
                                                        {{ row.categoria }}
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label for="ms_select_servicio">Servicios</label>
                                            <v-select id="ms_select_servicio" v-model="ms_select_servicio" :options="productos" :reduce="row => row.id" label="descripcion" />
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group pull-right">
                                    <button type="submit" class="btn btn-sm boton-primario-p">Registrar</button>
                                </div>
                            </form>
                            <div class="row">
                                <div class="col-12">
                                    <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                        {{ row }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col table-responsive">
                            <table class="display table table-striped table-hover dataTable" id="tabla_motor_servicios">
                                <thead>
                                    <tr>
                                        <th>Motor</th>
                                        <th>Categoria</th>
                                        <th>Servicio</th>
                                        <th class="text-center">Precio</th>
                                        <th class="text-center">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in servicios">
                                        <td style="height: inherit;">{{ row.motor.motor }}</td>
                                        <td style="height: inherit; width: 12%">{{ row.categoria.categoria }}</td>
                                        <td style="height: inherit; ">{{ row.servicio.servicio }}</td>
                                        <td style="height: inherit; width: 20%" class="text-right">{{ row.servicio.precio }}</td>
                                        <td class="text-center" style="height: inherit; width: 12%">
                                            <div class="form-button-action">
                                                <button type="button" title="Eliminar" class="btn btn-link btn-primary" @click="eliminarServicio(row)">
                                                    <i class="fa fa-trash text-dark"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    Vue.component('v-select', VueSelect.VueSelect)

    new Vue({
        el: '#appMotorServicios',
        data: {
            id_servicio: '',
            motores: [],
            categorias: [],
            ms_select_servicio: null,
            productos: [],
            servicios: [],
            errorForm: [],
            cargando: false
        },
        mounted() {

            var self = this;

            self.resetear();

            $('#modal-motor-servicios').on('shown.bs.modal', function(e) {
                $('#ms_motor').trigger('focus');
                self.obtenerCategorias();
                self.obtenerMotores();
                self.obtenerMotorServicios();
            });

            $('#modal-motor-servicios').on('hidden.bs.modal', function(e) {
                self.resetear();
            });
        },
        methods: {
            defaultSelectCategoria() {
                document.getElementById('ms_categoria').selectedIndex = 0;
            },
            eliminarTabla() {
                $('#tabla_motor_servicios').DataTable().destroy();
            },
            redibujarTabla() {
                $("#tabla_motor_servicios").DataTable({
                    retrieve: true,
                    dom: 'Bfrtip',
                    buttons: [{
                        title: 'Motores',
                        extend: 'excelHtml5',
                        exportOptions: {
                            columns: [0, 1, 2]
                        }
                    }]
                });
            },
            resetear() {
                this.errorForm = [];
                this.id_servicio = '';
                this.ms_select_servicio = null;
                document.getElementById('form_motor_servicio').reset();
                document.getElementById('ms_motor').selectedIndex = 0;
                document.getElementById('ms_categoria').selectedIndex = 0;
            },
            guardarMotorServicios() {

                this.errorForm = [];
                let form_motor_servicio = document.getElementById('form_motor_servicio');
                let formData = new FormData(form_motor_servicio);

                if (!formData.get('ms_motor'))
                    this.errorForm.push('EL campo Motor es obligatorio');
                if (!formData.get('ms_categoria'))
                    this.errorForm.push('EL campo Categoria es obligatorio');
                if (!this.ms_select_servicio) {
                    this.errorForm.push('EL campo Servicio es obligatorio');
                } else {
                    formData.append('ms_servicio', this.ms_select_servicio);
                }

                if (this.id_servicio) {
                    formData.append('id', this.id_servicio);
                }

                if (this.errorForm.length == 0) {
                    this.cargando = true;
                    axios({
                        method: 'post',
                        url: 'planilla/guardarMotorServicios',
                        data: formData
                    }).then(response => {
                        if (response.data.errors == null) {
                            this.eliminarTabla();
                            this.obtenerMotorServicios();
                        } else {
                            this.errorForm = response.data.errors;
                        }
                    }).catch(e => notificacion()).finally(() => {
                        this.cargando = false;
                    });
                }
            },
            async obtenerMotorServicios() {
                this.resetear();
                this.eliminarTabla();
                await axios.get('planilla/obtenerMotorServicios').then(response => {
                    this.servicios = response.data;
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    this.redibujarTabla();
                });
            },
            eliminarServicio(servicio) {
                axios.get('planilla/eliminarMotorServicio/' + servicio.id).then(response => {
                    if (response.data == true) {
                        let posicion = this.servicios.findIndex((item) => item.id == servicio.id);
                        this.servicios.splice(posicion, 1);
                        this.eliminarTabla();
                        this.redibujarTabla();
                        notificacion('fa fa-trash', 'Eliminado', servicio.servicio.servicio, 'danger');
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            },
            async obtenerMotores() {
                axios.get('planilla/obtenerMotores').then(response => {
                    this.motores = response.data;
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            },
            async obtenerCategorias() {
                axios.get('planilla/obtenerCategorias').then(response => {
                    this.categorias = response.data;
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            },
            obtenerServiciosPorCategoria(event) {
                const cat_value = document.getElementById('ms_categoria').value;
                const mot_value = document.getElementById('ms_motor').value;
                if (cat_value && mot_value) {
                    axios.get('planilla/obtenerServiciosPorCategoria', {
                        params: {
                            id_categoria: cat_value,
                            id_motor: mot_value
                        }
                    }).then(response => {
                        this.productos = response.data;
                    }).catch(e => notificacion());
                }
            }
        }
    })
</script>