<div id="appMarcas">
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal-marcas">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header mh">
                    <h4 class="modal-title">Registrar Marca de Motores</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col">
                            <form id="form_marca" @submit.prevent="guardarMarcas">
                                <div class="form-group">
                                    <label for="marca">Nombre de la Marca</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">
                                                <i class="fas fa-trademark"></i>
                                            </span>
                                        </div>
                                        <input type="text" id="marca" name="marca" maxlength="100" class="form-control" onkeyup="this.value=this.value.toUpperCase()">
                                    </div>
                                </div>
                                <div class="form-group pull-right">
                                    <button type="submit" class="btn btn-sm boton-primario-p">Registrar</button>
                                </div>
                            </form>
                            <div class="row">
                                <div class="col-12">
                                    <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                        {{ row }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col" style="margin: 0 auto; max-width: 97%;">
                            <table class="display table table-striped table-hover" id="tabla_marcas">
                                <thead>
                                    <tr>
                                        <th style="height: inherit;">Marcas</th>
                                        <th class="text-center" style="height: inherit; width: 20%">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in marcas">
                                        <td style="height: inherit;">{{ row.marca }}</td>
                                        <td class="text-center" style="height: inherit; width: 20%">
                                            <div class="form-button-action">
                                                <button type="button" title="Editar" class="btn btn-link btn-dark-r" @click="editarMarca(row)">
                                                    <i class="fa fa-edit text-info"></i>
                                                </button>
                                                <button type="button" title="Eliminar" class="btn btn-link btn-dark-r" @click="eliminarMarca(row)">
                                                    <i class="fa fa-trash text-dark"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    new Vue({
        el: '#appMarcas',
        data: {
            id_marca: '',
            marcas: [],
            errorForm: [],
            cargando: false
        },
        created() {
            this.obtenerMarcas();
        },
        mounted() {
            $('#modal-marcas').on('shown.bs.modal', function(e) {
                $('#marca').trigger('focus');
            });
        },
        methods: {
            resetearFormulario() {
                this.errorForm = [];
                this.id_marca = '';
                document.getElementById('form_marca').reset();
            },
            eliminarTabla() {
                if ($.fn.DataTable.isDataTable('#tabla_marcas')) {
                    $('#tabla_marcas').DataTable().destroy();
                }
            },
            /* redibujarTabla() {
                $(document).ready(function() {
                    $("#tabla_marcas").DataTable({
                        info: false,
                        retrieve: true,
                        dom: 'Bfrtip',
                        buttons: [{
                            title: 'Marcas',
                            extend: 'excelHtml5',
                            exportOptions: {
                                columns: [0]
                            }
                        }]
                    });
                });
            }, */
            guardarMarcas() {

                this.errorForm = [];
                let form_marca = document.getElementById('form_marca');
                let formData = new FormData(form_marca);

                if (!formData.get('marca'))
                    this.errorForm.push('EL campo marca es obligatorio');

                if (this.id_marca) {
                    formData.append('id', this.id_marca);
                }

                if (this.errorForm.length == 0) {
                    this.cargando = true;
                    axios({
                        method: 'post',
                        url: 'planilla/guardarMarcas',
                        data: formData
                    }).then(response => {
                        if (response.data.errors == null) {
                            this.eliminarTabla();
                            this.obtenerMarcas();
                            notificacion('fa fa-check', 'Guardado', 'Registro exitoso', 'success');
                        } else {
                            this.errorForm = response.data.errors;
                        }
                    }).catch(e => notificacion()).finally(() => {
                        this.cargando = false;
                    });
                }
            },
            editarMarca(marca) {
                this.id_marca = marca.id;
                document.getElementById('marca').value = marca.marca;
            },
            obtenerMarcas() {
                this.resetearFormulario();
                axios.get('planilla/obtenerMarcas').then(response => {
                    this.marcas = response.data;
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    //this.redibujarTabla();
                });
            },
            eliminarMarca(marca) {
                axios.get('planilla/eliminarMarca/' + marca.id).then(response => {
                    if (response.data == true) {
                        let posicion = this.marcas.findIndex((item) => item.id == marca.id);
                        this.marcas.splice(posicion, 1);
                        this.eliminarTabla();
                        //this.redibujarTabla();
                        notificacion('fa fa-trash', 'Eliminado', marca.marca.toUpperCase(), 'danger');
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            }
        }
    })
</script>