<div id="appCategorias">
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal-categorias">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header mh">
                    <h4 class="modal-title">Registrar Categorías</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col">
                            <form id="form_categoria" @submit.prevent="guardarCategorias">
                                <div class="form-group">
                                    <label for="categoria">Nombre de la Categoría</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">
                                                <i class="flaticon-mark-1"></i>
                                            </span>
                                        </div>
                                        <input type="text" id="categoria" name="categoria" maxlength="100" class="form-control" onkeyup="this.value=this.value.toUpperCase()">
                                    </div>
                                </div>
                                <div class="form-group text-right">
                                    <button type="submit" class="btn btn-sm boton-primario-p">Registrar</button>
                                </div>
                            </form>
                            <div class="row">
                                <div class="col-12">
                                    <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                        {{ row }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col" style="margin: 0 auto; max-width: 97%;">
                            <table class="display table table-striped table-hover dataTable" id="tabla_categorias">
                                <thead>
                                    <tr>
                                        <th style="height: inherit;">Nombre</th>
                                        <th class="text-center" style="height: inherit; width: 20%">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in categorias">
                                        <td style="height: inherit;">{{ row.categoria }}</td>
                                        <td class="text-center" style="height: inherit; width: 20%">
                                            <div class="form-button-action">
                                                <button type="button" title="Editar" class="btn btn-link btn-primary" @click="editarCategoria(row)">
                                                    <i class="fa fa-edit text-info"></i>
                                                </button>
                                                <button type="button" title="Eliminar" class="btn btn-link btn-primary" @click="eliminarCategoria(row)">
                                                    <i class="fa fa-trash text-dark"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    new Vue({
        el: '#appCategorias',
        data: {
            id_categoria: '',
            categorias: [],
            errorForm: [],
            cargando: false
        },
        created() {
            this.obtenerCategorias();
        },
        mounted() {
            $('#modal-categorias').on('shown.bs.modal', function(e) {
                $('#categoria').trigger('focus');
            });
        },
        methods: {
            eliminarTabla() {
                if ($.fn.DataTable.isDataTable('#tabla_categorias')) {
                    $('#tabla_categorias').DataTable().destroy();
                }
            },
            /* redibujarTabla() {
                $(document).ready(function() {
                    $("#tabla_categorias").DataTable({
                        retrieve: true,
                        dom: 'Bfrtip',
                        buttons: [{
                            title: 'Motores',
                            extend: 'excelHtml5',
                            exportOptions: {
                                columns: [0]
                            }
                        }]
                    });
                });
            }, */
            resetearFormulario() {
                this.errorForm = [];
                this.id_categoria = '';
                document.getElementById('form_categoria').reset();
            },
            guardarCategorias() {

                this.errorForm = [];
                let form_categoria = document.getElementById('form_categoria');
                let formData = new FormData(form_categoria);

                if (!formData.get('categoria'))
                    this.errorForm.push('EL campo Categoria es obligatorio');

                if (this.id_categoria) {
                    formData.append('id', this.id_categoria);
                }

                if (this.errorForm.length == 0) {
                    this.cargando = true;
                    axios({
                        method: 'post',
                        url: 'planilla/guardarCategorias',
                        data: formData
                    }).then(response => {
                        if (response.data.errors == null) {
                            this.eliminarTabla();
                            this.obtenerCategorias();
                            notificacion('fa fa-check', 'Guardado', 'Registro exitoso', 'success');
                        } else {
                            this.errorForm = response.data.errors;
                        }
                    }).catch(e => notificacion()).finally(() => {
                        this.cargando = false;
                    });
                }
            },
            editarCategoria(categoria) {
                this.id_categoria = categoria.id;
                document.getElementById('categoria').value = categoria.categoria;
            },
            obtenerCategorias() {
                this.resetearFormulario();
                axios.get('planilla/obtenerCategorias').then(response => {
                    this.categorias = response.data;
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    //this.redibujarTabla();
                });
            },
            eliminarCategoria(categoria) {
                axios.get('planilla/eliminarCategoria/' + categoria.id).then(response => {
                    if (response.data == true) {
                        let posicion = this.categorias.findIndex((item) => item.id == categoria.id);
                        this.categorias.splice(posicion, 1);
                        this.eliminarTabla();
                        //this.redibujarTabla();
                        notificacion('fa fa-trash', 'Eliminado', categoria.categoria.toUpperCase(), 'danger');
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            }
        }
    })
</script>