<?php

namespace App\Modelos;

use Core\Database;

class PlanillaMotorServicios extends Database
{
    protected $table = 'app_planillas_motor_servicios';
    protected $id = 'ms_id';

    public function obtenerMotoresServicios()
    {
        return $this->consultar("SELECT ms_id, mot_id, CONCAT(m_marca, ' - ', mot_motor, ' - ', mot_modelo) motor, cat_id, cat_categorias, pro_id, pro_precio, pro_descripcion
        FROM app_planillas_motor_servicios ms
        JOIN app_motores m ON m.mot_id = ms.ms_motid
        JOIN app_marcas mar ON mar.m_id = m.mot_marca
        JOIN app_planillas_servicios s ON s.serv_id = ms.ms_servid
        JOIN app_planilla_categorias c ON c.cat_id = s.serv_catid
        JOIN app_productos p ON p.pro_id = s.serv_proid
        ORDER BY mot_marca, mot_motor")->all();
    }
}
