<?php

namespace App\Modelos;

use Core\Database;

class PlanillaCategoriaEmpleado extends Database
{
    protected $table = 'app_planilla_categorias_empleados';
    protected $id = 'catemp_id';

    public function obtenerCategorias()
    {
        return $this->consultar("SELECT * 
        FROM app_planilla_categorias_empleados ce
        JOIN app_planilla_categorias c ON ce.catemp_catid = c.cat_id 
        JOIN app_empleados_info einfo ON einfo.einfo_id = ce.catemp_empid")->all();
    }

    public function obtenerEmpleadosSegunCategoria(int $id_categoria)
    {
        return $this->consultar("SELECT DISTINCT(einfo_id), einfo_id id, CONCAT(einfo_nombres, ' ', einfo_apellidos) empleado
        FROM app_planilla_categorias_empleados ce
        JOIN app_empleados_info einfo ON einfo.einfo_id = ce.catemp_empid
        WHERE catemp_catid = $id_categoria AND einfo_id != 1 AND einfo_eliminado=0")->all();
    }

    public function obtenerEmpleadosDeCategorias()
    {
        return $this->consultar("SELECT einfo_id id, CONCAT(einfo_nombres, ' ', einfo_apellidos) empleado
        FROM app_empleados_info einfo WHERE einfo_id != 1 AND einfo_eliminado=0")->all();
    }
}
