<?php

namespace App\Controladores;

use App\Modelos\BitacoraMensajesModel;
use App\Modelos\CarritoVentasModel;
use App\Modelos\Cliente;
use App\Modelos\Marca;
use App\Modelos\Motor;
use App\Modelos\OrdendeentregaArticulos;
use App\Modelos\PlanillaCategoria;
use App\Modelos\PlanillaCategoriaEmpleado;
use App\Modelos\PlanillaCategoriaParte;
use App\Modelos\PlanillaMotorServicios;
use App\Modelos\PlanillaOrdenDeEntrega;
use App\Modelos\PlanillaPreOrden;
use App\Modelos\PlanillaPreOrdenPartes;
use App\Modelos\PlanillaPreOrdenServicios;
use App\Modelos\PlanillaPreOrdenServiciosEmpleado;
use App\Modelos\PlanillaServAdicionales;
use App\Modelos\PlanillaServicio;
use App\Modelos\SmsContactosModel;
use App\Modelos\TipoMotor;
use App\Modelos\TipoMotorServicio;
use Core\Controller;
use Core\Helpers\Documento;
use Core\Helpers\Moneda;
use Core\Librerias\CarritoVentasEditar;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Librerias\SMS;
use Core\Vista;
use DateInterval;
use DateTime;
use DateTimeZone;

final class PlanillaControlador extends Controller
{
	private $array_errors = [];
	private $module;
	private $newPreOrden;

	public function __construct()
	{
		parent::__construct();
		$this->module = new Module('planilla');
		$this->newPreOrden = new PlanillaPreOrden();
	}

	public function index()
	{
		if ('GET' == $_SERVER['REQUEST_METHOD']) {

			$go = $this->module->has_module_action_permission('planilla', 'generar_orden', $_SESSION['user_data']['emp_id']);

			$impresoras = $this->newPreOrden->consultar("SELECT * FROM app_impresoras WHERE imp_tipo = 2 AND imp_estatus = 1")->all();
			$impresoras_de_ticket = [];

			if (is_countable($impresoras) && count($impresoras)) {
				foreach ($impresoras as $row) {
					$impresoras_de_ticket[] = [
						'id' => $row['imp_id'],
						'impresora' => $row['imp_descripcion'],
					];
				}
			}

			return Vista::view('planilla/index', [
				'generar_orden' => $go,
				'impresoras_de_ticket' => $impresoras_de_ticket,
				'series' => $this->newPreOrden->obtenerSeriesEmpleado(),
				'almacenes' => $this->newPreOrden->obtenerAlmacenesEmpleado(),
				'divisas' => $this->newPreOrden->obtenerDivisaEmpleado(),
				'tipos_de_documentos' => $GLOBALS['newDBIni']->consultar("SELECT * FROM app_tipo_documentos")->all()
			]);
		}
	}

	public function obtenerOrdenesCompletadas()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$anio = filter_input(INPUT_POST, 'anio', FILTER_SANITIZE_NUMBER_INT);
			$mes = $this->solicitud->sanitize($_POST['mes'], FILTER_SANITIZE_NUMBER_INT);

			$draw = $_POST['draw'];
			$row = $_POST['start'];
			$rowperpage = $_POST['length']; // Rows display per page
			$columnIndex = $_POST['order'][0]['column']; // Column index
			$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
			$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
			$searchValue = $_POST['search']['value'];

			if ($mes == 0) {
				$peticion = "YEAR(p.pre_modificado)=$anio";
			} else {
				$peticion =  "MONTH(p.pre_modificado)=$mes AND YEAR(p.pre_modificado)=$anio";
			}

			$totalRecordwithFilter = "";
			## Search 
			$searchQuery = " ";
			if ($searchValue != '') {
				$searchQuery = " AND (p.pre_correlativo LIKE '%" . $searchValue . "%' OR 
            p.pre_creado LIKE '%" . $searchValue . "%' OR p.pre_modificado LIKE '%" . $searchValue . "%' OR m.m_marca LIKE '%" . $searchValue . "%' OR c.cli_razon_social LIKE '%" . $searchValue . "%' OR mot.mot_motor LIKE '%" . $searchValue . "%') ";
			}

			## Total number of records without filtering
			$totalRecords = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 2 AND $peticion ORDER BY pre_id DESC")->count();

			$totalRecordwithFilter = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 2 AND $peticion $searchQuery ORDER BY p.pre_id DESC")->count();

			## Fetch records
			$ordenes = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 2 AND $peticion " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();


			$lista = [];
			$entreg = '';

			if (is_countable($ordenes) && count($ordenes)) {

				foreach ($ordenes as $row) {

					$presupuesto = '';
					$uri = '';
					$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$row['pre_id']}")->row();
					$total_pagos = $this->newPreOrden->consultar("SELECT SUM(fab_conversion) as total FROM app_movimientos WHERE fab_idgenerico={$existe_presupuesto['po_nid']} AND fab_doc = 12")->row();
					$data_presupuesto = $this->newPreOrden->consultar("SELECT n_correlativo, n_total FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();
					$total_pagado = round($total_pagos['total'], 2);
					$pagado = $total_pagado >= round($data_presupuesto['n_total'], 2) ? 1 : 0;
					$documento = Documento::obtener(12);
					$presupuesto = $documento['prefijo'] . $data_presupuesto['n_correlativo'];
					$uri = ruta_base()  . 'ordendeentregaeditar/verFactura/' . $existe_presupuesto['po_nid'];

					if ($existe_presupuesto) {
						$total_pagos = $this->newPreOrden->consultar("SELECT SUM(fab_conversion) as total FROM app_movimientos WHERE fab_idgenerico={$existe_presupuesto['po_nid']} AND fab_doc = 12")->row();
						$data_presupuesto = $this->newPreOrden->consultar("SELECT n_correlativo, n_total FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();
						$total_pagado = round($total_pagos['total'], 2);
						$total_factura = round($data_presupuesto['n_total'], 2);

						if ($total_pagado == 0 || $total_factura == 0) {
							$pagado = 0;
						} else {
							$pagador = $total_pagado - $total_factura;

							if ($pagador == 0) {
								$pagado = 1;
							}
							if ($pagador < 0) {
								$pagado = 2;
							}
						}

						if ($pagado == 0) {
							if ($existe_presupuesto['po_estatus'] == 1) {
								$pagado = 3;
							}
						}
					}

					switch ($pagado) {
						case 0:
							$str_pagado = 'PENDIENTE';
							break;
						case 1:
							$str_pagado = 'PAGADO';
							break;
						case 2:
							$str_pagado = 'ABONADO';
							break;
						default:
							$str_pagado = 'AUTORIZADO';
							break;
					}
					if ($pagado == 1) {
						$lista[] = [
							'id' => $row['pre_id'],
							'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
							'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
							'generar_orden' => $this->module->has_module_action_permission('planilla', 'generar_orden', $_SESSION['user_data']['emp_id']),
							'pre_correlativo' => $row['pre_correlativo'] ?? 0,
							'cli_razon_social' => $row['cli_razon_social'],
							'pre_creado' => date('d-m-Y', strtotime($row['pre_creado'])),
							'pre_modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
							'existe_presupuesto' => $existe_presupuesto ? true : false,
							'presupuesto' => $presupuesto,
							'uri_presupuesto' => $uri,
							'pagado' => $str_pagado,
							'mot_motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
						];
					}
				}
			}

			Http::json_response([
				"draw" => intval($draw),
				"iTotalRecords" => $totalRecords,
				"iTotalDisplayRecords" => $totalRecordwithFilter,
				"aaData" => $lista
			]);
		}
	}

	public function obtenerOrdenesCountTodas()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$anio = $this->solicitud->sanitize($_POST['anio'], FILTER_SANITIZE_NUMBER_INT);
			$mes = $this->solicitud->sanitize($_POST['mes'], FILTER_SANITIZE_NUMBER_INT);

			if ($mes == 0) {
				$peticion = "YEAR(p.pre_modificado)=$anio";
			} else {
				$peticion =  "MONTH(p.pre_modificado)=$mes AND YEAR(p.pre_modificado)=$anio";
			}

			$terminado=$this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 2 AND $peticion ORDER BY pre_id DESC")->count();

			$terminado_entregado=$this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 2 AND pre_entrega = 1 AND $peticion ORDER BY pre_id DESC")->count();

			$todas=$this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE $peticion ORDER BY pre_id DESC")->count();

			$nuevo=$this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 0 AND $peticion ORDER BY pre_id DESC")->count();

			$detenido=$this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 4 AND $peticion ORDER BY pre_id DESC")->count();

			$credito=$this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 5 AND $peticion ORDER BY pre_id DESC")->count();

			$pendiente=$this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 1 AND $peticion ORDER BY pre_id DESC")->count();

			$anulada=$this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 3 AND $peticion ORDER BY pre_id DESC")->count();

			$autorizado = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 1 AND $peticion ORDER BY pre_id DESC")->all();

			$array_autorizado = [];
			$array_abono = [];

			if (is_countable($autorizado) && count($autorizado)) {
				foreach ($autorizado as $row) {
					$presupuesto = '';
					$uri = '';
					$pagado = 0;

					$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$row['pre_id']}")->row();

					if ($existe_presupuesto) {
						$total_pagos = $this->newPreOrden->consultar("SELECT SUM(fab_conversion) as total FROM app_movimientos WHERE fab_idgenerico={$existe_presupuesto['po_nid']} AND fab_doc = 12")->row();
						$data_presupuesto = $this->newPreOrden->consultar("SELECT n_correlativo, n_total FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();
						$total_pagado = round($total_pagos['total'], 2);
						$total_factura = round($data_presupuesto['n_total'], 2);

						if ($total_pagado == 0 || $total_factura == 0) {
							$pagado = 0;
						} else {
							$pagador = $total_pagado - $total_factura;

							if ($pagador == 0) {
								$pagado = 1;
							}
							if ($pagador < 0) {
								$pagado = 2;
							}
						}

						$documento = Documento::obtener(12);
						$presupuesto = $documento['prefijo'] . $data_presupuesto['n_correlativo'];
						$uri = ruta_base()  . 'ordendeentregaeditar/verFactura/' . $existe_presupuesto['po_nid'];

						if ($pagado == 0) {
							if ($existe_presupuesto['po_estatus'] == 1) {
								$pagado = 3;
							}
						}
					}

					if ($pagado == 3) {
						$str_pagado = 'AUTORIZADO';
						$array_autorizado[] = [
							'id' => $row['pre_id'],
							'generar_orden' => $this->module->has_module_action_permission('planilla', 'generar_orden', $_SESSION['user_data']['emp_id']),
							'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
							'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
							'pre_correlativo' => $row['pre_correlativo'] ?? 0,
							'cli_razon_social' => $row['cli_razon_social'],
							'pre_creado' => date('d-m-Y', strtotime($row['pre_creado'])),
							'pre_modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
							'existe_presupuesto' => $existe_presupuesto ? true : false,
							'presupuesto' => $presupuesto,
							'uri_presupuesto' => $uri,
							'pagado' => $str_pagado,
							'mot_motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
						];
					}
					if ($pagado == 1) {
						$str_pagado = 'PAGADO';
						$array_autorizado[] = [
							'id' => $row['pre_id'],
							'generar_orden' => $this->module->has_module_action_permission('planilla', 'generar_orden', $_SESSION['user_data']['emp_id']),
							'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
							'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
							'pre_correlativo' => $row['pre_correlativo'] ?? 0,
							'cli_razon_social' => $row['cli_razon_social'],
							'pre_creado' => date('d-m-Y', strtotime($row['pre_creado'])),
							'pre_modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
							'existe_presupuesto' => $existe_presupuesto ? true : false,
							'presupuesto' => $presupuesto,
							'uri_presupuesto' => $uri,
							'pagado' => $str_pagado,
							'mot_motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
						];
					}

					if ($pagado == 2) {
						$str_pagado = 'ABONADO';
						$array_autorizado[] = [
							'id' => $row['pre_id'],
							'generar_orden' => $this->module->has_module_action_permission('planilla', 'generar_orden', $_SESSION['user_data']['emp_id']),
							'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
							'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
							'pre_correlativo' => $row['pre_correlativo'] ?? 0,
							'cli_razon_social' => $row['cli_razon_social'],
							'pre_creado' => date('d-m-Y', strtotime($row['pre_creado'])),
							'pre_modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
							'existe_presupuesto' => $existe_presupuesto ? true : false,
							'presupuesto' => $presupuesto,
							'uri_presupuesto' => $uri,
							'pagado' => $str_pagado,
							'mot_motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
						];
					}
				}
			}

			if (is_countable($autorizado) && count($autorizado)) {
				foreach ($autorizado as $row) {
					$presupuesto = '';
					$uri = '';
					$pagado = 0;

					$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$row['pre_id']}")->row();

					if ($existe_presupuesto) {
						$total_pagos = $this->newPreOrden->consultar("SELECT SUM(fab_conversion) as total FROM app_movimientos WHERE fab_idgenerico={$existe_presupuesto['po_nid']} AND fab_doc = 12")->row();
						$data_presupuesto = $this->newPreOrden->consultar("SELECT n_correlativo, n_total FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();
						$total_pagado = round($total_pagos['total'], 2);
						$total_factura = round($data_presupuesto['n_total'], 2);

						if ($total_pagado == 0 || $total_factura == 0) {
							$pagado = 0;
						} else {
							$pagador = $total_pagado - $total_factura;

							if ($pagador == 0) {
								$pagado = 1;
							}
							if ($pagador < 0) {
								$pagado = 2;
							}
						}

						$documento = Documento::obtener(12);
						$presupuesto = $documento['prefijo'] . $data_presupuesto['n_correlativo'];
						$uri = ruta_base()  . 'ordendeentregaeditar/verFactura/' . $existe_presupuesto['po_nid'];

						if ($pagado == 0) {
							if ($existe_presupuesto['po_estatus'] == 1) {
								$pagado = 3;
							}
						}
					}

					if ($pagado == 2) {
						$str_pagado = "ABONADO";

						$array_abono[] = [
							'id' => $row['pre_id'],
							'generar_orden' => $this->module->has_module_action_permission('planilla', 'generar_orden', $_SESSION['user_data']['emp_id']),
							'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
							'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
							'pre_correlativo' => $row['pre_correlativo'] ?? 0,
							'cli_razon_social' => $row['cli_razon_social'],
							'pre_creado' => date('d-m-Y', strtotime($row['pre_creado'])),
							'pre_modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
							'existe_presupuesto' => $existe_presupuesto ? true : false,
							'presupuesto' => $presupuesto,
							'uri_presupuesto' => $uri,
							'pagado' => $str_pagado,
							'mot_motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
						];
					}
				}
			}


			
			Http::json_response([
				"todos" => $todas,
				"pendiente" => $pendiente,
				"nuevo" => $nuevo,
				"terminado" => $terminado,
				"anulada" => $anulada,
				"completada" => $terminado,
				"detenido" => $detenido,
				"credito" => $credito,
				"entregar" => $terminado_entregado,
				"autorizado" => count($array_autorizado),
				"abono" => count($array_abono),
			]);
		}
	}

	public function obtenerOrdensCompletadas()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$anio = filter_input(INPUT_POST, 'anio', FILTER_SANITIZE_NUMBER_INT);
			$mes = $this->solicitud->sanitize($_POST['mes'], FILTER_SANITIZE_NUMBER_INT);

			$draw = $_POST['draw'];
			$row = $_POST['start'];
			$rowperpage = $_POST['length']; // Rows display per page
			$columnIndex = $_POST['order'][0]['column']; // Column index
			$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
			$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
			$searchValue = $_POST['search']['value'];

			if ($mes == 0) {
				$peticion = "YEAR(p.pre_modificado)=$anio";
			} else {
				$peticion =  "MONTH(p.pre_modificado)=$mes AND YEAR(p.pre_modificado)=$anio";
			}

			$totalRecordwithFilter = "";
			## Search 
			$searchQuery = " ";
			if ($searchValue != '') {
				$searchQuery = " AND (p.pre_correlativo LIKE '%" . $searchValue . "%' OR 
            p.pre_creado LIKE '%" . $searchValue . "%' OR p.pre_modificado LIKE '%" . $searchValue . "%' OR m.m_marca LIKE '%" . $searchValue . "%' OR c.cli_razon_social LIKE '%" . $searchValue . "%' OR mot.mot_motor LIKE '%" . $searchValue . "%') ";
			}

			## Total number of records without filtering
			$totalRecords = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 2 AND $peticion ORDER BY pre_id DESC")->count();

			$totalRecordwithFilter = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 2 AND $peticion $searchQuery ORDER BY p.pre_id DESC")->count();

			## Fetch records
			$ordenes = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 2 AND $peticion " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();


			$lista = [];
			$entreg = '';

			if (is_countable($ordenes) && count($ordenes)) {

				foreach ($ordenes as $row) {

					$presupuesto = '';
					$uri = '';
					$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$row['pre_id']}")->row();
					$total_pagos = $this->newPreOrden->consultar("SELECT SUM(fab_conversion) as total FROM app_movimientos WHERE fab_idgenerico={$existe_presupuesto['po_nid']} AND fab_doc = 12")->row();
					$data_presupuesto = $this->newPreOrden->consultar("SELECT n_correlativo, n_total FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();
					$total_pagado = round($total_pagos['total'], 2);
					$pagado = $total_pagado >= round($data_presupuesto['n_total'], 2) ? 1 : 0;
					$documento = Documento::obtener(12);
					$presupuesto = $documento['prefijo'] . $data_presupuesto['n_correlativo'];
					$uri = ruta_base()  . 'ordendeentregaeditar/verFactura/' . $existe_presupuesto['po_nid'];

					switch ($pagado) {
						case 0:
							$str_pagado = 'PENDIENTE';
							break;
						default:
							$str_pagado = 'PAGADO';
							break;
					}
					if ($pagado == 1) {
						$lista[] = [
							'id' => $row['pre_id'],
							'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
							'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
							'generar_orden' => $this->module->has_module_action_permission('planilla', 'generar_orden', $_SESSION['user_data']['emp_id']),
							'pre_correlativo' => $row['pre_correlativo'] ?? 0,
							'cli_razon_social' => $row['cli_razon_social'],
							'pre_creado' => date('d-m-Y', strtotime($row['pre_creado'])),
							'pre_modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
							'existe_presupuesto' => $existe_presupuesto ? true : false,
							'presupuesto' => $presupuesto,
							'uri_presupuesto' => $uri,
							'pagado' => $str_pagado,
							'mot_motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
						];
					}
				}
			}

			Http::json_response([
				"draw" => intval($draw),
				"iTotalRecords" => $totalRecords,
				"iTotalDisplayRecords" => $totalRecordwithFilter,
				"aaData" => $lista
			]);
		}
	}

	public function obtenerOrdensCompletadasEntregadas()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$anio = filter_input(INPUT_POST, 'anio', FILTER_SANITIZE_NUMBER_INT);
			$mes = $this->solicitud->sanitize($_POST['mes'], FILTER_SANITIZE_NUMBER_INT);

			$draw = $_POST['draw'];
			$row = $_POST['start'];
			$rowperpage = $_POST['length']; // Rows display per page
			$columnIndex = $_POST['order'][0]['column']; // Column index
			$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
			$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
			$searchValue = $_POST['search']['value'];

			if ($mes == 0) {
				$peticion = "YEAR(p.pre_modificado)=$anio";
			} else {
				$peticion =  "MONTH(p.pre_modificado)=$mes AND YEAR(p.pre_modificado)=$anio";
			}

			$totalRecordwithFilter = "";
			## Search 
			$searchQuery = " ";
			if ($searchValue != '') {
				$searchQuery = " AND (p.pre_correlativo LIKE '%" . $searchValue . "%' OR 
            p.pre_creado LIKE '%" . $searchValue . "%' OR p.pre_modificado LIKE '%" . $searchValue . "%' OR m.m_marca LIKE '%" . $searchValue . "%' OR c.cli_razon_social LIKE '%" . $searchValue . "%' OR mot.mot_motor LIKE '%" . $searchValue . "%') ";
			}

			## Total number of records without filtering
			$totalRecords = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 2 AND pre_entrega = 1 AND $peticion ORDER BY pre_id DESC")->count();

			$totalRecordwithFilter = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 2 AND pre_entrega = 1 AND $peticion $searchQuery ORDER BY p.pre_id DESC")->count();

			## Fetch records
			$ordenes = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 2 AND pre_entrega = 1 AND $peticion " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();


			$lista = [];
			$entreg = '';

			if (is_countable($ordenes) && count($ordenes)) {

				foreach ($ordenes as $row) {

					$presupuesto = '';
					$uri = '';
					$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$row['pre_id']}")->row();
					$total_pagos = $this->newPreOrden->consultar("SELECT SUM(fab_conversion) as total FROM app_movimientos WHERE fab_idgenerico={$existe_presupuesto['po_nid']} AND fab_doc = 12")->row();
					$data_presupuesto = $this->newPreOrden->consultar("SELECT n_correlativo, n_total FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();
					$total_pagado = round($total_pagos['total'], 2);
					$pagado = $total_pagado >= round($data_presupuesto['n_total'], 2) ? 1 : 0;
					$documento = Documento::obtener(12);
					$presupuesto = $documento['prefijo'] . $data_presupuesto['n_correlativo'];
					$uri = ruta_base()  . 'ordendeentregaeditar/verFactura/' . $existe_presupuesto['po_nid'];

					switch ($pagado) {
						case 0:
							$str_pagado = 'PENDIENTE';
							break;
						default:
							$str_pagado = 'PAGADO';
							break;
					}
					if ($pagado == 1) {
						$lista[] = [
							'id' => $row['pre_id'],
							'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
							'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
							'generar_orden' => $this->module->has_module_action_permission('planilla', 'generar_orden', $_SESSION['user_data']['emp_id']),
							'pre_correlativo' => $row['pre_correlativo'] ?? 0,
							'cli_razon_social' => $row['cli_razon_social'],
							'pre_creado' => date('d-m-Y', strtotime($row['pre_creado'])),
							'pre_modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
							'existe_presupuesto' => $existe_presupuesto ? true : false,
							'presupuesto' => $presupuesto,
							'uri_presupuesto' => $uri,
							'pagado' => $str_pagado,
							'entreg' => $row['pre_entrega'],
							'mot_motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
						];
					}
				}
			}

			Http::json_response([
				"draw" => intval($draw),
				"iTotalRecords" => $totalRecords,
				"iTotalDisplayRecords" => $totalRecordwithFilter,
				"aaData" => $lista
			]);
		}
	}

	public function obtenerOrdenesTodas()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$anio = $this->solicitud->sanitize($_POST['anio'], FILTER_SANITIZE_NUMBER_INT);
			$mes = $this->solicitud->sanitize($_POST['mes'], FILTER_SANITIZE_NUMBER_INT);

			$draw = $_POST['draw'];
			$row = $_POST['start'];
			$rowperpage = $_POST['length']; // Rows display per page
			$columnIndex = $_POST['order'][0]['column']; // Column index
			$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
			$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
			$searchValue = $_POST['search']['value'];

			if ($mes == 0) {
				$peticion = "YEAR(p.pre_modificado)=$anio";
			} else {
				$peticion =  "MONTH(p.pre_modificado)=$mes AND YEAR(p.pre_modificado)=$anio";
			}

			$totalRecordwithFilter = "";
			## Search 
			$searchQuery = " ";
			if ($searchValue != '') {
				$searchQuery = " AND (p.pre_correlativo LIKE '%" . $searchValue . "%' OR 
            p.pre_creado LIKE '%" . $searchValue . "%' OR p.pre_modificado LIKE '%" . $searchValue . "%' OR m.m_marca LIKE '%" . $searchValue . "%' OR c.cli_razon_social LIKE '%" . $searchValue . "%' OR mot.mot_motor LIKE '%" . $searchValue . "%') ";
			}

			## Total number of records without filtering
			$totalRecords = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE $peticion ORDER BY p.pre_id DESC")->count();

			$totalRecordwithFilter = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE $peticion $searchQuery ORDER BY p.pre_id DESC")->count();

			## Fetch records
			$ordenes = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE $peticion " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();


			$lista = [];
			$entreg = '';

			if (is_countable($ordenes) && count($ordenes)) {
				foreach ($ordenes as $row) {
					$presupuesto = '';
					$uri = '';
					$pagado = 0;

					$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$row['pre_id']}")->row();

					if ($existe_presupuesto) {
						$total_pagos = $this->newPreOrden->consultar("SELECT SUM(fab_conversion) as total FROM app_movimientos WHERE fab_idgenerico={$existe_presupuesto['po_nid']} AND fab_doc = 12")->row();
						$data_presupuesto = $this->newPreOrden->consultar("SELECT n_correlativo, n_total FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();
						$total_pagado = round($total_pagos['total'], 2);
						$total_factura = round($data_presupuesto['n_total'], 2);

						if ($total_pagado == 0 || $total_factura == 0) {
							$pagado = 0;
						} else {
							$pagador = $total_pagado - $total_factura;

							if ($pagador == 0) {
								$pagado = 1;
							}
							if ($pagador < 0) {
								$pagado = 2;
							}
						}

						$documento = Documento::obtener(12);
						$presupuesto = $documento['prefijo'] . $data_presupuesto['n_correlativo'];
						$uri = ruta_base()  . 'ordendeentregaeditar/verFactura/' . $existe_presupuesto['po_nid'];

						if ($pagado == 0) {
							if ($existe_presupuesto['po_estatus'] == 1) {
								$pagado = 3;
							}
						}
					}
					if ($row['pre_estatus'] == 2) {
						$entreg = 'TERMINADO';

						if ($row['pre_entrega'] == 1) {
							$entreg = 'ENTREGADO';
						}
					}
					if ($row['pre_estatus'] == 1) {
						$entreg = 'PENDIENTE';
					}
					if ($row['pre_estatus'] == 3) {
						$entreg = 'ANULADA';
					}
					if ($row['pre_estatus'] == 0) {
						$entreg = 'NUEVO';
					}
					if ($row['pre_estatus'] == 4) {
						$entreg = 'DETENIDO';
					}
					if ($row['pre_estatus'] == 5) {
						$entreg = 'CREDITO';
					}

					switch ($pagado) {
						case 0:
							$str_pagado = 'PENDIENTE';
							break;
						case 1:
							$str_pagado = 'PAGADO';
							break;
						case 2:
							$str_pagado = 'ABONADO';
							break;
						default:
							$str_pagado = 'AUTORIZADO';
							break;
					}

					$lista[] = [
						'id' => $row['pre_id'],
						'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
						'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
						'generar_orden' => $this->module->has_module_action_permission('planilla', 'generar_orden', $_SESSION['user_data']['emp_id']),
						'pre_correlativo' => $row['pre_correlativo'] ?? 0,
						'cli_razon_social' => $row['cli_razon_social'],
						'pre_creado' => date('d-m-Y', strtotime($row['pre_creado'])),
						'pre_modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
						'existe_presupuesto' => $existe_presupuesto ? true : false,
						'presupuesto' => $presupuesto,
						'uri_presupuesto' => $uri,
						'pagado' => $str_pagado,
						'entreg' => $entreg,
						'mot_motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
					];
				}
			}
			Http::json_response([
				"draw" => intval($draw),
				"iTotalRecords" => $totalRecords,
				"iTotalDisplayRecords" => $totalRecordwithFilter,
				"aaData" => $lista
			]);
		}
	}

	public function obtenerOrdenesPendientes()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$anio = filter_input(INPUT_POST, 'anio', FILTER_SANITIZE_NUMBER_INT);
			$mes = $this->solicitud->sanitize($_POST['mes'], FILTER_SANITIZE_NUMBER_INT);

			$draw = $_POST['draw'];
			$row = $_POST['start'];
			$rowperpage = $_POST['length']; // Rows display per page
			$columnIndex = $_POST['order'][0]['column']; // Column index
			$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
			$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
			$searchValue = $_POST['search']['value'];

			if ($mes == 0) {
				$peticion = "YEAR(p.pre_modificado)=$anio";
			} else {
				$peticion =  "MONTH(p.pre_modificado)=$mes AND YEAR(p.pre_modificado)=$anio";
			}

			$totalRecordwithFilter = "";
			## Search 
			$searchQuery = " ";
			if ($searchValue != '') {
				$searchQuery = " AND (p.pre_correlativo LIKE '%" . $searchValue . "%' OR 
            p.pre_creado LIKE '%" . $searchValue . "%' OR p.pre_modificado LIKE '%" . $searchValue . "%' OR m.m_marca LIKE '%" . $searchValue . "%' OR c.cli_razon_social LIKE '%" . $searchValue . "%' OR mot.mot_motor LIKE '%" . $searchValue . "%') ";
			}

			## Total number of records without filtering
			$totalRecords = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 1 AND $peticion ORDER BY pre_id DESC")->count();

			$totalRecordwithFilter = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 1 AND $peticion $searchQuery ORDER BY p.pre_id DESC")->count();

			## Fetch records
			$ordenes = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 1 AND $peticion " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();

			$lista = [];
			$entreg = '';

			if (is_countable($ordenes) && count($ordenes)) {
				foreach ($ordenes as $row) {
					$presupuesto = '';
					$uri = '';
					$pagado = 0;

					$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$row['pre_id']}")->row();

					if ($existe_presupuesto) {
						$total_pagos = $this->newPreOrden->consultar("SELECT SUM(fab_conversion) as total FROM app_movimientos WHERE fab_idgenerico={$existe_presupuesto['po_nid']} AND fab_doc = 12")->row();
						$data_presupuesto = $this->newPreOrden->consultar("SELECT n_correlativo, n_total FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();
						$total_pagado = round($total_pagos['total'], 2);
						$total_factura = round($data_presupuesto['n_total'], 2);

						if ($total_pagado == 0 || $total_factura == 0) {
							$pagado = 0;
						} else {
							$pagador = $total_pagado - $total_factura;

							if ($pagador == 0) {
								$pagado = 1;
							}
							if ($pagador < 0) {
								$pagado = 2;
							}
						}

						$documento = Documento::obtener(12);
						$presupuesto = $documento['prefijo'] . $data_presupuesto['n_correlativo'];
						$uri = ruta_base()  . 'ordendeentregaeditar/verFactura/' . $existe_presupuesto['po_nid'];

						if ($pagado == 0) {
							if ($existe_presupuesto['po_estatus'] == 1) {
								$pagado = 3;
							}
						}
					}

					switch ($pagado) {
						case 0:
							$str_pagado = 'PENDIENTE';
							break;
						case 1:
							$str_pagado = 'PAGADO';
							break;
						case 2:
							$str_pagado = 'ABONADO';
							break;
						default:
							$str_pagado = 'AUTORIZADO';
							break;
					}

					$lista[] = [
						'id' => $row['pre_id'],
						'generar_orden' => $this->module->has_module_action_permission('planilla', 'generar_orden', $_SESSION['user_data']['emp_id']),
						'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
						'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
						'pre_correlativo' => $row['pre_correlativo'] ?? 0,
						'cli_razon_social' => $row['cli_razon_social'],
						'pre_creado' => date('d-m-Y', strtotime($row['pre_creado'])),
						'pre_modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
						'existe_presupuesto' => $existe_presupuesto ? true : false,
						'presupuesto' => $presupuesto,
						'uri_presupuesto' => $uri,
						'pagado' => $str_pagado,
						'mot_motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
					];
				}
			}

			Http::json_response([
				"draw" => intval($draw),
				"iTotalRecords" => $totalRecords,
				"iTotalDisplayRecords" => $totalRecordwithFilter,
				"aaData" => $lista
			]);
		}
	}

	public function obtenerOrdenesAnuladas()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$anio = filter_input(INPUT_POST, 'anio', FILTER_SANITIZE_NUMBER_INT);
			$mes = $this->solicitud->sanitize($_POST['mes'], FILTER_SANITIZE_NUMBER_INT);

			$draw = $_POST['draw'];
			$row = $_POST['start'];
			$rowperpage = $_POST['length']; // Rows display per page
			$columnIndex = $_POST['order'][0]['column']; // Column index
			$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
			$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
			$searchValue = $_POST['search']['value'];

			if ($mes == 0) {
				$peticion = "YEAR(p.pre_modificado)=$anio";
			} else {
				$peticion =  "MONTH(p.pre_modificado)=$mes AND YEAR(p.pre_modificado)=$anio";
			}

			$totalRecordwithFilter = "";
			## Search 
			$searchQuery = " ";
			if ($searchValue != '') {
				$searchQuery = " AND (p.pre_correlativo LIKE '%" . $searchValue . "%' OR 
            p.pre_creado LIKE '%" . $searchValue . "%' OR p.pre_modificado LIKE '%" . $searchValue . "%' OR m.m_marca LIKE '%" . $searchValue . "%' OR c.cli_razon_social LIKE '%" . $searchValue . "%' OR mot.mot_motor LIKE '%" . $searchValue . "%') ";
			}

			## Total number of records without filtering
			$totalRecords = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 3 AND $peticion ORDER BY pre_id DESC")->count();

			$totalRecordwithFilter = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 3 AND $peticion $searchQuery ORDER BY p.pre_id DESC")->count();

			## Fetch records
			$ordenes = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 3 AND $peticion " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();


			$lista = [];
			$entreg = '';

			if (is_countable($ordenes) && count($ordenes)) {
				foreach ($ordenes as $row) {
					$presupuesto = '';
					$uri = '';
					$pagado = 0;

					$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$row['pre_id']}")->row();

					if ($existe_presupuesto) {
						$data_presupuesto = $this->newPreOrden->consultar("SELECT n_correlativo, n_total FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();

						$documento = Documento::obtener(12);
						$presupuesto = $documento['prefijo'] . $data_presupuesto['n_correlativo'];
						$uri = ruta_base()  . 'ordendeentregaeditar/verFactura/' . $existe_presupuesto['po_nid'];
					}

					$str_pagado = 'ANULADA';

					$lista[] = [
						'id' => $row['pre_id'],
						'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
						'generar_orden' => $this->module->has_module_action_permission('planilla', 'generar_orden', $_SESSION['user_data']['emp_id']),
						'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
						'pre_correlativo' => $row['pre_correlativo'] ?? 0,
						'cli_razon_social' => $row['cli_razon_social'],
						'pre_creado' => date('d-m-Y', strtotime($row['pre_creado'])),
						'pre_modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
						'existe_presupuesto' => $existe_presupuesto ? true : false,
						'presupuesto' => $presupuesto,
						'uri_presupuesto' => $uri,
						'pagado' => $str_pagado,
						'mot_motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
					];
				}
			}

			Http::json_response([
				"draw" => intval($draw),
				"iTotalRecords" => $totalRecords,
				"iTotalDisplayRecords" => $totalRecordwithFilter,
				"aaData" => $lista
			]);
		}
	}

	public function obtenerOrdenesDetenidos()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$anio = filter_input(INPUT_POST, 'anio', FILTER_SANITIZE_NUMBER_INT);
			$mes = $this->solicitud->sanitize($_POST['mes'], FILTER_SANITIZE_NUMBER_INT);

			$draw = $_POST['draw'];
			$row = $_POST['start'];
			$rowperpage = $_POST['length']; // Rows display per page
			$columnIndex = $_POST['order'][0]['column']; // Column index
			$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
			$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
			$searchValue = $_POST['search']['value'];

			if ($mes == 0) {
				$peticion = "YEAR(p.pre_modificado)=$anio";
			} else {
				$peticion =  "MONTH(p.pre_modificado)=$mes AND YEAR(p.pre_modificado)=$anio";
			}

			$totalRecordwithFilter = "";
			## Search 
			$searchQuery = " ";
			if ($searchValue != '') {
				$searchQuery = " AND (p.pre_correlativo LIKE '%" . $searchValue . "%' OR 
            p.pre_creado LIKE '%" . $searchValue . "%' OR p.pre_modificado LIKE '%" . $searchValue . "%' OR m.m_marca LIKE '%" . $searchValue . "%' OR c.cli_razon_social LIKE '%" . $searchValue . "%' OR mot.mot_motor LIKE '%" . $searchValue . "%') ";
			}

			## Total number of records without filtering
			$totalRecords = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 4 AND $peticion ORDER BY pre_id DESC")->count();

			$totalRecordwithFilter = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 4 AND $peticion $searchQuery ORDER BY p.pre_id DESC")->count();

			## Fetch records
			$ordenes = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 4 AND $peticion " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();


			$lista = [];
			$entreg = '';

			if (is_countable($ordenes) && count($ordenes)) {
				foreach ($ordenes as $row) {
					$presupuesto = '';
					$uri = '';
					$pagado = 0;

					$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$row['pre_id']}")->row();

					if ($existe_presupuesto) {
						$data_presupuesto = $this->newPreOrden->consultar("SELECT n_correlativo, n_total FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();

						$documento = Documento::obtener(12);
						$presupuesto = $documento['prefijo'] . $data_presupuesto['n_correlativo'];
						$uri = ruta_base()  . 'ordendeentregaeditar/verFactura/' . $existe_presupuesto['po_nid'];
					}

					$str_pagado = 'DETENIDOS';

					$lista[] = [
						'id' => $row['pre_id'],
						'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
						'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
						'generar_orden' => $this->module->has_module_action_permission('planilla', 'generar_orden', $_SESSION['user_data']['emp_id']),
						'pre_correlativo' => $row['pre_correlativo'] ?? 0,
						'cli_razon_social' => $row['cli_razon_social'],
						'pre_creado' => date('d-m-Y', strtotime($row['pre_creado'])),
						'pre_modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
						'existe_presupuesto' => $existe_presupuesto ? true : false,
						'presupuesto' => $presupuesto,
						'uri_presupuesto' => $uri,
						'pagado' => $str_pagado,
						'mot_motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
					];
				}
			}

			Http::json_response([
				"draw" => intval($draw),
				"iTotalRecords" => $totalRecords,
				"iTotalDisplayRecords" => $totalRecordwithFilter,
				"aaData" => $lista
			]);
		}
	}

	public function obtenerOrdenesCreditos()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$anio = filter_input(INPUT_POST, 'anio', FILTER_SANITIZE_NUMBER_INT);
			$mes = $this->solicitud->sanitize($_POST['mes'], FILTER_SANITIZE_NUMBER_INT);

			$draw = $_POST['draw'];
			$row = $_POST['start'];
			$rowperpage = $_POST['length']; // Rows display per page
			$columnIndex = $_POST['order'][0]['column']; // Column index
			$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
			$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
			$searchValue = $_POST['search']['value'];

			if ($mes == 0) {
				$peticion = "YEAR(p.pre_modificado)=$anio";
			} else {
				$peticion =  "MONTH(p.pre_modificado)=$mes AND YEAR(p.pre_modificado)=$anio";
			}

			$totalRecordwithFilter = "";
			## Search 
			$searchQuery = " ";
			if ($searchValue != '') {
				$searchQuery = " AND (p.pre_correlativo LIKE '%" . $searchValue . "%' OR 
            p.pre_creado LIKE '%" . $searchValue . "%' OR p.pre_modificado LIKE '%" . $searchValue . "%' OR m.m_marca LIKE '%" . $searchValue . "%' OR c.cli_razon_social LIKE '%" . $searchValue . "%' OR mot.mot_motor LIKE '%" . $searchValue . "%') ";
			}

			## Total number of records without filtering
			$totalRecords = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 5 AND $peticion ORDER BY pre_id DESC")->count();

			$totalRecordwithFilter = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 5 AND $peticion $searchQuery ORDER BY p.pre_id DESC")->count();

			## Fetch records
			$ordenes = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 5 AND $peticion " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();


			$lista = [];
			$entreg = '';

			if (is_countable($ordenes) && count($ordenes)) {
				foreach ($ordenes as $row) {
					$presupuesto = '';
					$uri = '';
					$pagado = 0;

					$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$row['pre_id']}")->row();

					if ($existe_presupuesto) {
						$data_presupuesto = $this->newPreOrden->consultar("SELECT n_correlativo, n_total FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();

						$documento = Documento::obtener(12);
						$presupuesto = $documento['prefijo'] . $data_presupuesto['n_correlativo'];
						$uri = ruta_base()  . 'ordendeentregaeditar/verFactura/' . $existe_presupuesto['po_nid'];
					}

					$str_pagado = 'CREDITO';

					$lista[] = [
						'id' => $row['pre_id'],
						'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
						'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
						'generar_orden' => $this->module->has_module_action_permission('planilla', 'generar_orden', $_SESSION['user_data']['emp_id']),
						'pre_correlativo' => $row['pre_correlativo'] ?? 0,
						'cli_razon_social' => $row['cli_razon_social'],
						'pre_creado' => date('d-m-Y', strtotime($row['pre_creado'])),
						'pre_modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
						'existe_presupuesto' => $existe_presupuesto ? true : false,
						'presupuesto' => $presupuesto,
						'uri_presupuesto' => $uri,
						'pagado' => $str_pagado,
						'mot_motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
					];
				}
			}

			Http::json_response([
				"draw" => intval($draw),
				"iTotalRecords" => $totalRecords,
				"iTotalDisplayRecords" => $totalRecordwithFilter,
				"aaData" => $lista
			]);
		}
	}

	public function obtenerOrdenesPreOrden()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$anio = filter_input(INPUT_POST, 'anio', FILTER_SANITIZE_NUMBER_INT);
			$mes = $this->solicitud->sanitize($_POST['mes'], FILTER_SANITIZE_NUMBER_INT);

			$draw = $_POST['draw'];
			$row = $_POST['start'];
			$rowperpage = $_POST['length']; // Rows display per page
			$columnIndex = $_POST['order'][0]['column']; // Column index
			$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
			$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
			$searchValue = $_POST['search']['value'];

			if ($mes == 0) {
				$peticion = "YEAR(p.pre_modificado)=$anio";
			} else {
				$peticion =  "MONTH(p.pre_modificado)=$mes AND YEAR(p.pre_modificado)=$anio";
			}

			$totalRecordwithFilter = "";
			## Search 
			$searchQuery = " ";
			if ($searchValue != '') {
				$searchQuery = " AND (p.pre_correlativo LIKE '%" . $searchValue . "%' OR 
            p.pre_creado LIKE '%" . $searchValue . "%' OR p.pre_modificado LIKE '%" . $searchValue . "%' OR m.m_marca LIKE '%" . $searchValue . "%' OR c.cli_razon_social LIKE '%" . $searchValue . "%' OR mot.mot_motor LIKE '%" . $searchValue . "%') ";
			}

			## Total number of records without filtering
			$totalRecords = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 0 AND $peticion ORDER BY pre_id DESC")->count();

			$totalRecordwithFilter = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 0 AND $peticion $searchQuery ORDER BY p.pre_id DESC")->count();

			## Fetch records
			$ordenes = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 0 AND $peticion " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();


			$lista = [];
			$entreg = '';

			if (is_countable($ordenes) && count($ordenes)) {
				foreach ($ordenes as $row) {
					$lista[] = [
						'id' => $row['pre_id'],
						'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
						'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
						'pre_correlativo' => $row['pre_correlativo'] ?? 0,
						'cli_razon_social' => $row['cli_razon_social'],
						'pre_creado' => date('d-m-Y', strtotime($row['pre_creado'])),
						'pre_modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
						'mot_motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : '',
					];
				}
			}

			Http::json_response([
				"draw" => intval($draw),
				"iTotalRecords" => $totalRecords,
				"iTotalDisplayRecords" => $totalRecordwithFilter,
				"aaData" => $lista
			]);
		}
	}

	public function obtenerTipoMotor()
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newTipo = new TipoMotor();
			$tipos = $newTipo->todos();
			$lista = [];
			if (is_countable($tipos) && count($tipos)) {
				foreach ($tipos as $row) {
					$lista[] = [
						'id' => $row['tip_id'],
						'tipo' => $row['tip_descripcion']
					];
				}
			}
			Http::json_response($lista);
		}
	}

	public function guardarTipoMotor()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['tipomotor']))
				$this->array_errors[] = 'El campo descripcion es obligatorio';

			if (empty($this->array_errors)) {

				$tipo = $this->solicitud->sanitize($_POST['tipomotor'], FILTER_SANITIZE_STRING);

				$newTipo = new TipoMotor();

				if (empty($_POST['id'])) {

					if ($newTipo->where(['tip_descripcion' => $tipo]))
						$this->array_errors[] = 'Lo siento ya se encuentra registrado';

					if (empty($this->array_errors)) {
						if ($newTipo->guardar([
							'tip_descripcion' => $tipo
						], true)) {
							Http::json_response(true);
						} else {
							Http::json_response(false);
						}
					}
				} else {

					$id = $this->solicitud->sanitize($_POST['id'], FILTER_SANITIZE_NUMBER_INT);

					if ($newTipo->where(['tip_descripcion' => $tipo, 'tip_id!=' => $id]))
						$this->array_errors[] = 'Lo siento ya se encuentra registrado';

					if (empty($this->array_errors)) {
						if ($newTipo->editar($id, [
							'tip_descripcion' => $tipo
						])) {
							Http::json_response(true);
						} else {
							Http::json_response(false);
						}
					}
				}
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function eliminarTipoMotor(int $id_tipo)
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newTipo = new TipoMotor();
			if ($newTipo->existe('tip_id', $id_tipo)) {
				Http::json_response($newTipo->eliminar($id_tipo));
			} else {
				$this->array_errors[] = 'Acción prohibida';
			}
		}
	}

	public function obtenerMarcas()
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newMarca = new Marca();
			$marcas = $newMarca->todos();
			$lista = [];
			if (is_countable($marcas) && count($marcas)) {
				foreach ($marcas as $row) {
					$lista[] = [
						'id' => $row['m_id'],
						'marca' => $row['m_marca']
					];
				}
			}
			Http::json_response($lista);
		}
	}

	public function guardarMarcas()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['marca']))
				$this->array_errors[] = 'El campo Marca es obligatorio';

			if (empty($this->array_errors)) {

				$marca = $this->solicitud->sanitize($_POST['marca'], FILTER_SANITIZE_STRING);

				$newMarca = new Marca();

				if (empty($_POST['id'])) {

					if ($newMarca->where(['m_marca' => $marca]))
						$this->array_errors[] = 'Lo siento ya se encuentra registrado';

					if (empty($this->array_errors)) {
						if ($newMarca->guardar([
							'm_marca' => $marca
						], true)) {
							Http::json_response(true);
						} else {
							Http::json_response(false);
						}
					}
				} else {

					$id = $this->solicitud->sanitize($_POST['id'], FILTER_SANITIZE_NUMBER_INT);

					if ($newMarca->where(['m_marca' => $marca, 'm_id!=' => $id]))
						$this->array_errors[] = 'Lo siento ya se encuentra registrado';

					if (empty($this->array_errors)) {
						if ($newMarca->editar($id, [
							'm_marca' => $marca
						])) {
							Http::json_response(true);
						} else {
							Http::json_response(false);
						}
					}
				}
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function eliminarMarca(int $id_marca)
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newMarca = new Marca();
			if ($newMarca->existe('m_id', $id_marca)) {
				Http::json_response($newMarca->eliminar($id_marca));
			} else {
				$this->array_errors[] = 'Acción prohibida';
			}
		}
	}

	public function obtenerMotores()
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newMotor = new Motor();
			$motores = $newMotor->obtenerMotores();
			$lista = [];
			if (is_countable($motores) && count($motores)) {
				foreach ($motores as $row) {
					$lista[] = [
						'id' => $row['mot_id'],
						'motor' => $row['mot_motor'],
						'marca' => [
							'id' => $row['m_id'],
							'marca' => $row['m_marca']
						],
						'tipo' => [
							'id' => $row['tip_id'],
							'tipo' => $row['tip_descripcion']
						],
						'modelo' => $row['mot_modelo']
					];
				}
			}
			Http::json_response($lista);
		}
	}

	public function guardarMotores()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['motor']))
				$this->array_errors[] = 'El campo Motor es obligatorio';
			if (empty($_POST['m_marca']))
				$this->array_errors[] = 'El campo Marca es obligatorio';
			if (empty($_POST['m_tipo']))
				$this->array_errors[] = 'El campo Tipo es obligatorio';

			if (empty($this->array_errors)) {

				$motor = $this->solicitud->sanitize($_POST['motor'], FILTER_SANITIZE_STRING);
				$marca = $this->solicitud->sanitize($_POST['m_marca'], FILTER_SANITIZE_NUMBER_INT);
				$modelo = $this->solicitud->sanitize($_POST['modelo'], FILTER_SANITIZE_STRING) ?? '';
				$tipo = $this->solicitud->sanitize($_POST['m_tipo'], FILTER_SANITIZE_NUMBER_INT);

				$newMotor = new Motor();

				if (empty($_POST['id'])) {

					if ($newMotor->where(['mot_motor' => $motor]))
						$this->array_errors[] = 'Lo siento ya se encuentra registrado';

					if (empty($this->array_errors)) {
						if ($newMotor->guardar([
							'mot_motor' => $motor,
							'mot_marca' => $marca,
							'mot_modelo' => $modelo,
							'mot_tipid' => $tipo
						], true)) {
							Http::json_response(true);
						} else {
							Http::json_response(false);
						}
					}
				} else {

					$id = $this->solicitud->sanitize($_POST['id'], FILTER_SANITIZE_NUMBER_INT);

					if ($newMotor->where(['mot_motor' => $motor, 'mot_id!=' => $id]))
						$this->array_errors[] = 'Lo siento ya se encuentra registrado';

					if (empty($this->array_errors)) {
						if ($newMotor->editar($id, [
							'mot_motor' => $motor,
							'mot_marca' => $marca,
							'mot_modelo' => $modelo,
							'mot_tipid' => $tipo
						])) {
							Http::json_response(true);
						} else {
							Http::json_response(false);
						}
					}
				}
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function eliminarMotor(int $id_motor)
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newMotor = new Motor();
			if ($newMotor->existe('mot_id', $id_motor)) {
				Http::json_response($newMotor->eliminar($id_motor));
			} else {
				$this->array_errors[] = 'Acción prohibida';
			}
		}
	}

	public function obtenerCategoriasSegunMotor(int $id_motor)
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$id_motor = filter_var($id_motor, FILTER_SANITIZE_NUMBER_INT);
			$newCat = new PlanillaServicio();
			$newPlaCat = new PlanillaCategoria();
			$categorias = $newCat->obtenerCategoriasSegunMotor($id_motor);
			$lista = [];
			if (is_countable($categorias) && count($categorias)) {
				foreach ($categorias as $row) {
					$lista[] = [
						'id' => $row['cat_id'],
						'categoria' => $row['cat_categorias']
					];
				}
			} else {
				$categorias = $newPlaCat->todos();
				foreach ($categorias as $row) {
					$lista[] = [
						'id' => $row['cat_id'],
						'categoria' => $row['cat_categorias']
					];
				}
			}
			Http::json_response($lista);
		}
	}

	public function obtenerComisionesTrabajoAdiccionales(int $id_orden)
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

			$lista = [];

			if (!$this->newPreOrden->existe('pre_id', $id_orden)) {
				Http::json_response(['errors' => ['Acción prohibida']]);
			}

			//$this->preordenEditable($id_orden);

			$trabajosAsignados =  $this->newPreOrden->consultar("SELECT * FROM app_preorden_master_servicios_empleados_adicionales ad  
			LEFT JOIN app_empleados_info e ON e.einfo_id=ad.pread_empid 
			LEFT JOIN app_empleados_agentes_tipo_comision c ON c.empagentipo_agente=ad.pread_empid 
			LEFT JOIN app_comision cm ON c.empagentipo_comid=cm.com_id 
			WHERE ad.pread_preid ={$id_orden}")->all();

			if (is_countable($trabajosAsignados) && count($trabajosAsignados)) {
				foreach ($trabajosAsignados as $row) {

					if ($row['pread_empid'] != NULL && $row['pread_comid'] != NULL && $row['pread_comid'] > 0) {
						$listac = $this->newPreOrden->consultar("SELECT * FROM app_comisiones_agente_fn cm 
						LEFT JOIN app_preorden_master_servicios_empleados_adicionales ad ON ad.pread_comid=cm.comagentefn_id AND ad.pread_empid=cm.comagentefn_fnempagente AND ad.pread_preid=cm.comagentefn_planilla 
						LEFT JOIN app_empleados_info e ON e.einfo_id=cm.comagentefn_fnempagente 
						WHERE cm.comagentefn_planilla=$id_orden AND cm.comagentefn_id ={$row['pread_comid']}")->row();

						$lista[] = [
							'id' => $row['pread_id'],
							'servicio' => $listac['comagentefn_descripcion'],
							'cantidad' => $listac['comagentefn_fncantidad'],
							'empleado' => $row['einfo_nombres'] . ' ' . $row['einfo_apellidos'],
							'monto' =>    $listac['comagentefn_monto'],
							'estatus' => $row['pread_estatus'],
							'com' => $listac['comagentefn_id'],
						];
					} else {
						$productos = $this->newPreOrden->consultar("SELECT * FROM app_preorden_master_servicios_empleados_adicionales ad  
						LEFT JOIN app_productos p ON p.pro_id=ad.pread_serv  
						WHERE ad.pread_id ={$row['pread_id']}")->row();

						$lista[] = [
							'id' => $row['pread_id'],
							'servicio' => $productos['pro_descripcion'],
							'cantidad' => $row['pread_cantidad'],
							'empleado' =>  $row['einfo_nombres'] . ' ' . $row['einfo_apellidos'],
							'monto' => ($row['empagentipo_porcentaje'] == 0) ? (($productos['pro_precio'] * $row['pread_cantidad']) * ($row['com_porcentaje'] / 100)) : (($productos['pro_precio'] * $row['pread_cantidad']) * ($row['empagentipo_porcentaje'] / 100)),
							'estatus' => $row['pread_estatus'],
							'com' => 0
						];
					}
				}
			}


			Http::json_response($lista);
		}
	}

	public function obtenerCategorias()
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newCat = new PlanillaCategoria();
			$categorias = $newCat->todos();
			$lista = [];
			if (is_countable($categorias) && count($categorias)) {
				foreach ($categorias as $row) {
					$lista[] = [
						'id' => $row['cat_id'],
						'categoria' => $row['cat_categorias']
					];
				}
			}
			Http::json_response($lista);
		}
	}

	public function guardarCategorias()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['categoria']))
				$this->array_errors[] = 'El campo Categoria es obligatorio';

			if (empty($this->array_errors)) {

				$categoria = $this->solicitud->sanitize($_POST['categoria'], FILTER_SANITIZE_STRING);

				$newCat = new PlanillaCategoria();

				if (empty($_POST['id'])) {

					if ($newCat->where(['cat_categorias' => $categoria]))
						$this->array_errors[] = 'Lo siento ya se encuentra registrado';

					if (empty($this->array_errors)) {
						if ($newCat->guardar([
							'cat_categorias' => $categoria
						], true)) {
							Http::json_response(true);
						} else {
							Http::json_response(false);
						}
					}
				} else {

					$id = $this->solicitud->sanitize($_POST['id'], FILTER_SANITIZE_NUMBER_INT);

					if ($newCat->where(['cat_categorias' => $categoria, 'cat_id!=' => $id]))
						$this->array_errors[] = 'Lo siento ya se encuentra registrado';

					if (empty($this->array_errors)) {
						if ($newCat->editar($id, [
							'cat_categorias' => $categoria
						])) {
							Http::json_response(true);
						} else {
							Http::json_response(false);
						}
					}
				}
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function eliminarCategoria(int $id_categoria)
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newCat = new PlanillaCategoria();
			if ($newCat->existe('cat_id', $id_categoria)) {
				Http::json_response($newCat->eliminar($id_categoria));
			} else {
				$this->array_errors[] = 'Acción prohibida';
			}
		}
	}

	public function obtenerPartes()
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newPar = new PlanillaCategoriaParte();
			$partes = $newPar->obtenerPartes();
			$lista = [];
			if (is_countable($partes) && count($partes)) {
				foreach ($partes as $row) {
					$lista[] = [
						'id' => $row['par_id'],
						'categoria' => [
							'id' => $row['cat_id'],
							'categoria' => $row['cat_categorias']
						],
						'parte' => $row['par_parte']
					];
				}
			}
			Http::json_response($lista);
		}
	}

	public function guardarPartes()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['p_categoria']))
				$this->array_errors[] = 'El campo Categoria es obligatorio';
			if (empty($_POST['parte']))
				$this->array_errors[] = 'El campo Parte es obligatorio';

			if (empty($this->array_errors)) {

				$categoria = $this->solicitud->sanitize($_POST['p_categoria'], FILTER_SANITIZE_NUMBER_INT);
				$parte = $this->solicitud->sanitize($_POST['parte'], FILTER_SANITIZE_STRING);

				$newPar = new PlanillaCategoriaParte();

				if (empty($_POST['id'])) {

					if ($newPar->where(['par_parte' => $parte, 'par_catid' => $categoria]))
						$this->array_errors[] = 'Lo siento ya se encuentra registrado';

					if (empty($this->array_errors)) {
						if ($newPar->guardar([
							'par_catid' => $categoria,
							'par_parte' => $parte
						], true)) {
							Http::json_response(true);
						} else {
							Http::json_response(false);
						}
					}
				} else {

					$id = $this->solicitud->sanitize($_POST['id'], FILTER_SANITIZE_NUMBER_INT);

					if ($newPar->where(['par_parte' => $parte, 'par_catid' => $categoria, 'par_id!=' => $id]))
						$this->array_errors[] = 'Lo siento ya se encuentra registrado';

					if (empty($this->array_errors)) {
						if ($newPar->editar($id, [
							'par_catid' => $categoria,
							'par_parte' => $parte
						])) {
							Http::json_response(true);
						} else {
							Http::json_response(false);
						}
					}
				}
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function eliminarParte(int $id_parte)
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newPar = new PlanillaCategoriaParte();
			if ($newPar->existe('par_id', $id_parte)) {
				Http::json_response($newPar->eliminar($id_parte));
			} else {
				$this->array_errors[] = 'Acción prohibida';
			}
		}
	}

	public function obtenerServicios()
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newServ = new PlanillaServicio();
			$newMotor = new Motor();
			$servicios = $newServ->obtenerServicios();
			$lista = [];
			$div = Moneda::Predeterminada();
			if (is_countable($servicios) && count($servicios)) {
				foreach ($servicios as $row) {
					$lista[] = [
						'id' => $row['serv_id'],
						'categoria' => [
							'id'  => $row['cat_id'],
							'categoria' => $row['cat_categorias']
						],
						'servicio' => [
							'id' => $row['pro_id'],
							'servicio' => $row['pro_descripcion'],
							'precio' => Moneda::moneda($row['pro_precio'], $div['locale'], $div['symbol'], $div['precision'])
						]
					];
				}
			}
			Http::json_response($lista);
		}
	}

	public function guardarServicios()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['s_categoria']))
				$this->array_errors[] = 'El campo Categoria es obligatorio';
			if (empty($_POST['servicio']))
				$this->array_errors[] = 'El campo Servicio es obligatorio';

			if (empty($this->array_errors)) {

				$categoria = $this->solicitud->sanitize($_POST['s_categoria'], FILTER_SANITIZE_NUMBER_INT);
				$servicio = $this->solicitud->sanitize($_POST['servicio'], FILTER_SANITIZE_NUMBER_INT);

				if (empty($motor))
					$motor = null;

				$newServ = new PlanillaServicio();

				if (empty($_POST['id'])) {

					if ($newServ->where(['serv_proid' => $servicio]))
						$this->array_errors[] = 'El servicio ya se encuentra asignado a otra categoria';

					if (empty($this->array_errors)) {
						Http::json_response($newServ->guardar([
							'serv_catid' => $categoria,
							'serv_proid' => $servicio
						], true));
					}
				} else {

					$id = $this->solicitud->sanitize($_POST['id'], FILTER_SANITIZE_NUMBER_INT);

					if ($newServ->where(['serv_proid' => $servicio, 'serv_id!=' => $id]))
						$this->array_errors[] = 'El servicio ya se encuentra asignado a otra categoria';

					if (empty($this->array_errors)) {
						Http::json_response($newServ->editar($id, [
							'serv_catid' => $categoria,
							'serv_proid' => $servicio
						]));
					}
				}
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function eliminarServicio(int $id_servicio)
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newServ = new PlanillaServicio();
			if ($newServ->existe('serv_id', $id_servicio)) {
				Http::json_response($newServ->eliminar($id_servicio));
			} else {
				$this->array_errors[] = 'Acción prohibida';
			}
		}
	}

	public function obtenerEmpleados()
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			Http::json_response($GLOBALS['newDBIni']->consultar("SELECT einfo_id id, CONCAT(einfo_nombres, ' ', einfo_apellidos) empleado FROM app_empleados_info WHERE einfo_id != 1")->all());
		}
	}

	public function obtenerCategoriasEmpleados()
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newCatEmp = new PlanillaCategoriaEmpleado();
			$cat_emp = $newCatEmp->obtenerCategorias();
			$lista = [];
			if (is_countable($cat_emp) && count($cat_emp)) {
				foreach ($cat_emp as $row) {
					$lista[] = [
						'id' => $row['catemp_id'],
						'categoria' => [
							'id' => $row['cat_id'],
							'categoria' => $row['cat_categorias']
						],
						'empleado' => [
							'id' => $row['einfo_id'],
							'empleado' => $row['einfo_nombres'] . ' ' . $row['einfo_apellidos']
						]
					];
				}
			}
			Http::json_response($lista);
		}
	}

	public function guardarCategoriaEmpleado()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['e_categoria']))
				$this->array_errors[] = 'El campo Categoria es obligatorio';
			if (empty($_POST['empleado']))
				$this->array_errors[] = 'El campo Empleado es obligatorio';

			if (empty($this->array_errors)) {

				$categoria = $this->solicitud->sanitize($_POST['e_categoria'], FILTER_SANITIZE_NUMBER_INT);
				$empleado = $this->solicitud->sanitize($_POST['empleado'], FILTER_SANITIZE_NUMBER_INT);

				$newCatEmp = new PlanillaCategoriaEmpleado();

				if (empty($_POST['id'])) {

					if ($newCatEmp->where(['catemp_catid' => $categoria, 'catemp_empid' => $empleado]))
						$this->array_errors[] = 'Lo siento la relación que intenta crear ya existe';

					if (empty($this->array_errors)) {
						if ($newCatEmp->guardar([
							'catemp_catid' => $categoria,
							'catemp_empid' => $empleado
						], true)) {
							Http::json_response(true);
						} else {
							Http::json_response(false);
						}
					}
				} else {

					$id = $this->solicitud->sanitize($_POST['id'], FILTER_SANITIZE_NUMBER_INT);

					if ($newCatEmp->where(['catemp_catid' => $categoria, 'catemp_empid' => $empleado, 'catemp_id!=' => $id]))
						$this->array_errors[] = 'Lo siento la relación que intenta crear ya existe';

					if (empty($this->array_errors)) {
						if ($newCatEmp->editar($id, [
							'catemp_catid' => $categoria,
							'catemp_empid' => $empleado
						])) {
							Http::json_response(true);
						} else {
							Http::json_response(false);
						}
					}
				}
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function eliminarCategoriaEmpleado(int $id_cat_emp)
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newCatEmp = new PlanillaCategoriaEmpleado();
			if ($newCatEmp->existe('catemp_id', $id_cat_emp)) {
				Http::json_response($newCatEmp->eliminar($id_cat_emp));
			} else {
				$this->array_errors[] = 'Acción prohibida';
			}
		}
	}

	public function guardarCliente()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['cli_tipodoc']))
				$this->array_errors[] = 'El campo Cedula de identidad es obligatorio.';
			if (empty($_POST['cli_dni']))
				$this->array_errors[] = 'El campo Tipo de documento es obligatorio.';
			if (empty($_POST['cli_razon_social']))
				$this->array_errors[] = 'El campo Razón social es obligatorio.';
			if (empty($_POST['cli_telefono']))
				$this->array_errors[] = 'El campo Telefono es obligatorio.';
			if (empty($_POST['cli_direccion']))
				$this->array_errors[] = 'El campo Direccion es obligatorio.';

			if (empty($this->array_errors)) {

				$cli_tipodoc    = filter_input(INPUT_POST, 'cli_tipodoc', FILTER_SANITIZE_NUMBER_INT);
				$cli_dni        = $this->solicitud->sanitize($_POST['cli_dni'], FILTER_SANITIZE_STRING);
				$razon_social   = $this->solicitud->sanitize($_POST['cli_razon_social'], FILTER_SANITIZE_STRING);
				$cli_telefono   = $this->solicitud->sanitize($_POST['cli_telefono'], FILTER_SANITIZE_STRING);
				$cli_direccion  = $this->solicitud->sanitize($_POST['cli_direccion'], FILTER_SANITIZE_STRING);
				$cli_natural    = ('true' == filter_input(INPUT_POST, 'cli_natural')) ? 1 : 0;

				$cliente_model = new Cliente();

				if (empty($_POST['cli_email'])) {
					$cli_email = NULL;
				} else {
					$cli_email = filter_input(INPUT_POST, 'cli_email', FILTER_VALIDATE_EMAIL);
					if (!$cli_email)
						$this->array_errors[] = 'Correo invalido';
					if ($cliente_model->existe('cli_email', $cli_email))
						$this->array_errors[] = 'El correo electronico ya se encuentra en uso';
				}

				if (empty($cli_telefono)) {
					$cli_telefono = NULL;
				} else {
					if (strlen($cli_telefono) < 15 || strlen($cli_telefono) > 50)
						$this->array_errors[] = 'El número de telefono es incorrecto';
				}

				if ($cliente_model->existe('cli_dni', $cli_dni))
					$this->array_errors[] = 'La cedula de identidad ya se encuentra en uso';

				if (empty($this->array_errors)) {

					try {

						$cliente_model->transactionBegin();

						$data_id = $cliente_model->guardar([
							'cli_tipodocid'     => $cli_tipodoc,
							'cli_dni'           => $cli_dni,
							'cli_razon_social'  => $razon_social,
							'cli_email'         => $cli_email,
							'cli_telefono'      => $cli_telefono,
							'cli_direccion'     => $cli_direccion,
							'cli_contribuyente' => 1,
							'cli_fecha_reg'     => date('Y-m-d H:i:s'),
							'cli_natural'       => $cli_natural
						]);

						$cliente_model->guardar([
							'ccon_cliid'    => $data_id,
							'ccon_nombre'   => $razon_social,
							'ccon_cargo'    => 'Personal',
							'ccon_telefono' => $cli_telefono,
							'ccon_email'    => $cli_email,
						], true, 'app_clientes_contactos');

						$cliente_model->guardar([
							'cde_cliid'     => $data_id,
							'cde_direccion' => $cli_direccion
						], true, 'app_clientes_direcciones_envios');

						$id_preorden = $cliente_model->guardar([
							'pre_cliid' => $data_id,
							'pre_empleado' => $_SESSION['user_data']['emp_id'],
							'pre_observacion' => ''
						], false, 'app_preorden_master');

						$cliente_model->transactionCommit();
					} catch (\Throwable $th) {
						$cliente_model->transactionRollBack();
						$this->array_errors[] = 'Error en transacción';
					}

					if (empty($this->array_errors)) {
						Http::json_response(ruta_base() . 'planilla/orden/' . $id_preorden);
					}
				}
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function agregarCliente(int $id_cliente)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			$id_cliente    = filter_var($id_cliente, FILTER_SANITIZE_NUMBER_INT);
			$cliente_model = new Cliente();

			$id_preorden = $cliente_model->guardar([
				'pre_cliid' => $id_cliente,
				'pre_empleado' => $_SESSION['user_data']['emp_id'],
				'pre_observacion' => ''
			], false, 'app_preorden_master');

			if (empty($this->array_errors)) {
				Http::json_response(ruta_base() . 'planilla/orden/' . $id_preorden);
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function guardarClienteCambiar()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_orden']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$id_orden = filter_input(INPUT_POST, 'id_orden', FILTER_SANITIZE_NUMBER_INT);

			if (!$this->newPreOrden->existe('pre_id', $id_orden)) {
				Http::json_response(['errors' => ['Acción prohibida']]);
			}

			$this->preordenEditable($id_orden);

			if (empty($_POST['cli_tipodoc']))
				$this->array_errors[] = 'El campo Cedula de identidad es obligatorio.';
			if (empty($_POST['cli_dni']))
				$this->array_errors[] = 'El campo Tipo de documento es obligatorio.';
			if (empty($_POST['cli_razon_social']))
				$this->array_errors[] = 'El campo Razón social es obligatorio.';
			if (empty($_POST['cli_telefono']))
				$this->array_errors[] = 'El campo Telefono es obligatorio.';
			if (empty($_POST['cli_direccion']))
				$this->array_errors[] = 'El campo Direccion es obligatorio.';

			if (empty($this->array_errors)) {

				$cli_tipodoc    = filter_input(INPUT_POST, 'cli_tipodoc', FILTER_SANITIZE_NUMBER_INT);
				$cli_dni        = $this->solicitud->sanitize($_POST['cli_dni'], FILTER_SANITIZE_STRING);
				$razon_social   = $this->solicitud->sanitize($_POST['cli_razon_social'], FILTER_SANITIZE_STRING);
				$cli_telefono   = $this->solicitud->sanitize($_POST['cli_telefono'], FILTER_SANITIZE_STRING);
				$cli_direccion  = $this->solicitud->sanitize($_POST['cli_direccion'], FILTER_SANITIZE_STRING);
				$cli_natural    = ('true' == filter_input(INPUT_POST, 'cli_natural')) ? 1 : 0;

				$cliente_model  = new Cliente();

				if (empty($_POST['cli_email'])) {
					$cli_email = NULL;
				} else {
					$cli_email = filter_input(INPUT_POST, 'cli_email', FILTER_VALIDATE_EMAIL);
					if (!$cli_email)
						$this->array_errors[] = 'Correo invalido';
					if ($cliente_model->existe('cli_email', $cli_email))
						$this->array_errors[] = 'El correo electronico ya se encuentra en uso';
				}

				if (empty($cli_telefono)) {
					$cli_telefono = NULL;
				} else {
					if (strlen($cli_telefono) < 15 || strlen($cli_telefono) > 50)
						$this->array_errors[] = 'El número de telefono es incorrecto';
				}

				if ($cliente_model->existe('cli_dni', $cli_dni))
					$this->array_errors[] = 'La cedula de identidad ya se encuentra en uso';

				if (empty($this->array_errors)) {

					try {

						$cliente_model->transactionBegin();

						$data_id = $cliente_model->guardar([
							'cli_tipodocid'     => $cli_tipodoc,
							'cli_dni'           => $cli_dni,
							'cli_razon_social'  => $razon_social,
							'cli_email'         => $cli_email,
							'cli_telefono'      => $cli_telefono,
							'cli_direccion'     => $cli_direccion,
							'cli_contribuyente' => 1,
							'cli_fecha_reg'     => date('Y-m-d H:i:s'),
							'cli_natural'       => $cli_natural
						]);

						$cliente_model->guardar([
							'ccon_cliid'    => $data_id,
							'ccon_nombre'   => $razon_social,
							'ccon_cargo'    => 'Personal',
							'ccon_telefono' => $cli_telefono,
							'ccon_email'    => $cli_email,
						], true, 'app_clientes_contactos');

						$cliente_model->guardar([
							'cde_cliid'     => $data_id,
							'cde_direccion' => $cli_direccion
						], true, 'app_clientes_direcciones_envios');

						$cliente_model->editar($id_orden, [
							'pre_cliid' => $data_id,
							'pre_empleado' => $_SESSION['user_data']['emp_id']
						], 'app_preorden_master', 'pre_id');

						$cliente_model->transactionCommit();
					} catch (\Throwable $th) {
						$cliente_model->transactionRollBack();
						$this->array_errors[] = 'Error en transacción';
					}

					if (empty($this->array_errors)) {
						$orden =  $this->newPreOrden->obtenerPreOrden($id_orden);
						Http::json_response([
							'orden' => $id_orden,
							'fecha' => date('d-m-Y', strtotime($orden['pre_creado'])),
							'cliente' => [
								'id' => $orden['cli_id'],
								'dni' => $orden['cli_dni'],
								'cliente' => $orden['cli_razon_social'],
								'telefono' => $orden['cli_telefono']
							]
						]);
					}
				}
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function cambiarCliente()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_orden']) || empty($_POST['id_cliente']))
				Http::json_response(['errors' => ['Acción prohiida']]);

			$id_cliente     = filter_input(INPUT_POST, 'id_cliente', FILTER_SANITIZE_NUMBER_INT);
			$id_orden       = filter_input(INPUT_POST, 'id_orden', FILTER_SANITIZE_NUMBER_INT);

			$this->preordenEditable($id_orden);

			$cliente_model  = new Cliente();

			if (!$cliente_model->existe('cli_id', $id_cliente))
				$this->array_errors[] = 'Acción prohibida';
			if (!$this->newPreOrden->existe('pre_id', $id_orden))
				$this->array_errors[] = 'Acción prohibida';

			if (empty($this->array_errors)) {

				if ($this->newPreOrden->editar($id_orden, [
					'pre_cliid' => $id_cliente,
					'pre_empleado' => $_SESSION['user_data']['emp_id']
				])) {
					$orden =  $this->newPreOrden->obtenerPreOrden($id_orden);
					Http::json_response([
						'orden' => $id_orden,
						'fecha' => date('d-m-Y', strtotime($orden['pre_creado'])),
						'cliente' => [
							'id' => $orden['cli_id'],
							'dni' => $orden['cli_dni'],
							'cliente' => $orden['cli_razon_social'],
							'telefono' => $orden['cli_telefono']
						]
					]);
				}

				Http::json_response('false');
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function actualizarTaller()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_orden']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$id_orden = $this->solicitud->sanitize($_POST['id_orden'], FILTER_SANITIZE_NUMBER_INT);
			$taller = $this->solicitud->sanitize($_POST['taller'], FILTER_SANITIZE_STRIPPED);

			$this->preordenEditable($id_orden);

			Http::json_response($this->newPreOrden->editar($id_orden, [
				'pre_taller' => $taller
			]));

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function actualizarObserv()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_orden']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$id_orden = $this->solicitud->sanitize($_POST['id_orden'], FILTER_SANITIZE_NUMBER_INT);
			$observ = $this->solicitud->sanitize($_POST['observ'], FILTER_SANITIZE_STRIPPED);

			$this->preordenEditable($id_orden);

			Http::json_response($this->newPreOrden->editar($id_orden, [
				'pre_observacion' => $observ
			]));

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function entregadocompletado(int $id_orden)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			$id_orden =  filter_var($id_orden, FILTER_SANITIZE_NUMBER_INT);

			$newPreOrdenServicios = new PlanillaPreOrdenServicios();
			$newPreOrdenPartes = new PlanillaPreOrdenPartes();

			if ($this->newPreOrden->existe('pre_id', $id_orden)) {

				if (!$newPreOrdenServicios->where(['preserv_preid' => $id_orden]))
					Http::json_response(['errors' => ['Acción prohibida no puede generar el presupuesto si la orden no tiene servicios cargados previamente']]);

				if (!$newPreOrdenPartes->where(['prepar_preid' => $id_orden]))
					Http::json_response(['errors' => ['Acción prohibida no puede generar el presupuesto si la orden no tiene partes cargados previamente']]);

				$orden = $this->newPreOrden->obtener($id_orden);


				if ($orden['pre_empbajo_motor'] == 0) {
					Http::json_response(['errors' => ['No puede generarse la planilla hasta que no se indique quien bajo el motor']]);
				}
				if ($orden['pre_entrega'] == 1) {
					$permis = $this->module->has_module_action_permission('planilla', 'cambiar_entrega', $_SESSION['user_data']['emp_id']);
					if ($permis) {
						$this->newPreOrden->editar($id_orden, [
							'pre_entrega' => 0,
						]);

						Http::json_response(true);
					} else {
						$this->array_errors[] = 'La orden ya fue entregada';
					}
					$this->array_errors[] = 'La orden ya fue entregada';
				} else {
					$this->newPreOrden->editar($id_orden, [
						'pre_entrega' => 1,
					]);


					Http::json_response(true);
				}
			} else {
				$this->array_errors[] = 'Acción prohibida';
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function generarOrden(int $id_orden)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			$id_orden =  filter_var($id_orden, FILTER_SANITIZE_NUMBER_INT);

			$newPreOrdenServicios = new PlanillaPreOrdenServicios();
			$newPreOrdenPartes = new PlanillaPreOrdenPartes();

			$this->preordenEditable($id_orden);

			if ($this->newPreOrden->existe('pre_id', $id_orden)) {

				if (!$newPreOrdenServicios->where(['preserv_preid' => $id_orden]))
					Http::json_response(['errors' => ['Acción prohibida no puede generar el presupuesto si la orden no tiene servicios cargados previamente']]);

				if (!$newPreOrdenPartes->where(['prepar_preid' => $id_orden]))
					Http::json_response(['errors' => ['Acción prohibida no puede generar el presupuesto si la orden no tiene partes cargados previamente']]);

				$orden = $this->newPreOrden->obtener($id_orden);

				$ultimo = $this->newPreOrden->consultar("SELECT COUNT(pre_id) as pre_id FROM app_preorden_master WHERE MONTH(CURDATE())=MONTH(pre_creado) AND YEAR(CURDATE())=YEAR(pre_creado) AND pre_estatus>0")->row();
				$ultimo = $ultimo['pre_id'] + 1;
				$mascara = mascara_correlativo(date('ym'), '000',  $ultimo);

				/*if ($orden['pre_empdesarmo_motor'] == 0) {
					Http::json_response(['errors' => ['No puede generarse la planilla hasta que no se indique quien desarmo el motor']]);
				}*/
				if ($orden['pre_empbajo_motor'] == 0) {
					Http::json_response(['errors' => ['No puede generarse la planilla hasta que no se indique quien bajo el motor']]);
				}
				if ($orden['pre_estatus'] == 1) {
					$this->array_errors[] = 'La orden ya fue generada';
				} else {
					if (date('m-Y', strtotime($orden['pre_creado'])) != date('m-Y')) {
						$fecha = date('Y-m-d h:i:s');

						$this->newPreOrden->editar($id_orden, [
							'pre_correlativo' => $mascara,
							'pre_estatus' => 1,
							'pre_creado'  => $fecha
						]);
					} else {
						$this->newPreOrden->editar($id_orden, [
							'pre_correlativo' => $mascara,
							'pre_estatus' => 1
						]);
					}

					Http::json_response($mascara);
				}
			} else {
				$this->array_errors[] = 'Acción prohibida';
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function orden(int $id_orden)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD']) {

			$id_orden = filter_var($id_orden, FILTER_SANITIZE_NUMBER_INT);

			$data_orden = $this->newPreOrden->obtener($id_orden);

			$documentos = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_tipo_documentos")->all();
			$categorias = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_planilla_categorias")->all();

			$add_emp = $this->module->has_module_action_permission('planilla', 'add_asig_emp', $_SESSION['user_data']['emp_id']);
			$delete_emp = $this->module->has_module_action_permission('planilla', 'delete_asig_emp_serv', $_SESSION['user_data']['emp_id']);

			$impresoras = $this->newPreOrden->consultar("SELECT * FROM app_impresoras WHERE imp_tipo = 2 AND imp_estatus = 1")->all();
			$impresoras_de_ticket = [];

			if (is_countable($impresoras) && count($impresoras)) {
				foreach ($impresoras as $row) {
					$impresoras_de_ticket[] = [
						'id' => $row['imp_id'],
						'impresora' => $row['imp_descripcion'],
					];
				}
			}

			$lista = [];
			if (is_countable($categorias) && count($categorias)) {
				foreach ($categorias as $row) {
					$lista[] = [
						'id' => $row['cat_id'],
						'categoria' => $row['cat_categorias']
					];
				}
			}


   $empleados = $this->newPreOrden->consultar("SELECT einfo_id id, einfo_eliminado, CONCAT(einfo_nombres, ' ', einfo_apellidos) empleado FROM app_empleados_info WHERE einfo_id != 1 AND einfo_eliminado = 0")->all();

			if ($this->newPreOrden->existe('pre_id', $id_orden)) {
				return Vista::view('planilla/orden/crear', [
					'orden' => $id_orden,
					'estatus' => $data_orden['pre_estatus'],
					'impresoras_de_ticket' => $impresoras_de_ticket,
					'tipos_de_documentos' => $documentos,
					'categorias' => $lista,
					'permiso_add_emp' => $add_emp,
					'permiso_delete_emp' => $delete_emp,
					'empleados'             => $empleados,

				]);
			}

			Http::exit_by_forbiden();
		}
	}

	public function obtenerOrden(int $id_orden)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			$id_orden = filter_var($id_orden, FILTER_SANITIZE_NUMBER_INT);

			$lista_part = [];
			$lista_serv = [];
			$serv_categorias = [];
			$newMotor = new Motor();
			$newPreOrdenPartes = new PlanillaPreOrdenPartes();
			$newPreOrdenServicios = new PlanillaPreOrdenServicios();
			$newPlanillaOrden = new PlanillaOrdenDeEntrega();
			$newCatEmp = new PlanillaCategoriaEmpleado();
			$orden = $this->newPreOrden->obtenerPreOrden($id_orden);
			$motor = $orden['pre_motid'] ? $newMotor->obtenerMotor($orden['pre_motid']) : null;
			$servicios = $newPreOrdenServicios->obtenerServicios($id_orden);
			$partes = $newPreOrdenPartes->obtenerPartes($id_orden);

			$data_presupuesto = $newPlanillaOrden->where(['po_preid' => $id_orden], true);

			if ($data_presupuesto) {
				$estatus_autorizado = $data_presupuesto['po_estatus'] == 1 ? true : false;
			} else {
				$estatus_autorizado = false;
			}

			if (is_countable($servicios) && count($servicios)) {
				foreach ($servicios as $row) {
					$empleados = $newPreOrdenServicios->obtenerEmpleadosServicios($row['preserv_id']);
					$data_serv = [
						'id' => $row['preserv_id'],
						'cantidad' => $row['preserv_cantidad'],
						'servicio' => $row['pro_descripcion'],
						'estatus' => $row['preserv_estatus'],
						'categoria' => $row['cat_categorias'],
						'empleados' => $empleados ?? [],
						'checked' => false,
					];
					if (!in_array($row['cat_id'], $serv_categorias)) {
						$serv_categorias[] = $row['cat_id'];
						$lista_serv[$row['cat_id']] = [
							'cat_id' => $row['cat_id'],
							'categoria' => $row['cat_categorias'],
							'servicios' => [$data_serv]
						];
					} else {
						$lista_serv[$row['cat_id']]['servicios'][] = $data_serv;
					}
				}
			}

			if (is_countable($partes) && count($partes)) {
				foreach ($partes as $row) {
					$lista_part[] = [
						'id' => $row['prepar_id'],
						'cantidad' => $row['prepar_cantidad'],
						'categoria' => $row['cat_categorias'],
						'ubicacion' => $row['prepar_ubicacion'],
						'observacion' => $row['prepar_observacion'],
						'parte' => $row['par_parte']
					];
				}
			}
			if (!$newPreOrdenServicios->where(['preserv_preid' => $id_orden])) {
				$servicios_check = 1;
			} else {
				$servicios = $this->newPreOrden->consultar("SELECT count(preserv_id) as total FROM app_preorden_master_servicios WHERE preserv_preid = $id_orden AND preserv_estatus = 0")->row();
				$servicios_check = $servicios['total'];
			}

			$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = $id_orden")->row();
			$deuda = 0;
			if ($existe_presupuesto) {
				$newCarritoVenta = new CarritoVentasModel();

				$factura = $newCarritoVenta->obtenerOrdenE($existe_presupuesto['po_nid']);

				$total_pagos = $newCarritoVenta->totalPagos($existe_presupuesto['po_nid'], 12, 1);

				$deuda = $factura['total'] - $total_pagos['total'];
			}

			Http::json_response([
				'orden' => $id_orden,
				'estatus' => $orden['pre_estatus'],
				'n_orden' => $orden['pre_correlativo'],
				'observacion_repuestos' => $orden['pre_observacion_repuestos'],
				'fecha' => date('d-m-Y', strtotime($orden['pre_creado'])),
				'taller' => $orden['pre_taller'],
				'ubicacion_culminado' => $orden['pre_ubicacion_final'],
				'motor_id' => ($motor) ? $motor['mot_id'] : '',
				'motor' => ($motor) ? $motor['mot_motor'] . ' - Marca: ' . $motor['m_marca'] . ' - Modelo: ' . $motor['mot_modelo'] : '',
				'cliente' => [
					'id' => $orden['cli_id'],
					'dni' => $orden['cli_dni'],
					'cliente' => $orden['cli_razon_social'],
					'telefono' => $orden['cli_telefono']
				],
				'emp_bajo_motor' => $orden['pre_empbajo_motor'],
				'emp_desarmo_motor' => $orden['pre_empdesarmo_motor'],
				'pre_emplficha' => $orden['pre_emplficha'],
				'medidas1' => $orden['pre_medidas'],
				'medidas2' => $orden['pre_medidas_d'],
				'medidas3' => $orden['pre_medidas_t'],
				'pre_observacion' => ($orden['pre_observacion'] != null) ? $orden['pre_observacion'] : '',
				'empleados_todos' => $newCatEmp->obtenerEmpleadosSegunCategoria(7),
				'estatus_autorizado' => $estatus_autorizado,
				'partes' => $lista_part,
				'servicios' => $lista_serv,
				'tot_servicios_asignados' => $servicios_check,
				'restante' => $deuda,
				'entrega' => $orden['pre_entrega']
			]);
		}
	}

	public function agregarMotorPlantilla()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_orden']) || empty($_POST['id_motor']))
				Http::json_response(['errors' => ['Acción prohibidadd']]);

			$id_motor = filter_input(INPUT_POST, 'id_motor', FILTER_SANITIZE_NUMBER_INT);
			$id_orden = filter_input(INPUT_POST, 'id_orden', FILTER_SANITIZE_NUMBER_INT);

			$this->preordenEditable($id_orden);

			$newMotor = new Motor();

			if (!$this->newPreOrden->existe('pre_id', $id_orden))
				$this->array_errors[] = 'Acción prohibidaddd';
			if (!$newMotor->existe('mot_id', $id_motor))
				$this->array_errors[] = 'Acción prohibidarr';

			if (empty($this->array_errors)) {
				Http::json_response($this->newPreOrden->editar($id_orden, [
					'pre_motid' => $id_motor
				]));
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function actualizarRepuestosClientes()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_orden']) || !isset($_POST['repuestos']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$id_orden = filter_input(INPUT_POST, 'id_orden', FILTER_SANITIZE_NUMBER_INT);
			$observacion = $this->solicitud->sanitize($_POST['repuestos'], FILTER_SANITIZE_STRING);

			$this->preordenEditable($id_orden);

			if (!$this->newPreOrden->existe('pre_id', $id_orden))
				Http::json_response(['errors' => ['Acción prohibida']]);

			Http::json_response($this->newPreOrden->editar($id_orden, ['pre_observacion_repuestos' => $observacion]));
		}
	}

	//PARTES
	public function obtenerParte(int $id_parte)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			$id_parte   = filter_var($id_parte, FILTER_SANITIZE_NUMBER_INT);
			$newPreOrdenPartes = new PlanillaPreOrdenPartes();
			$parte      = $newPreOrdenPartes->obtener($id_parte);

			Http::json_response([
				'cantidad' => $parte['prepar_cantidad'],
				'ubicacion' => $parte['prepar_ubicacion'],
				'observacion' => $parte['prepar_observacion'],
			]);
		}
	}

	public function obtenerPartesDeCategoria()
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_GET['id_categoria']) || empty($_GET['id_orden']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$id_categoria = filter_input(INPUT_GET, 'id_categoria', FILTER_SANITIZE_NUMBER_INT);
			$id_orden = filter_input(INPUT_GET, 'id_orden', FILTER_SANITIZE_NUMBER_INT);
			$lista = [];
			$newParte = new PlanillaCategoriaParte();

			$partes = $newParte->where(['par_catid' => $id_categoria]);

			if (is_countable($partes) && count($partes)) {
				foreach ($partes as $row) {
					if (!$newParte->consultar("SELECT * FROM app_preorden_master_partes WHERE prepar_preid=$id_orden AND prepar_parid = {$row['par_id']}")->row()) {
						$lista[] = [
							'id' => $row['par_id'],
							'cantidad' => 1,
							'parte' => $row['par_parte'],
							'checked' => false,
						];
					}
				}
			}
			Http::json_response($lista);
		}
	}

	public function obtenerPartesDePreOrden(int $id_orden)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$lista = [];
			$newPreOrdenPartes = new PlanillaPreOrdenPartes();
			$id_orden = filter_var($id_orden, FILTER_SANITIZE_NUMBER_INT);
			$partes = $newPreOrdenPartes->obtenerPartes($id_orden);
			if (is_countable($partes) && count($partes)) {
				foreach ($partes as $row) {
					$lista[] = [
						'id' => $row['prepar_id'],
						'cantidad' => $row['prepar_cantidad'],
						'categoria' => $row['cat_categorias'],
						'ubicacion' => $row['prepar_ubicacion'],
						'observacion' => $row['prepar_observacion'],
						'parte' => $row['par_parte']
					];
				}
			}
			Http::json_response($lista);
		}
	}

	public function guardarPartesPreOrden()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			$newPreOrdenPartes = new PlanillaPreOrdenPartes();

			if (empty($_POST['id_orden']) || empty($_POST['partes']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$partes = json_decode($_POST['partes'], true);

			$id_orden = filter_input(INPUT_POST, 'id_orden', FILTER_SANITIZE_NUMBER_INT);

			$this->preordenEditable($id_orden);

			if (is_countable($partes) && count($partes)) {

				if (!$this->newPreOrden->existe('pre_id', $id_orden))
					$this->array_errors[] = 'Acción prohibida';

				foreach ($partes as $row) {
					if (is_numeric($row['checked']) && ($row['cantidad'] < 1 && $row['checked'])) {
						$this->array_errors[] = 'La cantidad de la parte ' . $row['parte'] . ' no puede ser menor a 1';
					}
				}

				if (empty($this->array_errors)) {
					try {
						$newPreOrdenPartes->transactionBegin();
						foreach ($partes as $row) {
							if (!$newPreOrdenPartes->where(['prepar_preid' => $id_orden, 'prepar_parid' => $row['id']], true) && $row['checked'])
								$newPreOrdenPartes->guardar([
									'prepar_preid' => $id_orden,
									'prepar_parid' => $row['id'],
									'prepar_cantidad' => (is_numeric($row['cantidad'])) ? $row['cantidad'] : 'X'
								], true);
						}
						$newPreOrdenPartes->transactionCommit();
					} catch (\Throwable $th) {
						$newPreOrdenPartes->transactionRollBack();
						$this->array_errors[] = 'Error en transacción';
					}
				}
			} else {
				$this->array_errors[] = 'Acción prohibida';
			}

			if (empty($this->array_errors)) {
				Http::json_response(true);
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function eliminarParteOrden(int $id_parte_orden)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			$newPreOrdenPartes = new PlanillaPreOrdenPartes();

			$id_parte_orden = filter_var($id_parte_orden, FILTER_SANITIZE_NUMBER_INT);

			if (!$newPreOrdenPartes->existe('prepar_id', $id_parte_orden))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$data_parte_orden = $newPreOrdenPartes->obtener($id_parte_orden);

			$this->preordenEditable($data_parte_orden['prepar_preid']);

			Http::json_response($newPreOrdenPartes->eliminar($id_parte_orden));
		}
	}

	public function actualizarCantidadParteOrden()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_parte_orden']) || empty($_POST['cantidad']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$newPreOrdenPartes = new PlanillaPreOrdenPartes();

			$id_parte_orden = filter_input(INPUT_POST, 'id_parte_orden', FILTER_SANITIZE_NUMBER_INT);
			$cantidad = filter_input(INPUT_POST, 'cantidad', FILTER_SANITIZE_STRING) ?? 1;

			if (!is_numeric($cantidad)) {
				$cantidad =  'X';
			}

			if (!$newPreOrdenPartes->existe('prepar_id', $id_parte_orden))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$data_parte_orden = $newPreOrdenPartes->obtener($id_parte_orden);

			$this->preordenEditable($data_parte_orden['prepar_preid']);

			Http::json_response($newPreOrdenPartes->editar($id_parte_orden, [
				'prepar_cantidad' => $cantidad
			]));
		}
	}

	public function guardarObservacionParte()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_parte']) || !isset($_POST['observacion']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$id_parte = filter_var($_POST['id_parte'], FILTER_SANITIZE_NUMBER_INT);
			$cantidad = $this->solicitud->sanitize($_POST['cantidad'], FILTER_SANITIZE_STRING);
			$ubicacion = $this->solicitud->sanitize($_POST['ubicacion'], FILTER_SANITIZE_STRING);
			$observacion = $this->solicitud->sanitize($_POST['observacion'], FILTER_SANITIZE_STRING);

			$newPreOrdenPartes = new PlanillaPreOrdenPartes();

			if (!$newPreOrdenPartes->existe('prepar_id', $id_parte))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$data_parte = $newPreOrdenPartes->obtener($id_parte);

			$this->preordenEditable($data_parte['prepar_preid']);

			if ($newPreOrdenPartes->editar($id_parte, [
				'prepar_cantidad' => $cantidad,
				'prepar_ubicacion' => $ubicacion,
				'prepar_observacion' => $observacion
			])) {

				$parte_orden_cat = $newPreOrdenPartes->consultar("SELECT par_catid
                FROM app_preorden_master_partes mp
                JOIN app_planillas_categorias_partes cp ON cp.par_id = mp.prepar_parid
                WHERE prepar_id = {$data_parte['prepar_id']}")->row();

				$partes_orden = $newPreOrdenPartes->consultar("SELECT prepar_id
                FROM app_preorden_master_partes mp
                JOIN app_planillas_categorias_partes cp ON cp.par_id = mp.prepar_parid
                WHERE prepar_preid = {$data_parte['prepar_preid']} AND par_catid = {$parte_orden_cat['par_catid']}")->all();

				foreach ($partes_orden as $row) {
					$newPreOrdenPartes->consultar("UPDATE app_preorden_master_partes SET prepar_ubicacion = '$ubicacion' WHERE prepar_id = {$row['prepar_id']}")->run();
				}

				Http::json_response(true);
			}
		}
	}

	//SERVICIOS
	public function obtenerServiciosDeCategoria()
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_GET['id_categoria']) || empty($_GET['id_orden']))
				Http::json_response(['Acción prohibida']);

			$lista = [];
			$newServ = new PlanillaServicio();
			$newMotor = new Motor();
			$id_orden =	filter_input(INPUT_GET, 'id_orden', FILTER_SANITIZE_NUMBER_INT);
			$id_categoria =	filter_input(INPUT_GET, 'id_categoria', FILTER_SANITIZE_NUMBER_INT);

			if (empty($_GET['id_motor']) || !isset($_GET['id_motor'])) {
				$servicios = $newServ->obtenerServicioProductoSegunCategoria($id_categoria, $id_orden);
			} else {

				$id_motor = filter_input(INPUT_GET, 'id_motor', FILTER_SANITIZE_NUMBER_INT);
				$data_motor = $newMotor->obtener($id_motor);
				$servicios = $newServ->obtenerServicioProductoSegunCategoriaYMotor($id_categoria, $id_motor, $id_orden);

				if (!is_null($data_motor['mot_tipid'])) {
					$servicios_tipo = $newServ->obtenerServicioProductoSegunCategoriaYTipoMotor($id_categoria, $data_motor['mot_tipid'], $id_orden);
					if (is_countable($servicios_tipo) && count($servicios_tipo)) {
						if (is_countable($servicios) && count($servicios)) {
							foreach ($servicios_tipo as $row) {
								$existe = array_search($row['serv_id'], array_column($servicios, 'serv_id'));
								if ($existe === false || $existe === 'false') {
									$servicios[] = [
										'serv_id'  => $row['serv_id'],
										'pro_descripcion' => $row['pro_descripcion'],
										'serv_proid' => $row['serv_proid'],
									];
								}
							}
						} else {
							$servicios = $servicios_tipo;
						}
					}
				}
			}

			if (is_countable($servicios) && count($servicios)) {
				foreach ($servicios as $row) {
					$lista[] = [
						'id' => $row['serv_id'],
						'proid' => $row['serv_proid'],
						'cantidad' => 1,
						'servicio' => $row['pro_descripcion'],
						'checked' => false,
					];
				}
			}

			Http::json_response($lista);
		}
	}

	public function obtenerProductosTipoServicio()
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$lista = [];
			$newServ = new PlanillaServicio();
			$servicios = $newServ->obtenerProductosTipoServicioNoAsignadosACategorias();
			if (is_countable($servicios) && count($servicios)) {
				foreach ($servicios as $row) {
					$lista[] = [
						'id' => $row['pro_id'],
						'descripcion' => $row['pro_codigo'] . ' - ' . $row['pro_descripcion']
					];
				}
			}
			Http::json_response($lista);
		}
	}

	public function obtenerServiciosDePreOrden(int $id_orden)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$lista = [];
			$newPreOrdenServicios = new PlanillaPreOrdenServicios();
			$id_orden = filter_var($id_orden, FILTER_SANITIZE_NUMBER_INT);
			$servicios = $newPreOrdenServicios->obtenerServicios($id_orden);
			$serv_categorias = [];
			if (is_countable($servicios) && count($servicios)) {
				foreach ($servicios as $row) {
					$empleados = $newPreOrdenServicios->obtenerEmpleadosServicios($row['preserv_id']);
					$data_serv = [
						'id' => $row['preserv_id'],
						'cantidad' => $row['preserv_cantidad'],
						'servicio' => $row['pro_descripcion'],
						'estatus' => $row['preserv_estatus'],
						'categoria' => $row['cat_categorias'],
						'empleados' => $empleados ?? [],
						'checked' => false,
					];
					if (!in_array($row['cat_id'], $serv_categorias)) {
						$serv_categorias[] = $row['cat_id'];
						$lista[$row['cat_id']] = [
							'cat_id' => $row['cat_id'],
							'categoria' => $row['cat_categorias'],
							'servicios' => [$data_serv]
						];
					} else {
						$lista[$row['cat_id']]['servicios'][] = $data_serv;
					}
				}
			}
			Http::json_response($lista);
		}
	}

	public function guardarServiciosPreOrden()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_orden']) || empty($_POST['servicios']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$servicios = json_decode($_POST['servicios'], true);

			$id_orden = filter_input(INPUT_POST, 'id_orden', FILTER_SANITIZE_NUMBER_INT);

			$newCarritoVenta = new CarritoVentasEditar();

			if (is_countable($servicios) && count($servicios) && $this->newPreOrden->existe('pre_id', $id_orden)) {

				$this->preordenEditable($id_orden);

				foreach ($servicios as $row) {
					if (!is_numeric($row['checked']) && $row['cantidad'] < 1) {
						$this->array_errors[] = 'La cantidad no puede ser menor a 1';
					}
				}

				if (empty($this->array_errors)) {

					$existe_presupuesto = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = $id_orden")->row();

					$articulos_cantidad = 0;
					$neto = 0;
					$total_iva = 0;
					$total  = 0;
					$total_costo_servicio = 0;
					$total_costo_producto = 0;

					try {

						$GLOBALS['newDBIni']->transactionBegin();

						foreach ($servicios as $row) {

							if (!$GLOBALS['newDBIni']->consultar("SELECT * FROM app_preorden_master_servicios WHERE preserv_preid = $id_orden and preserv_servid = {$row['id']}")->row() && $row['checked']) {

								$GLOBALS['newDBIni']->guardar([
									'preserv_preid' => $id_orden,
									'preserv_servid' => $row['id'],
									'preserv_cantidad' => $row['cantidad']
								], true, 'app_preorden_master_servicios');

								if ($existe_presupuesto) {

									$data_producto = $GLOBALS['newDBIni']->consultar("SELECT pro_id, pro_costo, pro_precio, preserv_cantidad, pro_codigo, pro_descripcion 
                                    FROM app_preorden_master_servicios ms
                                    JOIN app_planillas_servicios ps ON ps.serv_id = ms.preserv_servid
                                    JOIN app_productos p ON p.pro_id = ps.serv_proid
                                    WHERE preserv_servid = {$row['id']}")->row();

									$data_presupuesto = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();

									$GLOBALS['newDBIni']->guardar([
										'nart_nid' => $existe_presupuesto['po_nid'],
										'nart_proid' => $data_producto['pro_id'],
										'nart_procodigo' => $data_producto['pro_codigo'],
										'nart_propnombre' => $data_producto['pro_descripcion'],
										'nart_procosto' => 0,
										'nart_costo_servicio' => $data_producto['pro_precio'],
										'nart_proprecio' => $data_producto['pro_precio'],
										'nart_procantidad' => $row['cantidad'],
										'nart_prodescuento' => 0,
										'nart_proneto' => $data_producto['pro_precio'] * $row['cantidad'],
										'nart_idiva' => 2,
										'nart_almid' => $data_presupuesto['n_almid'],
										'nart_proiva' => 0,
										'nart_ivatotal' => 0,
										'nart_prototal' => $data_producto['pro_precio'] * $row['cantidad'],
										'nart_descontar_inventario' => 0
									], true, 'app_orden_de_entrega_articulos');

									$servicios = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_orden_de_entrega_articulos WHERE nart_nid = {$existe_presupuesto['po_nid']}")->all();

									foreach ($servicios as $row) {

										$producto = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_productos WHERE pro_id = {$row['nart_proid']}")->row();

										$articulos_cantidad += 1;
										$neto += $row['nart_proneto'];
										$total_iva += $row['nart_ivatotal'];
										$total += $row['nart_prototal'];

										if ($producto['pro_tipo'] == 1 || $producto['pro_tipo'] == 2) {
											$total_costo_producto = $producto['pro_costo'];
										} else if ($producto['pro_tipo'] == 3) {
											$total_costo_servicio = $producto['pro_precio'];
										}
									}

									$GLOBALS['newDBIni']->editar($existe_presupuesto['po_nid'], [
										'n_subtotal'            => $neto,
										'n_neto'                => $neto,
										'n_iva'                 => $total_iva,
										'n_total'               => $total_iva + $total,
										'n_articulos_total'     => $articulos_cantidad,
										'total_procosto'        => $total_costo_producto,
										'total_costo_servicio'  => $total_costo_servicio
									], 'app_orden_de_entrega', 'n_id');
								}
							}
						}

						$GLOBALS['newDBIni']->transactionCommit();
					} catch (\Throwable $th) {
						$GLOBALS['newDBIni']->transactionRollBack();
						$this->array_errors[] = 'Error en transacción';
					}

					if (empty($this->array_errors)) {
						if ($existe_presupuesto) {
							$newCarritoVenta->recalcularComisiones($existe_presupuesto['po_nid'], 12);
						}
					}
				}
			} else {
				$this->array_errors[] = 'Acción prohibida';
			}

			if (empty($this->array_errors)) {
				Http::json_response(true);
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function eliminarServicioOrden(int $id_servicio_orden)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			$newPreOrdenServicios = new PlanillaPreOrdenServicios();
			$newCarritoVenta = new CarritoVentasEditar();

			$id_servicio_orden = filter_var($id_servicio_orden, FILTER_SANITIZE_NUMBER_INT);

			if (!$newPreOrdenServicios->existe('preserv_id', $id_servicio_orden))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$data_servicio = $newPreOrdenServicios->obtener($id_servicio_orden);

			$this->preordenEditable($data_servicio['preserv_preid']);

			if ($data_servicio['preserv_estatus'] == 1 || $data_servicio['preserv_estatus'] == 2)
				Http::json_response(['errors' => ['Lo siento no puede eliminar el servicio']]);

			$total_costo_producto = 0;
			$total_costo_servicio = 0;
			$articulos_cantidad = 0;
			$neto = 0;
			$total_iva = 0;
			$total = 0;

			$existe_presupuesto = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$data_servicio['preserv_preid']}")->row();

			if ($existe_presupuesto) {

				$estatus_pre = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_orden_de_entrega WHERE n_id={$existe_presupuesto['po_nid']}")->row();
				//$data = $this->newPreOrden->obtener($data_servicio['preserv_preid']);

				if ($estatus_pre['n_estatus'] == 1)
					Http::json_response(['errors' => ['No se puede eliminar ya se pago en su totalidad']]);

				if (empty($this->array_errors)) {

					$data_producto = $GLOBALS['newDBIni']->consultar("SELECT pro_id, pro_costo, pro_precio, preserv_cantidad, pro_codigo, pro_descripcion 
						FROM app_preorden_master_servicios ms
						JOIN app_planillas_servicios ps ON ps.serv_id = ms.preserv_servid
						JOIN app_productos p ON p.pro_id = ps.serv_proid
						WHERE preserv_servid = {$data_servicio['preserv_servid']}")->row();

					try {

						$GLOBALS['newDBIni']->transactionBegin();

						$GLOBALS['newDBIni']->consultar("DELETE FROM app_preorden_master_servicios WHERE preserv_id = $id_servicio_orden")->run();
						$GLOBALS['newDBIni']->consultar("DELETE FROM app_orden_de_entrega_articulos WHERE nart_nid = {$existe_presupuesto['po_nid']} AND nart_proid = {$data_producto['pro_id']}")->run();

						$servicios = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_orden_de_entrega_articulos WHERE nart_nid = {$existe_presupuesto['po_nid']}")->all();

						foreach ($servicios as $row) {

							$producto = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_productos WHERE pro_id = {$row['nart_proid']}")->row();

							$articulos_cantidad += 1;
							$neto += $row['nart_proneto'];
							$total_iva += $row['nart_ivatotal'];
							$total += $row['nart_prototal'];

							if ($producto['pro_tipo'] == 1 || $producto['pro_tipo'] == 2) {
								$total_costo_producto += $producto['pro_costo'];
							} else {
								$total_costo_servicio += $producto['pro_precio'];
							}
						}

						$GLOBALS['newDBIni']->editar($existe_presupuesto['po_nid'], [
							'n_subtotal'            => $neto,
							'n_neto'                => $neto,
							'n_iva'                 => $total_iva,
							'n_total'               => $total_iva + $total,
							'n_articulos_total'     => $articulos_cantidad,
							'total_procosto'        => $total_costo_producto,
							'total_costo_servicio'  => $total_costo_servicio
						], 'app_orden_de_entrega', 'n_id');

						$GLOBALS['newDBIni']->transactionCommit();
					} catch (\Throwable $th) {
						$GLOBALS['newDBIni']->transactionRollback();
						$this->array_errors[] = 'Error en transacción';
					}

					if (empty($this->array_errors)) {
						$newCarritoVenta->recalcularComisiones($existe_presupuesto['po_nid'], 12);
						Http::json_response(true);
					}
				}
			} else {
				Http::json_response($newPreOrdenServicios->eliminar($id_servicio_orden));
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function actualizarCantidadServicioOrden()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_servicio_orden']) || empty($_POST['cantidad']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$newPreOrdenServicios = new PlanillaPreOrdenServicios();

			$id_servicio_orden = filter_input(INPUT_POST, 'id_servicio_orden', FILTER_SANITIZE_NUMBER_INT);
			$cantidad = filter_input(INPUT_POST, 'cantidad', FILTER_SANITIZE_STRING);

			if (!$newPreOrdenServicios->existe('preserv_id', $id_servicio_orden))
				Http::json_response(['errors' => ['Acción prohibida']]);

			if (!is_numeric($cantidad))
				Http::json_response(['errors' => ['La cantidad debe ser numerica']]);

			$data_servicio = $newPreOrdenServicios->obtener($id_servicio_orden);

			$this->preordenEditable($data_servicio['preserv_preid']);

			if ($data_servicio['preserv_estatus'] == 2)
				Http::json_response(['errors' => ['Acción prohibida']]);

			$existe_presupuesto = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$data_servicio['preserv_preid']}")->row();

			$estatus_pre = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_orden_de_entrega WHERE n_id={$existe_presupuesto['po_nid']}")->row();

			if ($estatus_pre['n_estatus'] == 1)
				Http::json_response(['errors' => ['Acción prohibida']]);

			if ($existe_presupuesto) {

				$data_producto = $GLOBALS['newDBIni']->consultar("SELECT pro_id, pro_costo, pro_precio, preserv_cantidad, pro_codigo, pro_descripcion 
                FROM app_preorden_master_servicios ms
                JOIN app_planillas_servicios ps ON ps.serv_id = ms.preserv_servid
                JOIN app_productos p ON p.pro_id = ps.serv_proid
                WHERE preserv_servid = {$data_servicio['preserv_servid']}")->row();

				$data_articulo_presupuesto = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_orden_de_entrega_articulos WHERE nart_nid = {$existe_presupuesto['po_nid']} AND  nart_proid = {$data_producto['pro_id']}")->row();

				$nueva_procantidad  = $cantidad;
				$nuevo_precio       = $data_articulo_presupuesto['nart_proprecio'] * $nueva_procantidad;
				$nart_proneto       = $nuevo_precio - ($nuevo_precio * $data_articulo_presupuesto['nart_prodescuento']) / 100 - 0;
				$nart_ivatotal      = $nart_proneto * ($data_articulo_presupuesto['nart_proiva'] / 100);
				$pro_total          = $nart_proneto + $nart_ivatotal;

				$articulos_cantidad = 0;
				$neto = 0;
				$total_iva = 0;
				$total = 0;
				$total_costo_servicio = 0;
				$total_costo_producto = 0;
			}

			try {

				$GLOBALS['newDBIni']->transactionBegin();

				$GLOBALS['newDBIni']->editar($id_servicio_orden, [
					'preserv_cantidad' => $cantidad
				], 'app_preorden_master_servicios', 'preserv_id');

				if ($existe_presupuesto) {

					$GLOBALS['newDBIni']->editar($data_articulo_presupuesto['nart_id'], [
						'nart_procantidad' => $nueva_procantidad,
						'nart_proneto' => $nart_proneto,
						'nart_ivatotal' => $nart_ivatotal,
						'nart_prototal' => $pro_total,
						'nart_descontar_inventario' => 0
					], 'app_orden_de_entrega_articulos', 'nart_id');

					$servicios = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_orden_de_entrega_articulos WHERE nart_nid = {$existe_presupuesto['po_nid']}")->all();

					foreach ($servicios as $row) {

						$producto = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_productos WHERE pro_id = {$row['nart_proid']}")->row();

						$articulos_cantidad += 1;
						$neto += $row['nart_proneto'];
						$total_iva += $row['nart_ivatotal'];
						$total += $row['nart_prototal'];

						if ($producto['pro_tipo'] == 1 || $producto['pro_tipo'] == 2) {
							$total_costo_producto += $producto['pro_costo'];
						} else {
							$total_costo_servicio += $producto['pro_precio'];
						}
					}

					$GLOBALS['newDBIni']->editar($existe_presupuesto['po_nid'], [
						'n_subtotal'            => $neto,
						'n_neto'                => $neto,
						'n_iva'                 => $total_iva,
						'n_total'               => $total_iva + $total,
						'n_articulos_total'     => $articulos_cantidad,
						'total_procosto'        => $total_costo_producto,
						'total_costo_servicio'  => $total_costo_servicio
					], 'app_orden_de_entrega', 'n_id');
				}

				$GLOBALS['newDBIni']->transactionCommit();
			} catch (\Throwable $th) {
				$GLOBALS['newDBIni']->transactionRollback();
				$this->array_errors[] = 'Error en transaccion';
			}

			if (empty($this->array_errors)) {
				$newCarritoVenta = new CarritoVentasEditar();

				$servicios = $this->newPreOrden->consultar("SELECT count(preemp_id) as total FROM app_preorden_master_servicios_empleados WHERE preemp_preid = {$data_servicio['preserv_preid']}")->row();

				if ($servicios['total'] > 0) {
					$newCarritoVenta->recalcularComisiones($existe_presupuesto['po_nid'], 12);
				}

				Http::json_response(true);
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	private function preordenEditable(int $id_preorden)
	{
		$data = $this->newPreOrden->obtener($id_preorden);
		if ($data['pre_estatus'] == 2) {
			Http::json_response(['errors' => ['La orden no puede ser editada ya que se encuentra con estatus completada']]);
		} else {
			if ($data['pre_estatus'] == 3) {
				Http::json_response(['errors' => ['La orden no puede ser editada ya que se encuentra con estatus anulada']]);
			} else {
				if ($data['pre_estatus'] == 4) {
					Http::json_response(['errors' => ['La orden no puede ser editada ya que se encuentra con estatus detenida']]);
				} else {
					$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$id_preorden}")->row();

					if ($existe_presupuesto) {
						$estatus_pre = $this->newPreOrden->consultar("SELECT * FROM app_orden_de_entrega WHERE n_id={$existe_presupuesto['po_nid']}")->row();
						if ($estatus_pre['n_estatus'] == 1) {
							Http::json_response(['errors' => ['La orden no puede ser editada ya que el presupuesto fue pagado en su totalidad']]);
						} else {
							return true;
						}
					} else {
						return true;
					}
				}
			}
		}
	}

	public function chequearEstatusPlanilla(int $id_orden)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$id_orden = filter_var($id_orden, FILTER_SANITIZE_NUMBER_INT);
			$data_orden = $this->newPreOrden->obtener($id_orden);
			Http::json_response($data_orden['pre_estatus']);
		}
	}

	public function cambiarEstatusServicio(int $id_servicio_orden)
	{

		$id_servicio_orden = filter_var($id_servicio_orden, FILTER_SANITIZE_NUMBER_INT);

		$newPreOrdenServicios = new PlanillaPreOrdenServicios();

		if (!$newPreOrdenServicios->existe('preserv_id', $id_servicio_orden))
			Http::json_response(['errors' => ['Acción prohibida']]);

		$data_serv_orden = $newPreOrdenServicios->obtener($id_servicio_orden);

		$this->preordenEditable($data_serv_orden['preserv_preid']);

		$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$data_serv_orden['preserv_preid']}")->row();

		if ($existe_presupuesto) {
			$total_pagos = $this->newPreOrden->consultar("SELECT SUM(fab_conversion) as total FROM app_movimientos WHERE fab_idgenerico={$existe_presupuesto['po_nid']} AND fab_doc = 12")->row();
			$data_presupuesto = $this->newPreOrden->consultar("SELECT n_correlativo, n_total FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();
			$total_pagado = round($total_pagos['total'], 2);
			$total_factura = round($data_presupuesto['n_total']);
			if ($total_pagado == 0 || $total_factura == 0) {
				$pagado = 0;
			} else {
				$pagado = $total_pagado >= $total_factura ? 1 : 0;
				if ($pagado == 0) {
					if ($total_pagado > 0) {
						$pagado = 2;
					}
				}
			}

			if ($pagado == 0) {
				if ($existe_presupuesto['po_estatus'] == 1) {
					$pagado = 3;
				}
			}

			if ($pagado == 0) {
				Http::json_response(['errors' => ['Lo siento los pagos del documento debe tener estatus diferente pendiente parar poder cambiar el estatus de los servicios']]);
			}
		} else {
			Http::json_response(['errors' => ['Lo siento debe tener asociado un presupuesto para cambiar de estatus']]);
		}

		if ($data_serv_orden['preserv_estatus'] == 2)
			Http::json_response(['errors' => ['Acción prohibida']]);

		if ($data_serv_orden['preserv_estatus'] == 1) {
			$newServEmp = new PlanillaPreOrdenServiciosEmpleado();
			$data_ser_empleado = $newServEmp->where(['preemp_preid' => $data_serv_orden['preserv_preid'], 'preemp_preservid' => $id_servicio_orden], true);
			if ($data_ser_empleado && !is_null($data_ser_empleado['preemp_empid'])) {
				$this->array_errors[] = 'Debe eliminar al empleado para cambiar el estatus';
			}
		}

		if (empty($this->array_errors)) {

			try {

				$GLOBALS['newDBIni']->transactionBegin();

				$GLOBALS['newDBIni']->editar($id_servicio_orden, [
					'preserv_estatus' => $data_serv_orden['preserv_estatus'] == 1 ? 0 : 1
				], 'app_preorden_master_servicios', 'preserv_id');

				$servicios = $GLOBALS['newDBIni']->consultar("SELECT count(preserv_id) as total FROM app_preorden_master_servicios WHERE preserv_preid = {$data_serv_orden['preserv_preid']} AND preserv_estatus = 0")->row();

				if ($servicios['total'] == 0) {
					$GLOBALS['newDBIni']->editar($data_serv_orden['preserv_preid'], [
						'pre_estatus' => 2
					], 'app_preorden_master', 'pre_id');
				}

				$GLOBALS['newDBIni']->transactionCommit();
			} catch (\Throwable $th) {
				$GLOBALS['newDBIni']->transactionRollback();
				$this->array_errors[] = 'Error en transacción';
			}

			if (empty($this->array_errors)) {
				Http::json_response(true);
			}
		}

		Http::json_response(['errors' => $this->array_errors]);
	}

	//MOTOR SERVICIOS
	public function obtenerServiciosPorCategoria()
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_GET['id_categoria'] || empty($_GET['id_motor'])))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$newCatServ  = new PlanillaServicio();
			$id_categoria = filter_input(INPUT_GET, 'id_categoria', FILTER_SANITIZE_NUMBER_INT);
			$id_motor = filter_input(INPUT_GET, 'id_motor', FILTER_SANITIZE_NUMBER_INT);

			Http::json_response($newCatServ->obtenerServiciosSegunCategoria($id_categoria, $id_motor));
		}
	}

	public function guardarMotorServicios()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['ms_motor']) || empty($_POST['ms_categoria'] || empty($_POST['ms_servicio'])))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$id_motor = filter_input(INPUT_POST, 'ms_motor', FILTER_SANITIZE_NUMBER_INT);
			$id_servicio = filter_input(INPUT_POST, 'ms_servicio', FILTER_SANITIZE_NUMBER_INT);

			$newMorServ = new PlanillaMotorServicios();

			if (isset($_POST['id']) && !empty($_POST['id'])) {

				$id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);

				if ($newMorServ->existe('ms_id', $id)) {

					if ($newMorServ->where(['ms_id!=' => $id, 'ms_motid' => $id_motor, 'ms_servid' => $id_servicio]))
						Http::json_response(['errors' => ['Lo siento la relacion que intenta crear ya existe']]);

					Http::json_response($newMorServ->editar($id, [
						'ms_motid' => $id_motor,
						'ms_servid' => $id_servicio
					], true));
				} else {
					Http::json_response(['errors' => ['Acción prohibida']]);
				}
			} else {

				if ($newMorServ->where(['ms_motid' => $id_motor, 'ms_servid' => $id_servicio]))
					Http::json_response(['errors' => ['Lo siento la relacion que intenta crear ya existe']]);

				Http::json_response($newMorServ->guardar([
					'ms_motid' => $id_motor,
					'ms_servid' => $id_servicio
				], true));
			}
		}
	}

	public function obtenerMotorServicios()
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newMotServ = new PlanillaMotorServicios();
			$data = $newMotServ->obtenerMotoresServicios();
			$div_master = Moneda::Predeterminada();
			$lista = [];
			if (is_countable($data) && count($data)) {
				foreach ($data as $row) {
					$lista[] = [
						'id' => $row['ms_id'],
						'motor' => [
							'id' => $row['mot_id'],
							'motor' => $row['motor']
						],
						'categoria' => [
							'id' => $row['cat_id'],
							'categoria' => $row['cat_categorias']
						],
						'servicio' => [
							'id' => $row['pro_id'],
							'precio' =>  Moneda::moneda($row['pro_precio'], $div_master['locale'], $div_master['symbol'], $div_master['precision']),
							'servicio' => $row['pro_descripcion']
						]
					];
				}
			}
			Http::json_response($lista);
		}
	}

	public function eliminarMotorServicio(int $id_motor_servicio)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$id_motor_servicio = filter_var($id_motor_servicio, FILTER_SANITIZE_NUMBER_INT);
			$newMorServ = new PlanillaMotorServicios();
			Http::json_response($newMorServ->eliminar($id_motor_servicio));
		}
	}

	//TIPO MOTOR / SERVICIOS

	public function obtenerServiciosSegunCategoriaYTipoMotor()
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_GET['id_categoria'] || empty($_GET['id_motor'])))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$newCatServ  = new PlanillaServicio();
			$id_categoria = filter_input(INPUT_GET, 'id_categoria', FILTER_SANITIZE_NUMBER_INT);
			$id_motor = filter_input(INPUT_GET, 'id_motor', FILTER_SANITIZE_NUMBER_INT);

			Http::json_response($newCatServ->obtenerServiciosSegunCategoriaYTipoMotor($id_categoria, $id_motor));
		}
	}

	public function guardarTipoMotorServicios()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['stip_motor']) || empty($_POST['stip_categoria'] || empty($_POST['ms_servicio'])))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$id_motor = filter_input(INPUT_POST, 'stip_motor', FILTER_SANITIZE_NUMBER_INT);
			$id_servicio = filter_input(INPUT_POST, 'ms_servicio', FILTER_SANITIZE_NUMBER_INT);

			$newMorServ = new TipoMotorServicio();

			if (isset($_POST['id']) && !empty($_POST['id'])) {

				$id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);

				if ($newMorServ->existe('tipserv_id', $id)) {

					if ($newMorServ->where(['tipserv_id!=' => $id, 'tipserv_tipid' => $id_motor, 'tipserv_servid' => $id_servicio]))
						Http::json_response(['errors' => ['Lo siento la relacion que intenta crear ya existe']]);

					Http::json_response($newMorServ->editar($id, [
						'tipserv_tipid' => $id_motor,
						'tipserv_servid' => $id_servicio
					], true));
				} else {
					Http::json_response(['errors' => ['Acción prohibida']]);
				}
			} else {

				if ($newMorServ->where(['tipserv_tipid' => $id_motor, 'tipserv_servid' => $id_servicio]))
					Http::json_response(['errors' => ['Lo siento la relacion que intenta crear ya existe']]);

				Http::json_response($newMorServ->guardar([
					'tipserv_tipid' => $id_motor,
					'tipserv_servid' => $id_servicio
				], true));
			}
		}
	}

	public function obtenerTipoMotorServicios()
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newMotServ = new TipoMotorServicio();
			$data = $newMotServ->obtenerTipoMotoresServicios();
			$div_master = Moneda::Predeterminada();
			$lista = [];
			if (is_countable($data) && count($data)) {
				foreach ($data as $row) {
					$lista[] = [
						'id' => $row['tipserv_id'],
						'tipo' => [
							'id' => $row['tip_id'],
							'tipo' => $row['tip_descripcion']
						],
						'categoria' => [
							'id' => $row['cat_id'],
							'categoria' => $row['cat_categorias']
						],
						'servicio' => [
							'id' => $row['pro_id'],
							'precio' =>  Moneda::moneda($row['pro_precio'], $div_master['locale'], $div_master['symbol'], $div_master['precision']),
							'servicio' => $row['pro_descripcion']
						]
					];
				}
			}
			Http::json_response($lista);
		}
	}

	public function eliminarTipoMotorServicio(int $id_tipomotor_servicio)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$id_tipomotor_servicio = filter_var($id_tipomotor_servicio, FILTER_SANITIZE_NUMBER_INT);
			$newMorServ = new TipoMotorServicio();
			Http::json_response($newMorServ->eliminar($id_tipomotor_servicio));
		}
	}

	//ASIGNAR TRABAJO
	public function selectCategoriaEmpleado(string $id_categoria)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$newCatEmp = new PlanillaCategoriaEmpleado();
			$id_categoria = filter_var($id_categoria, FILTER_SANITIZE_STRING);
			if ($id_categoria == 'todas') {
				$data = $newCatEmp->obtenerEmpleadosDeCategorias();
			} else {
				$id_categoria = filter_var($id_categoria, FILTER_SANITIZE_NUMBER_INT);
				$data = $newCatEmp->obtenerEmpleadosSegunCategoria($id_categoria);
			}
			Http::json_response($data ?? []);
		}
	}

	public function serviciosOrdenTodos(int $id_orden)
	{
		$id_orden = filter_var($id_orden, FILTER_SANITIZE_NUMBER_INT);
		$lista_serv = [];
		$servicios = $GLOBALS['newDBIni']->consultar("SELECT * 
        FROM app_preorden_master_servicios
        JOIN app_planillas_servicios ON serv_id = preserv_servid
        JOIN app_planilla_categorias  ON cat_id = serv_catid
        JOIN app_productos ON pro_id = serv_proid
        WHERE preserv_estatus = 1 AND preserv_id NOT IN (SELECT preemp_preservid FROM app_preorden_master_servicios_empleados WHERE preemp_preid = $id_orden)")->all();

		if (is_countable($servicios) && count($servicios)) {
			foreach ($servicios as $row) {
				$lista_serv[] = [
					'id' => $row['preserv_id'],
					'cantidad' => $row['preserv_cantidad'],
					'servicio' => $row['pro_descripcion'],
					'estatus' => $row['preserv_estatus'],
					'checked' => false
				];
			}
		}

		Http::json_response($lista_serv);
	}

	public function asignarTrabajoEmpleado()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_orden']) || empty($_POST['id_servicio']) || empty($_POST['id_empleado']))
				$this->array_errors[] = 'Acción prohibida';

			if (empty($this->array_errors)) {

				$newServ = new PlanillaPreOrdenServicios();
				$newCarModel = new CarritoVentasModel();
				$servEmp = new PlanillaPreOrdenServiciosEmpleado();

				$id_servicio = filter_input(INPUT_POST, 'id_servicio', FILTER_SANITIZE_NUMBER_INT);
				$id_orden = filter_input(INPUT_POST, 'id_orden', FILTER_SANITIZE_NUMBER_INT);
				$id_empleado = filter_input(INPUT_POST, 'id_empleado', FILTER_SANITIZE_NUMBER_INT);

				$data = $this->newPreOrden->obtener($id_orden);
				/*if ($data['pre_estatus'] == 1) {
					Http::json_response(['errors' => ['El estatus de la orden debe ser diferente']]);
				}*/

				if ($GLOBALS['newDBIni']->consultar("SELECT * FROM app_preorden_master_servicios_empleados WHERE preemp_preservid = $id_servicio AND preemp_preid = $id_orden")->row())
					if (!$this->module->has_module_action_permission('planilla', 'add_asig_emp', $_SESSION['user_data']['emp_id']))
						Http::json_response(['errors' => ['Acción prohibida']]);

				$data_servicio_orden = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_preorden_master_servicios WHERE preserv_id = $id_servicio")->row();

				if ($data_servicio_orden['preserv_estatus'] == 2)
					Http::json_response(['errors' => ['Acción prohibida']]);

				if ($data_servicio_orden['preserv_estatus'] == 1) {
					$data_ser_empleado = $servEmp->where(['preemp_preid' => $data_servicio_orden['preserv_preid'], 'preemp_preservid' => $id_servicio], true);
					if ($data_ser_empleado && !is_null($data_ser_empleado['preemp_empid'])) {
						$this->array_errors[] = 'Ya existe un empleado asignado a este servicio';
					}
				}

				$div_master = Moneda::Predeterminada();
				$div_master = $div_master['id'];

				$data_servicio = $newServ->obtenerServicioSimple($id_servicio);

				$data_comisiones_agente = $newCarModel->obtenerComisionesAgente($id_empleado);
				$data_comisiones1 = $newCarModel->obtenerComisionesAgente(5);
				$data_comisiones2 = $newCarModel->obtenerComisionesAgente(15);

				$total_proservicio = $data_servicio['preserv_cantidad'] * $data_servicio['pro_precio'];

				if (!$newServ->existe('preserv_id', $id_servicio))
					Http::json_response(['errors' => ['Acción prohibida']]);

				$data_serv_orden = $newServ->obtener($id_servicio);

				$data = $this->newPreOrden->obtener($data_serv_orden['preserv_preid']);
				if ($data['pre_estatus'] == 2 or $data['pre_estatus'] == 3 or $data['pre_estatus'] == 4)
					Http::json_response(['errors' => ['La orden no puede ser editada']]);

				//$this->preordenEditable($data_serv_orden['preserv_preid']);

				$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$data_serv_orden['preserv_preid']}")->row();

				if ($existe_presupuesto) {
					$total_pagos = $this->newPreOrden->consultar("SELECT SUM(fab_conversion) as total FROM app_movimientos WHERE fab_idgenerico={$existe_presupuesto['po_nid']} AND fab_doc = 12")->row();
					$data_presupuesto = $this->newPreOrden->consultar("SELECT n_correlativo, n_total FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();
					$total_pagado = round($total_pagos['total'], 2);
					$total_factura = round($data_presupuesto['n_total']);
					if ($total_pagado == 0 || $total_factura == 0) {
						$pagado = 0;
					} else {
						$pagado = $total_pagado >= $total_factura ? 1 : 0;
						if ($pagado == 0) {
							if ($total_pagado > 0) {
								$pagado = 2;
							}
						}
					}

					if ($pagado == 0) {
						if ($existe_presupuesto['po_estatus'] == 1) {
							$pagado = 3;
						}
					}

					if ($pagado == 0) {
						Http::json_response(['errors' => ['Lo siento los pagos del documento debe tener estatus diferente pendiente parar poder cambiar el estatus de los servicios']]);
					}
				} else {
					Http::json_response(['errors' => ['Lo siento debe tener asociado un presupuesto para cambiar de estatus']]);
				}

				if ($servEmp->where(['preemp_preservid' => $id_servicio, 'preemp_empid' => $id_empleado], true))
					Http::json_response(['errors' => ['Lo siento no puede asignar dos veces el empleado al mismo servicio']]);

				try {

					$GLOBALS['newDBIni']->transactionBegin();

					$GLOBALS['newDBIni']->guardar([
						'preemp_preid' => $id_orden,
						'preemp_preservid' => $id_servicio,
						'preemp_empid' => $id_empleado,
						'preemp_estatus' => 1
					], true, 'app_preorden_master_servicios_empleados');

					$GLOBALS['newDBIni']->editar($id_servicio, [
						'preserv_estatus' => 1,
					], 'app_preorden_master_servicios', 'preserv_id');

					$presupuesto = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$data_servicio['preserv_preid']}")->row();

					if ($presupuesto) {
						$id_venta = $presupuesto['po_nid'];
					} else {
						$id_venta = null;
					}

					foreach ($data_comisiones_agente as $row) {
						//COMISION SOLO POR SERVICIO
						if ($row['com_tipo'] == 3 && $row['empagentipo_estatus'] == 1) {
							$porcentaje = $row['com_estatus'] == 1 ? $row['com_porcentaje'] : $row['empagentipo_porcentaje'];
							if ($porcentaje > 0) {
								$GLOBALS['newDBIni']->guardar([
									'comagentefn_fnempagente' 	=> $id_empleado,
									'comagentefn_com'         	=> $row['empagentipo_comid'],
									'comagentefn_monto'       	=> $total_proservicio * $porcentaje / 100,
									'comagentefn_divid'       	=> $div_master,
									'comagentefn_porcentaje'  	=> $porcentaje,
									'comagentefn_fnid'        	=> $id_venta,
									'comagentefn_fntipo'      	=> 12,
									'comagentefn_fntotal'     	=> $total_proservicio,
									'comagentefn_fncantidad'  	=> $data_servicio['preserv_cantidad'],
									'comagentefn_planilla' 		=> $data_servicio['preserv_preid'],
									'comagentefn_planilla_servid' => $data_servicio['pro_id'],
									'comagentefn_sobreempid'    => 0
								], true, 'app_comisiones_agente_fn');
							}
						}
					}

					foreach ($data_comisiones1 as $row) {
						//COMISION SOLO POR SERVICIO
						if ($row['com_tipo'] == 3 && $row['empagentipo_estatus'] == 1) {
							$porcentaje = $row['com_estatus'] == 1 ? $row['com_porcentaje'] : $row['empagentipo_porcentaje'];
							if ($porcentaje > 0) {
								$GLOBALS['newDBIni']->guardar([
									'comagentefn_fnempagente' 	=> 5,
									'comagentefn_com'         	=> $row['empagentipo_comid'],
									'comagentefn_monto'       	=> $total_proservicio * $porcentaje / 100,
									'comagentefn_divid'       	=> $div_master,
									'comagentefn_porcentaje'  	=> $porcentaje,
									'comagentefn_fnid'        	=> $id_venta,
									'comagentefn_fntipo'      	=> 12,
									'comagentefn_fntotal'     	=> $total_proservicio,
									'comagentefn_fncantidad'  	=> $data_servicio['preserv_cantidad'],
									'comagentefn_planilla' 		=> $data_servicio['preserv_preid'],
									'comagentefn_planilla_servid' => $data_servicio['pro_id'],
									'comagentefn_sobreempid'    => $id_empleado
								], true, 'app_comisiones_agente_fn');
							}
						}
					}

					foreach ($data_comisiones2 as $row) {
						//COMISION SOLO POR SERVICIO
						if ($row['com_tipo'] == 3 && $row['empagentipo_estatus'] == 1) {
							$porcentaje = $row['com_estatus'] == 1 ? $row['com_porcentaje'] : $row['empagentipo_porcentaje'];
							if ($porcentaje > 0) {
								$GLOBALS['newDBIni']->guardar([
									'comagentefn_fnempagente' 	=> 15,
									'comagentefn_com'         	=> $row['empagentipo_comid'],
									'comagentefn_monto'       	=> $total_proservicio * $porcentaje / 100,
									'comagentefn_divid'       	=> $div_master,
									'comagentefn_porcentaje'  	=> $porcentaje,
									'comagentefn_fnid'        	=> $id_venta,
									'comagentefn_fntipo'      	=> 12,
									'comagentefn_fntotal'     	=> $total_proservicio,
									'comagentefn_fncantidad'  	=> $data_servicio['preserv_cantidad'],
									'comagentefn_planilla' 		=> $data_servicio['preserv_preid'],
									'comagentefn_planilla_servid' => $data_servicio['pro_id'],
									'comagentefn_sobreempid'    => $id_empleado
								], true, 'app_comisiones_agente_fn');
							}
						}
					}

					$GLOBALS['newDBIni']->transactionCommit();
				} catch (\Throwable $th) {
					$GLOBALS['newDBIni']->transactionRollBack();
					$this->array_errors[] = 'Error en transacción--';
				}
			}

			if (empty($this->array_errors)) {
				Http::json_response(true);
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}
	public function asignarTrabajoEmpleadoSincobrarCliente()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_orden']) || empty($_POST['servicio']) || empty($_POST['cantidad']) || empty($_POST['id_empleado']))
				$this->array_errors[] = 'Acción prohibida';

			if (empty($this->array_errors)) {

				$newServ = new PlanillaPreOrdenServicios();
				$newCarModel = new CarritoVentasModel();
				$servEmp = new PlanillaPreOrdenServiciosEmpleado();
				$servAdi = new PlanillaServAdicionales();

				$id_orden = filter_input(INPUT_POST, 'id_orden', FILTER_SANITIZE_NUMBER_INT);
				$id_empleado = filter_input(INPUT_POST, 'id_empleado', FILTER_SANITIZE_NUMBER_INT);
				$id_servicio = filter_input(INPUT_POST, 'servicio', FILTER_SANITIZE_NUMBER_INT);
				$cantidad = filter_input(INPUT_POST, 'cantidad', FILTER_SANITIZE_NUMBER_INT);

				$data = $this->newPreOrden->obtener($id_orden);


				$div_master = Moneda::Predeterminada();
				$div_master = $div_master['id'];

				$data_comisiones_agente = $newCarModel->obtenerComisionesAgente($id_empleado);
				$data_comisiones1 = $newCarModel->obtenerComisionesAgente(5);
				$data_comisiones2 = $newCarModel->obtenerComisionesAgente(15);

				$id_adicional = $servAdi->guardar([
					'pread_serv' 	=> $id_servicio,
					'pread_empid'         	=> $id_empleado,
					'pread_preid'       	=> $id_orden,
					'pread_estatus'       	=> 1,
					'pread_cantidad'  	=> $cantidad,
				]);

				if ($id_adicional > 0) {

					$trabajosAsignados =  $servEmp->consultar("SELECT * FROM app_preorden_master_servicios_empleados_adicionales ad  
								LEFT JOIN app_productos p ON p.pro_id=ad.pread_serv  
								LEFT JOIN app_empleados_info e ON e.einfo_id=ad.pread_empid 
								LEFT JOIN app_empleados_agentes_tipo_comision c ON c.empagentipo_agente=ad.pread_empid 
								LEFT JOIN app_comision cm ON c.empagentipo_comid=cm.com_id 
								WHERE ad.pread_id ={$id_adicional}")->row();

					$total_proservicio = $cantidad * $trabajosAsignados['pro_precio'];


					$data = $this->newPreOrden->obtener($id_orden);
					if ($data['pre_estatus'] == 2 or $data['pre_estatus'] == 3 or $data['pre_estatus'] == 4)
						Http::json_response(['errors' => ['La orden no puede ser editada']]);

					$id_com = 0;
					try {

						$GLOBALS['newDBIni']->transactionBegin();

						$presupuesto = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$data['pre_id']}")->row();

						$id_venta = null;
						if ($presupuesto) {
							$id_venta = $presupuesto['po_nid'];
						} else {
							$id_venta = null;
						}

						foreach ($data_comisiones_agente as $row) {
							//COMISION SOLO POR SERVICIO
							if ($row['com_tipo'] == 3 && $row['empagentipo_estatus'] == 1) {
								$porcentaje = $row['com_estatus'] == 1 ? $row['com_porcentaje'] : $row['empagentipo_porcentaje'];
								if ($porcentaje > 0) {
									$id_com = $GLOBALS['newDBIni']->guardar([
										'comagentefn_fnempagente' 	=> $id_empleado,
										'comagentefn_com'         	=> $row['empagentipo_comid'],
										'comagentefn_monto'       	=> $total_proservicio * $porcentaje / 100,
										'comagentefn_divid'       	=> $div_master,
										'comagentefn_porcentaje'  	=> $porcentaje,
										'comagentefn_fnid'        	=> $id_venta,
										'comagentefn_fntipo'      	=> 12,
										'comagentefn_fntotal'     	=> $total_proservicio,
										'comagentefn_planilla' 		=> $id_orden,
										'comagentefn_fncantidad'  	=> $cantidad,
										'comagentefn_descripcion' 	=> $trabajosAsignados['pro_descripcion'],
										'comagentefn_sobreempid'        => 0
									], true, 'app_comisiones_agente_fn');
								}
							}
						}

						$GLOBALS['newDBIni']->transactionCommit();
					} catch (\Throwable $th) {
						$GLOBALS['newDBIni']->transactionRollBack();
						$this->array_errors[] = 'Error en transacción--' . $th;
					}

					if (empty($this->array_errors)) {
						Http::json_response(true);
					}

					Http::json_response(['errors' => ['Error al guardar']]);
				}
			}



			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function estatusServiciosEmpleados(int $id)
	{
		$Newservem = new PlanillaPreOrdenServiciosEmpleado();
		$newServ = new PlanillaPreOrdenServicios();
		$newCarModel = new CarritoVentasModel();

		if ($Newservem->existe('preemp_id', $id)) {
			$servEmp = $Newservem->obtener($id);

			//$this->preordenEditable($servEmp['preemp_preid']);

			if ($Newservem->editar($id, [
				'preemp_estatus' => ($servEmp['preemp_estatus'] == 0) ? 1 : 0
			])) {
				$existe_comision = $Newservem->consultar("SELECT cm.comagentefn_id FROM app_preorden_master_servicios ms 
						JOIN app_planillas_servicios s ON s.serv_id = ms.preserv_servid 
						JOIN app_comisiones_agente_fn cm ON cm.comagentefn_planilla_servid=s.serv_proid AND cm.comagentefn_planilla=ms.preserv_preid 
						WHERE ms.preserv_id={$servEmp['preemp_preservid']}")->count();

				$servEmp = $Newservem->obtener($id);

				if ($existe_comision == 0 && $servEmp['preemp_estatus'] == 1) {

					$data_servicio = $Newservem->consultar("SELECT preserv_preid, pro_id, pro_costo, pro_precio, preserv_cantidad, pro_codigo, pro_descripcion
							FROM app_preorden_master_servicios ms
							JOIN app_planillas_servicios s ON s.serv_id = ms.preserv_servid
							JOIN app_productos p ON p.pro_id = s.serv_proid 
							JOIN app_planilla_orden_de_entrega pl ON pl.po_preid=ms.preserv_preid 
							JOIN app_orden_de_entrega_articulos ord ON ord.nart_nid=pl.po_nid AND ord.nart_proid=p.pro_id 
							WHERE preserv_id={$servEmp['preemp_preservid']}")->row();

					$data_comisiones_agente = $newCarModel->obtenerComisionesAgente($servEmp['preemp_empid']);
					$data_comisiones1 = $newCarModel->obtenerComisionesAgente(5);
					$data_comisiones2 = $newCarModel->obtenerComisionesAgente(15);

					$div_master = Moneda::Predeterminada();
					$div_master = $div_master['id'];

					$total_proservicio = $data_servicio['preserv_cantidad'] * $data_servicio['pro_precio'];


					try {

						$GLOBALS['newDBIni']->transactionBegin();

						$presupuesto = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$servEmp['preemp_preid']}")->row();

						if ($presupuesto) {
							$id_venta = $presupuesto['po_nid'];
						} else {
							$id_venta = null;
						}

						foreach ($data_comisiones_agente as $row) {
							//COMISION SOLO POR SERVICIO
							if ($row['com_tipo'] == 3 && $row['empagentipo_estatus'] == 1) {
								$porcentaje = $row['com_estatus'] == 1 ? $row['com_porcentaje'] : $row['empagentipo_porcentaje'];
								if ($porcentaje > 0) {
									$GLOBALS['newDBIni']->guardar([
										'comagentefn_fnempagente' 	=> $servEmp['preemp_empid'],
										'comagentefn_com'         	=> $row['empagentipo_comid'],
										'comagentefn_monto'       	=> $total_proservicio * $porcentaje / 100,
										'comagentefn_divid'       	=> $div_master,
										'comagentefn_porcentaje'  	=> $porcentaje,
										'comagentefn_fnid'        	=> $id_venta,
										'comagentefn_fntipo'      	=> 12,
										'comagentefn_fntotal'     	=> $total_proservicio,
										'comagentefn_fncantidad'  	=> $data_servicio['preserv_cantidad'],
										'comagentefn_planilla' 		=> $data_servicio['preserv_preid'],
										'comagentefn_planilla_servid' => $data_servicio['pro_id'],
										'comagentefn_sobreempid'    => 0
									], true, 'app_comisiones_agente_fn');
								}
							}
						}

						foreach ($data_comisiones1 as $row) {
							//COMISION SOLO POR SERVICIO
							if ($row['com_tipo'] == 3 && $row['empagentipo_estatus'] == 1) {
								$porcentaje = $row['com_estatus'] == 1 ? $row['com_porcentaje'] : $row['empagentipo_porcentaje'];
								if ($porcentaje > 0) {
									$GLOBALS['newDBIni']->guardar([
										'comagentefn_fnempagente' 	=> 5,
										'comagentefn_com'         	=> $row['empagentipo_comid'],
										'comagentefn_monto'       	=> $total_proservicio * $porcentaje / 100,
										'comagentefn_divid'       	=> $div_master,
										'comagentefn_porcentaje'  	=> $porcentaje,
										'comagentefn_fnid'        	=> $id_venta,
										'comagentefn_fntipo'      	=> 12,
										'comagentefn_fntotal'     	=> $total_proservicio,
										'comagentefn_fncantidad'  	=> $data_servicio['preserv_cantidad'],
										'comagentefn_planilla' 		=> $data_servicio['preserv_preid'],
										'comagentefn_planilla_servid' => $data_servicio['pro_id'],
										'comagentefn_sobreempid'    => $servEmp['preemp_empid']
									], true, 'app_comisiones_agente_fn');
								}
							}
						}

						foreach ($data_comisiones2 as $row) {
							//COMISION SOLO POR SERVICIO
							if ($row['com_tipo'] == 3 && $row['empagentipo_estatus'] == 1) {
								$porcentaje = $row['com_estatus'] == 1 ? $row['com_porcentaje'] : $row['empagentipo_porcentaje'];
								if ($porcentaje > 0) {
									$GLOBALS['newDBIni']->guardar([
										'comagentefn_fnempagente' 	=> 15,
										'comagentefn_com'         	=> $row['empagentipo_comid'],
										'comagentefn_monto'       	=> $total_proservicio * $porcentaje / 100,
										'comagentefn_divid'       	=> $div_master,
										'comagentefn_porcentaje'  	=> $porcentaje,
										'comagentefn_fnid'        	=> $id_venta,
										'comagentefn_fntipo'      	=> 12,
										'comagentefn_fntotal'     	=> $total_proservicio,
										'comagentefn_fncantidad'  	=> $data_servicio['preserv_cantidad'],
										'comagentefn_planilla' 		=> $data_servicio['preserv_preid'],
										'comagentefn_planilla_servid' => $data_servicio['pro_id'],
										'comagentefn_sobreempid'    => $servEmp['preemp_empid']
									], true, 'app_comisiones_agente_fn');
								}
							}
						}

						$GLOBALS['newDBIni']->transactionCommit();
					} catch (\Throwable $th) {
						$GLOBALS['newDBIni']->transactionRollBack();
						$this->array_errors[] = 'Error en transacción--';
					}
					return true;
				}
				return false;
			}
		}
	}

	public function cambiarEstatusServicioAsignadosAdicionales()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
			$com = filter_input(INPUT_POST, 'com', FILTER_SANITIZE_NUMBER_INT);

			if (empty($this->array_errors)) {
				$NewservAd = new PlanillaServAdicionales();
				if ($NewservAd->existe('pread_id', $id) && $id > 0) {
					$servAd = $NewservAd->obtener($id);

					//$this->preordenEditable($servAd['pread_preid']);

					if ($NewservAd->editar($id, [
						'pread_estatus' => ($servAd['pread_estatus'] == 0) ? 1 : 0
					])) {

						$newCarModel = new CarritoVentasModel();

						$div_master = Moneda::Predeterminada();
						$div_master = $div_master['id'];

						$data_comisiones_agente = $newCarModel->obtenerComisionesAgente($servAd['pread_empid']);

						if ($servAd['pread_comid'] == 0 || $servAd['pread_comid'] == NULL) {

							$trabajosAsignados =  $this->newPreOrden->consultar("SELECT * FROM app_preorden_master_servicios_empleados_adicionales ad  
							LEFT JOIN app_productos p ON p.pro_id=ad.pread_serv  
							LEFT JOIN app_empleados_info e ON e.einfo_id=ad.pread_empid 
							LEFT JOIN app_empleados_agentes_tipo_comision c ON c.empagentipo_agente=ad.pread_empid 
							LEFT JOIN app_comision cm ON c.empagentipo_comid=cm.com_id 
							WHERE ad.pread_id ={$servAd['pread_id']}")->row();

							$total_proservicio = $servAd['pread_cantidad'] * $trabajosAsignados['pro_precio'];

							$presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$servAd['pread_preid']}")->row();

							$id_venta = null;
							if ($presupuesto) {
								$id_venta = $presupuesto['po_nid'];
							} else {
								$id_venta = null;
							}
							foreach ($data_comisiones_agente as $row) {
								//COMISION SOLO POR SERVICIO
								if ($row['com_tipo'] == 3 && $row['empagentipo_estatus'] == 1) {
									$porcentaje = $row['com_estatus'] == 1 ? $row['com_porcentaje'] : $row['empagentipo_porcentaje'];
									if ($porcentaje > 0) {
										$this->newPreOrden->guardar([
											'comagentefn_fnempagente' 	=> $servAd['pread_empid'],
											'comagentefn_com'         	=> $row['empagentipo_comid'],
											'comagentefn_monto'       	=> $total_proservicio * $porcentaje / 100,
											'comagentefn_divid'       	=> $div_master,
											'comagentefn_porcentaje'  	=> $porcentaje,
											'comagentefn_fnid'        	=> $id_venta,
											'comagentefn_fntipo'      	=> 12,
											'comagentefn_fntotal'     	=> $total_proservicio,
											'comagentefn_planilla' 		=> $servAd['pread_preid'],
											'comagentefn_planilla_servid' => $servAd['pread_serv'],
											'comagentefn_fncantidad'  	=> $servAd['pread_cantidad'],
											'comagentefn_descripcion' 	=> $trabajosAsignados['pro_descripcion'],
											'comagentefn_sobreempid'        => 0
										], true, 'app_comisiones_agente_fn');
									}
								}
							}
						}
						Http::json_response(true);
					}
				} else {
					$comision = $NewservAd->consultar("SELECT * FROM app_comisiones_agente_fn WHERE comagentefn_id=$com")->row();

					$this->preordenEditable($comision['comagentefn_planilla']);

					if (empty($this->array_errors)) {
						if ($NewservAd->guardar([
							'pread_comid'   => $com,
							'pread_empid'   => $comision['comagentefn_fnempagente'],
							'pread_preid'   => $comision['comagentefn_planilla'],
							'pread_estatus' => 1,
						], true)) {
							Http::json_response(true);
						}
					}
				}
			}
			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function asignarServicioEmpleado()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_orden']) || empty($_POST['servicios']) || empty($_POST['id_empleado'])) {
				$this->array_errors[] = 'Acción prohibida';
			} else {
				$servicios = json_decode($_POST['servicios'], true);
			}

			$id_orden = filter_input(INPUT_POST, 'id_orden', FILTER_SANITIZE_NUMBER_INT);
			$id_empleado = filter_input(INPUT_POST, 'id_empleado', FILTER_SANITIZE_NUMBER_INT);

			if ($this->newPreOrden->existe('pre_id', $id_orden) && is_countable($servicios) && count($servicios)) {

				if (!$this->module->has_module_action_permission('planilla', 'add_asig_emp', $_SESSION['user_data']['emp_id']))
					Http::json_response(['errors' => ['Acción prohibida']]);

				if (empty($this->array_errors)) {
					try {
						$GLOBALS['newDBIni']->transactionBegin();
						foreach ($servicios as $row) {
							if (!$GLOBALS['newDBIni']->consultar("SELECT * FROM app_preorden_master_servicios_empleados WHERE preemp_preid = $id_orden AND preemp_preservid = {$row['id']}")->row() && $row['checked']) {
								$GLOBALS['newDBIni']->guardar([
									'preemp_preid' => $id_orden,
									'preemp_preservid' => $row['id'],
									'preemp_empid' => $id_empleado
								], true, 'app_preorden_master_servicios_empleados');
								$GLOBALS['newDBIni']->editar($row['id'], [
									'preserv_estatus' => 1,
								], 'app_preorden_master_servicios', 'preserv_id');
							}
						}
						$GLOBALS['newDBIni']->transactionCommit();
					} catch (\Throwable $th) {
						$GLOBALS['newDBIni']->transactionRollBack();
						$this->array_errors[] = 'Error en transacción';
					}
				}
			} else {
				$this->array_errors[] = 'Acción prohibida';
			}

			if (empty($this->array_errors)) {
				Http::json_response(true);
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function obtenerTrabajosAsignados(int $id_orden)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			$newServEmp = new PlanillaPreOrdenServiciosEmpleado();
			$newPlaOrden = new PlanillaOrdenDeEntrega();
			$lista = [];

			if ($this->newPreOrden->existe('pre_id', $id_orden)) {

				$data_presupuesto = $newPlaOrden->obtenerOrdenPorIdPlanilla($id_orden);

				$servicios = $newServEmp->obtenerEmpleadosServicios($id_orden);

				if (is_countable($servicios) && count($servicios)) {
					if ($data_presupuesto) {
						foreach ($servicios as $row) {

							$monto = $newServEmp->obtenerPrecioPresupuesto($id_orden, $row['pro_id']);
							$row['pro_precio'] = $monto['precio'];
							$lista[] = [
								'id' => $row['preemp_id'],
								'id_empleado' => $row['preemp_empid'],
								'id_orden' => $row['preemp_preid'],
								'is_servicio' => $row['preserv_id'],
								'empleado' => $row['empleado'],
								'servicio' => $row['pro_descripcion'],
								'cantidad' => $row['preserv_cantidad'],
								'precio' => $row['pro_precio'],
								'fecha' => $row['fecha'],
								'estatus' => $row['preemp_estatus']
							];
						}
					} else {
						foreach ($servicios as $row) {

							$lista[] = [
								'id' => $row['preemp_id'],
								'id_empleado' => $row['preemp_empid'],
								'id_orden' => $row['preemp_preid'],
								'is_servicio' => $row['preserv_id'],
								'empleado' => $row['empleado'],
								'servicio' => $row['pro_descripcion'],
								'cantidad' => $row['preserv_cantidad'],
								'precio' => $row['precio'],
								'fecha' => $row['fecha'],
								'estatus' => $row['preemp_estatus']
							];
						}
					}
				}

				Http::json_response($lista);
			} else {
				$this->array_errors[] = 'Acción prohibida';
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function eliminarTrabajoAsignado(int $id)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			$id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

			if (!$this->module->has_module_action_permission('planilla', 'delete_asig_emp_serv', $_SESSION['user_data']['emp_id']))
				Http::json_response(['errors' => ['Usted no está autorizado']]);

			$data_orden = $GLOBALS['newDBIni']->consultar("SELECT preemp_preid,preemp_preservid FROM app_preorden_master_servicios_empleados WHERE preemp_id=$id")->row();
			$data = $this->newPreOrden->obtener($data_orden['preemp_preid']);
			if ($data['pre_estatus'] == 2 or $data['pre_estatus'] == 3 or $data['pre_estatus'] == 4)
				Http::json_response(['errors' => ['La orden no puede ser editada']]);
			//$this->preordenEditable($data_orden['preemp_preid']);
			//$existe_presupuesto = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$data_orden['preemp_preid']}")->row();


			try {

				$GLOBALS['newDBIni']->transactionBegin();

				$data_planilla_producto = $GLOBALS['newDBIni']->consultar("SELECT ps.serv_proid, s.preserv_preid, se.preemp_empid,se.preemp_preid
				FROM app_preorden_master_servicios_empleados se
				JOIN app_preorden_master_servicios s ON s.preserv_id = se.preemp_preservid
				JOIN app_planillas_servicios ps ON ps.serv_id = s.preserv_servid
				WHERE se.preemp_id=$id")->row();

				//Eliminar las comisiones del empleado asignado al trabajo
				$GLOBALS['newDBIni']->consultar("DELETE FROM app_comisiones_agente_fn WHERE comagentefn_planilla = {$data_planilla_producto['preserv_preid']} AND comagentefn_planilla_servid = {$data_planilla_producto['serv_proid']} AND comagentefn_estatus=0 AND comagentefn_fnempagente={$data_planilla_producto['preemp_empid']}")->run();

				//Eliminar comisiones fijas
				$GLOBALS['newDBIni']->consultar("DELETE FROM app_comisiones_agente_fn WHERE comagentefn_planilla = {$data_planilla_producto['preserv_preid']} AND comagentefn_planilla_servid = {$data_planilla_producto['serv_proid']} AND comagentefn_estatus=0 AND comagentefn_fnempagente=15 AND  comagentefn_sobreempid={$data_planilla_producto['preemp_empid']}")->run();
				$GLOBALS['newDBIni']->consultar("DELETE FROM app_comisiones_agente_fn WHERE comagentefn_planilla = {$data_planilla_producto['preserv_preid']} AND comagentefn_planilla_servid = {$data_planilla_producto['serv_proid']} AND comagentefn_estatus=0 AND comagentefn_fnempagente=5 AND  comagentefn_sobreempid={$data_planilla_producto['preemp_empid']}")->run();

				$count_servicios_emple = $GLOBALS['newDBIni']->consultar("SELECT COUNT(preemp_id) contador FROM app_preorden_master_servicios_empleados WHERE preemp_preservid={$data_orden['preemp_preservid']}")->row();

				if ($count_servicios_emple['contador'] == 1) {
					$GLOBALS['newDBIni']->consultar("UPDATE app_preorden_master_servicios SET preserv_estatus = 0 WHERE preserv_id= {$data_orden['preemp_preservid']}")->run();
				}

				$GLOBALS['newDBIni']->consultar("DELETE FROM app_preorden_master_servicios_empleados WHERE preemp_id = $id")->run();

				$GLOBALS['newDBIni']->transactionCommit();
			} catch (\Throwable $th) {
				$GLOBALS['newDBIni']->transactionRollBack();
				$this->array_errors[] = 'Error en transacción';
			}

			if (empty($this->array_errors)) {
				Http::json_response(true);
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}
	public function eliminarTrabajoAsignadoAdicionales()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			$id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
			$id_orden = filter_input(INPUT_POST, 'id_orden', FILTER_SANITIZE_NUMBER_INT);

			$newServ = new PlanillaServAdicionales();

			$data = $this->newPreOrden->obtener($id_orden);
			if ($data['pre_estatus'] == 2 or $data['pre_estatus'] == 3 or $data['pre_estatus'] == 4) {
				Http::json_response(['errors' => ['La orden no puede ser editada']]);
			}
			try {

				$GLOBALS['newDBIni']->transactionBegin();

				$adicional = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_preorden_master_servicios_empleados_adicionales WHERE pread_id={$id}")->row();
				//Eliminar las comisiones del empleado asignado al trabajo

				if ($adicional['pread_comid'] > 0 && $adicional['pread_comid'] != NULL) {
					$GLOBALS['newDBIni']->consultar("DELETE FROM app_comisiones_agente_fn WHERE comagentefn_id = {$adicional['pread_comid']} AND comagentefn_planilla_servid IS NULL AND comagentefn_estatus=0")->run();
				}

				if ($newServ->existe('pread_id', $id)) {
					$GLOBALS['newDBIni']->consultar("DELETE FROM app_comisiones_agente_fn WHERE comagentefn_planilla_servid = {$adicional['pread_serv']} AND comagentefn_planilla={$id_orden}")->run();
					$GLOBALS['newDBIni']->consultar("DELETE FROM app_preorden_master_servicios_empleados_adicionales WHERE pread_id = {$id}")->run();
				}


				//Eliminar comisiones fijas
				/*$GLOBALS['newDBIni']->consultar("DELETE FROM app_comisiones_agente_fn WHERE comagentefn_id = $id AND comagentefn_planilla_servid IS NULL AND comagentefn_estatus=0 AND comagentefn_fnempagente=15")->run();
				$GLOBALS['newDBIni']->consultar("DELETE FROM app_comisiones_agente_fn WHERE comagentefn_id = $id AND comagentefn_planilla_servid IS NULL AND comagentefn_estatus=0 AND comagentefn_fnempagente=5")->run();*/

				$GLOBALS['newDBIni']->transactionCommit();
			} catch (\Throwable $th) {
				$GLOBALS['newDBIni']->transactionRollBack();
				$this->array_errors[] = 'Error en transacción';
			}

			if (empty($this->array_errors)) {
				Http::json_response(true);
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}
	public function guardarObservacionCulminado()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_orden']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$id_orden = filter_input(INPUT_POST, 'id_orden', FILTER_SANITIZE_NUMBER_INT);
			$observacion = $this->solicitud->sanitize($_POST['observacion'], FILTER_SANITIZE_STRING);
			$medidas = $this->solicitud->sanitize($_POST['medidas_u'], FILTER_SANITIZE_NUMBER_INT);
			$medidas2 = $this->solicitud->sanitize($_POST['medidas_d'], FILTER_SANITIZE_NUMBER_INT);
			$medidas3 = $this->solicitud->sanitize($_POST['medidas_t'], FILTER_SANITIZE_NUMBER_INT);

			if (empty($medidas) || empty($medidas2) || empty($medidas3))
				Http::json_response(['errors' => ['Debe seleccionar las medidas']]);

			$data_orden = $this->newPreOrden->obtener($id_orden);

			if (!$data_orden)
				Http::json_response(['errors' => ['Acción prohibida']]);

			$servicios = $this->newPreOrden->consultar("SELECT count(preserv_id) as total FROM app_preorden_master_servicios WHERE preserv_preid = $id_orden AND preserv_estatus = 0")->row();

			if ($servicios['total'] == 0) {
				$this->newPreOrden->editar($id_orden, [
					'pre_estatus' => 2
				], 'app_preorden_master', 'pre_id');

				$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = $id_orden")->row();

				if ($existe_presupuesto) {
					$newCarritoVenta = new CarritoVentasModel();

					$factura = $newCarritoVenta->obtenerOrdenE($existe_presupuesto['po_nid']);

					$total_pagos = $newCarritoVenta->totalPagos($existe_presupuesto['po_nid'], 12, 1);

					if ((round($total_pagos['total'] ?? 0, 2) >= round($factura['total'], 2))) {
						$status = ['n_estatus' => 1];
						$newCarritoVenta->editar($existe_presupuesto['po_nid'], $status, 'app_orden_de_entrega', 'n_id');
					}
				}

				if ($data_orden['pre_estatus'] == 2) {
					Http::json_response($this->newPreOrden->editar($id_orden, [
						'pre_ubicacion_final' => $observacion,
						'pre_medidas'         => $medidas,
						'pre_medidas_d'       => $medidas2,
						'pre_medidas_t'       => $medidas3,
					]));
				}
			} else {
				Http::json_response(['errors' => ['Lo siento, todos los servicios deben estar concluidos para poder cerrar la orden']]);
			}
		}
	}

	public function generarPresupuesto()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_orden']) || empty($_POST['pre_serie']) || empty($_POST['pre_divisa']) || empty($_POST['pre_almacen']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$id_orden = filter_var($_POST['id_orden'], FILTER_SANITIZE_NUMBER_INT);
			$id_serie = filter_var($_POST['pre_serie'], FILTER_SANITIZE_NUMBER_INT);
			$id_divisa = filter_var($_POST['pre_divisa'], FILTER_SANITIZE_NUMBER_INT);
			$id_almacen = filter_var($_POST['pre_almacen'], FILTER_SANITIZE_NUMBER_INT);

			if (!$this->module->has_module_action_permission('planilla', 'generar_orden', $_SESSION['user_data']['emp_id']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			if (!$this->newPreOrden->existe('pre_id', $id_orden))
				Http::json_response(['errors' => ['Acción prohibida']]);

			if ($this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = $id_orden")->row())
				Http::json_response(['errors' => ['Esta orden ya fue asignada a un presupuesto']]);

			$div_master = Moneda::facturarPredeterminada();

			$newPreOrdenServicios = new PlanillaPreOrdenServicios();
			$newPreOrdenPartes = new PlanillaPreOrdenPartes();
			$newCarritoVenta = new CarritoVentasEditar();

			if (!$newPreOrdenServicios->where(['preserv_preid' => $id_orden]))
				Http::json_response(['errors' => ['Acción prohibida no puede generar el presupuesto si la orden no tiene servicios cargados previamente']]);

			if (!$newPreOrdenPartes->where(['prepar_preid' => $id_orden]))
				Http::json_response(['errors' => ['Acción prohibida no puede generar el presupuesto si la orden no tiene partes cargados previamente']]);

			$data_orden = $this->newPreOrden->obtener($id_orden);

			$correlativo    = $this->newPreOrden->chuequearCorrelativo($id_serie, 12);
			$serie          = $this->newPreOrden->obtenerSerie($id_serie);
			$cliente        = $this->newPreOrden->obtenerCliente($data_orden['pre_cliid']);
			$servicios      = $newPreOrdenServicios->obtenerServiciosSimple($data_orden['pre_id']);

			if (!$correlativo) {
				Http::json_response(['errors' => ['No existe correlativo entre la serie seleccionada y el documento por favor dirijase a Modulo Configuración -> correlativos']]);
			}

			$factor = 1;

			if ($div_master['id'] != $id_divisa) {
				$factor_div = $this->newPreOrden->obtenerDivisaAlCambio($id_divisa, $div_master['id']);
				$factor = $factor_div['df_factor'];
			}

			$data_form_master = [
				'n_subtotal'           => 0,
				'n_descuento'          => 0,
				'n_neto'               => 0,
				'n_iva'                => 0,
				'n_total'              => 0,
				'n_articulos_total'    => 0,
				'n_divid'              => $id_divisa,
				'n_almid'              => $id_almacen,
				'n_empleadoid'         => $_SESSION['user_data']['einfo_id'],
				'n_correlativo'        => $correlativo['cor_correlativo'] + 1,
				'n_serid'              => $serie['ser_id'],
				'n_serie'              => $serie['ser_descripcion'],
				'n_cliid'              => $cliente['cli_id'],
				'n_env_nombres'        => $cliente['cli_razon_social'],
				'n_env_direccion'      => $cliente['cli_direccion'],
				'n_env_pais'           => $cliente['cli_paisid'],
				'n_env_estado'         => $cliente['cli_estado'],
				'n_env_ciudad'         => $cliente['cli_ciudad'],
				'n_env_codigo_postal'  => $cliente['cli_codpostal'],
				//'n_empagente'          => $agente,
				'n_fecha'              => date('Y-m-d H:i:s'),
				'n_observaciones'      => '',
				'n_estatus'            => 2,
				'n_empresaid'          => 1,
				'n_descontado'         => 1,
				'factor'               => $factor
			];

			$neto = 0;
			$iva = 0;

			try {

				$this->newPreOrden->transactionBegin();

				$this->newPreOrden->consultar("UPDATE app_correlativos SET cor_correlativo = cor_correlativo + 1 WHERE cor_serid = {$serie['ser_id']} AND cor_docid=12")->run();

				$id_factura = $this->newPreOrden->guardar($data_form_master, false, 'app_orden_de_entrega');

				$this->newPreOrden->consultar("UPDATE app_comisiones_agente_fn SET comagentefn_fnid = $id_factura WHERE comagentefn_planilla = $id_orden AND comagentefn_fnid IS NULL")->run();

				if (is_countable($servicios) && count($servicios)) {
					foreach ($servicios as $row) {
						$iva_con = $this->newPreOrden->consultar("SELECT * FROM app_impuestos WHERE imp_id={$row['pro_impid']}")->row();
						$iva_prod = ($row['pro_precio'] * $row['preserv_cantidad']) * ($iva_con['imp_valor'] / 100);
						$this->newPreOrden->guardar([
							'nart_nid' => $id_factura,
							'nart_proid' => $row['pro_id'],
							'nart_procodigo' => $row['pro_codigo'],
							'nart_propnombre' => $row['pro_descripcion'],
							'nart_procosto' => 0,
							'nart_costo_servicio' => $row['pro_precio'],
							'nart_proprecio' => $row['pro_precio'],
							'nart_procantidad' => $row['preserv_cantidad'],
							'nart_prodescuento' => 0,
							'nart_proneto' => $row['pro_precio'] * $row['preserv_cantidad'],
							'nart_idiva' =>  $row['pro_impid'],
							'nart_almid' => $id_almacen,
							'nart_proiva' => $iva_con['imp_valor'],
							'nart_ivatotal' => ($row['pro_precio'] * $row['preserv_cantidad']) * ($iva_con['imp_valor'] / 100),
							'nart_prototal' => ($row['pro_precio'] * $row['preserv_cantidad']) + $iva_prod,
							'nart_descontar_inventario' => 0
						], true, 'app_orden_de_entrega_articulos');
						$neto += $row['pro_precio'] * $row['preserv_cantidad'];

						if ($iva_con['imp_valor'] > 0) {
							$iva +=  ($row['pro_precio'] * $row['preserv_cantidad']) * ($iva_con['imp_valor'] / 100);
						}
					}
				}

				$this->newPreOrden->editar($id_factura, [
					'n_subtotal'           => $neto,
					'n_descuento'          => 0,
					'n_neto'               => $neto,
					'n_iva'                => $iva,
					'n_total'              => $neto + $iva,
					'n_articulos_total'    => count($servicios),
					'total_costo_servicio' => $neto,
				], 'app_orden_de_entrega', 'n_id');

				$this->newPreOrden->guardar([
					'po_preid' => $id_orden,
					'po_nid' => $id_factura,
					'po_empleado' => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos']
				], true, 'app_planilla_orden_de_entrega');

				$this->newPreOrden->transactionCommit();
			} catch (\Throwable $th) {
				$this->newPreOrden->transactionRollBack();
				$this->array_errors[] = 'Error en transacción';
			}

			if (empty($this->array_errors)) {
				$servicios = $this->newPreOrden->consultar("SELECT count(preemp_id) as total FROM app_preorden_master_servicios_empleados WHERE preemp_preid =$id_orden")->row();

				if ($servicios['total'] > 0) {
					$newCarritoVenta->recalcularComisiones($id_factura, 12);
				}
				$url = ruta_base() . "ordendeentregaeditar/verFactura/$id_factura";
				Http::json_response($url);
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function imprimirTicket()
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_GET['id_orden']) || empty($_GET['id_impresora']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$id_orden = filter_input(INPUT_GET, 'id_orden', FILTER_SANITIZE_NUMBER_INT);
			$id_impresora = filter_input(INPUT_GET, 'id_impresora', FILTER_SANITIZE_NUMBER_INT);

			$lista_part = [];
			$lista_serv = [];
			$newMotor = new Motor();
			$newPreOrdenPartes = new PlanillaPreOrdenPartes();
			$newPreOrdenServicios = new PlanillaPreOrdenServicios();

			$orden = $this->newPreOrden->obtenerPreOrden($id_orden);

			if ($orden['pre_estatus'] != 1)
				Http::json_response(['errors' => ['Acción prohibida']]);

			$motor = $orden['pre_motid'] ? $newMotor->obtenerMotor($orden['pre_motid']) : "";
			$servicios = $newPreOrdenServicios->obtenerServicios($id_orden);
			$partes = $newPreOrdenPartes->obtenerPartes($id_orden);

			$impresora = $newPreOrdenPartes->consultar("SELECT imp_tipo, CONCAT(imp_ip, ':', imp_puerto) ip_puerto FROM app_impresoras WHERE imp_id = $id_impresora")->row();

			if (is_countable($servicios) && count($servicios)) {
				foreach ($servicios as $row) {
					$lista_serv[] = [
						'cantidad' => $row['preserv_cantidad'],
						'servicio' => $row['pro_descripcion'],
						'categoria' => $row['cat_categorias']
					];
				}
			}

			if (is_countable($partes) && count($partes)) {
				foreach ($partes as $row) {
					$lista_part[] = [
						'cantidad' => $row['prepar_cantidad'],
						'observacion' => empty($row['prepar_observacion']) ? '' : $row['prepar_observacion'],
						'parte' => $row['par_parte'],
						'categoria' => $row['cat_categorias']
					];
				}
			}

			Http::json_response([
				'ip_puerto' => protocolo() . $impresora['ip_puerto'],
				'data' => [
					'command' => 'generate_ticket_planilla_orden',
					'args' => [[
						'n_orden' => $orden['pre_correlativo'],
						'observacion_repuestos' => empty($orden['pre_observacion_repuestos']) ? '' : $orden['pre_observacion_repuestos'],
						'fecha' => date('d-m-Y', strtotime($orden['pre_creado'])),
						'taller' => $orden['pre_taller'] ?? '',
						'motor' => ($motor) ? $motor['mot_motor'] . ' - Marca: ' . $motor['m_marca'] . ' - Modelo: ' . $motor['mot_modelo'] : '',
						'cliente' => [[
							'dni' => $orden['cli_dni'],
							'cliente' => $orden['cli_razon_social'],
							'telefono' => $orden['cli_telefono']
						]],
						'partes' => $lista_part,
						'servicios' => $lista_serv
					]]
				]
			]);
		}
	}

	//PDF PLANILLA
	public function imprimirPlanilla(int $id_orden)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD']) {

			$orden      = $this->newPreOrden->obtenerPreOrden($id_orden);

			$parte      = new PlanillaPreOrdenPartes();
			$servicio   = new PlanillaPreOrdenServicios();
			$newMotor   = new Motor();

			$servicios  = $servicio->obtenerServicios($id_orden);
			$partes     = $parte->obtenerPartes($id_orden);

			$cat_id = [];
			$lista_cat_serv = [];

			foreach ($servicios as $row) {
				if (in_array($row['cat_id'], $cat_id)) {
					$lista_cat_serv[$row['cat_id']]['servicios'][] = [
						'cantidad' => $row['preserv_cantidad'],
						'servicio' => $row['pro_descripcion']
					];
				} else {
					$cat_id[] = $row['cat_id'];
					$lista_cat_serv[$row['cat_id']] = [
						'categoria' => $row['cat_categorias'],
						'servicios' => [[
							'cantidad' => $row['preserv_cantidad'],
							'servicio' => $row['pro_descripcion']
						]]
					];
				}
			}

			$motor = $orden['pre_motid'] ? $newMotor->obtenerMotor($orden['pre_motid']) : null;

			$mpdf = new \Mpdf\Mpdf([
				'mode'              => 'utf-8',
				'margin_left'       => 10,
				'margin_right'      => 10,
				'margin_top'        => 40,
				'margin_bottom'     => 10,
				'margin_header'     => 10,
				'margin_footer'     => 10,
				'format'            => [155, 263],
				'orientation'       => 'P',
				'default_font_size' => 8,
				'default_font'      => 'Arial'
			]);

			$mpdf->SetTitle('PLANILLA' .  $id_orden);
			$mpdf->SetAuthor(constant('EMP_NOMBRE'));
			$mpdf->SetCreator(constant('EMP_NOMBRE'));
			$mpdf->SetSubject('PLANILLA' .  $id_orden);

			$html_header = Vista::viewPDF('planilla/pdf_planilla/header', [
				'orden'     => $orden,
				'n_orden'   => date('Ymd', strtotime($orden['pre_creado']))  . '' . $orden['pre_id'],
			]);

			$mpdf->SetHTMLHeader($html_header);

			$html_body = Vista::viewPDF('planilla/pdf_planilla/body', [
				'orden'         => $orden,
				'partes'        => $partes,
				'servicios'     => $lista_cat_serv,
				'motor'         => $motor ? $motor['mot_motor'] . ' - Marca: ' . $motor['m_marca'] . ' - Modelo: ' . $motor['mot_modelo'] : '',
			]);

			$mpdf->WriteHTML($html_body);

			$html_footer = Vista::viewPDF('planilla/pdf_planilla/footer');

			$mpdf->SetHTMLFooter($html_footer);

			$mpdf->Output("$id_orden", \Mpdf\Output\Destination::INLINE);
			exit;
		}
	}

	public function abrirOrden(int $id_orden)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			$id_orden = filter_var($id_orden, FILTER_SANITIZE_NUMBER_INT);

			if (!$this->newPreOrden->existe('pre_id', $id_orden))
				Http::json_response(['errors' => ['Acción prohibida']]);

			Http::json_response($this->newPreOrden->editar($id_orden, [
				'pre_estatus' => 1
			]));
		}
	}

	public function obtnerRepuestosAsignados(int $id_orden)
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			$id_orden = filter_var($id_orden, FILTER_SANITIZE_NUMBER_INT);

			$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = $id_orden")->row();

			if ($existe_presupuesto) {
				$newArt = new OrdendeentregaArticulos();
				Http::json_response($newArt->repuestos($existe_presupuesto['po_nid']));
			}

			Http::json_response([]);
		}
	}

	public function imprimirServicio()
	{
		if ('GET' === $_SERVER['REQUEST_METHOD']) {

			$newServ 	= new PlanillaPreOrdenServicios();
			$newMotor 	= new Motor();
			$newCat 	= new PlanillaCategoria();

			$id_impresora = filter_input(INPUT_GET, 'impresora', FILTER_SANITIZE_NUMBER_INT);
			$id_servicio = filter_input(INPUT_GET, 'orden', FILTER_SANITIZE_NUMBER_INT);
			$id_categoria = filter_input(INPUT_GET, 'cat', FILTER_SANITIZE_NUMBER_INT);

			$impresora = $newServ->consultar("SELECT imp_tipo, CONCAT(imp_ip, ':', imp_puerto) ip_puerto FROM app_impresoras WHERE imp_id = $id_impresora")->row();

			$data_cat 	= $newCat->obtener($id_categoria);
			$orden 		= $this->newPreOrden->obtenerPreOrden($id_servicio);
			$motor 		= $orden['pre_motid'] ? $newMotor->obtenerMotor($orden['pre_motid']) : null;
			$servicios 	= $newServ->obtenerServicioSegunCategoriaYOrden($id_servicio, $id_categoria);

			if ($motor) {
				$tipo_de_motor = $motor['tip_descripcion'] ?? '';
				$motor = $motor['mot_motor'] . ' - Marca: ' . $motor['m_marca'] . ' - Modelo: ' . $motor['mot_modelo'];
			} else {
				$motor = '';
				$tipo_de_motor = '';
			}

			Http::json_response([
				'ip_puerto' => protocolo() . $impresora['ip_puerto'],
				'data' => [
					'command' => 'generate_ticket_servicios_planilla',
					'args' => [
						[
							'fecha_impresion'   => date('d-m-Y H:i:s'),
							'cliente'       	=> $orden['cli_razon_social'],
							'dni_cliente' 		=> $orden['cli_dni'],
							'correlativo'       => $orden['pre_correlativo'],
							'motor'            	=> $motor,
							'tipo_de_motor' 	=> $tipo_de_motor,
							'categoria' 		=> $data_cat['cat_categorias'],
							'servicios' 		=> $servicios
						]
					]
				]
			]);
		}
	}

	public function empleadBajoMotor()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_orden']) || empty($_POST['id_empleado']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$id_orden = $this->solicitud->sanitize($_POST['id_orden'], FILTER_SANITIZE_NUMBER_INT);
			$id_empleado = $this->solicitud->sanitize($_POST['id_empleado'], FILTER_SANITIZE_NUMBER_INT);

			$this->preordenEditable($id_orden);

			if (empty($this->array_errors)) {
				Http::json_response($this->newPreOrden->editar($id_orden, [
					'pre_empbajo_motor' => $id_empleado
				]));
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function empleadDesarmoMotor()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_orden']) || empty($_POST['id_empleado']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$id_orden = $this->solicitud->sanitize($_POST['id_orden'], FILTER_SANITIZE_NUMBER_INT);
			$id_empleado = $this->solicitud->sanitize($_POST['id_empleado'], FILTER_SANITIZE_NUMBER_INT);

			$this->preordenEditable($id_orden);

			if (empty($this->array_errors)) {
				Http::json_response($this->newPreOrden->editar($id_orden, [
					'pre_empdesarmo_motor' => $id_empleado
				]));
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function obtenerEmpleadosId()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_empleado']))
				Http::json_response(['errors' => ['Acción prohibida']]);

			$id_empleado = $this->solicitud->sanitize($_POST['id_empleado'], FILTER_SANITIZE_NUMBER_INT);

			if (empty($this->array_errors)) {
				Http::json_response($this->newPreOrden->obtenerEmpleadosId($id_empleado));
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function anularOrden()
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_GET['id']) || empty($_GET['orden']))
				$this->array_errors[] = 'Acción prohibida';

			$id = $this->solicitud->sanitize($_GET['id'], FILTER_SANITIZE_NUMBER_INT);
			$orden = $this->solicitud->sanitize($_GET['orden'], FILTER_SANITIZE_NUMBER_INT);

			$data_orden = $this->newPreOrden->obtener($id);

			if (!$data_orden)
				$this->array_errors[] = 'Acción prohibida';

			if (empty($this->array_errors)) {
				$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = $id")->row();

				if ($existe_presupuesto) {
					$newCarritoVenta = new CarritoVentasModel();

					$factura = $newCarritoVenta->obtenerOrdenE($existe_presupuesto['po_nid']);
					$estatus = $factura['estatus'];

					if ($estatus != 3)
						$this->array_errors[] = 'Debe anular el presupuesto';
				}

				if (empty($this->array_errors)) {
					Http::json_response($this->newPreOrden->editar($id, [
						'pre_estatus' => 3
					]));
				}
			}
			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function detenerOrden()
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_GET['id']) || empty($_GET['orden']))
				$this->array_errors[] = 'Acción prohibida';

			$id = $this->solicitud->sanitize($_GET['id'], FILTER_SANITIZE_NUMBER_INT);
			$orden = $this->solicitud->sanitize($_GET['orden'], FILTER_SANITIZE_NUMBER_INT);

			$data_orden = $this->newPreOrden->obtener($id);

			if (!$data_orden)
				$this->array_errors[] = 'Acción prohibida';

			if (empty($this->array_errors)) {
				Http::json_response($this->newPreOrden->editar($id, [
					'pre_estatus' => 4
				]));
			}
			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function activarOrden()
	{
		if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_GET['id']) || empty($_GET['orden']))
				$this->array_errors[] = 'Acción prohibida';

			$id = $this->solicitud->sanitize($_GET['id'], FILTER_SANITIZE_NUMBER_INT);
			$orden = $this->solicitud->sanitize($_GET['orden'], FILTER_SANITIZE_NUMBER_INT);

			$data_orden = $this->newPreOrden->obtener($id);

			if (!$data_orden)
				$this->array_errors[] = 'Acción prohibida';

			if (empty($this->array_errors)) {
				Http::json_response($this->newPreOrden->editar($id, [
					'pre_estatus' => 1
				]));
			}
			Http::json_response(['errors' => $this->array_errors]);
		}
	}


	public function empleadFicha()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['id_orden']) || empty($_POST['id_empleado']))
				$this->array_errors[] = 'Acción prohibida';

			$id_orden = $this->solicitud->sanitize($_POST['id_orden'], FILTER_SANITIZE_NUMBER_INT);
			$id_empleado = $this->solicitud->sanitize($_POST['id_empleado'], FILTER_SANITIZE_NUMBER_INT);

			$this->preordenEditable($id_orden);

			if (empty($this->array_errors)) {
				Http::json_response($this->newPreOrden->editar($id_orden, [
					'pre_emplficha' => $id_empleado
				]));
			}

			Http::json_response(['errors' => $this->array_errors]);
		}
	}

	public function cne()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			if (empty($_POST['cli_dni']))
				Http::json_response('El numero del documento es obligatorio');
			if (empty($_POST['tipo']))
				Http::json_response('El campo Tipo de documento es obligatorio');

			if (empty($this->array_errors)) {

				$cli_tipo             =  $this->solicitud->sanitize($_POST['tipo'], FILTER_SANITIZE_NUMBER_INT);
				$cli_dni            = $this->solicitud->sanitize($_POST['cli_dni'], FILTER_SANITIZE_STRING);

				$tipo = $dni = '';
				if ($cli_tipo == 2) {
					$dni = str_replace('V', '', $cli_dni);

					if (strlen($dni) < 7) {
						Http::json_response('Verifique los numeros del documento.');
					}
					$tipo = 'V';
				} else {
					$dni = str_replace('J', '', $cli_dni);
					$tipo = 'J';
					if (strlen($dni) < 8) {
						Http::json_response('Verifique los numeros del documento.');
					}
				}

				$url = "http://www.cne.gob.ve/web/registro_electoral/ce.php?nacionalidad=$tipo&cedula=$dni";
				$resource = self::geUrl($url);
				if (!$resource) {
					Http::json_response('No hay repuesta del servidor CNE.');
				}

				$text = strip_tags($resource);
				$findme = 'REGISTRO ELECTORAL'; // Identifica que si es población Votante
				$pos = strpos($text, $findme);

				$findme2 = 'ADVERTENCIA'; // Identifica que si es población Votante
				$pos2 = strpos($text, $findme2);
				$datoJson = [];
				if ($pos == TRUE and $pos2 == FALSE) {
					// Codigo buscar votante
					$rempl = array('Cédula:', 'Nombre:', 'Estado:', 'Municipio:', 'Parroquia:', 'Centro:', 'Dirección:', 'SERVICIO ELECTORAL', 'Mesa:');
					$r = trim(str_replace($rempl, '|', self::limpiarCampo($text)));
					$resource = explode("|", $r);
					$datos = explode(" ", self::limpiarCampo($resource[2]));
					Http::json_response(['error' => 0, 'nacionalidad' => $tipo, 'cedula' => $dni, 'nombres' => $datos[0] . ' ' . $datos[1], 'apellidos' => $datos[2] . ' ' . $datos[3], 'inscrito' => 'SI', 'cvestado' => self::limpiarCampo($resource[3]), 'cvmunicipio' => self::limpiarCampo($resource[4]), 'cvparroquia' => self::limpiarCampo($resource[5]), 'centro' => self::limpiarCampo($resource[6]), 'direccion' => self::limpiarCampo($resource[7])]);
				} elseif ($pos == FALSE and $pos2 == FALSE) {
					Http::json_response('No inscrito CNE.');
				} elseif ($pos == FALSE and $pos2 == TRUE) {
					Http::json_response('No inscrito CNE.');
				} else {
					Http::json_response('No inscrito CNE.');
				}
			}
		}
	}

	public static function geUrl($url)
	{
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true); // almacene en una variable
		curl_setopt($curl, CURLOPT_HEADER, FALSE);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 3000);
		curl_setopt($curl, CURLOPT_TIMEOUT, 3000); //timeout in seconds
		if (curl_exec($curl) === false) {
			//echo 'Curl error: ' . curl_error($curl);
			curl_close($curl);
			$return = false;
		} else {
			$return = curl_exec($curl);
		}
		//curl_close($curl);
		return $return;
	}
	public static function limpiarCampo($valor)
	{ //Con esto limpiamos los errores de la pagina
		$rempl = array('\n', '\t');
		$r = trim(str_replace($rempl, ' ', $valor));
		return str_replace("\r", "", str_replace("\n", "", str_replace("\t", "", $r)));
	}

	public function cronSMS()
	{
		if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

			$id_orden = $this->solicitud->sanitize($_POST['id_orden'], FILTER_SANITIZE_NUMBER_INT);
			$tipo = $this->solicitud->sanitize($_POST['tipo'], FILTER_SANITIZE_NUMBER_INT);

			$orden = $this->newPreOrden->obtenerPreOrden($id_orden);
			$newMotor = new Motor();
			$motor = $orden['pre_motid'] ? $newMotor->obtenerMotor($orden['pre_motid']) : null;

			$newSMS = new SMS(constant('SMS_USER'), constant('SMS_PASSWORD'));

			if ($newSMS->obtenerEstatus() != 'Activa')
				Http::json_response(['errors' => ['Lo siento el estatus de su Mensajeria se encuentra Inactiva']]);

			if ($newSMS->obtenerCreditos() <= 0)
				Http::json_response(['errors' => ['Lo siento no posee creditos suficientes verifique su proveedor de Mensajeria']]);

			$newSMSContact  = new SmsContactosModel();
			$newBitacora    = new BitacoraMensajesModel();

			if ($orden['pre_estatus'] == 2) {
				$entreg = 'TERMINADO';
			}
			if ($orden['pre_estatus'] == 1) {
				$entreg = 'PENDIENTE';
			}
			if ($orden['pre_estatus'] == 3) {
				$entreg = 'ANULADA';
			}
			if ($orden['pre_estatus'] == 0) {
				$entreg = 'NUEVO';
			}
			if ($orden['pre_estatus'] == 4) {
				$entreg = 'DETENIDA';
			}
			if ($orden['pre_estatus'] == 5) {
				$entreg = 'CREDITO';
			}

			$motors = ($motor) ? $motor['mot_motor'] . '/Marca:' . $motor['m_marca'] . '/Modelo:' . $motor['mot_modelo'] : '';

			$msj = "RESILCA RECTIFICADORA,CA Le notifica que tiene una orden " . $orden['pre_correlativo'] . " Del motor(" . $motors . "), con estatus " . $entreg.' --n visite nuestra pagina web www.resilca.com?id='.$orden['pre_correlativo'];
			$tele = str_replace('(', '', $orden['cli_telefono']);
			$tele = str_replace(')', '', $tele);
			$tele = str_replace(' ', '', $tele);
                        $tele = str_replace('-', '', $tele);
			$msj = str_replace(' ', '+', $msj);

			if ($tipo == 1) {
				$estatus = $newSMS->enviarMensaje($tele, $msj);

				switch ($estatus) {
					case '200 / 1':
						$estatus_condicion = 'Enviado';
						break;
					case '200 / 0':
						$estatus_condicion = 'Error al enviar';
						//case '400':
						//$estatus_condicion = 'Falta Texto';
						break;
					case '401':
						$estatus_condicion = 'Autenticación Inválida';
						break;
					case '402':
						$estatus_condicion = 'Créditos Insuficientes';
						break;
					case '403':
						$estatus_condicion = 'Cuenta Inactiva';
						break;
					case '405':
						$estatus_condicion = 'Falta Destinatario';
						break;
					case '501':
						$estatus_condicion = 'Tipo de Cuenta Inválida';
						break;
					case '502':
						$estatus_condicion = 'Petición Sobrecargada';
						break;
					default:
						$estatus_condicion = $estatus;
				}

				$newBitacora->guardar([
					'bitmen_cliente' => $orden['cli_id'],
					'bitmen_contacto' => $orden['cli_razon_social'],
					'bitmen_telefono' => $tele,
					'bitmen_correo' => $orden['cli_email'],
					'bitmen_titulo' => 'Ordenes',
					'bitmen_cuerpo' => $msj,
					'bitmen_estatus' => $estatus_condicion,
					'bitmen_tipo' => 'SMS'
				], true);

				Http::json_response($estatus_condicion);
			} else {
				if ($orden['pre_estatus'] == 4 || $orden['pre_estatus'] == 5) {
					$estatus = $newSMS->enviarMensaje($tele, $msj);

					switch ($estatus) {
						case '200 / 1':
							$estatus_condicion = 'Enviado';
							break;
						case '200 / 0':
							$estatus_condicion = 'Error al enviar';
							//case '400':
							//$estatus_condicion = 'Falta Texto';
							break;
						case '401':
							$estatus_condicion = 'Autenticación Inválida';
							break;
						case '402':
							$estatus_condicion = 'Créditos Insuficientes';
							break;
						case '403':
							$estatus_condicion = 'Cuenta Inactiva';
							break;
						case '405':
							$estatus_condicion = 'Falta Destinatario';
							break;
						case '501':
							$estatus_condicion = 'Tipo de Cuenta Inválida';
							break;
						case '502':
							$estatus_condicion = 'Petición Sobrecargada';
							break;
						default:
							$estatus_condicion = $estatus;
					}

					$newBitacora->guardar([
						'bitmen_cliente' => $orden['cli_id'],
						'bitmen_contacto' => $orden['cli_razon_social'],
						'bitmen_telefono' => $tele,
						'bitmen_correo' => $orden['cli_email'],
						'bitmen_titulo' => 'Ordenes',
						'bitmen_cuerpo' => $msj,
						'bitmen_estatus' => $estatus_condicion,
						'bitmen_tipo' => 'SMS'
					], true);

					Http::json_response($estatus_condicion);
				}
			}
		}
	}

public function obtenerOrdenesCount()
	{
		if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			
			$timeZone = new DateTimeZone('America/Caracas');
            $fecha_desde = (new DateTime(null, $timeZone))->modify('first day of last month')->format('Y-m-d');
            $fecha_hasta = date('Y-m-d');

			$terminado = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 2 AND (DATE(pre_creado) BETWEEN '$fecha_desde' AND '$fecha_hasta') ORDER BY pre_id DESC")->count();

			$terminado_entregado = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 2 AND pre_entrega = 1 AND (DATE(pre_creado) BETWEEN '$fecha_desde' AND '$fecha_hasta') ORDER BY pre_id DESC")->count();

			$todas = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE (DATE(pre_creado) BETWEEN '$fecha_desde' AND '$fecha_hasta') ORDER BY pre_id DESC")->count();

			$anulada = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 3 AND (DATE(pre_creado) BETWEEN '$fecha_desde' AND '$fecha_hasta') ORDER BY pre_id DESC")->count();

			Http::json_response([
				"todos" => $todas,
				"terminado" => $terminado,
				"anulada" => $anulada,
				"entregado" => $terminado_entregado,
			]);
		}
	}

	public function obtenerOrdenesAutorizados()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$anio = filter_input(INPUT_POST, 'anio', FILTER_SANITIZE_NUMBER_INT);
			$mes = $this->solicitud->sanitize($_POST['mes'], FILTER_SANITIZE_NUMBER_INT);

			if ($mes == 0) {
				$peticion = "YEAR(p.pre_modificado)=$anio";
			} else {
				$peticion =  "MONTH(p.pre_modificado)=$mes AND YEAR(p.pre_modificado)=$anio";
			}

			$ordenes = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca 
			WHERE pre_estatus = 1 AND $peticion ORDER BY p.pre_id DESC")->all();

			$lista = [];
			$entreg = '';

			if (is_countable($ordenes) && count($ordenes)) {
				foreach ($ordenes as $row) {
					$presupuesto = '';
					$uri = '';
					$pagado = 0;

					$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$row['pre_id']}")->row();

					if ($existe_presupuesto) {
						$total_pagos = $this->newPreOrden->consultar("SELECT SUM(fab_conversion) as total FROM app_movimientos WHERE fab_idgenerico={$existe_presupuesto['po_nid']} AND fab_doc = 12")->row();
						$data_presupuesto = $this->newPreOrden->consultar("SELECT n_correlativo, n_total FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();
						$total_pagado = round($total_pagos['total'], 2);
						$total_factura = round($data_presupuesto['n_total'], 2);

						if ($total_pagado == 0 || $total_factura == 0) {
							$pagado = 0;
						} else {
							$pagador = $total_pagado - $total_factura;

							if ($pagador == 0) {
								$pagado = 1;
							}
							if ($pagador < 0) {
								$pagado = 2;
							}
						}

						$documento = Documento::obtener(12);
						$presupuesto = $documento['prefijo'] . $data_presupuesto['n_correlativo'];
						$uri = ruta_base()  . 'ordendeentregaeditar/verFactura/' . $existe_presupuesto['po_nid'];

						if ($pagado == 0) {
							if ($existe_presupuesto['po_estatus'] == 1) {
								$pagado = 3;
							}
						}
					}

					if ($pagado == 3) {
						$str_pagado = 'AUTORIZADO';
						$lista[] = [
							'id' => $row['pre_id'],
							'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
							'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
							'orden' => $row['pre_correlativo'] ?? 0,
							'cliente' => $row['cli_razon_social'],
							'creado' => date('d-m-Y', strtotime($row['pre_creado'])),
							'modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
							'existe_presupuesto' => $existe_presupuesto ? true : false,
							'presupuesto' => $presupuesto,
							'uri_presupuesto' => $uri,
							'pagado' => $str_pagado,
							'motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
						];
					}
					if ($pagado == 1) {
						$str_pagado = 'PAGADO';
						$lista[] = [
							'id' => $row['pre_id'],
							'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
							'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
							'orden' => $row['pre_correlativo'] ?? 0,
							'cliente' => $row['cli_razon_social'],
							'creado' => date('d-m-Y', strtotime($row['pre_creado'])),
							'modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
							'existe_presupuesto' => $existe_presupuesto ? true : false,
							'presupuesto' => $presupuesto,
							'uri_presupuesto' => $uri,
							'pagado' => $str_pagado,
							'motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
						];
					}
					if ($pagado == 2) {
						$str_pagado = 'ABONADO';
						$lista[] = [
							'id' => $row['pre_id'],
							'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
							'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
							'orden' => $row['pre_correlativo'] ?? 0,
							'cliente' => $row['cli_razon_social'],
							'creado' => date('d-m-Y', strtotime($row['pre_creado'])),
							'modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
							'existe_presupuesto' => $existe_presupuesto ? true : false,
							'presupuesto' => $presupuesto,
							'uri_presupuesto' => $uri,
							'pagado' => $str_pagado,
							'motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
						];
					}
				}
			}

			Http::json_response(["lista" => $lista]);
		}
	}

	public function obtenerOrdenesAbonado()
	{
		if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
			$anio = filter_input(INPUT_POST, 'anio', FILTER_SANITIZE_NUMBER_INT);
			$mes = $this->solicitud->sanitize($_POST['mes'], FILTER_SANITIZE_NUMBER_INT);

			if ($mes == 0) {
				$peticion = "YEAR(p.pre_modificado)=$anio";
			} else {
				$peticion =  "MONTH(p.pre_modificado)=$mes AND YEAR(p.pre_modificado)=$anio";
			}

			$ordenes = $this->newPreOrden->consultar("SELECT * 
			FROM app_preorden_master p 
			JOIN app_clientes c ON c.cli_id = p.pre_cliid 
			LEFT JOIN app_motores mot ON mot.mot_id = p.pre_motid
			LEFT JOIN app_marcas m ON m.m_id = mot.mot_marca
			WHERE pre_estatus = 1 AND $peticion ORDER BY p.pre_id DESC")->all();

			$lista = [];
			$entreg = '';

			if (is_countable($ordenes) && count($ordenes)) {
				foreach ($ordenes as $row) {
					$presupuesto = '';
					$uri = '';
					$pagado = 0;

					$existe_presupuesto = $this->newPreOrden->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$row['pre_id']}")->row();

					if ($existe_presupuesto) {
						$total_pagos = $this->newPreOrden->consultar("SELECT SUM(fab_conversion) as total FROM app_movimientos WHERE fab_idgenerico={$existe_presupuesto['po_nid']} AND fab_doc = 12")->row();
						$data_presupuesto = $this->newPreOrden->consultar("SELECT n_correlativo, n_total FROM app_orden_de_entrega WHERE n_id = {$existe_presupuesto['po_nid']}")->row();
						$total_pagado = round($total_pagos['total'], 2);
						$total_factura = round($data_presupuesto['n_total'], 2);

						if ($total_pagado == 0 || $total_factura == 0) {
							$pagado = 0;
						} else {
							$pagador = $total_pagado - $total_factura;

							if ($pagador == 0) {
								$pagado = 1;
							}
							if ($pagador < 0) {
								$pagado = 2;
							}
						}

						$documento = Documento::obtener(12);
						$presupuesto = $documento['prefijo'] . $data_presupuesto['n_correlativo'];
						$uri = ruta_base()  . 'ordendeentregaeditar/verFactura/' . $existe_presupuesto['po_nid'];

						if ($pagado == 0) {
							if ($existe_presupuesto['po_estatus'] == 1) {
								$pagado = 3;
							}
						}
					}

					if ($pagado == 2) {
						$str_pagado = 'ABONADO';
						$lista[] = [
							'id' => $row['pre_id'],
							'uri_imprimir' => ruta_base()  . 'planilla/imprimirPlanilla/' . $row['pre_id'],
							'uri' => ruta_base() . 'planilla/orden/' . $row['pre_id'],
							'orden' => $row['pre_correlativo'] ?? 0,
							'cliente' => $row['cli_razon_social'],
							'creado' => date('d-m-Y', strtotime($row['pre_creado'])),
							'modificado' => date('d-m-Y', strtotime($row['pre_modificado'])),
							'existe_presupuesto' => $existe_presupuesto ? true : false,
							'presupuesto' => $presupuesto,
							'uri_presupuesto' => $uri,
							'pagado' => $str_pagado,
							'motor' => ($row['mot_id']) ? $row['mot_motor'] . ' - Marca: ' . $row['m_marca'] . ' - Modelo: ' . $row['mot_modelo'] : ''
						];
					}
				}
			}

			Http::json_response([
				"lista" => $lista
			]);
		}
	}

public function asignarRepuestoAEmpleadoIndividual()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newArt = new OrdendeentregaArticulos();

            if (empty($_POST['id_empleado']) || empty($_POST['id_producto']))
                Http::json_response(['errors' => ['Acción prohibida']]);

            $id_empleado = filter_input(INPUT_POST, 'id_empleado', FILTER_SANITIZE_NUMBER_INT);
            $nart_id = filter_input(INPUT_POST, 'id_producto', FILTER_SANITIZE_NUMBER_INT);

           // $factura = $this->newPreOrden->obtenerFactura($id_factura);

            //if (!$factura || $factura['n_estatus'] == 1)
             //   Http::json_response(['errors' => ['Acción prohibida']]);

            if (!$this->newPreOrden->consultar("SELECT * FROM app_empleados_info WHERE einfo_id = $id_empleado")->row())
                Http::json_response(['errors' => ['Acción prohibida']]);

            if (!$newArt->existe('nart_id', $nart_id))
                Http::json_response(['errors' => ['Acción prohibidadd']]);

            try {
                $newArt->transactionBegin();
                $newArt->editar($nart_id, [
                    'nart_empleado_repuesto_planilla' => $id_empleado
                ]);
                $newArt->transactionCommit();
            } catch (\Throwable $th) {
                $newArt->transactionRollBack();
                $this->array_errors[] = 'Error al actualizar empleado';
            }

            if (empty($this->array_errors)) {
                Http::json_response(true);
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }


}
