<?php

use Core\Helpers\Moneda;

?>
<div class="container" id="appPedidosVer" v-cloak>
    <input type="hidden" value="<?= $cliente['cli_id'] ?>" id="id_cliente_fac">
    <input type="hidden" value="<?= $factura['pe_id'] ?>" id="id_fac">
    <input type="hidden" value="<?= $empresa['emp_nombre'] ?>" id="nombEmpresa">
    <input type="hidden" value="<?= $doc_pendientes ?>" id="cant_pend">
    <input type="hidden" value="<?= $pagot ?>" id="pagot">
    <input type="hidden" value="<?= $telefonocli ?>" id="telcli">
    <div class="page-inner">
        <div class="row">
            <div class="col">
                <div class="d-flex justify-content-between">
                    <div class="col-5 pl-0 row-card-no-pd" style="margin-bottom: 0; padding-top: 0; padding-bottom: 0">
                        <div class="list-group list-group-messages list-group-flush">
                            <div class="list-group-item unread">
                                <div class="list-group-item-figure">
                                    <div class="avatar">
                                        <span class="avatar-title rounded-circle border border-white bg-info"><?= strtoupper($cliente['cli_razon_social'][0]) ?></span>
                                    </div>
                                </div>
                                <div class="list-group-item-body pl-3 pl-md-4">
                                    <div class="row">
                                        <div class="col-12 col-lg-10">
                                            <h4 class="list-group-item-title">
                                                <span id="cabecera_cliente"> <?= $cliente['cli_razon_social'] ?> <?= $cliente['cli_dni'] ?> </span>
                                            </h4>
                                        </div>
                                        <div class="col-12 col-lg-10">
                                            <h5 class="list-group-item-title text-warning">
                                                VENTAS - PEDIDOS
                                                <div class="<?= ($doc_pendientes > 1) ? 'text-danger' : 'text-dark' ?>">
                                                <span class="text-success"  @click="modal_whatsapp()"><i class="fa-2x fab fa-whatsapp"></i></span>
                                                <small>Pendientes: <?= $doc_pendientes ?></small>
                                                    <?php foreach ($total_doc_pendientes['divisas_totales'] as $row) : ?>
                                                        <small><?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']); ?></small>
                                                    <?php endforeach; ?>
                                                    <?php if ($cliente['grup_id']) : ?>
                                                        <small> Venta Al <?= $cliente['grup_nombre'] ?> <?= $cliente['grup_descuento'] ?>%</small>
                                                    <?php endif; ?>
                                                </div>
                                            </h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-7 p-0">
                        <div class="row">
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="fecha">Fecha</label>
                                    <input type="date" id="fecha" class="form-control" value="<?= date('Y-m-d', strtotime($factura['pe_fecha'])) ?>">
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="divisa">Divisa</label>
                                    <select id="divisa" v-model="divisa_predeterminada" @change="predeterminarDivisa" class="form-control">
                                        <?php foreach ($divisas as $row) : ?>
                                            <option value="<?= $row['div_id'] ?>"><?= $row['div_nombre'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="sucursal">Sucursal</label>
                                    <select id="sucursal" v-model="sucursal_predeterminada" class="form-control" disabled>
                                        <option disabled value="">Seleccione un elemento</option>
                                        <option v-for="row in sucursales_empleado" :value="row.su_id">{{row.su_nombre}}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="serie">Serie</label>
                                    <select id="serie" v-model="serie_predeterminada" class="form-control">
                                        <option disabled value="">Seleccione un elemento</option>
                                        <option v-for="row in series_empleado" :value="row.ser_id">{{row.ser_descripcion}}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="almacen">Almacén</label>
                                    <select id="almacen" class="form-control" disabled>
                                        <option disabled value="">Seleccione un elemento</option>
                                        <?php foreach ($almacenes as $row) : ?>
                                            <option value="<?= $row['alm_id'] ?>" <?= ($factura['pe_almid'] == $row['alm_id']) ? 'selected' : '' ?>><?= $row['alm_nombre'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 mt-3">
                <nav>
                    <div class="nav nav-tabs" role="tablist">
                        <a class="nav-item nav-link active" data-toggle="tab" href="#nav-lista" role="tab" aria-controls="nav-home" aria-selected="true">Pedido <span class="badge badge-info ml-2"> #<?= $factura['pe_correlativo'] ?></span></a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-detalles" role="tab" aria-controls="nav-profile" aria-selected="false"><i class="fas fa-user-friends"></i> Detalles</a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-envio" role="tab" aria-controls="nav-contact" aria-selected="false"><i class="fas fa-shipping-fast"></i> Envíos</a>
                        <a class="nav-item nav-link" target="_blank" href="<?= ruta_base() ?>pedidoseditar/pdf/<?= $factura['pe_id'] ?>">
                            <i class="fas fa-print"></i> Imprimir
                        </a>
                        <a class="nav-item nav-link" href="#" @click.prevent="modalCorreo">
                            <i class="far fa-envelope"></i> Enviar Pedido
                        </a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-documentos" role="tab" aria-controls="nav-documentos" aria-selected="false"><i class="fas fa-file-contract"></i> Documentos</a>
                    </div>
                </nav>
                <div class="tab-content mt-2">
                    <div class="tab-pane fade show active" id="nav-lista" role="tabpanel" aria-labelledby="nav-home-tab">
                        <div class="row row-card-no-pd">
                            <div class="col-12 mt-2 mb-2">
                                <div class="d-flex justify-content-between">
                                    <div class="suiche">
                                        <label for="" class="etiqueta icon-preview"><i class="fas fa-barcode"></i></label>
                                        <input type="checkbox" v-model="toggleBarcode" id="switch" @change="focusBuuscar">
                                        <label for="switch" class="lbl"></label>
                                    </div>
                                    <div class="col">
                                        <div class="input-icon">
                                            <span class="input-icon-addon">
                                                <i :class="'fa fa-search'"></i>
                                            </span>
                                            <input type="text" id="buscador" class="form-control" placeholder="buscar productos" @input="buscarProducto" @keydown="seleccionarProducto">
                                        </div>
                                    </div>
                                    <a class="btn btn-info btn-round btn-border btn-sm mr-2" href="<?= url('facturacion') ?>" target="_blank" style="max-height: 2rem;"><i class="fas fa-reply"></i> Ventas</a>
                                    <a class="btn btn-info btn-round btn-border btn-sm mr-2" href="#" @click.prevent="modalConvertirDocumento()" style="max-height: 2rem;"><i class="fas fa-exchange-alt"></i> Convertir documento</a>
                                    <a class="btn btn-info btn-round btn-border btn-sm mr-2" href="<?= url('productos') ?>" target="_blank" style="max-height: 2rem;">Productos <i class="far fa-share-square"></i></a>
                                    <button type="button" class="btn btn-primary btn-round btn-sm mr-2" disabled v-if="cargando" style="max-height: 2rem;">
                                        <i class="loader loader-info"></i>
                                    </button>
                                    <button type="button" class="btn btn-info btn-round btn-sm mr-2" v-else @click="guardarFactura" style="max-height: 2rem;"><i class="fas fa-save"></i> Guardar</button>
                                </div>
                            </div>
                            <div class="col-12 mt-2">
                                <div class="scroll" style="height: 300px;width: 100%;padding: 0;margin: 0;overflow-y: scroll;overflow-x: hidden;">
                                    <div class="table-responsive">
                                        <table class="bg-white table-bordered-bd-black" cellspacing="1" cellpadding="1" width="100%" tabindex="2">
                                            <thead>
                                                <tr class="text-center">
                                                    <th></th>
                                                    <th>Código</th>
                                                    <th>Artículo</th>
                                                    <th>Precio</th>
                                                    <th>Cantidad</th>
                                                    <th>Dto. %</th>
                                                    <th>Neto</th>
                                                    <th>IVA</th>
                                                    <th>Total</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="row in carrito" class="text-right">
                                                    <td class="text-center">
                                                        <a href="#" @click.prevent="eliminarProducto(row.unique)">
                                                            <i class="fa fa-trash text-danger"></i>
                                                        </a>
                                                    </td>
                                                    <td class="text-left">{{ row.codigo }}</td>
                                                    <td class="text-left"><input type="text" class="form-control text-right" style="border-color: #bbb;" v-model="row.nombre" @keyup.prevent="actualizarDescripcion(row.unique, $event)"></td>
                                                    <td width="13%"><input type="text" class="form-control text-right" style="border-color: #bbb;" v-model="row.precio" v-money="money" @keyup.prevent="actualizarPrecio(row.unique, $event)"></td>
                                                    <td width="7%"><input type="text" class="form-control text-right" style="border-color: #bbb;" v-model="row.cantidad" @keyup.prevent="actualizarCantidad(row.id, $event)"></td>
                                                    <td width="7%" class="text-center"><input type="text" class="form-control text-right" style="border-color: #bbb;" v-model="row.descuento" @keyup.prevent="aplicarDescuentoProducto(row.unique, $event)"></td>
                                                    <td width="12%">{{ moneda(row.neto, money.locale, money.prefix, money.precision) }}</td>
                                                    <td width="7%">
                                                        <select id="impuestos" class="form-control text-center input-border-bottom" v-model="row.id_iva" @change="aplicarNuevoIva(row.unique, row.id_iva)">
                                                            <?php foreach ($impuestos as $row) : ?>
                                                                <option value="<?= $row['imp_id'] ?>"><?= $row['imp_descripcion'] ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td width="12%" class="text-right">{{ moneda(row.total, money.locale, money.prefix, money.precision) }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row row-card-no-pd">
                            <div class="col-12" style="padding-left: 30%;">
                                <div class="table-responsive ">
                                    <table class="bg-white table-bordered-bd-black" cellspacing="1" cellpadding="2" width="100%" tabindex="2">
                                        <thead>
                                            <tr class="text-right">
                                                <th>Subtotal</th>
                                                <th>Dto. %</th>
                                                <th>Neto</th>
                                                <th>IVA</th>
                                                <th>Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="text-right">
                                                <td width="20%">{{ moneda(subtotal, money.locale, money.prefix, money.precision) }}</td>
                                                <td width="20%"><input type="text" class="form-control text-right" style="border-color: #bbb;" v-model="descuento" @keyup.prevent="aplicarDescuentoAdicional"></td>
                                                <td width="20%">{{ moneda(neto, money.locale, money.prefix, money.precision) }}</td>
                                                <td width="20%">{{ iva }}</td>
                                                <td width="20%">{{ moneda(total, money.locale, money.prefix, money.precision) }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-3 row-card-no-pd">
                            <div class="col">
                                <div class="form-group form-group-default">
                                    <label>Observaciones</label>
                                    <textarea class="form-control" rows="3" v-model="observaciones"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="nav-detalles" role="tabpanel" aria-labelledby="nav-detalles-tab">
                        <form action="#" autocomplete="off" @submit.prevent="actualizarDetalles">
                            <div class="card">
                                <div class="card-body">
                                    <div class="card-category"> <i class="fa fa-user"></i> Cliente</div>
                                    <div class="separator-solid"></div>
                                    <div class="form-row">
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_tipodoc">Tipo de documento:</label>
                                                <select id="cli_tipodoc" class="form-control">
                                                    <?php foreach ($tipos_de_documentos as $row) : ?>
                                                        <option value="<?= $row['tipodoc_id'] ?>" <?= ($cliente['tipodoc_codigo'] == $row['tipodoc_id']) ? 'selected' : '' ?>><?= $row['tipodoc_codigo']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_dni">DNI:</label>
                                                <input type="text" id="cli_dni" class="form-control" value="<?= $cliente['cli_dni'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group form-group-default">
                                                <label for="cli_razon_social">Razón social:</label>
                                                <input type="text" id="cli_razon_social" class="form-control" value="<?= $cliente['cli_razon_social'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_pais">Pais:</label>
                                                <select id="cli_pais" class="form-control">
                                                    <?php foreach ($paises as $row) : ?>
                                                        <option value="<?= $row['pa_id'] ?>" <?= ($cliente['cli_paisid'] == $row['pa_id']) ? 'selected' : '' ?>><?= $row['pa_nombre']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_estado">Estado:</label>
                                                <input type="text" id="cli_estado" class="form-control" value="<?= $cliente['cli_estado'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_ciudad">Ciudad:</label>
                                                <input type="text" id="cli_ciudad" class="form-control" value="<?= $cliente['cli_ciudad'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_codigopostal">Codigo postal:</label>
                                                <input type="text" id="cli_codigopostal" class="form-control" value="<?= $cliente['cli_codpostal'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col">
                                            <div class="form-group form-group-default">
                                                <label for="cli_direccion">Direccion:</label>
                                                <input type="text" id="cli_direccion" class="form-control" value="<?= $cliente['cli_direccion'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-12 text-right">
                                            <button type="button" class="btn btn-info btn-border btn-round btn-sm" disabled v-if="cargando">
                                                <span class="btn-label"><i class="loader loader-info"></i></span>
                                            </button>
                                            <button type="submit" class="btn btn-info btn-border btn-round btn-sm" v-else>
                                                <span class="btn-label"><i class="fa fa-edit"></i></span> Actualizar
                                            </button>
                                        </div>
                                    </div>
                                    <div class="card-category"> <i class="fa fa-user-tie"></i> Empleado</div>
                                    <div class="separator-solid"></div>
                                    <div class="form-row">
                                        <div class="col-sm-6">
                                            <label for="empleado">Empleado</label>
                                            <input type="text" id="empleado" class="form-control" disabled value="<?= $empleado['einfo_apellidos']; ?> - <?= $empleado['einfo_email']; ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="tab-pane" id="nav-envio" role="tabpanel" aria-labelledby="nav-envio-tab">
                        <form action="#" autocomplete="off" @submit.prevent="actualizarEnvio">
                            <div class="card">
                                <div class="card-body">
                                    <div class="form-row">
                                        <div class="col-sm-6">
                                            <div class="form-group form-group-default">
                                                <label for="env_nombre_opcional">Nombres:</label>
                                                <input type="text" id="env_nombre_opcional" class="form-control" placeholder="opcional" value="<?= $factura['pe_env_nombres'] ?>" required>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_agencia_transporte">Agencia de transporte:</label>
                                                <select id="env_agencia_transporte" class="form-control" value="<?= $factura['pe_env_agencia_transporte'] ?>" required>
                                                    <option value="V">V</option>
                                                    <option value="R">R</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_codigo_seguimiento">Codigo de sequimiento:</label>
                                                <input type="text" id="env_codigo_seguimiento" class="form-control" value="<?= $factura['pe_env_codigo_seguimiento'] ?>" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_pais">Pais:</label>
                                                <select id="env_pais" class="form-control">
                                                    <?php foreach ($paises as $row) : ?>
                                                        <option value="<?= $row['pa_id'] ?>" <?= ($factura['pe_env_pais'] == $row['pa_id']) ? 'selected' : '' ?>><?= $row['pa_nombre']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_estado">Estado:</label>
                                                <input type="text" id="env_estado" class="form-control" value="<?= $factura['pe_env_estado'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_ciudad">Ciudad:</label>
                                                <input type="text" id="env_ciudad" class="form-control" value="<?= $factura['pe_env_ciudad'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_codigopostal">Codigo postal:</label>
                                                <input type="text" id="env_codigopostal" class="form-control" value="<?= $factura['pe_env_codigo_postal'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col">
                                            <div class="form-group form-group-default">
                                                <label for="env_direccion">Direccion:</label>
                                                <input type="text" id="env_direccion" class="form-control" value="<?= $factura['pe_env_direccion'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-check">
                                        <label class="form-check-label">
                                            <input class="form-check-input" type="checkbox" <?= $factura['pe_env_asegurado'] ? 'checked' : '' ?> id="env_asegurado" disabled>
                                            <span class="form-check-sign">Envio asegurado SI/NO</span>
                                        </label>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-12 text-right">
                                            <button type="button" class="btn btn-info btn-border btn-round btn-sm" disabled v-if="cargando">
                                                <span class="btn-label"><i class="loader loader-info"></i></span>
                                            </button>
                                            <button type="submit" class="btn btn-info btn-border btn-round btn-sm" v-else>
                                                <span class="btn-label"><i class="fa fa-edit"></i></span> Actualizar
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="tab-pane" id="nav-documentos" role="tabpanel" aria-labelledby="nav-documentos">
                        <form action="#" enctype="multipart/form-data" autocomplete="off" @submit.prevent="enviarDocumento">
                            <div class="form-group">
                                <label for="doc_descripcion">Descripción</label>
                                <input type="text" class="form-control" placeholder="Descripcion" maxlength="50" v-model="formDocumentos.descripcion">
                            </div>
                            <div class="form-group">
                                <label for="doc_archivo">Documento</label>
                                <input type="file" class="form-control" id="file" ref="file" v-on:change="handleFileUpload()" accept=".jpg,.png,.pdf">
                                <small class="form-text text-muted">Solo archivos con formato PDF, PNG o JPG y maximo de 1MB</small>
                            </div>
                            <div class="form-group">
                                <button type="button" class="btn btn-info btn-border" disabled v-if="cargando_documento">
                                    <span class="btn-label"><i class="loader loader-info"></i></span>
                                </button>
                                <button v-else type="submit" class="btn btn-info btn-border">Enviar</button>
                            </div>
                        </form>
                        <div class="row">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Descripción</th>
                                        <th>Documento</th>
                                        <th>Fecha</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in documentos">
                                        <td>{{ row.pedoc_descripcion }}</td>
                                        <td>{{ row.pedoc_documento }}</td>
                                        <td>{{ row.pedoc_fecha }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modalcorreo.php'; ?>
</div>
<?php include 'modalconvertir.php' ?>
<link rel="stylesheet" href="<?= asset('assets/buscadorProductos.css') ?>">
<script src="<?= asset('assets/underscore-min.js') ?>"></script>
<script src="<?= asset('assets/vue-the-mask.js') ?>"></script>
<script src="<?= asset('assets/v-money.js') ?>"></script>
<script src="<?= asset('assetsvuejs/pedidos/ver.js') ?>"></script>
