<style>
    .table,
    .td,
    .th {
        border: 1px solid black;
        text-align: left;
    }

    .table {
        border-collapse: collapse;
        width: 100%;
    }

    .th,
    .td {
        padding: 5px;
    }
</style>

<?php

use Core\Helpers\Moneda; ?>

<div style="display:block; width: 100%;">
    <table width="100%" border="0">
        <tr>
            <td><strong>Sucursal:</strong></td>
            <td><?= $sucursal ?></td>
        </tr>
        <tr>
            <th style="width: 10%; text-align: left">Pedido:</th>
            <td style="width: 60%; text-align: left"><?= $factura ?></td>
            <th style="text-align: right">Fecha:</th>
            <td style="text-align: right"><?= $fecha ?></td>
        </tr>
        <tr>
            <th style="text-align: left">Cliente:</th>
            <td style="text-align: left"><?= $cliente ?></td>
            <th style="text-align: right">Cedula/Rif:</th>
            <td style="text-align: right"><?= $cedularif ?></td>
        </tr>
        <tr>
            <th style="text-align: left">Dirección:</th>
            <td style="text-align: left"><?= $direccion ?></td>
            <th style="text-align: right">Telefóno:</th>
            <td style="text-align: right"><?= $telefono ?></td>
        </tr>
    </table>
</div>

<div style="display:block; width: 100%; padding:15px"></div>

<div style="display:block; width: 100%;">
    <table class="table">
        <thead>
            <tr>
                <th class="th" style="text-align: left">Ref. + Descripción</th>
                <th class="th" style="text-align: right">Cant.</th>
                <th class="th" style="text-align: right">Dto %.</th> 
                <th class="th" style="text-align: right">Precio</th>
                <th class="th" style="text-align: right">Subtotal</th>
                <th class="th" style="text-align: right">Total</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($articulos as $row) : ?>
                <tr>
                    <td class="td" style="text-align: left"><strong><?= $row['peart_procodigo'] ?></strong> <?= $row['peart_propnombre'] ?></td>
                    <td class="td" style="text-align: right"><?= $row['peart_procantidad'] ?></td>
                    <td class="td" style="text-align: right"><?= $row['peart_prodescuento'] ?></td>
                    <?php if ($iva_integrado) : ?>
                        <?php  $descuento = convertir_a_float((($row['peart_procantidad'] * ($row['peart_proprecio']+($row['peart_proprecio'] *($row['imp_valor']/100)))) * ($row['peart_prodescuento'] / 100))) ?? 0; ?>
                        <td class="td" style="text-align: right"><?= Moneda::moneda(($row['peart_proprecio']+($row['peart_proprecio'] *($row['imp_valor']/100))), $div_locale, $div_simbolo) ?></td>
                        <td class="td" style="text-align: right"><?= Moneda::moneda(($row['peart_procantidad'] * ($row['peart_proprecio']+($row['peart_proprecio'] *($row['imp_valor']/100))))-$descuento, $div_locale, $div_simbolo) ?></td>
                        <td class="td" style="text-align: right"><?= Moneda::moneda(($row['peart_procantidad'] * ($row['peart_proprecio']+($row['peart_proprecio'] *($row['imp_valor']/100))))-$descuento, $div_locale, $div_simbolo) ?></td>
                    <?php else : ?>
                        <td class="td" style="text-align: right"><?= Moneda::moneda($row['peart_proprecio'], $div_locale, $div_simbolo) ?></td>
                        <td class="td" style="text-align: right"><?= Moneda::moneda($row['peart_procantidad'] * $row['peart_proprecio'], $div_locale, $div_simbolo) ?></td>
                        <td class="td" style="text-align: right"><?= Moneda::moneda($row['peart_prototal'], $div_locale, $div_simbolo) ?></td>
                    <?php endif; ?>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<p><strong>Observaciones:</strong></p>
<p style="text-align: justify;"><?= strtoupper($observaciones) ?></p>