<style>
    .bg-head {
        background-color: rgba(222, 222, 222, 0.4);
    }

    .tam20 {
        width: 10%;
    }

    .table td,
    .table th {
        padding: 5px !important;
        font-size: 12px;
        height: 35px;
    }

    td,
    th {
        padding: 1px !important;
    }
</style>
<?php

use Core\Helpers\Moneda;

?>
<div class="container" id="appOrdenDeEntregaVer" v-cloak>
    <input type="hidden" value="<?= $cliente['cli_id'] ?>" id="id_cliente_fac">
    <input type="hidden" value="<?= $factura['n_id'] ?>" id="id_fac">
    <input type="hidden" id="ruta_documento" value="ordendeentregaeditar">
    <input type="hidden" id="id_planilla" value="<?= $id_orden_planilla ?>">
    <input type="hidden" value="<?= $empresa['emp_nombre'] ?>" id="nombEmpresa">
    <input type="hidden" value="<?= $doc_pendientes ?>" id="cant_pend">
    <input type="hidden" value="<?= $pagot ?>" id="pagot">
    <input type="hidden" value="<?= $telefonocli ?>" id="telcli">
    <div class="page-inner">
        <div class="row ">
            <div class="col">
                <div class="d-flex justify-content-between">
                    <div class="col-5 pl-0 mr-2 row-card-no-pd" style="margin-bottom: 0; padding-top: 0; padding-bottom: 0">
                        <div class="list-group list-group-messages list-group-flush">
                            <div class="list-group-item unread">
                                <div class="list-group-item-figure">
                                    <div class="avatar">
                                        <span class="avatar-title rounded-circle border border-white bg-info"><?= strtoupper($cliente['cli_razon_social'][0]) ?></span>
                                    </div>
                                </div>
                                <div class="list-group-item-body pl-3 pl-md-4">
                                    <div class="row">
                                        <div class="col-12 col-lg-10">
                                            <h4 class="list-group-item-title">
                                                <span id="cabecera_cliente"> <?= $cliente['cli_razon_social'] ?> <?= $cliente['cli_dni'] ?> </span>
                                                <a href="#" data-toggle="modal" data-target="#modal_buscar_cliente_generico"><span class="fa fa-edit"></span></a>
                                                <span title="<?= ($factura['n_descontado']) ? 'DESCONTADA' : 'SIN DESCONTAR'  ?>" class="fa-2x <?= ($factura['n_descontado']) ? 'fas fa-cart-arrow-down' : 'fas fa-shopping-cart' ?>"></span>
                                            </h4>
                                        </div>
                                        <div class="col-12 col-lg-10">
                                            <h5 class="list-group-item-title text-warning">
                                                VENTAS - <?= $doc_['descripcion'] ?>
                                                <div class="<?= ($doc_pendientes > 1) ? 'text-danger' : 'text-dark' ?>">
                                                <span class="text-success"  @click="modal_whatsapp()"><i class="fa-2x fab fa-whatsapp"></i></span>    
                                                <small>Pendientes: <?= $doc_pendientes ?>
                                                        <?php foreach ($total_doc_pendientes['divisas_totales'] as $row) : ?>
                                                            <small><?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']); ?></small>
                                                        <?php endforeach; ?>
                                                    </small>
                                                    <?php if ($cliente['grup_id']) : ?>
                                                        <small> Venta Al <?= $cliente['grup_nombre'] ?> <?= $cliente['grup_descuento'] ?>%</small>
                                                    <?php endif; ?>
                                                </div>
                                            </h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-7 p-0">
                        <div class="row" style="margin-bottom: 16px;">
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="fecha">Fecha</label>
                                    <input type="date" id="fecha" class="form-control" value="<?= date('Y-m-d', strtotime($factura['n_fecha'])) ?>">
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="divisa">Divisa</label>
                                    <select id="divisa" v-model="divisa_predeterminada" @change="predeterminarDivisa" class="custom-select">
                                        <?php foreach ($divisas as $row) : ?>
                                            <option value="<?= $row['div_id'] ?>"><?= $row['div_nombre'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="sucursal">Sucursal</label>
                                    <select id="sucursal" v-model="sucursal_predeterminada" class="form-control" disabled>
                                        <option disabled value="">Seleccione un elemento</option>
                                        <option v-for="row in sucursales_empleado" :value="row.su_id">{{row.su_nombre}}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="serie">Serie</label>
                                    <select id="serie" v-model="serie_predeterminada" class="form-control">
                                        <option disabled value="">Seleccione un elemento</option>
                                        <option v-for="row in series_empleado" :value="row.ser_id">{{row.ser_descripcion}}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="almacen">Almacén</label>
                                    <select id="almacen" v-model="almacen_predeterminado" class="custom-select" disabled>
                                        <option disabled value="">Seleccione un elemento</option>
                                        <?php foreach ($almacenes as $row) : ?>
                                            <option value="<?= $row['alm_id'] ?>" <?= ($factura['n_almid'] == $row['alm_id']) ? 'selected' : '' ?>><?= $row['alm_nombre'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-12 text-right">
                                <div class="btn-group" role="group" aria-label="Basic example" style="box-shadow: rgba(69, 65, 78, 0.1) 2px 2px 5px 0px;margin-top:3px;">
                                    <a :class="estatus_ordenesp==1 ? 'text-warning' : 'text-success'" class="btn btn-light" href="#" @click="finalizarOrden()">
                                        <span v-if="estatus_ordenesp==1">
                                            <i class="fas fa-ban"></i> Pendiente
                                        </span>
                                        <span v-else>
                                            <i class="fas fa-check"></i> Finalizar
                                        </span>
                                    </a>
                                    <a v-if="mostrarPlanilla" :class="planillaOrden.estatus_autorizado ? 'text-success' : 'text-warning'" class="btn btn-light" href="#" @click="autorizarTrabajo">
                                        <span v-if="planillaOrden.estatus_autorizado">
                                            <i class="fas fa-handshake"></i> Desautorizar Trabajo
                                        </span>
                                        <span v-else>
                                            <i class="fas fa-handshake"></i> Autorizar Trabajo
                                        </span>
                                    </a>
                                    <a class="btn btn-light" href="#" data-toggle="modal" data-target="#modal-imprimir-punto-ticket"><i class="fas fa-print"></i> Imprimir Ticket</a>
                                    <a class="btn btn-light" href="<?= url('facturacion') ?>" target="_blank"><i class="fas fa-reply"></i> Ventas</a>
                                    <a class="btn btn-light" href="<?= url('productos') ?>" target="_blank"><i class="fas fa-reply"> </i>Productos</a>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 mt-3">
                <nav>
                    <div class="nav nav-tabs" role="tablist">
                        <a class="nav-item nav-link active" data-toggle="tab" href="#nav-lista" role="tab" aria-controls="nav-home" aria-selected="true"><?= $doc_['descripcion'] ?> <span class="badge badge-info ml-2"> #<?= $factura['n_correlativo'] ?></span></a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-detalles" role="tab" aria-controls="nav-profile" aria-selected="false"><i class="fas fa-user-friends"></i> Detalles</a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-envio" role="tab" aria-controls="nav-contact" aria-selected="false"><i class="fas fa-shipping-fast"></i> Envíos</a>
                        <?php if ($per_pagar) : ?>
                            <a class="nav-item nav-link" data-toggle="tab" href="#nav-pagos" role="tab" aria-controls="nav-pagos" aria-selected="false"><i class="fas fa-file-invoice-dollar"></i> Pagos</a>
                        <?php endif; ?>
                        <a class="nav-item nav-link" href="#" @click.prevent="modalCorreo">
                            <i class="far fa-envelope"></i> Enviar
                        </a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-documentos" role="tab" aria-controls="nav-documentos" aria-selected="false"><i class="fas fa-file-contract"></i> Documentos</a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-rutadocumento" role="tab" aria-controls="nav-rutadocumento" aria-selected="false"><i class="flaticon-stopwatch"></i> Historial</a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-ubicacion" role="tab" aria-controls="nav-ubicacion" aria-selected="false">Ubicación</a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-comisiones" role="tab" aria-controls="nav-comisiones" aria-selected="false" @click="obtenerComisionFactNotaPendiente()">Comisiones</a>
                        <a v-if="mostrarPlanilla" class="nav-item nav-link" data-toggle="tab" href="#nav-planilla" role="tab" aria-controls="nav-planilla" aria-selected="false">Planilla</a>
                        <a v-if="mostrarPlanilla" class="nav-item nav-link" data-toggle="tab" href="#nav-repuesto" role="tab" aria-controls="nav-repuesto" aria-selected="false">Repuestos</a>
                    </div>
                </nav>
                <div class="tab-content mt-2">
                    <div class="tab-pane fade show active" id="nav-lista" role="tabpanel" aria-labelledby="nav-home-tab">
                        <div class="row row-card-no-pd">
                            <div class="col-12 mt-2 ">
                                <div class="col-12 mt-2 mb-2 p-0">
                                    <div class="d-flex justify-content-between">
                                        <div class="suiche">
                                            <label for="" class="etiqueta icon-preview"><i class="fas fa-barcode"></i></label>
                                            <input type="checkbox" v-model="toggleBarcode" id="switch" @change="focusBuuscar">
                                            <label for="switch" class="lbl"></label>
                                        </div>
                                        <div class="col">
                                            <div class="input-icon">
                                                <span class="input-icon-addon" data-toggle="modal" data-target="#modal-precio-global">
                                                    <i :class="'fa fa-search'"></i>
                                                </span>
                                                <input type="text" id="buscador" class="form-control" placeholder="buscar productos" @input="buscarProducto" @keydown="seleccionarProducto">
                                            </div>
                                        </div>
                                        <div class="btn-group btn-group-sm" role="group" aria-label="Basic example" style="box-shadow: rgb(221, 221, 221) 2px 2px 5px 0px; max-height: 2.5rem;">
                                            <button type="button" class="btn btn-light" disabled v-if="cargando">
                                                <i class="loader loader-info"></i>
                                            </button>
                                            <button class="btn btn-light" @click="actualizarPrecios">
                                                Actualizar precios
                                            </button>
                                            <button type="button" class="btn btn-light text-danger" @click="modalanularPrecio">Anular Precio</button>
                                            <a class="btn btn-light" href="#" @click.prevent="modalConvertirDocumento()" style="padding-top: 8px;"><i class="fas fa-exchange-alt"></i> Convertir</a>
                                            <?php if ($factura['n_descontado'] == 0) : ?>
                                                <a class="btn btn-light" href="#" @click.prevent="descontardeEstock">Descontar de stock</a>
                                            <?php endif; ?>
                                            <button type="button" class="btn btn-light" @click="modalImprimir">Imprimir</button>
                                            <button type="button" class="btn btn-light" disabled v-if="cargando">
                                                <i class="loader loader-info"></i>
                                            </button>
                                            <button type="button" class="btn btn-light  text-info" v-else @click="guardarFactura"><i class="fas fa-save"></i> Guardar</button>
                                            <?php if ($anular_doc) : ?>
                                                <button type="button" class="btn btn-light text-danger" @click="modalAnular">Anular</button>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="scroll" style="height: 300px;width: 100%;padding: 0;margin: 0;overflow-y: scroll;overflow-x: hidden;">
                                    <div class="table-responsive">
                                        <table class="bg-white table-bordered-bd-black" cellspacing="1" cellpadding="1" width="100%" tabindex="2">
                                            <thead>
                                                <tr class="text-center">
                                                    <th></th>
                                                    <th>Código</th>
                                                    <th>Artículo</th>
                                                    <th>Precio</th>
                                                    <th>Cantidad</th>
                                                    <th>Dto. %</th>
                                                    <th>Neto</th>
                                                    <th>IVA</th>
                                                    <th>Total</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="row in carrito" class="text-right">
                                                    <td class="text-center">
                                                        <a href="#" @click.prevent="eliminarProducto(row.unique)">
                                                            <i class="fa fa-trash text-dark"></i>
                                                        </a>
                                                    </td>
                                                    <td class="text-center">{{ row.codigo }}</td>
                                                    <td><input type="text" class="form-control text-left" style="border-color: #bbb;" v-model="row.nombre" @keyup.prevent="actualizarDescripcion(row.unique, $event)"></td>
                                                    <td width="13%"><input type="text" class="form-control text-right" style="border-color: #bbb;" v-model="row.precio" v-money="money" @keyup.prevent="actualizarPrecio(row.unique, $event)"></td>
                                                    <td width="7%">
                                                        <input type="text" class="form-control text-right" style="border-color: #bbb;" v-model="row.cantidad" @keyup.prevent="actualizarCantidad(row.id, $event)">
                                                    </td>
                                                    <td width="7%"><input type="text" class="form-control text-center" style="border-color: #bbb;" v-model="row.descuento" @keyup.prevent="aplicarDescuentoProducto(row.unique, $event)"></td>
                                                    <td width="12%">{{ moneda(row.neto, money.locale, money.prefix, money.precision) }}</td>
                                                    <td width="7%">
                                                        <select id="impuestos" class="form-control text-center input-border-bottom" v-model="row.id_iva" @change="aplicarNuevoIva(row.unique, row.id_iva)">
                                                            <?php foreach ($impuestos as $row) : ?>
                                                                <option value="<?= $row['imp_id'] ?>"><?= $row['imp_descripcion'] ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td width="12%" class="text-right">{{ moneda(row.total, money.locale, money.prefix, money.precision) }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row row-card-no-pd">
                            <div class="col-12" style="padding-left: 30%;">
                                <div class="table-responsive ">
                                    <table class="bg-white table-bordered-bd-black" cellspacing="1" cellpadding="2" width="100%" tabindex="2">
                                        <thead>
                                            <tr class="text-center">
                                                <th>Subtotal</th>
                                                <th width="5%">Dto. %</th>
                                                <th>Neto</th>
                                                <th>IVA</th>
                                                <th>Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="text-right">
                                                <td width="20%">{{ moneda(subtotal, money.locale, money.prefix, money.precision) }}</td>
                                                <td width="20%"><input type="text" class="form-control text-right border-dark" id="descuentoMonto" v-model="descuento" @click.prevent="modalDescuento" @keyup.prevent="aplicarDescuentoAdicional"></td>
                                                <td width="20%">{{ moneda(neto, money.locale, money.prefix, money.precision) }}</td>
                                                <td width="20%">{{ iva }}</td>
                                                <td width="20%">{{ moneda(total, money.locale, money.prefix, money.precision) }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="card-category"> <i class="fa fa-user-tie"></i> Empleado</div>
                        <div class="separator-solid"></div>
                        <div class="form-row">
                            <div class="col-sm-6">
                                <label for="empleado">Empleado</label>
                                <input type="text" id="empleado" class="form-control" disabled value="<?= $empleado['einfo_apellidos']; ?> - <?= $empleado['einfo_email']; ?>">
                            </div>
                        </div>
                        <div class="row mt-3 row-card-no-pd">
                            <div class="col">
                                <div class="form-group form-group-default">
                                    <label>Observaciones</label>
                                    <textarea class="form-control" rows="3" v-model="observaciones"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="nav-detalles" role="tabpanel" aria-labelledby="nav-detalles-tab">
                        <form action="#" autocomplete="off" @submit.prevent="actualizarDetalles">
                            <div class="card">
                                <div class="card-body">
                                    <div class="card-category"> <i class="fa fa-user"></i> Cliente</div>
                                    <div class="separator-solid"></div>
                                    <div class="form-row">
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_tipodoc">Tipo de documento:</label>
                                                <select id="cli_tipodoc" class="form-control">
                                                    <?php foreach ($tipos_de_documentos as $row) : ?>
                                                        <option value="<?= $row['tipodoc_id'] ?>" <?= ($cliente['tipodoc_codigo'] == $row['tipodoc_id']) ? 'selected' : '' ?>><?= $row['tipodoc_codigo']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_dni"># Documento:</label>
                                                <input type="text" id="cli_dni" class="form-control" value="<?= $cliente['cli_dni'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group form-group-default">
                                                <label for="cli_razon_social">Razón social:</label>
                                                <input type="text" id="cli_razon_social" class="form-control" value="<?= $cliente['cli_razon_social'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_pais">País:</label>
                                                <select id="cli_pais" class="form-control">
                                                    <?php foreach ($paises as $row) : ?>
                                                        <option value="<?= $row['pa_id'] ?>" <?= ($cliente['cli_paisid'] == $row['pa_id']) ? 'selected' : '' ?>><?= $row['pa_nombre']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_estado">Estado:</label>
                                                <input type="text" id="cli_estado" class="form-control" value="<?= $cliente['cli_estado'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_ciudad">Ciudad:</label>
                                                <input type="text" id="cli_ciudad" class="form-control" value="<?= $cliente['cli_ciudad'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_codigopostal">Código postal:</label>
                                                <input type="text" id="cli_codigopostal" class="form-control" value="<?= $cliente['cli_codpostal'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col">
                                            <div class="form-group form-group-default">
                                                <label for="cli_direccion">Dirección:</label>
                                                <input type="text" id="cli_direccion" class="form-control" value="<?= $cliente['cli_direccion'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-12 text-right">
                                            <button type="button" class="btn btn-light" disabled v-if="cargando" style="box-shadow: rgb(221, 221, 221) 2px 2px 5px 0px;">
                                                <span class="btn-label"><i class="loader loader-info"></i></span>
                                            </button>
                                            <button type="submit" class="btn btn-light" v-else style="box-shadow: rgb(221, 221, 221) 2px 2px 5px 0px;">
                                                <span class="btn-label"><i class="fa fa-edit"></i></span> Actualizar
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="tab-pane" id="nav-envio" role="tabpanel" aria-labelledby="nav-envio-tab">
                        <form action="#" autocomplete="off" @submit.prevent="actualizarEnvio">
                            <div class="card">
                                <div class="card-body">
                                    <div class="form-row">
                                        <div class="col-sm-6">
                                            <div class="form-group form-group-default">
                                                <label for="env_nombre_opcional">Nombres:</label>
                                                <input type="text" id="env_nombre_opcional" class="form-control" placeholder="opcional" value="<?= $factura['n_env_nombres'] ?>" required>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_agencia_transporte">Agencia de transporte:</label>
                                                <select id="env_agencia_transporte" class="form-control" value="<?= $factura['n_env_agencia_transporte'] ?>" required>
                                                    <option value="V">V</option>
                                                    <option value="R">R</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_codigo_seguimiento">Código de sequimiento:</label>
                                                <input type="text" id="env_codigo_seguimiento" class="form-control" value="<?= $factura['n_env_codigo_seguimiento'] ?>" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_pais">País:</label>
                                                <select id="env_pais" class="form-control">
                                                    <?php foreach ($paises as $row) : ?>
                                                        <option value="<?= $row['pa_id'] ?>" <?= ($factura['n_env_pais'] == $row['pa_id']) ? 'selected' : '' ?>><?= $row['pa_nombre']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_estado">Estado:</label>
                                                <input type="text" id="env_estado" class="form-control" value="<?= $factura['n_env_estado'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_ciudad">Ciudad:</label>
                                                <input type="text" id="env_ciudad" class="form-control" value="<?= $factura['n_env_ciudad'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_codigopostal">Código postal:</label>
                                                <input type="text" id="env_codigopostal" class="form-control" value="<?= $factura['n_env_codigo_postal'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col">
                                            <div class="form-group form-group-default">
                                                <label for="env_direccion">Dirección:</label>
                                                <input type="text" id="env_direccion" class="form-control" value="<?= $factura['n_env_direccion'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-check">
                                        <label class="form-check-label">
                                            <input class="form-check-input" type="checkbox" <?= $factura['n_env_asegurado'] ? 'checked' : '' ?> id="env_asegurado">
                                            <span class="form-check-sign">Envío asegurado SI/NO</span>
                                        </label>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-12 text-right">
                                            <button type="button" class="btn btn-light" disabled v-if="cargando" style="box-shadow: rgb(221, 221, 221) 2px 2px 5px 0px;">
                                                <span class="btn-label"><i class="loader loader-info"></i></span>
                                            </button>
                                            <button type="submit" class="btn btn-light" v-else style="box-shadow: rgb(221, 221, 221) 2px 2px 5px 0px;">
                                                <span class="btn-label"><i class="fa fa-edit"></i></span> Actualizar
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="tab-pane" id="nav-pagos" role="tabpanel" aria-labelledby="nav-pagos-tab">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="row pull">
                                            <div class="col-3 text-right">
                                                <h4>Resumen</h4>
                                                <p><?= $doc_['descripcion'] ?> #<?= $factura['n_correlativo'] ?></p>
                                            </div>
                                            <div class="col-7">
                                                <div class="table-responsive">
                                                    <table class="table table-bordered table-bordered-bd-black">
                                                        <thead style="background-color: #eee;">
                                                            <tr>
                                                                <th class="text-center">Fecha</th>
                                                                <th class="text-center">Divisa</th>
                                                                <th class="text-center">Total</th>
                                                                <th class="text-center">Restante</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr>
                                                                <td class="text-center">{{ factura.fecha }}</td>
                                                                <td class="text-center">{{ div_nombre_master }}</td>
                                                                <td class="text-right">{{ moneda(total, div_locale, div_simbolo) }}</td>
                                                                <td class="text-right">{{ moneda(restante_original, div_locale, div_simbolo) }}</td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                            <div class="col-2">
                                                <?php if ($per_pagar) : ?>
                                                    <div class="row d-flex justify-content-end ">
                                                        <div class="btn-group-vertical btn-group-sm mr-3" role="group" aria-label="Basic example" style="box-shadow: rgb(221,221,221) 2px 6px 15px 0px;">
                                                            <a class="btn btn-info" href="#" @click.prevent="modalPagar">Pagar</a>
                                                            <a class="btn btn-light" href="#" @click.prevent="modalCrearCredito">Crédito</a>
                                                            <a class="btn btn-warning" href="#" v-if="restante_original>0" @click.prevent="pagoACredito">Pago crédito</a>
                                                            <a class="btn btn-info btn-border" href="#" v-if="(estatus_orden==5 || estatus_ordenesp==4) && restante_original>0" @click.prevent="modalImprimirCredito">Imprimir (Pago crédito)</a>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-bordered-bd-black mt-3">
                                        <thead>
                                            <tr>
                                                <th style="border-style:none !important;"></th>
                                                <th style="background-color: #eee;" class="text-center" colspan="6">Abonos</th>
                                            </tr>
                                            <tr>
                                                <th style="width: 5%; border-style:none !important;" class="text-center"></th>
                                                <th>Fecha</th>
                                                <th class="text-center">Cuenta</th>
                                                <th class="text-center">Método</th>
                                                <th class="text-center">Monto</th>
                                                <th class="text-center">Factor</th>
                                                <th class="text-center">Conversión</th>
                                                <th style="width: 5%; border-style:none !important;" class="text-center"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="row in abonos" :class="[row.fab_retiro == 1 ? 'bg-danger': '', row.credito == '1' ? 'bg-secondary': '']">
                                                <td class="text-center" style="width: 5%; border-style:none !important;">
                                                    <?php if ($eliminar_pago) : ?>
                                                        <a v-if="row.fab_retiro==0 && row.credito != '1'" href="#" @click.prevent="eliminarPago(row.fab_id)">
                                                            <i class="fa fa-trash text-dark"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-center">{{ row.fab_fecha }}</td>
                                                <td>{{ row.bc_alias }} {{ row.bc_tipo }}</td>
                                                <td class="text-center">{{ row.mp_nombre }}</td>
                                                <td class="text-right">{{ row.fab_monto }}</td>
                                                <td class="text-right">{{ row.fab_factor }}</td>
                                                <td class="text-right">{{ row.fab_conversion }}</td>
                                                <td style="width: 5%; border-style:none !important;" class="text-center">
                                                    <a @click.prevent="modalImprimirTicketIndividual(row.fab_id)" href="#"><span class="fa fa-print"></span></a>
                                                </td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th style="border-style:none !important;"></th>
                                                <th style="border-style:none !important;"></th>
                                                <th style="border-style:none !important;"></th>
                                                <th style="border-style:none !important;"></th>
                                                <th style="border-style:none !important;"></th>
                                                <th class="text-right"><strong>TOTAL ABONOS</strong></th>
                                                <th class="text-right">{{ moneda(total_pagado, money.locale, money.prefix, money.precision) }}</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="nav-documentos" role="tabpanel" aria-labelledby="nav-documentos">
                        <form action="#" enctype="multipart/form-data" autocomplete="off" @submit.prevent="enviarDocumento">
                            <div class="row">
                                <div class="col-5">
                                    <div class="form-group">
                                        <label for="doc_descripcion">Descripción</label>
                                        <input type="text" class="form-control" placeholder="Descripcion" maxlength="50" v-model="formDocumentos.descripcion">
                                    </div>
                                </div>
                                <div class="col-5">
                                    <div class="form-group">
                                        <label for="doc_archivo">Documento</label>
                                        <input type="file" class="form-control" id="file" ref="file" v-on:change="handleFileUpload()" accept=".jpg,.png,.pdf">
                                        <small class="form-text text-muted">Solo archivos con formato PDF, PNG o JPG y maximo de 1MB</small>
                                    </div>
                                </div>
                                <div class="col-2" style="display: flex; align-items: center;">
                                    <div class="form-group">
                                        <button type="button" class="btn btn-info btn-border" disabled v-if="cargando_documento">
                                            <span class="btn-label"><i class="loader loader-info"></i></span>
                                        </button>
                                        <button v-else type="submit" class="btn btn-light" style="box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;">Enviar</button>
                                    </div>
                                </div>
                            </div>

                        </form>
                        <div class="row">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Descripción</th>
                                        <th>Documento</th>
                                        <th>Fecha</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in documentos">
                                        <td>{{ row.nedoc_descripcion }}</td>
                                        <td>{{ row.nedoc_documento }}</td>
                                        <td>{{ row.nedoc_fecha }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane" id="nav-rutadocumento" role="tabpanel" aria-labelledby="nav-documentos">
                        <div class="card">
                            <div class="card-body">
                                <ul class="list-group">
                                    <li class="list-group-item">Créditos</li>
                                </ul>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Estatus</th>
                                            <th>Documento</th>
                                            <th>Fecha</th>
                                            <th>Monto</th>
                                            <th>Observaciones</th>
                                            <th>Imprimir</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="row in creditosFactura">
                                            <td>
                                                <i :title="row.estatus ? 'Finalizado' : 'Activo'" :class="row.estatus ? 'text-warning fas fa-info-circle' : 'text-success fas fa-check-circle'"></i>
                                            </td>
                                            <td>{{ row.correlativo }}</td>
                                            <td>{{ row.fecha }}</td>
                                            <td>{{ row.monto }}</td>
                                            <td>{{ row.observaciones }}</td>
                                            <td>
                                                <a href="" @click.prevent="modalImprimirCredito(row.id)" title="Imprimir"><i class="fas fa-print btn" style="padding: .65rem;"></i></a>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <ul class="list-group">
                                    <li class="list-group-item">Conversión Documento</li>
                                </ul>
                                <?php if (is_countable($ruta)) : ?>
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Fecha</th>
                                                <th>Tipo de documento</th>
                                                <th>Usuario</th>
                                                <th>Descripción</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td><?= $ruta['fecha'] ?></td>
                                                <td><?= $ruta['doc_prefijo'] ?></td>
                                                <td><?= $ruta['emp_username'] ?></td>
                                                <td><?= $ruta['rd_observacion'] ?></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                <?php endif; ?>
                                <ul class="list-group">
                                    <li class="list-group-item">Envíos de email</li>
                                </ul>
                                <?php if (is_countable($historico_email)) : ?>
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Fecha</th>
                                                <th>Empleado</th>
                                                <th>Descripción</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($historico_email as $row) : ?>
                                                <tr>
                                                    <td><?= date('d/m/Y h:i A', strtotime($row['venhisemail_fecha'])) ?></td>
                                                    <td><?= $row['einfo_nombres'] ?> <?= $row['einfo_apellidos'] ?></td>
                                                    <td><?= $row['venhisemail_descripcion'] ?></td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="nav-ubicacion" role="tabpanel" aria-labelledby="nav-ubicacion-tab">
                        <div class="card" v-for="row in ubicacionProductos">
                            <div class="card-header">
                                <strong>Almacén:</strong> {{ row.almacen.descripcion }}
                            </div>
                            <div class="card-body">
                                <span><strong>{{ row.producto.descripcion.toUpperCase() }}</strong></span>
                                <span v-for="row_dos in row.ubicacion">
                                    -> <strong>{{ row_dos.tipo }}:</strong> {{ row_dos.descripcion }}
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="nav-planilla" role="tabpanel" aria-labelledby="nav-planilla-tab">
                        <?php include 'tab_planilla.php' ?>
                    </div>
                    <div class="tab-pane" id="nav-comisiones" role="tabpanel" aria-labelledby="nav-comisiones-tab">
                        <div class="card">
                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col">
                                        <div class="row d-flex justify-content-end" v-if="<?= ($factura['n_estatus']); ?>==2">
                                            <a href="#" class="btn btn-light mr-3" @click.prevent="recalcularComisiones()" style="box-shadow: rgb(221,221,221) 2px 6px 15px 0px;">Recalcular comisiones</a>
                                        </div>
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-bordered-bd-black mt-3">
                                                <thead>
                                                    <tr>
                                                        <th>Estatus</th>
                                                        <th>Agente</th>
                                                        <th>Total en Venta</th>
                                                        <th>Comisión</th>
                                                        <th>Servicio/Producto</th>
                                                        <th>Porcentaje</th>
                                                        <th>Monto por Comisión</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody v-for="com in comisiones_por_agentes">
                                                    <tr>
                                                        <td>{{com.estatus}}</td>
                                                        <td>{{com.agente_nombre}}</td>
                                                        <td>{{com.total_moneda}}</td>
                                                        <td>{{com.comision}}</td>
                                                        <th>{{com.servicio_producto}}</th>
                                                        <td>{{com.porcentaje}} %</td>
                                                        <td>{{com.monto_moneda}}</td>
                                                        <td>
                                                            <button type="button" title="Eliminar" class="btn btn-link btn-dark" v-if="com.estatus=='Pendiente'" @click.prevent="eliminarComisionPendiente(com.id)"><i class="fa fa-trash"></i></button>
                                                            <button type="button" title="Editar" class="btn btn-link btn-primary" v-if="com.estatus=='Pendiente'" @click.prevent="modalPendienteeditar(com.id,com.porcentaje,com.monto,com.total)"><i class="fa fa-edit"></i></button>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="nav-repuesto" role="tabpanel" aria-labelledby="nav-repuesto">
                        <?php include 'navRepuesto.php' ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if ($per_pagar) : ?>
        <?php include 'app/notasdeentregaeditar/vista/modalpagar.php'; ?>
        <?php include 'app/notasdeentregaeditar/vista/modal_nuevo_credito.php' ?>
    <?php endif; ?>
    <?php include 'app/notasdeentregaeditar/vista/modalcorreo.php'; ?>
    <?php if ($anular_doc) : ?>
        <?php include 'app/notasdeentregaeditar/vista/modal_anular.php' ?>
    <?php endif; ?>
    <?php include 'modal_imprimir.php' ?>
    <?php include 'modal_imprimir_credito.php' ?>
    <?php include 'modal_imprimir_punto_ticket.php' ?>
    <?php include 'modal_indivudual_ticket.php' ?>
    <?php include 'app/poseditar/vista/modal_imprimir_credito.php' ?>
    <?php include 'app/notasdeentregaeditar/vista/modal_editar_con_agente.php' ?>
    <?php include 'modal_anular_precio.php' ?>
    <?php include 'modal_descuento.php' ?>
</div>
<?php include 'modalconvertir.php' ?>
<link rel="stylesheet" href="<?= asset('assets/buscadorProductos.css') ?>">

<script src="<?= asset('assets/underscore-min.js') ?>"></script>
<script src="<?= asset('assets/vue-the-mask.js') ?>"></script>
<script src="<?= asset('assets/v-money.js') ?>"></script>
<script src="<?= asset('assetsvuejs/ordendeentrega/ver.js') ?>"></script>

<script src="<?= asset('assets/vue-select.js') ?>"></script>
<link rel="stylesheet" href="<?= asset('assets/vue-select.css') ?>">
<?php include 'app/notasdeentrega/vista/guardar_cambiar_cliente_editar.php' ?>