<div id="AppConvertirDocumento" v-cloak>
    <form autocomplete="off" @submit.prevent="convertir" id="modal_form_convertir">
        <div class="modal fade" id="modal_convertir" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Convertir Documento</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="sucursal">Sucursal:</label>
                                    <select id="sucursal" class="form-control" v-model="sucursal" @click="obtenerDatos()" :disabled="disabled">
                                        <option :value="0" disabled>SELECCIONE UN ELEMENTO</option>
                                        <option v-for="row in sucursales" :value="row.su_id">{{ row.su_nombre }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="fecha_conv">Fecha:</label>
                                    <input type="date" class="form-control" id="fecha_conv" v-model="dataFormConvertir.fecha">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="almacen_conv">Almacén:</label>
                                    <select id="almacen_conv" class="form-control" v-model="dataFormConvertir.almacen">
                                        <option :value="0" disabled>SELECCIONE UN ELEMENTO</option>
                                        <option v-for="row in almacenes" :value="row.alm_id">{{ row.alm_nombre }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="documento_conv">Documento:</label>
                                    <select id="documento_conv" class="form-control" v-model="dataFormConvertir.documento">
                                        <option value="2">Factura Ventas</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="serie_conv">Serie:</label>
                                    <select id="serie_conv" class="form-control" v-model="dataFormConvertir.serie">
                                        <option :value="0" disabled>SELECCIONE UN ELEMENTO</option>
                                        <option v-for="row in series" :value="row.ser_id">{{ row.ser_descripcion }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-check">
                            <label class="form-check-label">
                                <input class="form-check-input" type="checkbox" v-model="dataFormConvertir.separar">
                                <span class="form-check-sign">Separar Productos/Servicios</span>
                            </label>
                        </div>
                        <div class="alert alert-warning" v-for="row in errorForm">{{ row }}</div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary  btn-sm" data-dismiss="modal">Cerrar</button>
                        <button v-if="loader_convertir" class="btn btn-sm btn-primary" disabled>
                            <i class="loader loader-info"></i>
                        </button>
                        <button v-else type="submit" class="btn btn-primary  btn-sm">Convertir</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script src="<?= asset('assets/js/plugin/moment/moment.min.js'); ?>"></script>
<script>
    new Vue({
        el: '#AppConvertirDocumento',
        data: {
            documentos: [],
            almacenes: [],
            divisas: [],
            sucursales: [],
            sucursal: '',
            series: [],
            disabled: false,
            dataFormConvertir: {
                'id': '',
                'fecha': moment().format('YYYY-MM-DD'),
                'documento': '',
                'almacen': '',
                'divisa': '',
                'serie': '',
                'separar': false,
                'modulo': 1,
                'descontar': false
            },
            errorForm: [],
            loader_convertir: false
        },
        mounted() {
            this.dataFormConvertir.id = document.getElementById('id_fac').value;
        },
        created() {
            this.obtenerSucursalesEmpleado();
        },
        methods: {
            obtenerSucursalesEmpleado() {
                axios
                    .get("convertirdocumento/obtenerSucursalesEmpleado")
                    .then((response) => {
                        this.sucursales = response.data.sucursales;
                        this.sucursal = response.data.id;
                        if (response.data.desactivar == true) {
                            this.disabled = true
                        }
                        axios.get('convertirdocumento/obtenerDatos/' + this.sucursal).then(response => {
                            this.almacenes = response.data.almacenes;
                            this.divisas = response.data.divisas;
                            this.series = response.data.series;
                        });
                    })
                    .catch((e) => notificacion());
            },
            obtenerDatos(){
                axios.get('convertirdocumento/obtenerDatos/' + this.sucursal).then(response => {
                            this.almacenes = response.data.almacenes;
                            this.divisas = response.data.divisas;
                            this.series = response.data.series;
                        });
            },
            convertir() {
                this.loader_convertir = true;
                axios({
                    method: 'post',
                    url: 'convertirdocumento/convertirOrdenENFacturaSeparar',
                    data: this.dataFormConvertir,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (this.dataFormConvertir.separar == true) {
                            if (response.data.repuestos != "") {
                                window.open(response.data.repuestos)
                            }
                            if (response.data.servicios != "") {
                                window.open(response.data.servicios)
                            }

                        } else {
                            location.href = response.data;
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => {
                    notificacion('fa fa-ban', '', 'Error al procesar pedido', 'danger');
                }).finally(() => {
                    this.loader_convertir = false;
                });
            },
        }
    });
</script>