<?php

namespace App\Controladores;

use App\Modelos\Notificaciones;
use Core\Controller;
use Core\Librerias\Http;
use Core\Vista;

final class NotificacionesControlador extends Controller
{
    private $newNotifi;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->newNotifi = new Notificaciones();
    }

    public function index()
    {
        Vista::view('notificaciones/index');
    }

    public function obtenerNotificaciones()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $list_notifi = [];
            $notificaciones = $this->newNotifi->obtenerNotificaciones();

            if (is_countable($notificaciones) && count($notificaciones)) {
                foreach ($notificaciones as $row) {
                    $list_notifi[] = [
                        'id' => $row['not_id'],
                        'fecha' => $row['not_fecha'],
                        'empleado' => [
                            'nombres' => $row['einfo_nombres'],
                            'apellidos' => $row['einfo_apellidos'],
                        ],
                        'descripcion' => $row['not_descripcion']
                    ];
                }
            }

            Http::json_response($list_notifi);
        }
    }

    public function obtenerNotificacionesHeader()
    {
        $list_notifi = [];
        $notificaciones = $this->newNotifi->obtenerNotificaciones();

        if (is_countable($notificaciones) && count($notificaciones)) {
            foreach ($notificaciones as $row) {
                $list_notifi[] = [
                    'id' => $row['not_id'],
                    'fecha' => $row['not_fecha'],
                    'empleado' => [
                        'nombres' => $row['einfo_nombres'],
                        'apellidos' => $row['einfo_apellidos'],
                    ],
                    'descripcion' => $row['not_descripcion']
                ];
            }
        }

        return $list_notifi;
    }
}
