<form autocomplete="off" id="modal_form_pagar" @submit.prevent="pagar">
    <div class="modal fade" id="modal_pagar" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header border-top-0 border-bottom-0">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body border-top-0">
                    <div class="form-row">
                        <div class="col-sm-6">
                            <div class="form-group form-floating-label" v-if="creditos.length > 0">
                                <select class="form-control input-border-bottom" v-model="select_credito" @change="pagarConCredito">
                                    <option value="">Ninguno</option>
                                    <option :value="row.id" v-for="row in creditos">{{ row.monto }}</option>
                                </select>
                                <label for="pagardivisa" class="placeholder">Credito</label>
                            </div>
                            <div id="contenerdor_campos_pagar" v-show="ver_contenedor_campos_pagar">
                                <div class="form-group form-floating-label">
                                    <select class="form-control input-border-bottom" v-model="divisa_pagar" id="pagardivisa" @change="obtenerMetodosSegunDivisa">
                                        <option disabled value="">&nbsp;</option>
                                        <?php foreach ($divisas as $row) : ?>
                                            <option value="<?= $row['div_id'] ?>"><?= $row['div_nombre'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <label for="pagardivisa" class="placeholder">Divisa</label>
                                </div>
                                <div class="form-group form-floating-label">
                                    <select class="form-control input-border-bottom" v-model="metodo_pagar" id="pagarmetodo" @change="obtenerCuentasSegunMetodo">
                                        <option disabled value="">&nbsp;</option>
                                        <option v-for="row in metodos_de_pagos" :value="row.md_id">{{ row.mp_nombre }}</option>
                                    </select>
                                    <label for="pagarmetodo" class="placeholder">Metodo de pago</label>
                                </div>
                                <div class="form-group form-floating-label">
                                    <select class="form-control input-border-bottom" v-model="cuenta_pagar" id="pagarcuenta">
                                        <option disabled value="">&nbsp;</option>
                                        <option v-for="row in cuentas" :value="row.cmp_id">{{ row.bc_alias }} - {{ row.bc_tipo }} - {{ row.ban_codigo }}</option>
                                    </select>
                                    <label for="pagarcuenta" class="placeholder">Cuenta</label>
                                </div>
                            </div>
                            <div class="form-group">
                                <input id="pagarmonto" type="text" class="form-control input-border-bottom" v-money="moneyPagar" v-model="monto">
                                <label for="pagarmonto" class="placeholder">Monto</label>
                            </div>
                            <div class="form-check" v-if="diferencia_n > 0" v-show="ver_contenedor_campos_pagar">
                                <label class="form-check-label">
                                    <input class="form-check-input" type="checkbox" v-model="generar_credito" @click="borrarSeleccionCredito()">
                                    <span class="form-check-sign">Generar credito</span>
                                </label>
                            </div>
                            <div class="form-check" v-if="diferencia_n > 0  && divisa_pagar==2" v-show="ver_contenedor_campos_pagar">
                                <label class="form-check-label">
                                    <input class="form-check-input" type="checkbox" v-model="compra_dolares" @click="borrarSeleccionCompra()">
                                    <span class="form-check-sign">Compra de dolares</span>
                                </label>
                            </div>
                            <div class="form-check" v-show="ver_contenedor_campos_pagar">
                                <label class="form-check-label">
                                    <input class="form-check-input" id="confirmarp" type="checkbox" v-model="cambiar_estatus" checked>
                                    <span class="form-check-sign">Confirmar pago</span>
                                </label>
                            </div>
                            <div class="form-group form-floating-label" v-if="diferencia_n > 0 && compra_dolares==true" v-show="ver_contenedor_campos_pagar">
                                <b class="badge badge-danger" style="font-size: 14px;">PAGAR {{pagomovil}}</b>
                                <template>
                                    <div class="multi-text">
                                        <div class="form-inputs">
                                            <div class="row" v-for="(campo, index) in campos" :key="index">
                                                <div class="col-sm-6 m-2">
                                                    <select class="form-control input-border-bottom" v-model="campo.id" id="pagarDolares">
                                                        <option disabled value="">Seleccione una cuenta</option>
                                                        <?php foreach ($cuentaCompraBolivares as $row) : ?>
                                                            <option value="<?= $row['cmp_id'] ?>"><?= $row['bc_alias'] . '-' . $row['bc_tipo'] . '-' . $row['ban_codigo']; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                    <label for="pagarcuenta" class="placeholder">Cuenta </label>
                                                </div>
                                                <div class="col-sm-2 ">
                                                    <input type="text" v-money="moneyBs" class="form-control input-border-bottom" v-model="campo.valor" />
                                                    <label for="descontarcuenta" class="placeholder">Descontar </label>
                                                </div>
                                                <div class="col-sm-2">
                                                    <button type="button" class="btn-sm btn-danger" title="Quitar" @click.prevent="deleteValue(index)" v-show="numeroCampos > 1">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <button type="button" class="btn-sm btn-primary" title="Añadir" @click.prevent="addValue">
                                                        <i class="fa fa-plus"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </template>
                            </div>
                            <div class="form-group">
                                <input id="referencia" type="text" class="form-control input-border-bottom" v-model="referencia">
                                <label for="referencia" class="placeholder">#Referencia Operación</label>
                            </div>
                            <div class="col mt-3">
                                <button class="btn btn-primary btn-round btn-block" disabled v-if="cargando">
                                    <i class="loader loader-info"></i>
                                </button>
                                <button type="submit" id="btn_pagar" class="btn btn-primary btn-round btn-block" v-else>pagar</button>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <?php if ($cambiar_factor) : ?>
                                <div class="card card-pricing p-0 m-2" v-if="divisa_predeterminada!=divisa_pagar && divisa_pagar==1">
                                    <b class="text-left text-primary m-2">Factor</b>
                                    <div class="form-group">
                                        <input type="text" class="form-control text-right" id="monto_factor" v-money="moneyPagar" v-model="div_conv_factor" @keyup="factor_b">
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="card card-pricing p-0 m-2">
                                <b class="text-left text-primary m-2">Conversion <i class="fas fa-money-bill-wave"></i></b>
                                <div class="form-row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <select class="form-control " id="divisa_convertir_P" v-model="divisa_convertir_p" @change="conversor">
                                                <?php foreach ($divisas as $row) : ?>
                                                    <option value="<?= $row['div_id'] ?>"><?= $row['div_nombre'] ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <select class="form-control " id="divisa_convertir_s" v-model="divisa_convertir_s" @change="conversor">
                                                <?php foreach ($divisas as $row) : ?>
                                                    <option value="<?= $row['div_id'] ?>"><?= $row['div_nombre'] ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control text-right" id="monto_conv" v-money="moneyConver" v-model="monto_conv" @keyup="convedorInput">
                                    <input type="text" class="form-control text-rgiht" disabled id="result_conv">
                                </div>
                            </div>
                            <div class="card card-pricing p-0 m-2">
                                <div class="card-header p-0 m-0">
                                    <div class="card-price">
                                        <span class="price">{{ moneda(total, div_locale, div_simbolo) }}</span>
                                        <br>
                                        <span class="text text-danger">{{ moneda(restante_original, div_locale, div_simbolo) }}</span>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="specification-list">
                                        <li class="text-danger" @click="colocarEnMonto" style="cursor: pointer;">
                                            <span class="name-specification">Total restante</span>
                                            <span class="status-specification" style="font-size: 20px;">{{ moneda(restante, this.moneyPagar.locale, this.moneyPagar.prefix, this.moneyPagar.precision) }}</span>
                                        </li>
                                        <li>
                                            <span class="name-specification">Monto</span>
                                            <span class="status-specification" style="font-size: 20px;">{{ moneda(monto, this.moneyPagar.locale, this.moneyPagar.prefix, this.moneyPagar.precision) }}</span>
                                        </li>
                                        <li>
                                            <span class="name-specification">Balance</span>
                                            <span class="status-specification" style="font-size: 20px;">{{ balance }}</span>
                                        </li>
                                        <li class="text-warning">
                                            <span class="name-specification">Diferencia</span>
                                            <span class="status-specification" style="font-size: 20px;">{{ diferencia }}</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>