<?php

namespace App\Controladores;

use App\Modelos\Empleado;
use App\Modelos\MovimientoModel;
use App\Modelos\Notadecredito;
use App\Modelos\NotadeCreditoDetalles;
use App\Modelos\Notasdeentrega;
use App\Modelos\NotasdeentregaArticulos;
use App\Modelos\VentasHistoricoEmail;
use Core\Controller;
use Core\Helpers\Moneda;
use Core\Helpers\Notifica;
use Core\Librerias\CarritoVentasEditar;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Librerias\Seguridad;
use Core\Vista;

final class NotasdeentregacajaeditarControlador extends Controller
{
    private $array_errors = [];
    private $notas_entrega_model;
    private $divisa_master;
    private $module;
    private $carritoVentas;

    public function __construct()
    {
        parent::__construct();
        $this->module = new Module();
        $this->notas_entrega_model = new Notasdeentrega();
        $this->carritoVentas = new CarritoVentasEditar();
        $this->divisa_master  = $this->notas_entrega_model->obtenerDivisaMaster();
    }

    public function verFactura(int $id_factura)
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {

            $id_factura = filter_var($id_factura, FILTER_SANITIZE_NUMBER_INT);
            $factura = $this->notas_entrega_model->obtenerFactura($id_factura);

            if ($factura) {

                $newVentasHistoricoEmail = new VentasHistoricoEmail();

                $data_factura = [
                    'doc_pendientes'        => $this->carritoVentas->totalDocumentosPendientes($factura['ne_cliid']),
                    'per_pagar'             => $this->module->has_module_action_permission('facturacion', 'pagar', $_SESSION['user_data']['emp_id']),
                    'impresoras'            => $this->notas_entrega_model->consultar("SELECT imp_id id, imp_descripcion impresora, imp_tipo tipo FROM app_impresoras WHERE imp_tipo = 2 AND imp_estatus = 1")->all(),
                    'imp_ticket'            => $this->notas_entrega_model->consultar("SELECT imp_id id, imp_descripcion impresora FROM app_impresoras WHERE imp_estatus = 1 AND imp_tipo = 2")->all(),
                    'historico_email'       => $newVentasHistoricoEmail->obtenerHistorico($id_factura),
                    'ruta'                  => $this->notas_entrega_model->rutaDocumento($factura['ne_id']),
                    'anular_doc'            => $this->module->has_module_action_permission('facturacion', 'anular_doc', $_SESSION['user_data']['emp_id']),
                    'eliminar_pago'         => $this->module->has_module_action_permission('facturacion', 'eliminar_pagos', $_SESSION['user_data']['emp_id']),
                    'factura'               => $factura,
                    'empleado'              => $this->carritoVentas->obtenerEmpleado($factura['ne_empleadoid']),
                    'empresa'               => $this->carritoVentas->obtenerDatosEmpresa(),
                    'cliente'               => $this->carritoVentas->obtenerCliente($factura['ne_cliid']),
                    'tipos_de_documentos'   => $this->carritoVentas->obternerTiposDeDocumentos(),
                    'impuestos'             => $this->carritoVentas->obtenerImpuestos(),
                    'paises'                => $this->carritoVentas->obtenerPaises(),
                    'almacenes'             => $this->carritoVentas->obtenerAlmacenesEmpleado(),
                    'series'                => $this->carritoVentas->obtenerSeriesEmpleado(),
                    'divisas'               => $this->carritoVentas->obtenerDivisasParaFacturar(),
                    'empleados'             => $this->carritoVentas->obtenerEmpleados()
                ];

                if ($factura['ne_estatus'] < 3) {
                    return Vista::view('notasdeentregacajaeditar/ver', $data_factura);
                } elseif ($factura['ne_estatus'] == 3) {
                    return Vista::view('notasdeentregacajaeditar/anulado', $data_factura);
                }
            } else {
                header('Location: ' . ruta_base() . 'facturacion');
            }
        }
    }

    public function obtenerFactura(int $id_factura)
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            $result = $this->carritoVentas->obtenerFactura('app_notas_de_entrega', 'needitar', $id_factura);

            if (isset($result['errors'])) {
                return Http::json_response(['errors' => $result['errors']]);
            } else {
                return Http::json_response($result);
            }
        }
    }

    public function obtenerCreditosFactura(int $id_factura)
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {
            Http::json_response($this->carritoVentas->obtenerCreditosFactura($id_factura, 1));
        }
    }

    public function predeterminarDivisa()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_GET['id_factura']))
                $this->array_errors[] = 'La Factura es obligatorio';
            if (empty($_GET['id_divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';

            if (empty($this->array_errors)) {

                $id_divisa          = filter_input(INPUT_GET, 'id_divisa', FILTER_VALIDATE_INT);
                $id_factura         = filter_input(INPUT_GET, 'id_factura', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_GET, 'descuento', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_factura && $id_divisa) {
                    $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    if ($data_factura) {
                        if ($this->esEditable($id_factura)) {
                            $result = $this->carritoVentas->predeterminarDivisa('needitar', $id_factura, $data_factura['ne_cliid'], $id_divisa, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function agregarProductoBarcode()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] = 'La Factura es obligatorio';
            if (empty($_POST['producto']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['id_almacen']))
                $this->array_errors[] = 'El Almacen es obligatorio';
            if (empty($_POST['id_divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';

            if (empty($this->array_errors)) {

                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $producto           = filter_input(INPUT_POST, 'producto', FILTER_SANITIZE_STRIPPED);
                $id_almacen         = filter_input(INPUT_POST, 'id_almacen', FILTER_VALIDATE_INT);
                $id_divisa          = filter_input(INPUT_POST, 'id_divisa', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_factura && $id_almacen && $id_divisa) {
                    $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    if ($data_factura) {
                        if ($this->esEditable($id_factura)) {
                            $result = $this->carritoVentas->agregarProductoBarcode('app_notas_de_entrega', 'needitar', $id_factura, $data_factura['ne_cliid'], $producto, $id_almacen, $id_divisa, $descuento_global, true, true);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function agregarProducto()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] = 'La Factura es obligatorio';
            if (empty($_POST['id_producto']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['id_almacen']))
                $this->array_errors[] = 'El Almacen es obligatorio';
            if (empty($_POST['id_divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';

            if (empty($this->array_errors)) {

                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $id_producto        = filter_input(INPUT_POST, 'id_producto', FILTER_VALIDATE_INT);
                $id_almacen         = filter_input(INPUT_POST, 'id_almacen', FILTER_VALIDATE_INT);
                $id_divisa          = filter_input(INPUT_POST, 'id_divisa', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_factura && $id_producto && $id_almacen && $id_divisa) {
                    $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    if ($data_factura) {
                        if ($this->esEditable($id_factura)) {
                            $result = $this->carritoVentas->agregarProducto('app_notas_de_entrega', 'needitar', $id_factura, $data_factura['ne_cliid'], $id_producto, $id_almacen, $id_divisa, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function actualizarPrecio()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] = 'El Factura es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';

            if (empty($this->array_errors)) {

                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRIPPED);
                $precio             = filter_input(INPUT_POST, 'precio', FILTER_SANITIZE_STRING) ?? 0;
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_factura) {
                    $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    if ($data_factura) {
                        if ($this->esEditable($id_factura)) {
                            $result = $this->carritoVentas->actualizarPrecio('needitar', $id_factura, $data_factura['ne_cliid'], $unique, $precio, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function actualizarCantidad()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] = 'El Factura es obligatorio';
            if (empty($_POST['id_producto']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['cantidad']))
                $this->array_errors[] = 'El Cantidad es obligatorio';

            if (empty($this->array_errors)) {

                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $id_producto        = filter_input(INPUT_POST, 'id_producto', FILTER_VALIDATE_INT);
                $cantidad           = filter_input(INPUT_POST, 'cantidad', FILTER_VALIDATE_FLOAT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_factura && $id_producto && $cantidad) {
                    $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    if ($data_factura) {
                        if ($this->esEditable($id_factura)) {
                            $result = $this->carritoVentas->actualizarCantidad('needitar', 'app_notas_de_entrega', $id_factura, $data_factura['ne_cliid'], $id_producto, $cantidad, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function actualizarDescripcion()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] = 'El Factura es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['descripcion']))
                $this->array_errors[] = 'La Descripción es obligatorio';

            if (empty($this->array_errors)) {

                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRING);
                $descripcion        = $this->solicitud->sanitize($_POST['descripcion'], FILTER_SANITIZE_STRING);

                if ($id_factura) {
                    $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    if ($data_factura) {
                        if ($this->esEditable($id_factura)) {
                            $result = $this->carritoVentas->actualizarDescripcion('needitar', $id_factura, $unique, $descripcion);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function aplicarNuevoIva()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] = 'El Factura es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['id_iva']))
                $this->array_errors[] = 'El IVA es obligatorio';

            if (empty($this->array_errors)) {

                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRIPPED);
                $id_iva             = filter_input(INPUT_POST, 'id_iva', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_factura && $id_iva) {
                    $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    if ($data_factura) {
                        if ($this->esEditable($id_factura)) {
                            $result = $this->carritoVentas->aplicarNuevoIva('needitar', $id_factura, $data_factura['ne_cliid'], $unique, $id_iva, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function aplicarDescuentoProducto()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] = 'La Factura es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';

            if (empty($this->array_errors)) {

                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRIPPED);
                $descuento          = filter_input(INPUT_POST, 'descuento', FILTER_SANITIZE_STRING) ?? 0;
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_factura) {
                    $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    if ($data_factura) {
                        if ($this->esEditable($id_factura)) {
                            $result = $this->carritoVentas->aplicarDescuentoProducto('needitar', $id_factura, $data_factura['ne_cliid'], $unique, $descuento, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function aplicarDescuentoAdicional()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura'])) {
                $this->array_errors[] = 'La Factura es obligatorio';
            } else {

                $id_factura = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $descuento_global = filter_input(INPUT_POST, 'descuento', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_factura) {
                    $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    if ($data_factura) {
                        if ($this->esEditable($id_factura)) {
                            $result = $this->carritoVentas->aplicarDescuentoAdicional('needitar', $id_factura, $data_factura['ne_cliid'], $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarProducto()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] = 'El Cliente es obligatorio';
            if (empty($_POST['id_producto']))
                $this->array_errors[] = 'El Producto es obligatorio';

            if (empty($this->array_errors)) {

                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'id_producto', FILTER_SANITIZE_STRING);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_factura) {
                    $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    if ($data_factura) {
                        if ($this->esEditable($id_factura)) {
                            $result = $this->carritoVentas->eliminarProducto('needitar', 'app_notas_de_entrega', $id_factura, $data_factura['ne_cliid'], $unique, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function guardarDetallesCliente()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['cli_tipodoc']))
                $this->array_errors[] = 'El campo Cedula de identidad es obligatorio';
            if (empty($_POST['cli_dni']))
                $this->array_errors[] = 'El campo Tipo de documento es obligatorio';
            if (empty($_POST['cli_razon_social']))
                $this->array_errors[] = 'El campo Razón social es obligatorio';
            if (empty($_POST['cli_direccion']))
                $this->array_errors[] = 'El campo Dirección es obligatorio';

            if (empty($this->array_errors)) {

                $cli_id             = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                $cli_tipodoc        = filter_input(INPUT_POST, 'cli_tipodoc', FILTER_SANITIZE_NUMBER_INT);
                $cli_dni            = filter_input(INPUT_POST, 'cli_dni', FILTER_SANITIZE_STRING);
                $cli_nombres        = $this->solicitud->sanitize($_POST['cli_razon_social'], FILTER_SANITIZE_STRING);
                $cli_direccion      = $this->solicitud->sanitize($_POST['cli_direccion'], FILTER_SANITIZE_STRING);
                $cli_pais           = filter_input(INPUT_POST, 'cli_paisid', FILTER_SANITIZE_NUMBER_INT);
                $cli_estado         = $this->solicitud->sanitize($_POST['cli_estado'], FILTER_SANITIZE_STRING);
                $cli_ciudad         = $this->solicitud->sanitize($_POST['cli_ciudad'], FILTER_SANITIZE_STRING);
                $cli_codigopostal   = filter_input(INPUT_POST, 'cli_codigopostal', FILTER_SANITIZE_STRING);

                $result = $this->carritoVentas->editarDetallesCliente($cli_id, [
                    'cli_tipodocid'     => $cli_tipodoc,
                    'cli_dni'           => $cli_dni,
                    'cli_razon_social'  => $cli_nombres,
                    'cli_direccion'     => $cli_direccion,
                    'cli_paisid'        => $cli_pais,
                    'cli_estado'        => $cli_estado,
                    'cli_ciudad'        => $cli_ciudad,
                    'cli_codpostal'     => $cli_codigopostal
                ]);

                if (isset($result['errors'])) {
                    return Http::json_response(['errors' => $result['errors']]);
                } else {
                    return Http::json_response($result);
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function enviarDocumento()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] = 'Acción prohibida';
            if (empty($_POST['descripcion']))
                $this->array_errors[] = 'El campo Descripcion es obligatorio.';
            if (empty($_FILES['documento']))
                $this->array_errors[] = 'El documento es obligatorio.';

            if (empty($this->array_errors)) {

                $id_factura = filter_var($_POST['id_factura'], FILTER_VALIDATE_INT);
                $descripcion = $this->solicitud->sanitize($_POST['descripcion'], FILTER_SANITIZE_STRING);

                if ($id_factura) {
                    $result = $this->carritoVentas->enviarDocumento('app_notas_de_entrega', $id_factura, $_FILES, $descripcion);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function guardarClienteCambiar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] = 'Acción prohibida';
            if (empty($_POST['cli_tipodoc']))
                $this->array_errors[] = 'El campo Cedula de identidad es obligatorio';
            if (empty($_POST['cli_dni']))
                $this->array_errors[] = 'El campo Tipo de documento es obligatorio';
            if (empty($_POST['cli_razon_social']))
                $this->array_errors[] = 'El campo Razón social es obligatorio';
            if (empty($_POST['cli_direccion']))
                $this->array_errors[] = 'El campo Dirección es obligatorio';

            if (empty($this->array_errors)) {

                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
                $cli_id             = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                $cli_tipodoc        = filter_input(INPUT_POST, 'cli_tipodoc', FILTER_SANITIZE_NUMBER_INT);
                $cli_dni            = filter_input(INPUT_POST, 'cli_dni', FILTER_SANITIZE_STRING);
                $cli_email          = filter_input(INPUT_POST, 'cli_email', FILTER_SANITIZE_STRING);
                $cli_telefono       = filter_input(INPUT_POST, 'cli_telefono', FILTER_SANITIZE_STRING);
                $cli_nombres        = $this->solicitud->sanitize($_POST['cli_razon_social'], FILTER_SANITIZE_STRING);
                $cli_direccion      = $this->solicitud->sanitize($_POST['cli_direccion'], FILTER_SANITIZE_STRING);
                $cli_natural        = ('true' == filter_input(INPUT_POST, 'cli_natural')) ? 1 : 0;

                if ($this->esEditable($id_factura)) {
                    $result = $this->carritoVentas->guardarClienteCambiar('app_notas_de_entrega', $id_factura, [
                        'cli_tipodocid'     => $cli_tipodoc,
                        'cli_dni'           => $cli_dni,
                        'cli_razon_social'  => $cli_nombres,
                        'cli_direccion'     => $cli_direccion,
                        'cli_natural'       => $cli_natural,
                        'cli_email'         => $cli_email,
                        'cli_telefono'      => $cli_telefono
                    ], true);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Documento no editable';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function cambiarCliente()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            $id_cliente     = filter_input(INPUT_GET, 'id_cliente', FILTER_SANITIZE_NUMBER_INT);
            $id_factura     = filter_input(INPUT_GET, 'id_factura', FILTER_SANITIZE_NUMBER_INT);

            if (!empty($id_cliente) && !empty($id_factura)) {
                if ($this->esEditable($id_factura)) {
                    $result = $this->carritoVentas->cambiarCliente('app_notas_de_entrega', $id_cliente, $id_factura, true);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Documento no editable';
                }
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    //METODOS PROPIO DEL CONTRALADOR

    public function ventaEnEsperaEditar()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {

            $id_serie       = filter_input(INPUT_POST, 'id_serie', FILTER_SANITIZE_NUMBER_INT);
            $id_factura     = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
            $desci          = true;
            $fecha          = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
            $observaciones  = filter_input(INPUT_POST, 'observaciones', FILTER_SANITIZE_STRING) ?? '';

            $cantidad_descontada = 0;

            if (!empty($id_factura)) {

                if (empty($id_serie))
                    $this->array_errors[] = 'El campo Serie es obligatorio.';
                if (empty($fecha))
                    $this->array_errors[] = 'Debe seleccionar una fecha.';

                if (empty($this->array_errors)) {

                    $notas_entrega_articulos_model = new NotasdeentregaArticulos();
                    $serie = $this->carritoVentas->obtenerSerie($id_serie);
                    $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    $cliente = $this->carritoVentas->obtenerCliente($factura['ne_cliid']);
                    $fecha = date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s');
                    $factor = 1;
                    $total_procosto = 0;
                    $total_costo_servicio = 0;

                    if ($cliente && $serie && $factura) {

                        if ($this->esEditable($id_factura)) {

                            $articulos = $this->carritoVentas->contenidoCarrito('needitar', $id_factura);
                            $ne_decontado = $factura['ne_descontado'];

                            foreach ($articulos as $row) {
                                if ($row['precio'] == 0 || $row['total'] == 0) {
                                    $this->array_errors[] = "Lo siento el total del producto <strong>{$row['nombre']}</strong> no puede quedar en cero";
                                }
                            }

                            if (empty($this->array_errors) && ($factura['ne_descontado'] == 1 || $desci == true)) {
                                $ne_decontado = 1;
                                foreach ($articulos as $row) {
                                    $detalles_producto = $notas_entrega_articulos_model->obtenerDetalleProductoFacturado($id_factura, $row['id'], $row['id_almacen']);
                                    $cantidad = $this->carritoVentas->chuequearStock($row['id'], $row['id_almacen']);
                                    $data_p = $this->carritoVentas->obtenerProducto($row['id']);
                                    if ($data_p['pro_tipo'] != 3) {
                                        if ($data_p['pro_nostock'] == 0) {
                                            if ($detalles_producto) {
                                                if ($cantidad) {
                                                    if ($detalles_producto['neart_procantidad'] < $row['cantidad'] && $cantidad['ps_cantidad'] < ($row['cantidad'] - $detalles_producto['neart_descontar_inventario'])) {
                                                        $this->array_errors[] = "Lo siento la cantidad a descontar del producto {$row['nombre']} supera la cantidad existente en Stock";
                                                    }
                                                } else {
                                                    $this->array_errors[] = "Lo siento el producto {$row['nombre']} no tiene existencia en el almacen seleccionado";
                                                }
                                            } else {
                                                if ($cantidad) {
                                                    if ($cantidad['ps_cantidad'] < $row['cantidad']) {
                                                        $this->array_errors[] = "Lo siento la cantidad a descontar del producto {$row['nombre']} supera la cantidad existente en Stock";
                                                    }
                                                } else {
                                                    $this->array_errors[] = "Lo siento el producto {$row['nombre']} no tiene existencia en el almacen seleccionado";
                                                }
                                            }
                                        }
                                    }
                                }
                            }

                            if (empty($this->array_errors)) {

                                if ($this->divisa_master['div_id'] != $_SESSION["needitar$id_factura"]['divisa']) {
                                    $factor_div = $this->notas_entrega_model->obtenerDivisaAlCambio($_SESSION["needitar$id_factura"]['divisa'], $this->divisa_master['div_id']);
                                    $factor = $factor_div['df_factor'];
                                }

                                if ($this->notas_entrega_model->editar($id_factura, [
                                    'ne_subtotal'           => $_SESSION["needitar$id_factura"]['subtotal'],
                                    'ne_descuento'          => $_SESSION["needitar$id_factura"]['descuento'],
                                    'ne_neto'               => $_SESSION["needitar$id_factura"]['neto'],
                                    'ne_iva'                => $_SESSION["needitar$id_factura"]['iva'],
                                    'ne_total'              => $_SESSION["needitar$id_factura"]['total'],
                                    'ne_articulos_total'    => $_SESSION["needitar$id_factura"]['articulos_cantidad'],
                                    'ne_divid'              => $_SESSION["needitar$id_factura"]['divisa'],
                                    'ne_serid'              => $serie['ser_id'],
                                    'ne_serie'              => $serie['ser_descripcion'],
                                    'ne_empresaid'          => 1,
                                    'ne_fecha'              => $fecha,
                                    'ne_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                    'ne_cliid'              => $cliente['cli_id'],
                                    'ne_env_nombres'        => $cliente['cli_razon_social'],
                                    'ne_env_direccion'      => $cliente['cli_direccion'],
                                    'ne_env_pais'           => $cliente['cli_paisid'],
                                    'ne_env_estado'         => $cliente['cli_estado'],
                                    'ne_env_ciudad'         => $cliente['cli_ciudad'],
                                    'ne_env_codigo_postal'  => $cliente['cli_codpostal'],
                                    'ne_estatus'            => 2,
                                    'ne_observaciones'      => $observaciones,
                                    'ne_descontado'         => $ne_decontado,
                                    'factor'                => $factor
                                ])) {

                                    foreach ($articulos as $row) {

                                        $detalles_producto = $notas_entrega_articulos_model->obtenerDetalleProductoFacturado($id_factura, $row['id'], $row['id_almacen']);
                                        $almacen  = $this->carritoVentas->obtenerAlmacen($row['id_almacen']);
                                        $producto = $this->carritoVentas->obtenerProducto($row['id']);
                                        $cantidad_stock = $this->carritoVentas->chuequearStock($row['id'], $row['id_almacen']);

                                        if ($detalles_producto) {

                                            $cantidad_descontada = $detalles_producto['neart_descontar_inventario'];

                                            if ($producto['pro_tipo'] != 3) {
                                                if ($detalles_producto['neart_procantidad'] > $row['cantidad'] && $ne_decontado == 1) {
                                                    $cantidad = $detalles_producto['neart_procantidad'] - $row['cantidad'];
                                                    if ($this->notas_entrega_model->restablecerStock($row['id'], $row['id_almacen'], $cantidad)) {
                                                        Notifica::stock($row['id'], $almacen['alm_nombre'], 'ventas', $cantidad_stock['ps_cantidad'] ?? 0, $cantidad, 0, ($cantidad_stock['ps_cantidad']  ?? 0) + $cantidad, $factura['ne_correlativo'], 1);
                                                        $cantidad_descontada = $detalles_producto['neart_descontar_inventario'] - $cantidad;
                                                    }
                                                } else {
                                                    if (($desci == true || $ne_decontado == 1) && $detalles_producto['neart_descontar_inventario'] < $row['cantidad']) {
                                                        $cantidad_a_descontar = $row['cantidad'] - $detalles_producto['neart_descontar_inventario'];
                                                        if ($cantidad_a_descontar > 0 && $this->notas_entrega_model->desontardeStock($row['id'], $row['id_almacen'], $cantidad_a_descontar)) {
                                                            Notifica::stock($row['id'], $almacen['alm_nombre'], 'ventas', $cantidad_stock['ps_cantidad'] ?? 0, 0, $cantidad_a_descontar, ($cantidad_stock['ps_cantidad'] ?? 0) - $cantidad_a_descontar, $factura['ne_correlativo'], 1);
                                                            $cantidad_descontada = $detalles_producto['neart_descontar_inventario'] + $cantidad_a_descontar;
                                                        }
                                                    }
                                                }
                                            }

                                            if ($notas_entrega_articulos_model->editar($detalles_producto['neart_id'], [
                                                'neart_procodigo'               => $row['codigo'],
                                                'neart_propnombre'              => $row['nombre'],
                                                'neart_procosto'                => $row['costo'],
                                                'neart_costo_servicio'          => $row['costo_servicio'],
                                                'neart_proprecio'               => $row['precio'],
                                                'neart_procantidad'             => $row['cantidad'],
                                                'neart_prodescuento'            => $row['descuento'],
                                                'neart_proneto'                 => $row['neto'],
                                                'neart_idiva'                   => $row['id_iva'],
                                                'neart_proiva'                  => $row['iva'],
                                                'neart_ivatotal'                => $row['iva_total'],
                                                'neart_prototal'                => $row['total'],
                                                'neart_descontar_inventario'    => $cantidad_descontada,
                                            ])) {
                                                if ($producto['pro_tipo'] == 3) {
                                                    $total_costo_servicio += $row['costo_servicio'] * $row['cantidad'];
                                                } else {
                                                    $total_procosto += $row['costo'] * $row['cantidad'];
                                                }
                                            }
                                        } else {

                                            $cantidad_descontada = 0;

                                            if ($producto['pro_tipo'] != 3 && ($desci == true || $ne_decontado == 1) && $this->notas_entrega_model->desontardeStock($row['id'], $row['id_almacen'], $row['cantidad'])) {
                                                $cantidad_descontada = $row['cantidad'];
                                                Notifica::stock($row['id'], $almacen['alm_nombre'], 'ventas', $cantidad_stock['ps_cantidad'] ?? 0, 0, $row['cantidad'], ($cantidad_stock['ps_cantidad'] ?? 0) - $row['cantidad'], $factura['ne_correlativo'], 1);
                                            }

                                            if ($notas_entrega_articulos_model->guardar([
                                                'neart_neid'                    => $id_factura,
                                                'neart_proid'                   => $row['id'],
                                                'neart_procodigo'               => $row['codigo'],
                                                'neart_propnombre'              => $row['nombre'],
                                                'neart_procosto'                => $row['costo'],
                                                'neart_costo_servicio'          => $row['costo_servicio'],
                                                'neart_proprecio'               => $row['precio'],
                                                'neart_procantidad'             => $row['cantidad'],
                                                'neart_prodescuento'            => $row['descuento'],
                                                'neart_proneto'                 => $row['neto'],
                                                'neart_idiva'                   => $row['id_iva'],
                                                'neart_almid'                   => $row['id_almacen'],
                                                'neart_proiva'                  => $row['iva'],
                                                'neart_ivatotal'                => $row['iva_total'],
                                                'neart_prototal'                => $row['total'],
                                                'neart_descontar_inventario'    => $cantidad_descontada,
                                            ], true)) {
                                                if ($producto['pro_tipo'] == 3) {
                                                    $total_costo_servicio += $row['costo_servicio'] * $row['cantidad'];
                                                } else {
                                                    $total_procosto += $row['costo'] * $row['cantidad'];
                                                }
                                            }
                                        }
                                    }

                                    $this->notas_entrega_model->editar($id_factura, [
                                        'total_procosto' => $total_procosto,
                                        'total_costo_servicio' => $total_costo_servicio,
                                    ]);

                                    Http::json_response(ruta_base() . 'notasdeentregacajaeditar/verFactura/' . $id_factura);
                                } else {
                                    $this->array_errors[] = 'Los siento ocurrio un error al guardar la venta';
                                }
                            }
                        } else {
                            $this->array_errors[] = 'La nota de etrega a sido pagada en su totalidad por lo tanto no puede ser modificada.';
                        }
                    }
                }

                Http::json_response(['errors' => $this->array_errors]);
            }
        }
    }

    public function guardarEnvioCliente()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_factura             = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
            $env_nombre_opcional    = filter_input(INPUT_POST, 'env_nombre_opcional', FILTER_SANITIZE_STRING);
            $env_agencia_transporte = filter_input(INPUT_POST, 'env_agencia_transporte', FILTER_SANITIZE_STRING);
            $env_codigo_seguimiento = filter_input(INPUT_POST, 'env_codigo_seguimiento', FILTER_SANITIZE_STRING);
            $env_direccion          = filter_input(INPUT_POST, 'env_direccion', FILTER_SANITIZE_STRING);
            $env_pais               = filter_input(INPUT_POST, 'env_pais', FILTER_SANITIZE_NUMBER_INT);
            $env_estado             = filter_input(INPUT_POST, 'env_estado', FILTER_SANITIZE_STRING);
            $env_ciudad             = filter_input(INPUT_POST, 'env_ciudad', FILTER_SANITIZE_STRING);
            $env_codigopostal       = filter_input(INPUT_POST, 'env_codigopostal', FILTER_SANITIZE_STRING);
            $env_asegurado          = ('true' == filter_input(INPUT_POST, 'env_asegurado')) ? 1 : 0;

            if (!empty($id_factura)) {

                if (empty($env_agencia_transporte))
                    $this->array_errors[] = 'El campo Agencia de tranporte es obligatorio.';
                if (empty($env_codigo_seguimiento))
                    $this->array_errors[] = 'El campo Codigo de seguimiento es obligatorio.';
                if (empty($env_direccion))
                    $this->array_errors[] = 'El campo Dirección obligatorio.';
                if (empty($env_pais))
                    $this->array_errors[] = 'El campo País es obligatorio.';
                if (empty($env_estado))
                    $this->array_errors[] = 'El campo Estado es obligatorio.';
                if (empty($env_ciudad))
                    $this->array_errors[] = 'El campo Ciudad es obligatorio.';
                if (empty($env_codigopostal))
                    $this->array_errors[] = 'El campo Codigo postal es obligatorio.';

                if (empty($this->array_errors)) {

                    $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);

                    if ($data_factura['ne_estatus'] != 1) {
                        Http::json_response($this->notas_entrega_model->editar($id_factura, [
                            'ne_env_nombres'            => $env_nombre_opcional ?? $data_factura['ne_env_nombres'],
                            'ne_env_direccion'          => $env_direccion,
                            'ne_env_pais'               => $env_pais,
                            'ne_env_estado'             => $env_estado,
                            'ne_env_ciudad'             => $env_ciudad,
                            'ne_env_codigo_postal'      => $env_codigopostal,
                            'ne_env_agencia_transporte' => $env_agencia_transporte,
                            'ne_env_codigo_seguimiento' => $env_codigo_seguimiento,
                            'ne_env_asegurado'          => $env_asegurado,
                        ]));
                    } else {
                        $this->array_errors[] = 'La factura no se puede editar ya que ha sigo pagada en su totalidad.';
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function comprobarFactura(int $id_factura)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id_factura = filter_var($id_factura, FILTER_SANITIZE_NUMBER_INT);
            $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
            if ($factura['ne_estatus'] == 1) {
                $this->array_errors[] = 'Ya la factura a sido pagada en su totalidad';
            } else {
                Http::json_response(true);
            }
            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    private function esEditable(int $id_factura)
    {
        $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
        return ($factura['ne_estatus'] == 1) ? false : true;
    }

    private function facturaFinalizada($id_factura)
    {
        $movimiento_model = new MovimientoModel();
        $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
        $total_pagos = $movimiento_model->totalPagos($id_factura, 1,1);
        return (round($total_pagos['total'], 2) >= round($factura['ne_total'], 2)) ? true : false;
    }

    public function obtenerMetodosSegunDivisa()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_divisa = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_factura = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
            $factor = 1;

            if (empty($id_divisa))
                $this->array_errors[] = 'Debe seleccionar una divisa';

            if (!empty($id_factura) && empty($this->array_errors)) {

                $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                $divisa = Moneda::obtenerDivisa($id_divisa);

                if ($divisa && $factura) {

                    $movimiento_model = new MovimientoModel();
                    $data_metodos = $this->notas_entrega_model->obtenerMetodosSegunDivisa($id_divisa);

                    if ($data_metodos) {

                        if ($factura['ne_divid'] != $divisa['id']) {
                            $divisa_factor = $this->notas_entrega_model->obtenerDivisaAlCambio($factura['ne_divid'], $divisa['id']);
                            if ($divisa_factor) {
                                $factor = $divisa_factor['df_factor'];
                            } else {
                                $this->array_errors[] = 'Lo siento no se encuentra ningun valor de conversión para la moneda que intenta escoger y la moneda en que se realizo la factura';
                            }
                        }

                        if (empty($this->array_errors)) {
                            $total_pagos = $movimiento_model->totalPagos($factura['ne_id'], 1,1);
                            $total = round(($factura['ne_total'] - ($total_pagos['total'] ?? 0)), 2);
                            Http::json_response([
                                'factor'        => $factor,
                                'divisa'        => $divisa,
                                'data_metodos'  => $data_metodos,
                                'restante'      => $total
                            ]);
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerCuentasSegunMetodo($id_metodo_divisa)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_metodo_divisa = filter_var($id_metodo_divisa, FILTER_SANITIZE_NUMBER_INT);

            if (empty($id_metodo_divisa))
                $this->array_errors[] = 'Debe seleccionar un metodo';

            if (empty($this->array_errors)) {
                $data = $this->notas_entrega_model->obtenerCuentasSegunMetodo($id_metodo_divisa);
                if ($data) {
                    Http::json_response($data);
                } else {
                    $this->array_errors[] = 'Lo siento no hay cuentas registradas para este metoto de pago';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function pagar()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax() && $this->module->has_module_action_permission('facturacion', 'pagar', $_SESSION['user_data']['emp_id'])) {
            $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
            $id_divisa          = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_metodo_divisa   = filter_input(INPUT_POST, 'id_metodo_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_cuenta_metodo   = filter_input(INPUT_POST, 'id_cuenta_metodo', FILTER_SANITIZE_NUMBER_INT);
            $monto              = filter_input(INPUT_POST, 'monto', FILTER_SANITIZE_STRING);
            $generar_credito    = ('true' == $_POST['credito']) ? true : false;
            if (empty($id_divisa))
                $this->array_errors[] = 'El campo Divisa el obligatorio.';
            if (empty($id_metodo_divisa))
                $this->array_errors[] = 'El campo Metodo el obligatorio.';
            if (empty($id_cuenta_metodo))
                $this->array_errors[] = 'El campo Cuenta el obligatorio.';
            if (empty($monto))
                $this->array_errors[] = 'El campo Monto el obligatorio.';
            if (!empty($id_factura) && empty($this->array_errors)) {

                $factura    = $this->notas_entrega_model->obtenerFactura($id_factura);

                if ($factura && !$this->facturaFinalizada($factura['ne_id'])) {
                    $result = $this->carritoVentas->pagar('app_notas_de_entrega', $monto, $id_divisa, $id_factura, $generar_credito, $id_cuenta_metodo, $id_metodo_divisa);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                }
            }
            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarPago()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {

            if ($this->module->has_module_action_permission('facturacion', 'eliminar_pagos', $_SESSION['user_data']['emp_id'])) {

                $id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                $id_factura = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);

                if (!empty($id) && !empty($id_factura)) {

                    $factura = $this->notas_entrega_model->obtenerFactura($id_factura);

                    if ($factura['ne_estatus'] == 1) {
                        $this->array_errors[] = 'Lo siento no se puede eliminar el pago ya que la factura a sido cancelada en su totalidad';
                    } else {

                        $movimiento_model = new MovimientoModel();

                        $movimiento = $movimiento_model->abtenerMovimiento($id);

                        if ($movimiento && $factura['ne_id'] == $movimiento['fab_idgenerico']) {

                            if ($movimiento_model->abtenerMovimientoNegativo($id)) {
                                $this->array_errors[] = 'EL pago no se puede eliminar ya que se encuentra en reverso';
                            } else {

                                $cuenta = $this->notas_entrega_model->consultar("SELECT cmp_cueid, cmp_saldo FROM app_cuentas_metodopago WHERE cmp_id = {$movimiento['fab_cmpid']}")->row();
                                $total_saldo_cuenta = $this->notas_entrega_model->consultar("SELECT bc_saldo FROM app_bancos_cuentas WHERE bc_id = {$cuenta['cmp_cueid']}")->row();
                                $divisa_fac_mov = $this->carritoVentas->obtenerDivisa($movimiento['fab_divisa']);
                                $cliente = $this->carritoVentas->obtenerCliente($factura['ne_cliid']);

                                $movimiento_model->editar($movimiento['fab_id'], [
                                    'fab_retiro' => 1,
                                ]);

                                if ($movimiento_model->guardar([
                                    'fab_idgenerico'        => $movimiento['fab_idgenerico'],
                                    'fab_doc'               => 1,
                                    'fab_divisa'            => $movimiento['fab_divisa'],
                                    'fab_metodo'            => $movimiento['fab_metodo'],
                                    'fab_cmpid'             => $movimiento['fab_cmpid'],
                                    'fab_monto'             => $movimiento['fab_monto'] * -1,
                                    'fab_factor'            => $movimiento['fab_factor'],
                                    'fab_conversion'        => $movimiento['fab_conversion'] * -1,
                                    'fab_divid_conversion'  => $movimiento['fab_divid_conversion'],
                                    'fab_factor_master'     => $movimiento['fab_factor_master'],
                                    'fab_idretiro'          => $movimiento['fab_id'],
                                    'fab_retiro'            => 1,
                                    'fab_empid'             => $movimiento['fab_empid'],
                                    'fab_modulo'            => $movimiento['fab_modulo'],
                                    'fab_descripcion'       => '',
                                    'fab_observacion'       => 'Devolución NEV #' . $factura['ne_correlativo'] . ' ' . $cliente['cli_razon_social'] . ' Monto: ' . Moneda::moneda($movimiento['fab_monto'], $divisa_fac_mov['div_locale'], $divisa_fac_mov['div_simbolo']),
                                    'fab_categoria'         => 1,
                                    'fab_saldo_anterior'    => $total_saldo_cuenta['bc_saldo']
                                ])) {

                                    $this->notas_entrega_model->pagoPositivo($cuenta['cmp_cueid'], ($total_saldo_cuenta['bc_saldo'] - $movimiento['fab_monto']));
                                    $tcm = $cuenta['cmp_saldo'] - $movimiento['fab_monto'];
                                    $this->notas_entrega_model->consultar("UPDATE app_cuentas_metodopago SET cmp_saldo = $tcm WHERE cmp_id = {$movimiento['fab_cmpid']}")->run();

                                    $total_pagos = $movimiento_model->totalPagos($factura['ne_id'], 1,1);

                                    $array_abonos = [];
                                    $abonos = $this->notas_entrega_model->abonos($factura['ne_id']);

                                    if (is_countable($abonos) && count($abonos)) {
                                        foreach ($abonos as $row) {
                                            $divisa_mov = $this->carritoVentas->obtenerDivisa($row['fab_divisa']);
                                            $divisa_conv_mov = $this->carritoVentas->obtenerDivisa($row['fab_divid_conversion']);
                                            $array_abonos[] = [
                                                'fab_id'            => $row['fab_id'],
                                                'fab_fecha'         => $row['fecha'],
                                                'bc_alias'          => $row['bc_alias'],
                                                'bc_tipo'           => $row['bc_tipo'],
                                                'fab_retiro'        => $row['fab_retiro'],
                                                'mp_nombre'         => $row['mp_nombre'],
                                                'fab_monto'         => Moneda::moneda($row['fab_monto'], $divisa_mov['div_locale'], $divisa_mov['div_simbolo']),
                                                'fab_factor'        => Moneda::decimal($row['fab_factor'], $this->divisa_master['div_locale']),
                                                'fab_conversion'    => Moneda::moneda($row['fab_conversion'], $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo'])
                                            ];
                                        }
                                    }

                                    Http::json_response([
                                        'abonos'        => $array_abonos,
                                        'total_factura' => $factura['ne_total'],
                                        'restante'      => round(($factura['ne_total'] - $total_pagos['total']), 2),
                                        'total_pagado'  => $total_pagos['total']
                                    ]);
                                }
                            }
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para eliminar los pagos.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function anularFactura()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            if ($this->module->has_module_action_permission('facturacion', 'anular_doc', $_SESSION['user_data']['emp_id'])) {

                $id_factura     = filter_input(INPUT_GET, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
                $descripcion    = filter_input(INPUT_GET, 'descripcion', FILTER_SANITIZE_STRING);

                $factura = $this->notas_entrega_model->obtenerFactura($id_factura);

                if (!$factura) {
                    $this->array_errors[] = 'ACCESO DENEGADO';
                    return Http::json_response(['errors' => $this->array_errors]);
                } else {
                    if ($factura['ne_estatus'] == 3) {
                        $this->array_errors[] = 'La nota de entrega ya se encuentra anulada.';
                    }
                }

                if (empty($this->array_errors)) {

                    $correlativo = $this->carritoVentas->chuequearCorrelativo($factura['ne_serid'], 7);
                    $serie = $this->carritoVentas->obtenerSerie($factura['ne_serid']);

                    if ($correlativo == false) {
                        $this->array_errors[] = "No existe correlativo entre la se serie $serie[ser_descripcion] y el documento Notas de credito por favor dirijase a Modulo Configuración -> correlativos";
                    }

                    if (empty($this->array_errors)) {

                        $new_articulos  = new NotasdeentregaArticulos();
                        $new_movimiento = new MovimientoModel();
                        $new_credito = new Notadecredito();
                        $articulos = $new_articulos->articulos($factura['ne_id']);
                        $movimientos = $new_movimiento->obtenerMovimientosDocumento($factura['ne_id'], 1);
                        $total_pagos = 0;

                        if ($this->notas_entrega_model->editar($factura['ne_id'], [
                            'ne_estatus' => 3,
                            'ne_observaciones' => $factura['ne_observaciones'] . ' (ANULADO ' . $descripcion . ')'
                        ])) {

                            foreach ($articulos as $row) {
                                $almacen  = $this->carritoVentas->obtenerAlmacen($row['neart_almid']);
                                $cantidad_stock = $this->carritoVentas->chuequearStock($row['neart_proid'], $row['neart_almid']);
                                if ($row['neart_descontar_inventario'] > 0 && $this->notas_entrega_model->restablecerStock($row['neart_proid'], $row['neart_almid'], $row['neart_descontar_inventario'])) {
                                    $new_articulos->editar($row['neart_id'], ['neart_descontar_inventario' => 0]);
                                    Notifica::stock($row['neart_proid'], "{$almacen['alm_nombre']}", 'ventas', $cantidad_stock['ps_cantidad'], $row['neart_descontar_inventario'], 0, $cantidad_stock['ps_cantidad'] + $row['neart_descontar_inventario'], $factura['ne_correlativo'], 1);
                                }
                            }

                            if (is_countable($movimientos) && count($movimientos)) {

                                foreach ($movimientos as $row) {
                                    if ($row['fab_divisa'] == $this->divisa_master['div_id']) {
                                        $total_pagos += $row['fab_monto'];
                                    } else {
                                        $total_pagos += $row['fab_monto'] / $row['fab_factor_master'];
                                    }
                                }

                                if ($new_credito->guardar([
                                    'cre_cliid'         => $factura['ne_cliid'],
                                    'cre_facid'         => $factura['ne_id'],
                                    'cre_docid'         => 1,
                                    'cre_empleado'      => $_SESSION['user_data']['emp_id'],
                                    'cre_modulo'        => 'NEV',
                                    'cre_descripcion'   => $descripcion,
                                    'cre_correlativo'   => $correlativo['cor_correlativo'] + 1,
                                    'cre_monto'         => $total_pagos
                                ], true)) {
                                    $this->carritoVentas->actualizarCorrelativo($serie['ser_id'], 7, ($correlativo['cor_correlativo'] + 1));
                                }
                            }

                            return Http::json_response(ruta_base() . 'notasdeentregacajaeditar/verFactura/' . $id_factura);
                        } else {
                            Http::json_response(false);
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para anular el documento.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function imprimir()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_GET['id_factura']) && !empty($_GET['impresora'])) {

                $id_factura     = $this->solicitud->sanitize($_GET['id_factura'], FILTER_VALIDATE_INT);
                $id_impresora   = $this->solicitud->sanitize($_GET['impresora'], FILTER_VALIDATE_INT);

                if ($id_factura && $id_impresora) {
                    if ($this->notas_entrega_model->existe('ne_id', $id_factura)) {
                        Http::json_response($this->carritoVentas->imprimir('app_notas_de_entrega', $id_factura, $id_impresora));
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerCreditos(int $id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_cliente = $this->solicitud->sanitize($id_cliente, FILTER_SANITIZE_NUMBER_INT);

            $newNotaDeCredito = new Notadecredito();
            $newNotadeCreditoDetalles = new NotadeCreditoDetalles();

            $lista_creditos = [];

            $creditos = $newNotaDeCredito->obtenerCreditosClientes($id_cliente);

            if (is_countable($creditos) && count($creditos)) {
                foreach ($creditos as $row) {
                    $total_credito = $newNotadeCreditoDetalles->obtenerTotalPagosCreditos($row['cre_id']);
                    $lista_creditos[] = [
                        'id' => $row['cre_id'],
                        'monto' => $row['cre_monto'] - ($total_credito['total']) ?? 0
                    ];
                }
            }

            Http::json_response($lista_creditos);
        }
    }

    public function pagarConCredito()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax() && (!empty($_GET['id_fac']) && !empty($_GET['id_credito']))) {
            $newCreditoaPagos = new Notadecredito();
            $newNotadeCreditoDetalles = new NotadeCreditoDetalles();
            $movimiento_model = new MovimientoModel();
            $id_factura = $this->solicitud->sanitize($_GET['id_fac'], FILTER_SANITIZE_NUMBER_INT);
            $id_credito = $this->solicitud->sanitize($_GET['id_credito'], FILTER_SANITIZE_NUMBER_INT);
            $factura    = $this->notas_entrega_model->obtenerFactura($id_factura);
            if ($this->facturaFinalizada($factura['ne_id'])) {
                Http::json_response('pagado');
            } else {

                $factor_master = 1;
                $factor_factura = 1;

                $data_credito = $newCreditoaPagos->obtener($id_credito);
                $total_credito = $newNotadeCreditoDetalles->obtenerTotalPagosCreditos($data_credito['cre_id']);
                $total_disponible = $data_credito['cre_monto'] - ($total_credito['total']) ?? 0;
                $cliente = $this->carritoVentas->obtenerCliente($factura['ne_cliid']);
                $total_pagos = $movimiento_model->totalPagos($id_factura, 1,1);
                $restante = $factura['ne_total'] - $total_pagos['total'] ?? 0;

                if ($factura['ne_divid'] != $this->divisa_master['div_id']) {
                    $factor = $this->notas_entrega_model->obtenerDivisaAlCambio($factura['ne_divid'], $this->divisa_master['div_id']);
                    if (!$factor) {
                        $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa de la factura y la divisa predeterminada.';
                    } else {
                        $total_disponible = round(($total_disponible / $factor['df_factor']), 2);
                    }
                    $data_factor_factura = $this->notas_entrega_model->obtenerDivisaAlCambio($this->divisa_master['div_id'], $factura['ne_divid']);
                    if (!$data_factor_factura) {
                        $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa predeterminada y la divisa en que se registró la factura.';
                    } else {
                        $factor_factura = $data_factor_factura['df_factor'];
                        $factor_master = $data_factor_factura['df_factor'];
                    }
                }

                if (empty($this->array_errors)) {

                    if ($total_disponible > round($restante, 2)) {
                        $monto = $restante;
                    } else {
                        $monto = $total_disponible;
                    }

                    $conversion = $monto / $factor_factura;

                    $id_movimiento = $movimiento_model->guardar([
                        'fab_idgenerico'        => $factura['ne_id'],
                        'fab_doc'               => 1,
                        'fab_monto'             => $conversion,
                        'fab_factor'            => $factor_factura,
                        'fab_conversion'        => $monto,
                        'fab_retiro'            => 0,
                        'fab_factor_master'     => $factor_master,
                        'fab_empid'             => $_SESSION['user_data']['emp_id'],
                        'fab_modulo'            => 'notas de entrega',
                        'fab_descripcion'       => '',
                        'fab_observacion'       => 'Pago con saldo Credito en NEV #' . $factura['ne_correlativo'] . ' ' . $cliente['cli_razon_social'] . ' Monto: ' . Moneda::moneda($monto, $this->divisa_master['div_locale'], $this->divisa_master['div_simbolo']),
                        'fab_credito'           => 1,
                        'fab_categoria'         => 1
                    ]);

                    if ($id_movimiento) {

                        $newNotadeCreditoDetalles->guardar([
                            'credet_movid' => $id_movimiento,
                            'credet_creid' => $data_credito['cre_id'],
                            'credet_idfac' => $factura['ne_id'],
                            'credet_docid' => 1,
                            'credet_monto' => $conversion,
                            'credet_descripcion' => "Pago con nota de credito #{$data_credito['cre_correlativo']} por el monto de $monto",
                            'credet_empid' => $_SESSION['user_data']['einfo_id'],
                            'credet_modulo' => 'NEV'
                        ]);

                        $total_credito = $newNotadeCreditoDetalles->obtenerTotalPagosCreditos($data_credito['cre_id']);

                        if (round($data_credito['cre_monto'], 2) == round($total_credito['total'], 2)) {
                            $newCreditoaPagos->editar($data_credito['cre_id'], [
                                'cre_estatus' => 1
                            ]);
                        }

                        $pagado = false;

                        if ($this->facturaFinalizada($factura['ne_id'])) {
                            $this->notas_entrega_model->culminarFactura($id_factura);
                            $pagado = true;
                        }

                        $factura = $this->notas_entrega_model->obtenerFactura($id_factura);

                        $array_abonos = [];

                        $total_pagos = $movimiento_model->totalPagos($factura['ne_id'], 1,1);
                        $abonos = $this->notas_entrega_model->abonos($factura['ne_id']);

                        if (is_countable($abonos) && count($abonos)) {

                            foreach ($abonos as $row) {

                                if (is_null($row['fab_divisa'])) {
                                    $divisa_mov = $this->divisa_master;
                                } else {
                                    $divisa_mov = $this->carritoVentas->obtenerDivisa($row['fab_divisa']);
                                }

                                if (is_null($row['fab_divid_conversion'])) {
                                    $divisa_conv_mov = $this->divisa_master;
                                } else {
                                    $divisa_conv_mov = $this->carritoVentas->obtenerDivisa($row['fab_divid_conversion']);
                                }

                                if (is_null($row['fab_factor'])) {
                                    $row['fab_factor'] = 1;
                                }

                                $array_abonos[] = [
                                    'fab_id'            => $row['fab_id'],
                                    'fab_fecha'         => $row['fecha'],
                                    'bc_alias'          => $row['bc_alias'],
                                    'bc_tipo'           => $row['bc_tipo'],
                                    'fab_retiro'        => $row['fab_retiro'],
                                    'mp_nombre'         => $row['mp_nombre'],
                                    'fab_monto'         => Moneda::moneda($row['fab_monto'], $divisa_mov['div_locale'], $divisa_mov['div_simbolo']),
                                    'fab_factor'        => Moneda::decimal($row['fab_factor'], $this->divisa_master['div_locale']),
                                    'fab_conversion'    => Moneda::moneda($row['fab_conversion'], $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo']),
                                    'credito'           => $row['fab_credito']
                                ];
                            }
                        }

                        Http::json_response([
                            'abonos'        => $array_abonos,
                            'total_factura' => round($factura['ne_total'], 2),
                            'pagado'        => $pagado,
                            'restante'      => round(($factura['ne_total'] - $total_pagos['total']), 2),
                            'total_pagado'  => round($total_pagos['total'], 2)
                        ]);
                    }
                } else {
                    Http::json_response(['errors' => $this->array_errors]);
                }
            }
        }
    }

    public function obtenerFactor()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax() && (!empty($_GET['id_factura']) && !empty($_GET['id_credito']))) {
            $id_factura = $this->solicitud->sanitize($_GET['id_factura'], FILTER_VALIDATE_INT);
            $id_credito = $this->solicitud->sanitize($_GET['id_credito'], FILTER_VALIDATE_INT);
            if ($this->notas_entrega_model->existe('ne_id', $id_factura)) {

                $data_factura = $this->notas_entrega_model->obtener($id_factura);
                $newCreditoa = new Notadecredito();
                $newNotadeCreditoDetalles = new NotadeCreditoDetalles();

                $data_credito = $newCreditoa->obtener($id_credito);
                $total_credito = $newNotadeCreditoDetalles->obtenerTotalPagosCreditos($data_credito['cre_id']);
                $total_disponible = $data_credito['cre_monto'] - ($total_credito['total']) ?? 0;

                if ($data_factura['ne_divid'] != $this->divisa_master['div_id']) {
                    $factor = $this->notas_entrega_model->obtenerDivisaAlCambio($data_factura['ne_divid'], $this->divisa_master['div_id']);
                    if (!$factor) {
                        $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa predeterminada y la divisa en que se registró la factura.';
                    } else {
                        $total_disponible = round(($total_disponible / $factor['df_factor']), 2);
                    }
                }

                if (empty($this->array_errors)) {
                    Http::json_response($total_disponible);
                } else {
                    Http::json_response(0);
                }
            }
        }
    }

    public function obtenerubicacionProductos(int $id_factura)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id_factura = filter_var($id_factura, FILTER_SANITIZE_NUMBER_INT);
            Http::json_response($this->carritoVentas->obtenerUbicacionesProducto('needitar', $id_factura));
        }
    }

    public function autorizarDescuentoProducto()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['empleado']))
                $this->array_errors[] = 'El empleado es obligatorio';
            if (empty($_POST['clave']))
                $this->array_errors[] = 'La clave es obligatorio';
            if (empty($_POST['id_factura']))
                $this->array_errors[] = 'Acción prohibida';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'Acción prohibida';

            if (empty($this->array_errors)) {

                $id_factura = filter_var($_POST['id_factura'], FILTER_VALIDATE_INT);
                $descuento = filter_var($_POST['descuento'], FILTER_SANITIZE_STRING);
                $descuento_global = filter_var($_POST['descuento_global'], FILTER_SANITIZE_STRING);
                $empleado = $this->solicitud->sanitize($_POST['empleado'], FILTER_SANITIZE_STRING);
                $clave = $this->solicitud->sanitize($_POST['clave'], FILTER_SANITIZE_STRING);
                $unique = $_POST['unique'];

                if (!$id_factura)
                    $this->array_errors[] = 'Acción prohibida';
                if (!$descuento)
                    $this->array_errors[] = 'El descuento debe ser de tipo numerico';

                if (empty($this->array_errors)) {

                    $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    $cliente = $this->carritoVentas->obtenerCliente($factura['ne_cliid']);

                    if ($factura) {

                        $empleado_model = new Empleado();
                        $usuario = $empleado_model->getUserInfo($empleado);

                        if (!isset($usuario['emp_id'])) {
                            $this->array_errors[] = 'Usuario no encontrado';
                        } else {
                            if (!Seguridad::verificar($clave, $usuario['emp_password'])) {
                                $this->array_errors[] = 'Clave incorrecta';
                            }
                        }

                        if (empty($this->array_errors)) {
                            $result = $this->carritoVentas->aplicarDescuentoProducto('needitar', $id_factura, $cliente['cli_id'], $unique, $descuento, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function guardarCredito()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] =  'El campo Factura es obligatorio.';
            if (empty($_POST['monto']))
                $this->array_errors[] =  'El campo Monto es obligatorio.';
            if (empty($_POST['id_divisa']))
                $this->array_errors[] =  'El campo Divisa es obligatorio';
            if (empty($_POST['id_metodo_divisa']))
                $this->array_errors[] =  'El campo Metodo es obligatorio';
            if (empty($_POST['id_cuenta_metodo']))
                $this->array_errors[] =  'El campo Cuenta es obligatorio';
            if (empty($_POST['id_serie']))
                $this->array_errors[] =  'El campo Serie es obligatorio';

            if (empty($this->array_errors)) {

                $id_factura = $_POST['id_factura'];
                $id_cuenta_metodo = $_POST['id_cuenta_metodo'];
                $observacion = $_POST['observacion'];
                $id_serie = $_POST['id_serie'];

                $monto = $this->solicitud->sanitize($_POST['monto'], FILTER_SANITIZE_STRING);

                $result = $this->carritoVentas->guardarCredito('app_notas_de_entrega', $id_factura, $monto, $id_cuenta_metodo, $id_serie, $observacion);

                if (isset($result['errors'])) {
                    return Http::json_response(['errors' => $result['errors']]);
                } else {
                    return Http::json_response($result);
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }
}
