<?php

namespace App\Controladores;

use App\Modelos\EmpleadoAgente;
use App\Modelos\Convertirdocumento;
use App\Modelos\EmpleadoInfo;
use App\Modelos\EmpleadoSucursales;
use Core\Controller;
use Core\Librerias\CarritoVentas;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Vista;

final class NotasdeentregaControlador extends Controller
{
    private $array_errors = [];
    private $carritoVentas;
    private $module;

    public function __construct()
    {
        parent::__construct();
        $this->carritoVentas = new CarritoVentas();
        $this->module = new Module('facturacion');
    }

    public function nuevaFactura(int $id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD']) {

            $id_cliente = filter_var($id_cliente, FILTER_SANITIZE_NUMBER_INT);

            $tab_id = 0;
            if (isset($_GET['tab'])) {
                $tab_id = $this->solicitud->sanitize($_GET['tab'], FILTER_SANITIZE_NUMBER_INT);
            }
            $cliente = $this->carritoVentas->obtenerCliente($id_cliente);
            $_SESSION["ne$cliente[cli_id]"] = null;

            if ($cliente) {
                return Vista::view('notasdeentrega/index', [
                    'doc_pendientes'        => $this->carritoVentas->totalDocumentosPendientes($id_cliente),
                    'total_doc_pendientes'  => $this->carritoVentas->obtenerDocumentosPendientesPorPagarPorCliente($id_cliente),
                    'cliente'               => $cliente,
                    'empresa'               => $this->carritoVentas->obtenerDatosEmpresa(),
                    'tipos_de_documentos'   => $this->carritoVentas->obternerTiposDeDocumentos(),
                    'impuestos'             => $this->carritoVentas->obtenerImpuestos(),
                    'paises'                => $this->carritoVentas->obtenerPaises(),
                    'almacenes'             => $this->carritoVentas->obtenerAlmacenesEmpleado(),
                    'series'                => $this->carritoVentas->obtenerSeriesEmpleado(),
                    'empleados_agentes'     => $this->carritoVentas->obtenerAgentesdeVenta(),
                    'divisas'               => $this->carritoVentas->obtenerDivisasParaFacturar(),
                    'total_costo'           => $this->module->has_module_action_permission('facturacion', 'total_costo', $_SESSION['user_data']['emp_id']),
                    'servicio'              => $tab_id
                    
                ]);
            } else {
                header('Location: ' . ruta_base() . 'facturacion');
            }
        }
    }

    public function buscarProducto()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_GET['divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';
            if (empty($_GET['almacen']))
                $this->array_errors[] = 'El almacen es obligatorio';

            if (empty($this->array_errors)) {

                $id_divisa      = filter_input(INPUT_GET, 'divisa', FILTER_VALIDATE_INT);
                $id_almacen     = filter_input(INPUT_GET, 'almacen', FILTER_VALIDATE_INT);
                $producto       = $this->solicitud->sanitize($_GET['buscar'], FILTER_SANITIZE_STRING);

                $result = $this->carritoVentas->buscarProducto($producto, $id_divisa, $id_almacen);
                if (isset($result['errors'])) {
                    return Http::json_response(['errors' => $result['errors']]);
                } else {
                    return Http::json_response($result);
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function predeterminarDivisa()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_GET['id_cliente']))
                $this->array_errors[] = 'El Cliente es obligatorio';
            if (empty($_GET['id_divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';

            if (empty($this->array_errors)) {

                $id_divisa          = filter_input(INPUT_GET, 'id_divisa', FILTER_VALIDATE_INT);
                $id_cliente         = filter_input(INPUT_GET, 'id_cliente', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_GET, 'descuento', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_cliente && $id_divisa) {
                    $result = $this->carritoVentas->predeterminarDivisa('ne', $id_cliente, $id_divisa, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function cambiarAlmacen(int $id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $_SESSION["ne$id_cliente"] = null;
            Http::json_response(true);
        } else {
            Http::json_response(false);
        }
    }

    public function agregarProductoBarcode()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_cliente']))
                $this->array_errors[] = 'El Cliente es obligatorio';
            if (empty($_POST['producto']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['id_almacen']))
                $this->array_errors[] = 'El Almacen es obligatorio';
            if (empty($_POST['id_divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';

            if (empty($this->array_errors)) {

                $id_cliente         = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $producto           = filter_input(INPUT_POST, 'producto', FILTER_SANITIZE_STRIPPED);
                $id_almacen         = filter_input(INPUT_POST, 'id_almacen', FILTER_VALIDATE_INT);
                $id_divisa          = filter_input(INPUT_POST, 'id_divisa', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_cliente && $id_almacen && $id_divisa) {
                    $result = $this->carritoVentas->agregarProductoBarcode('app_notas_de_entrega', 'ne', $id_cliente, $producto, $id_almacen, $id_divisa, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function agregarProducto()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_cliente']))
                $this->array_errors[] = 'El Cliente es obligatorio';
            if (empty($_POST['id_producto']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['id_almacen']))
                $this->array_errors[] = 'El Almacen es obligatorio';
            if (empty($_POST['id_divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';

            if (empty($this->array_errors)) {

                $id_cliente         = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $id_producto        = filter_input(INPUT_POST, 'id_producto', FILTER_VALIDATE_INT);
                $id_almacen         = filter_input(INPUT_POST, 'id_almacen', FILTER_VALIDATE_INT);
                $id_divisa          = filter_input(INPUT_POST, 'id_divisa', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_cliente && $id_producto && $id_almacen && $id_divisa) {
                    $result = $this->carritoVentas->agregarProducto('app_notas_de_entrega', 'ne', $id_cliente, $id_producto, $id_almacen, $id_divisa, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function actualizarPrecio()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_cliente']))
                $this->array_errors[] = 'El Cliente es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';

            if (empty($this->array_errors)) {

                $id_cliente         = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRIPPED);
                $precio             = filter_input(INPUT_POST, 'precio', FILTER_SANITIZE_STRING) ?? 0;
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_cliente) {
                    $result = $this->carritoVentas->actualizarPrecio('ne', $id_cliente, $unique, $precio, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function actualizarCantidad()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_cliente']))
                $this->array_errors[] = 'El Cliente es obligatorio';
            if (empty($_POST['id_producto']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['cantidad']))
                $this->array_errors[] = 'El Cantidad es obligatorio';

            if (empty($this->array_errors)) {

                $id_cliente         = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $id_producto        = filter_input(INPUT_POST, 'id_producto', FILTER_VALIDATE_INT);
                $cantidad           = filter_input(INPUT_POST, 'cantidad', FILTER_VALIDATE_FLOAT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_cliente && $id_producto && $cantidad) {
                    $result = $this->carritoVentas->actualizarCantidad('ne', $id_cliente, $id_producto, $cantidad, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function actualizarDescripcion()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_cliente']))
                $this->array_errors[] = 'El Cliente es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['descripcion']))
                $this->array_errors[] = 'La Desceipción es obligatorio';

            if (empty($this->array_errors)) {

                $id_cliente         = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRING);
                $descripcion        = $this->solicitud->sanitize($_POST['descripcion'], FILTER_SANITIZE_STRING);

                if ($id_cliente) {
                    $result = $this->carritoVentas->actualizarDescripcion('ne', $id_cliente, $unique, $descripcion);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function aplicarNuevoIva()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_cliente']))
                $this->array_errors[] = 'El Cliente es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['id_iva']))
                $this->array_errors[] = 'El IVA es obligatorio';

            if (empty($this->array_errors)) {

                $id_cliente         = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRIPPED);
                $id_iva             = filter_input(INPUT_POST, 'id_iva', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_cliente && $id_iva) {
                    $result = $this->carritoVentas->aplicarNuevoIva('ne', $id_cliente, $unique, $id_iva, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function aplicarDescuentoProducto()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_cliente']))
                $this->array_errors[] = 'El Cliente es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';

            if (empty($this->array_errors)) {

                $id_cliente         = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRIPPED);
                $descuento          = filter_input(INPUT_POST, 'descuento', FILTER_SANITIZE_STRING) ?? 0;
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_cliente) {
                    $result = $this->carritoVentas->aplicarDescuentoProducto('ne', $id_cliente, $unique, $descuento, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function aplicarDescuentoAdicional()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_cliente'])) {
                $this->array_errors[] = 'El Cliente es obligatorio';
            } else {

                $id_cliente = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $descuento_global = filter_input(INPUT_POST, 'descuento', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_cliente) {
                    $result = $this->carritoVentas->aplicarDescuentoAdicional('ne', $id_cliente, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarProducto()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_cliente']))
                $this->array_errors[] = 'El Cliente es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';

            if (empty($this->array_errors)) {

                $id_cliente         = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRING);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_cliente) {
                    $result = $this->carritoVentas->eliminarProducto('ne', $id_cliente, $unique, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function guardarDetallesCliente()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['cli_tipodoc']))
                $this->array_errors[] = 'El campo Cedula de identidad es obligatorio';
            if (empty($_POST['cli_dni']))
                $this->array_errors[] = 'El campo Tipo de documento es obligatorio';
            if (empty($_POST['cli_razon_social']))
                $this->array_errors[] = 'El campo Razón social es obligatorio';
            if (empty($_POST['cli_direccion']))
                $this->array_errors[] = 'El campo Dirección es obligatorio';

            if (empty($this->array_errors)) {

                $cli_id             = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                $cli_tipodoc        = filter_input(INPUT_POST, 'cli_tipodoc', FILTER_SANITIZE_NUMBER_INT);
                $cli_dni            = filter_input(INPUT_POST, 'cli_dni', FILTER_SANITIZE_STRING);
                $cli_nombres        = $this->solicitud->sanitize($_POST['cli_razon_social'], FILTER_SANITIZE_STRING);
                $cli_direccion      = $this->solicitud->sanitize($_POST['cli_direccion'], FILTER_SANITIZE_STRING);
                $cli_pais           = filter_input(INPUT_POST, 'cli_paisid', FILTER_SANITIZE_NUMBER_INT);
                $cli_estado         = $this->solicitud->sanitize($_POST['cli_estado'], FILTER_SANITIZE_STRING);
                $cli_ciudad         = $this->solicitud->sanitize($_POST['cli_ciudad'], FILTER_SANITIZE_STRING);
                $cli_codigopostal   = filter_input(INPUT_POST, 'cli_codigopostal', FILTER_SANITIZE_STRING);

                $result = $this->carritoVentas->editarDetallesCliente($cli_id, [
                    'cli_tipodocid'     => $cli_tipodoc,
                    'cli_dni'           => $cli_dni,
                    'cli_razon_social'  => $cli_nombres,
                    'cli_direccion'     => $cli_direccion,
                    'cli_paisid'        => $cli_pais,
                    'cli_estado'        => $cli_estado,
                    'cli_ciudad'        => $cli_ciudad,
                    'cli_codpostal'     => $cli_codigopostal
                ]);

                if (isset($result['errors'])) {
                    return Http::json_response(['errors' => $result['errors']]);
                } else {
                    return Http::json_response($result);
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerubicacionProductos(int $id_cliente)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id_cliente = filter_var($id_cliente, FILTER_SANITIZE_NUMBER_INT);
            Http::json_response($this->carritoVentas->obtenerUbicacionesProducto('ne', $id_cliente));
        }
    }

    public function obtenerSucursalesEmpleado()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $empleado_sucursales = new EmpleadoSucursales();
            $suc = $empleado_sucursales->obtenerSucursales($_SESSION['user_data']['emp_id']);

            $ID = '';
            foreach ($suc as $row) {
                if ($row['sucursal_predeterminado'] == 1) {
                    $ID = $row['sucursal_id'];
                }
            }

            if($ID=="" && count($suc)>0){
                $ID = $suc[0]['empalm_almid'];
            }

            Http::json_response([
                'sucursales' => $suc,
                'id' => ($_SESSION['sucursal']['id'] != 0) ? $_SESSION['sucursal']['id'] : $ID,
                'desactivar' => ($_SESSION['sucursal']['id'] != 0) ? true : false
            ]);
        }
    }

    public function obtenerSeriesAlmacenesEmpleado(int $sucursales)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $sucursales = filter_var($sucursales, FILTER_SANITIZE_NUMBER_INT);

            $series = $this->carritoVentas->obtenerSeriesEmpleadoSucursales($sucursales);
            $almacenes = $this->carritoVentas->obtenerAlmacenesEmpleadoSucursales($sucursales);

            $idser = '';
            foreach ($series as $row) {
                if ($row['empser_predeterminado'] == 1) {
                    $idser = $row['empser_serid'];
                }
            }

            $idalm = '';
            foreach ($almacenes as $row) {
                if ($row['empalm_predeterminado'] == 1) {
                    $idalm = $row['empalm_almid'];
                }
            }

            if($idalm=="" && count($almacenes)>0){
                $idalm = $almacenes[0]['empalm_almid'];
            }

            if($idser=="" && count($series)>0){
                $idser = $series[0]['empser_serid'];
            }

            Http::json_response([
                'series' => $series,
                'id_ser' => $idser,
                'almacenes' => $almacenes,
                'id_alm' => $idalm
            ]);
        }
    }

    public function chequearAgente()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {

            $id_cliente = filter_input(INPUT_POST, 'id_cliente', FILTER_SANITIZE_NUMBER_INT);
            $id_agente = filter_input(INPUT_POST, 'id_agente', FILTER_SANITIZE_NUMBER_INT);
            $factura = filter_input(INPUT_POST, 'factura', FILTER_SANITIZE_NUMBER_INT);

            $newAgent = new EmpleadoAgente();

            $agent = $newAgent->consultar("SELECT * FROM app_empleados_agentes WHERE empagent_empid = {$id_agente} AND empagent_clientid = {$id_cliente} AND empagent_docid={$factura} AND empagent_tipo=1")->row();

            if (!$agent && $newAgent->guardar([
                'empagent_empid' => $id_agente,
                'empagent_clientid'  => $id_cliente,
                'empagent_captado' => '',
                'empagent_tipo' => 1,
                'empagent_docid' => $factura
            ], true)) {
                Http::json_response(true);
            } else {
                Http::json_response(false);
            }
        }
    }

    public function ventaEnEspera()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {

            if (empty($_POST['id_serie']))
                $this->array_errors[] = 'El campo Serie es obligatorio.';
            if (empty($_POST['id_sucursal']))
                $this->array_errors[] = 'El campo Sucursal es obligatorio.';
            if (empty($_POST['fecha']))
                $this->array_errors[] = 'Debe seleccionar una fecha.';
            if (empty($_POST['id_cliente']))
                $this->array_errors[] = 'Acción prohibida, seleccione el cliente.';

            if (empty($this->array_errors)) {

                $id_cliente         = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $id_serie           = filter_input(INPUT_POST, 'id_serie', FILTER_VALIDATE_INT);
                $id_sucursal        = filter_input(INPUT_POST, 'id_sucursal', FILTER_VALIDATE_INT);
                $agente             = filter_input(INPUT_POST, 'agente', FILTER_VALIDATE_INT);
                $desci              = ('true' == filter_input(INPUT_POST, 'descontar_inventario')) ? true : false;
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;
                $fecha              = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
                $observaciones      = filter_input(INPUT_POST, 'observaciones', FILTER_SANITIZE_STRING) ?? '';
                $id_tab             = filter_input(INPUT_POST, 'id_tab', FILTER_VALIDATE_INT);

                if (constant('EMP_FIGURA_AGENTE')) {
                    if (!$agente) {
                        $this->array_errors[] = 'Datos incorrectos, seleccione un agente.';
                    }
                }

                $convertir_model = new Convertirdocumento();

                $documento  = $convertir_model->obtenerDocumento(1);
                $modulo_origen  = $convertir_model->obtenerDocumento(13);

                if ($id_tab > 0) {
                    if (!$documento || !$modulo_origen) {
                        $this->array_errors[] = 'El documento no esta configurado dirijase a Modulo Configuración -> Documentos';
                    }
                }

                if (!$id_cliente || !$id_serie)
                    $this->array_errors[] = 'Datos incorrectos';

                if (empty($this->array_errors)) {

                    $result = $this->carritoVentas->guardarVenta('app_notas_de_entrega', 'ne', $id_cliente, $id_serie, $id_sucursal, $fecha, $observaciones, $desci, $agente, $descuento_global);

                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {

                        $_SESSION["ne$id_cliente"] = null;

                        if ($id_tab > 0) {

                            $ultima_nota = $this->carritoVentas->obtenerUltimaNota();

                            $convertir_model->guardar([
                                'rd_facid_procedencia'  => $id_tab,
                                'rd_docid_procedencia'  => 13,
                                'rd_facid_conversion'   => $ultima_nota['ultimo'],
                                'rd_docid_conversion'   => $documento['doc_id'],
                                'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                            ], true, 'app_ruta_documento');
                        }

                        if (constant('EMP_FIGURA_AGENTE')) {
                            $ultima_nota = $this->carritoVentas->obtenerUltimaNota();

                            $newAgent = new EmpleadoAgente();
                            $agent = $newAgent->consultar("SELECT * FROM app_empleados_agentes WHERE empagent_empid = {$agente} AND empagent_clientid = {$id_cliente} AND empagent_docid={$documento['doc_id']} AND empagent_tipo=1")->row();

                            if (!$agent) {

                                $newAgent->guardar([
                                    'empagent_empid' => $agente,
                                    'empagent_clientid'  => $id_cliente,
                                    'empagent_captado' => '',
                                    'empagent_tipo' => 1,
                                    'empagent_docid' => $ultima_nota['ultimo']
                                ]);
                            }
                            return Http::json_response($result);
                        } else {
                            return Http::json_response($result);
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function nombreDivisa($id)
    {
        $divisa = $this->carritoVentas->obtenerDivisa($id);
        Http::json_response($divisa['div_nombre']);
    }

    public function nombreAlmacen($id)
    {
        $almacen = $this->carritoVentas->obtenerAlmacen($id);
        Http::json_response($almacen['alm_nombre']);
    }

    public function obtenerAgenteCliente(int $id)
    {
        $new_agente = new EmpleadoInfo();

        if ($new_agente->existe('einfo_id', $id)) {

            $agente = $new_agente->obtener($id);

            Http::json_response($agente);
        } else {
            Http::json_response(false);
        }
    }
}
