<div class="container" id="appMiPerfil" v-cloak>
	<div class="page-inner">
		<div class="page-header">
			<h4 class="page-title">Perfil</h4>
			<ul class="breadcrumbs">
				<li class="nav-home">
					<a href="<?= ruta_base() ?>">
						<i class="flaticon-home"></i>
					</a>
				</li>
				<li class="separator">
					<i class="flaticon-right-arrow"></i>
				</li>
				<li class="nav-item">
					<a href="<?= url('miperfil') ?>">{{ dataForm.nombres }} {{ dataForm.apellidos }}</a>
				</li>
			</ul>
		</div>
		<div class="row">
			<div class="col-md-12">
				<div class="card">
					<div class="card-body">
						<ul class="nav nav-pills nav-secondary" id="pills-tab" role="tablist">
							<li class="nav-item">
								<a class="nav-link active" data-toggle="pill" href="#home" role="tab" aria-controls="home" aria-selected="true">Datos Basicos</a>
							</li>
							<li class="nav-item">
								<a class="nav-link" data-toggle="pill" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Usuario</a>
							</li>
							<li class="nav-item">
								<a class="nav-link" data-toggle="pill" href="#tab_clients" role="tab" aria-controls="tab_clients" aria-selected="false">Clientes</a>
							</li>
							<li class="nav-item">
								<a class="nav-link" data-toggle="pill" href="#tab_comisiones" role="tab" aria-controls="tab_comisiones" aria-selected="false">Comisiones</a>
							</li>
							<li class="nav-tem" v-if="dataFormUser.autenticacion==true">
								<a class="nav-link" data-toggle="pill" href="#tab_google" role="tab" aria-controls="tab_google" aria-selected="false">Seguridad con google</a>
							</li>
						</ul>
						<div class="tab-content mt-3">
							<div class="tab-pane active show mb-3" id="home">
								<div class="row">
									<div class="col-12">
										<form @submit.prevent="editarInfo" autocomplete="off">
											<div class="form-row">
												<div class="col">
													<div class="form-group form-group-default">
														<label for="einfo_nombres">Nombres:</label>
														<input type="text" id="einfo_nombres" class="form-control" v-model="dataForm.nombres">
													</div>
												</div>
												<div class="col">
													<div class="form-group form-group-default">
														<label for="einfo_apellidos">Apellidos:</label>
														<input type="text" id="einfo_apellidos" class="form-control" v-model="dataForm.apellidos">
													</div>
												</div>
												<div class="col">
													<div class="form-group form-group-default">
														<label for="einfo_telefono_movil">Telefono:</label>
														<input type="tel" id="einfo_telefono_movil" class="form-control" v-model="dataForm.telefono" v-mask="'(####) ###-####'">
													</div>
												</div>
												<div class="col">
													<div class="form-group form-group-default">
														<label for="einfo_email">Correo electronico:</label>
														<input type="email" id="einfo_email" class="form-control" v-model="dataForm.correo">
													</div>
												</div>
											</div>
											<div class="form-group form-group-default">
												<label for="einfo_direccion_1">Direccion:</label>
												<input type="text" id="einfo_direccion_1" class="form-control" v-model="dataForm.direccion_uno">
											</div>
											<div class="form-row">
												<div class="col-6">
													<div class="form-group form-group-default">
														<label for="einfo_direccion_2">Referencia:</label>
														<input type="text" id="einfo_direccion_2" class="form-control" v-model="dataForm.direccion_dos">
													</div>
												</div>
												<div class="col">
													<div class="form-group form-group-default">
														<label for="einfo_ciudad">Ciudad:</label>
														<input type="text" id="einfo_ciudad" class="form-control" v-model="dataForm.ciudad">
													</div>
												</div>
												<div class="col">
													<div class="form-group form-group-default">
														<label for="einfo_estado">Estado:</label>
														<input type="text" id="einfo_estado" class="form-control" v-model="dataForm.estado">
													</div>
												</div>
											</div>
											<div class="row">
												<div class="col-12">
													<div class=" alert alert-warning" role="alert" v-for="row in errorForm">
														{{ row }}
													</div>
												</div>
											</div>
											<div class="form-row">
												<div class="col">
													<button type="submit" class="btn btn-primary  btn-sm"><i class="fas fa-save"></i> Actualizar</button>
												</div>
											</div>
										</form>
									</div>
								</div>
							</div>
							<div class="tab-pane mb-3" id="profile">
								<div class="row">
									<div class="col-6">
										<form autocomplete="off" @submit.prevent="editarUsuario">
											<div class="form-group form-group-default">
												<label for="username">Usuario</label>
												<div class="col-md-8">
													<input id='emp_username' class='form-control form-inps' v-model="dataFormUser.nombre">
												</div>
											</div>
											<div class="form-group form-group-default">
												<label for="emp_password">Contraseña</label>
												<div class="col-md-8">
													<input type="password" id='emp_password' class='form-control form-inps' v-model="dataFormUser.password">
												</div>
											</div>
											<div class="form-group form-group-default">
												<label for="repeat_password">Re-contraseña</label>
												<div class="col-md-8">
													<input type="password" id='repeat_password' class='form-control form-inps' v-model="dataFormUser.repassword">
												</div>
											</div>
											<div class="form-row">
												<div class="col-11">
													<div class="form-check">
														<label class="form-check-label">
															<input class="form-check-input" type="checkbox" v-model="dataFormUser.autenticacion">
															<span class="form-check-sign">Seguridad con APP GOOGLE</span>
														</label>
													</div>
												</div>
											</div>
											<div class="row">
												<div class="col-12">
													<div class=" alert alert-warning" role="alert" v-for="row in errorForm">
														{{ row }}
													</div>
												</div>
											</div>
											<div class="form-row">
												<div class="col">
													<button type="submit" class="btn btn-primary  btn-sm"> Actualizar</button>
												</div>
											</div>
										</form>
									</div>
									<div class="col-md-6 d-flex justify-content-center">
										<div class="input-file input-file-image" :class="upload_imagen">
											<img class="img-upload-preview img-circle" :src="ruta_imagen" width="150" height="150">

											<input type="file" class="form-control form-control-file" id="imagen" accept="image/*" required="" ref="file" v-on:change="handleFileUpload()">
											<label for="uploadImg2" class="label-input-file btn btn-black btn-round">
												<span class="btn-label">
													<i class="fa fa-file-image"></i>
												</span>
												Subir Imagen
											</label>
										</div>
									</div>
								</div>
							</div>
							<div class="tab-pane mb-3" id="tab_clients">
								<div class="row">
									<div class="col-12 table-responsive">
										<table class="table" id="tabla_clientes">
											<thead>
												<tr>
													<th>Fecha</th>
													<th>Rif / Cedula</th>
													<th>Razón social</th>
													<th>Telefono</th>
													<th>Email</th>
													<th>Documento</th>
													<th>Captado</th>
													<th></th>
												</tr>
											</thead>
											<tbody>
												<tr v-for="row in clientes">
													<td>{{ row.empagent_fecha_registro }}</td>
													<td>{{ row.cli_dni }}</td>
													<td>{{ row.cli_razon_social }}</td>
													<td>{{ row.cli_telefono }}</td>
													<td>{{ row.cli_email }}</td>
													<td>
														<?php if ($opfacturas) : ?>
															<a v-if="row.empagent_tipo==1" :href="'notasdeentregaeditar/verFactura/'+row.empagent_docid">NEV{{row.empagent_docid}}</a>
															<a v-if="row.empagent_tipo==2" :href="'poseditar/verFactura/'+row.empagent_docid">FACV{{row.empagent_docid}}</a>
															<a v-if="row.empagent_tipo==12" :href="'ordendeentregaeditar/verFactura/'+row.empagent_docid">ORDENV{{row.empagent_docid}}</a>
															<span v-if="row.empagent_tipo==0" class="text-danger">No asignado</span>
														<?php else : ?>
															<span class="text-danger"></span>
														<?php endif; ?>
													</td>
													<td>
														<span v-if="row.empagent_captado!=''" class="text-success">{{row.empagent_captado}}</span>
														<span v-else class="text-warning">No definido</span>
													</td>
													<td class="text-center">
														<div class="form-button-action">
															<div class="input-group-append">
																<button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
																<div class="dropdown-menu">
																	<a class="dropdown-item" href="#" @click.prevent="modalClientsIntereses(row)">Agregar intereses</a>
																	<a class="dropdown-item" v-if="row.empagent_tipo>0" href="#" @click.prevent="modalClientsCaptado(row)">Agregar Captado</a>
																</div>
															</div>
														</div>
													</td>
												</tr>
											</tbody>
										</table>
									</div>
								</div>
							</div>
							<div class="tab-pane mb-3" id="tab_comisiones">
								<div class="form-group form-groud-default">
									<div class="row">
										<div class="col-12 col-md-12">
											<ul class="nav nav-pills nav-secondary" id="pills-tab" role="tablist">
												<li class="nav-item">
													<a class="nav-link active" data-toggle="pill" href="#Comisionespendiente" role="tab" aria-controls="Comisionespendiente" aria-selected="true" @click="obtenerComisionesEmpAgentePendiente">Comisiones Pendientes</a>
												</li>
												<li class="nav-item">
													<a class="nav-link" data-toggle="pill" href="#Comisionespagada" role="tab" aria-controls="Comisionespagada" aria-selected="false" @click="obtenerComisionesEmpAgentePagadas">Comisiones Pagadas</a>
												</li>
											</ul>
										</div>
										<div class="col-12 col-md-12 my-3">
											<div class="tab-content">
												<div class="tab-pane fade" id="Comisionespagada">
													<div class="table-responsive">
														<table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_comisiones_pagadas">
															<thead>
																<tr>
																	<th>Fecha</th>
																	<th>Documento</th>
																	<th>Cliente</th>
																	<th>Comision</th>
																	<th>Porcentaje</th>
																	<th>Monto</th>
																	<th>Fecha del pago</th>
																</tr>
															</thead>
															<tbody>
																<tr v-for="pagadas in comisionesAgentepagadas">
																	<td>{{pagadas.fecha_reg}}</td>
																	<td class="text-center">
																		{{ pagadas.documento }}
																	</td>
																	<td>{{pagadas.cliente}}</td>
																	<td>{{pagadas.comision}}</td>
																	<td>{{pagadas.porcentaje}} %</td>
																	<td>{{pagadas.monto}} {{pagadas.divisa}}</td>
																	<td>{{pagadas.fecha_pago}}</td>
																</tr>
															</tbody>
														</table>
													</div>
												</div>
												<div class="tab-pane fade show active" id="Comisionespendiente">
													<div class="table-responsive">
														<table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_comisiones_pendientes">
															<thead>
																<tr>
																	<th>Fecha</th>
																	<th>Documento</th>
																	<th>Total</th>
																	<th>Cliente</th>
																	<th>Comision</th>
																	<th>Porcentaje</th>
																	<th>Monto</th>
																</tr>
															</thead>
															<tbody>
																<tr v-for="pendientes in comisionesAgentependientes">
																	<td>{{pendientes.fecha_reg}}</td>
																	<td class="text-center">
																		{{ pendientes.documento }}
																	</td>
																	<td>{{pendientes.total}} {{pendientes.divisa}}</td>
																	<td>{{pendientes.cliente}}</td>
																	<td>{{pendientes.comision}}</td>
																	<td>{{pendientes.porcentaje}} %</td>
																	<td>{{pendientes.monto}} {{pendientes.divisa}}</td>
																</tr>
															</tbody>
														</table>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="tab-pane mb-3" id="tab_google" v-if="dataFormUser.autenticacion==true">
								<div class="row">
									<div class="col">
										<div class="form-group">
											<button type="button" class="btn btn-primary" @click="generar_qr()">Generar QR</button>
										</div>
										<h2 :class="(google.length>4)?'text-success text-left ml-3':'text-warning text-left ml-3'">{{(google.length>0)?'ACTIVADO':'GENERE QR'}}</h2>
										<div class="col-lg-12 d-flex justify-content-center" v-if="qr!=''">
											<div class="input-file input-file-image">
												<img class="img-upload-preview" :src="qr" width="150" height="150">
												<label class="label-input-file btn btn-black btn-round" @click="escaneado()">QR escaneado</label>
											</div>
										</div>
										<div class="col-lg-12 d-flex justify-content-center" v-else>
										
											<lottie-player :src="(google.length>4)?'<?= asset('assets/img/check-google.json'); ?>':'<?= asset('assets/img/38870-google-logo-effect.json'); ?>'" background="transparent" speed="1" style="width: 30%; height: 30%;" loop autoplay></lottie-player>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php include 'modal_interes.php' ?>
	<?php include 'modal_captado.php' ?>
</div>
<script src="<?= asset('assets/js/lottie-player.js'); ?>"></script>
<script src="<?= ruta_base() ?>public/assets/vue-the-mask.js"></script>
<script src="<?= ruta_base() ?>public/assetsvuejs/miperfil/miperfil.js"></script>