<?php

namespace App\Controladores;

use App\Modelos\Clienteintereses;
use App\Modelos\Empleado;
use App\Modelos\EmpleadoAgente;
use App\Modelos\EmpleadoInfo;
use App\Modelos\EmpleadosComisionesEmplAgente;
use Core\Controller;
use Core\Librerias\GoogleAuthenticator;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Librerias\ModuleAction;
use Core\Vista;
use Verot\Upload\Upload;

final class MiperfilControlador extends Controller
{
    private $empleado;
    private $empleado_info;
    private $array_errors = [];
    private $module;

    public function __construct()
    {
        parent::__construct();
        $this->empleado         = new Empleado();
        $this->empleado_info    = new EmpleadoInfo();
        $this->moduleAction     = new ModuleAction();
        $this->module = new Module();
    }

    public function index()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD']) {
            $data = ['opfacturas' => $this->module->has_module_action_permission('facturacion', 'opfacturas', $_SESSION['user_data']['emp_id'])];

            return Vista::view('miperfil/index', $data
            );
        }
    }

    public function obtener()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $empleado = $this->empleado->empleado($_SESSION['user_data']['einfo_id']);
            $info = $this->empleado_info->empleadoInfo($_SESSION['user_data']['einfo_id']);
            Http::json_response([
                'info' => $info,
                'user' => $empleado
            ]);
        }
    }

    public function actualizar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $einfo_id               = $_SESSION['user_data']['einfo_id'];
            $einfo_nombres          = $this->solicitud->sanitize($_POST['nombres'], FILTER_SANITIZE_STRING);
            $einfo_apellidos        = $this->solicitud->sanitize($_POST['apellidos'], FILTER_SANITIZE_STRING);
            $einfo_telefono_movil   = filter_input(INPUT_POST, 'telefono', FILTER_SANITIZE_STRING);
            $einfo_direccion_1      = filter_input(INPUT_POST, 'direccion_uno', FILTER_SANITIZE_STRING);
            $einfo_direccion_2      = filter_input(INPUT_POST, 'direccion_dos', FILTER_SANITIZE_STRING);
            $einfo_ciudad           = filter_input(INPUT_POST, 'ciudad', FILTER_SANITIZE_STRING);
            $einfo_estado           = filter_input(INPUT_POST, 'estado', FILTER_SANITIZE_STRING);
            $einfo_email            = filter_input(INPUT_POST, 'correo', FILTER_SANITIZE_EMAIL);
            $einfo_agente_de_venta  = ('true' == filter_input(INPUT_POST, 'agente_de_venta')) ? 1 : 0;

            if (empty($einfo_nombres))
                $this->array_errors[] = "El campo Nombre es obligatorio.";
            if (empty($einfo_apellidos))
                $this->array_errors[] = "El campo Apellidos obligatorio.";
            if (empty($einfo_telefono_movil))
                $this->array_errors[] = "El campo Telefono movil es obligatorio.";
            if (empty($einfo_direccion_1))
                $this->array_errors[] = "El campo Dirección es obligatorio.";
            if (empty($einfo_email))
                $this->array_errors[] = "El campo Correo es obligatorio.";

            if (empty($this->array_errors)) {

                $data_form = [
                    'einfo_nombres'         => $einfo_nombres,
                    'einfo_apellidos'       => $einfo_apellidos,
                    'einfo_telefono_movil'  => $einfo_telefono_movil,
                    'einfo_direccion_1'     => $einfo_direccion_1,
                    'einfo_direccion_2'     => $einfo_direccion_2,
                    'einfo_ciudad'          => $einfo_ciudad,
                    'einfo_estado'          => $einfo_estado,
                    'einfo_email'           => $einfo_email,
                    'einfo_eliminado'       => 0,
                    'einfo_agente_de_venta' => $einfo_agente_de_venta
                ];

                $where_correo = "einfo_email='$einfo_email' and einfo_id!=$einfo_id";

                if ($this->empleado_info->empleadoDiferente($where_correo)) {
                    $this->array_errors[] = "El correo $einfo_email ya se encuentra en uso por otro empleado";
                }

                if (empty($this->array_errors)) {
                    Http::json_response($this->empleado_info->editar($einfo_id, $data_form));
                }
            }

            $data['errors'] = $this->array_errors;
            Http::json_response($data);
        }
    }

    public function editarUsuario()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['nombre']))
                $this->array_errors[] = "El campo Nombre de usuario es obligatorio.";
            if (empty($_POST['password']))
                $this->array_errors[] = "El campo Contraseña es obligatorio.";
            if (empty($_POST['repassword']))
                $this->array_errors[] = "El campo Re-Contraseña es obligatorio.";

            if (empty($this->array_errors)) {

                $emp_username   = $this->solicitud->sanitize($_POST['nombre'], FILTER_SANITIZE_STRING);
                $emp_password   = $this->solicitud->sanitize($_POST['password']);
                $repassword     = $this->solicitud->sanitize($_POST['repassword']);
                $autenti     = ('true' == filter_input(INPUT_POST, 'autenticacion')) ? 1 : 0;

                if ($emp_password !== $repassword)
                    $this->array_errors[] = "Las contraseñas no coninciden.";

                if (empty($this->array_errors)) {
                    Http::json_response($this->empleado->editar($_SESSION['user_data']['emp_id'], [
                        'emp_username' => $emp_username,
                        'emp_password' => password_hash($emp_password, PASSWORD_BCRYPT),
                        'emp_gauth' => $autenti,
                    ]));
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function imagenPerfil()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_FILES['imagen']))
                $this->array_errors[] = "La imagen es obligatorio.";

            if (empty($this->array_errors)) {

                $empleado = $this->empleado_info->obtener($_SESSION['user_data']['einfo_id']);

                $fileSize       = $_FILES['imagen']['size'];
                $extenciones    = array('jpg', 'jpeg', 'png', 'gif');

                if ($_FILES['imagen']['error'] === UPLOAD_ERR_OK) {

                    $handle = new Upload($_FILES['imagen']);

                    $fileNameCmps = explode(".", basename($_FILES['imagen']['name']));
                    $fileExtension = strtolower(end($fileNameCmps));

                    if ($fileSize < 1048576) {

                        if (in_array($fileExtension, $extenciones)) {

                            if ($handle->uploaded) {

                                $handle->file_new_name_body = 'emp' . $empleado['einfo_id'];
                                $file_img                   = 'emp' . $empleado['einfo_id'] . '.gif';
                                $handle->image_resize       = true;
                                $handle->image_convert      = 'gif';
                                $handle->image_x            = 150;
                                $handle->image_ratio_y      = true;

                                if (file_exists(constant('UPLOADS_URI') . 'empleados/' . $file_img)) {
                                    unlink(constant('UPLOADS_URI') . 'empleados/' . $file_img);
                                }

                                $handle->process(constant('UPLOADS_URI') . 'empleados');

                                if ($handle->processed) {
                                    if ($this->empleado_info->editar($_SESSION['user_data']['einfo_id'], [
                                        'einfo_imagen' => $file_img
                                    ], true)) {
                                        $_SESSION['user_data']['einfo_imagen'] = $file_img;
                                        Http::json_response(true);
                                    } else {
                                        unlink(constant('UPLOADS_URI') . 'empleados/' . $file_img);
                                        $this->array_errors[] = "Se produjo un error al cargar el archivo";
                                    }
                                    $handle->clean();
                                } else {
                                    $this->array_errors[] = "Se produjo un error al d el archivo";
                                }
                            }
                        } else {
                            $this->array_errors[] = "Solo archivos con formato PNG, JPG, JPEG, o GIF";
                        }
                    } else {
                        $this->array_errors[] = "EL archivo supera el limite de 1MB";
                    }
                } else {
                    $this->array_errors[] = "EL archivo supera el limite de 1MB";
                }
            }
        }
    }

    public function obtenerClienteAgente()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $newcli = new EmpleadoAgente();
            Http::json_response($newcli->obtenerClienteAgente($_SESSION['user_data']['einfo_id']));
        }
    }

    public function obtenerInteresesCli(int $id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
           $clientesint = new Clienteintereses();

           Http::json_response($clientesint->obtenerIntereses($id_cliente));
          
        }
    }
    public function eliminarInteres(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newInters = new Clienteintereses();

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if ($newInters->existe('cliint_id', $id)) {
                Http::json_response($newInters->eliminarInteres($id));
            } else {
                Http::json_response(false);
            }
        }
    }

    public function obtenerComisionesEmpAgentePagadas()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_empleado = $_SESSION['user_data']['einfo_id'];
            $new_comempl = new EmpleadosComisionesEmplAgente();
            $facturas = $new_comempl->obtenerComisionesAgenteFacturasPagadas($id_empleado);
            $notas = $new_comempl->obtenerComisionesAgenteNotasPagadas($id_empleado);
            $array_total = [];

            if (is_countable($notas) && count($notas)) {
                $documento = $new_comempl->obtenerDocumento(1);
                foreach ($notas as $row) {
                    $array_total[] = [
                        'id'              => $row['comagentefn_id'],
                        'idnf'            => $row['comagentefn_fnid'],
                        'documento'       => $documento['doc_prefijo'] . $row['comagentefn_fnid'],
                        'fecha_reg'       => date('d-m-Y h:i A', strtotime($row['ne_fecha'])),
                        'total_factura'   => $row['div_simbolo'] == 'Bs' ? number_format($row['ne_total'], 2, ',', '.') : $row['ne_total'],
                        'total'           => $row['div_simbolo'] == 'Bs' ? number_format($row['comagentefn_fntotal'], 2, ',', '.') : $row['comagentefn_fntotal'],
                        'cliente'         => $row['cli_razon_social'],
                        'comision'        => $row['com_descripcion'],
                        'porcentaje'      => $row['comagentefn_porcentaje'],
                        'monto'           => $row['div_simbolo'] == 'Bs' ? number_format($row['comagentefn_monto'], 2, ',', '.') : $row['comagentefn_monto'],
                        'fecha_pago'      => $row['comagentefn_fechapago'] ? date('d-m-Y h:i A', strtotime($row['comagentefn_fechapago'])) : '',
                        'divisa'      => $row['div_simbolo']
                    ];
                }
            }

            if (is_countable($facturas) && count($facturas)) {
                $documento = $new_comempl->obtenerDocumento(2);
                foreach ($facturas as $row) {
                    $array_total[] = [
                        'id'              => $row['comagentefn_id'],
                        'idnf'            => $row['comagentefn_fnid'],
                        'documento'       => $documento['doc_prefijo'] . $row['comagentefn_fnid'],
                        'fecha_reg'       => $row['fm_fecha'],
                        'total_factura'   => $row['div_simbolo'] == 'Bs' ? number_format($row['fm_total'], 2, ',', '.') : $row['fm_total'],
                        'total'           => $row['div_simbolo'] == 'Bs' ? number_format($row['comagentefn_fntotal'], 2, ',', '.') : $row['comagentefn_fntotal'],
                        'cliente'         => $row['cli_razon_social'],
                        'comision'        => $row['com_descripcion'],
                        'porcentaje'      => $row['comagentefn_porcentaje'],
                        'monto'           => $row['div_simbolo'] == 'Bs' ? number_format($row['comagentefn_monto'], 2, ',', '.') : $row['comagentefn_monto'],
                        'fecha_pago'      => $row['comagentefn_fechapago'] ? date('d-m-Y h:i A', strtotime($row['comagentefn_fechapago'])) : '',
                        'divisa'      => $row['div_simbolo'],
                    ];
                }
            }

            Http::json_response($array_total);
        }
    }

    public function obtenerComisionesEmpAgentePendiente()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_empleado = $_SESSION['user_data']['einfo_id'];
            $new_comempl = new EmpleadosComisionesEmplAgente();
            $facturas = $new_comempl->obtenerComisionesAgenteFacturasPendientes($id_empleado);
            $notas = $new_comempl->obtenerComisionesAgenteNotasPendientes($id_empleado);
            $orden = $new_comempl->obtenerComisionesAgenteOrdenPendientes($id_empleado);
            $array_total = [];

            if (is_countable($notas) && count($notas)) {
                $documento = $new_comempl->obtenerDocumento(1);
                foreach ($notas as $row) {
                    $array_total[] = [
                        'id'              => $row['comagentefn_id'],
                        'idnf'            => $row['comagentefn_fnid'],
                        'documento'       => $documento['doc_prefijo'] . $row['comagentefn_fnid'],
                        'fecha_reg'       => date('d-m-Y h:i A', strtotime($row['ne_fecha'])),
                        'total_factura'   => $row['div_simbolo'] == 'Bs' ? number_format($row['ne_total'], 2, ',', '.') : $row['ne_total'],
                        'total'           => $row['div_simbolo'] == 'Bs' ? number_format($row['comagentefn_fntotal'], 2, ',', '.') : $row['comagentefn_fntotal'],
                        'cliente'         => $row['cli_razon_social'],
                        'comision'        => $row['com_descripcion'],
                        'porcentaje'      => $row['comagentefn_porcentaje'],
                        'monto'           => $row['div_simbolo'] == 'Bs' ? number_format($row['comagentefn_monto'], 2, ',', '.') : $row['comagentefn_monto'],
                        'fecha_pago'      => $row['comagentefn_fechapago'] ? date('d-m-Y h:i A', strtotime($row['comagentefn_fechapago'])) : '',
                        'divisa'      => $row['div_simbolo'],
                    ];
                }
            }

            if (is_countable($facturas) && count($facturas)) {
                $documento = $new_comempl->obtenerDocumento(2);
                foreach ($facturas as $row) {
                    $array_total[] = [
                        'id'              => $row['comagentefn_id'],
                        'idnf'            => $row['comagentefn_fnid'],
                        'documento'       => $documento['doc_prefijo'] . $row['comagentefn_fnid'],
                        'fecha_reg'       => date('d-m-Y h:i A', strtotime($row['fm_fecha'])),
                        'total_factura'   => $row['div_simbolo'] == 'Bs' ? number_format($row['fm_total'], 2, ',', '.') : $row['fm_total'],
                        'total'           => $row['div_simbolo'] == 'Bs' ? number_format($row['comagentefn_fntotal'], 2, ',', '.') : $row['comagentefn_fntotal'],
                        'cliente'         => $row['cli_razon_social'],
                        'comision'        => $row['com_descripcion'],
                        'porcentaje'      => $row['comagentefn_porcentaje'],
                        'monto'           => $row['div_simbolo'] == 'Bs' ? number_format($row['comagentefn_monto'], 2, ',', '.') : $row['comagentefn_monto'],
                        'fecha_pago'      => $row['comagentefn_fechapago'] ? date('d-m-Y h:i A', strtotime($row['comagentefn_fechapago'])) : '',
                        'divisa'      => $row['div_simbolo'],
                    ];
                }
            }

            if (is_countable($orden) && count($orden)) {
                $documento = $new_comempl->obtenerDocumento(12);
                foreach ($orden as $row) {
                    $array_total[] = [
                        'id'              => $row['comagentefn_id'],
                        'idnf'            => $row['comagentefn_fnid'],
                        'documento'       => $documento['doc_prefijo'] . $row['comagentefn_fnid'],
                        'fecha_reg'       => date('d-m-Y h:i A', strtotime($row['n_fecha'])),
                        'total_factura'   => $row['div_simbolo'] == 'Bs' ? number_format($row['n_total'], 2, ',', '.') : $row['n_total'],
                        'total'           => $row['div_simbolo'] == 'Bs' ? number_format($row['comagentefn_fntotal'], 2, ',', '.') : $row['comagentefn_fntotal'],
                        'cliente'         => $row['cli_razon_social'],
                        'comision'        => $row['com_descripcion'],
                        'porcentaje'      => $row['comagentefn_porcentaje'],
                        'monto'           => $row['div_simbolo'] == 'Bs' ? number_format($row['comagentefn_monto'], 2, ',', '.') : $row['comagentefn_monto'],
                        'fecha_pago'      => $row['comagentefn_fechapago'] ? date('d-m-Y h:i A', strtotime($row['comagentefn_fechapago'])) : '',
                        'divisa'      => $row['div_simbolo'],
                    ];
                }
            }

            Http::json_response($array_total);
        }
    }

    public function guardarInteres()
    {
        $newintereses = new Clienteintereses();

        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $idcliente  = filter_input(INPUT_POST, 'idcliente', FILTER_SANITIZE_NUMBER_INT);
            $descripcion = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);


            if (empty($idcliente))
                $this->array_errors[] = "Error al identificar el cliente.";
            if (empty($descripcion))
                $this->array_errors[] = "Debe llenar el campo descripcion.";

            if (empty($this->array_errors)) {

                if ($newintereses->guardar([
                    'cliint_tipo' => 0,
                    'cliint_descripcion'  => $descripcion,
                    'cliint_cli_id' => $idcliente
                ], true)) {

                    Http::json_response(true);
                } else {
                    Http::json_response(false);
                }
            }


            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function guardarCaptado()
    {
        $newAgent = new EmpleadoAgente();

        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $agente = $_SESSION['user_data']['einfo_id'];
            $idcliente  = filter_input(INPUT_POST, 'idcliente', FILTER_SANITIZE_NUMBER_INT);
            $captado = filter_input(INPUT_POST, 'captado', FILTER_SANITIZE_STRING);
            $factura  = filter_input(INPUT_POST, 'factura', FILTER_SANITIZE_NUMBER_INT);
            $tipo  = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT);

            if (empty($agente))
                $this->array_errors[] = "Debe seleccionar un agente de venta.";
            if (empty($idcliente))
                $this->array_errors[] = "Error al identificar el cliente.";

            if (empty($this->array_errors)) {
                if ($newAgent->existe('empagent_clientid', $idcliente)) {
                    if ($newAgent->modificarAgente($idcliente, $agente, $captado,$factura,$tipo)) {
                        Http::json_response(true);
                    } else {
                        Http::json_response(false);
                    }
                } else {
                    $this->array_errors[] = "Error al identificar el cliente.";
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function ComprobarQr(){

        $emp_id=$_SESSION['user_data']['emp_id'];
        Http::json_response($this->empleado->empleadoDiferente("emp_id={$emp_id}"));
    }

    public function crear_qr(){
        
        $emp_id=$_SESSION['user_data']['emp_id'];
        $emplead=$this->empleado->empleadoDiferente("emp_id={$emp_id}");
        $infoid=$_SESSION['user_data']['einfo_id'];
        $info=$this->empleado->getUserPerData($infoid);
        $user=$_SESSION['user_data']['emp_username'];
        $google= new GoogleAuthenticator();

        if($emplead['emp_googlecode']!=null){
            $secret = $emplead['emp_googlecode'];
            $web=constant('WEB_GOOGLE');
            Http::json_response($google->getQRCodeGoogleUrl($user, $secret,$web));
        }else{
            $secret = $google->createSecret();
            $this->empleado->editar($emp_id,['emp_googlecode'=>$secret]);
            $web=constant('WEB_GOOGLE');
            Http::json_response($google->getQRCodeGoogleUrl($user, $secret,$web));
        }

    }
}
