<div class="row" id="AppTabProduccion" v-cloak>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form @submit.prevent="buscar($event)" id="form_produccion_busqueda">
                    <div class="form-row">
                        <div class="col-sm-6">
                            <div class="form-group form-floating-label">
                                <input id="prod_fecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha_desde">
                                <label for="prod_fecha_desde" class="placeholder">Fecha desde</label>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group input-group form-floating-label">
                                <input id="prod_fecha_hasta" type="date" class="form-control input-border-bottom" v-model="fecha_hasta">
                                <label for="prod_fecha_hasta" class="placeholder">Fecha hasta</label>
                                <div class="input-group-append">
                                    <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="row row-card-no-pd">
            <div class="col-sm-6 col-md-4">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-success">
                            <br>
                        </div>
                        <div class="h1 m-0 text-primary">
                            {{ art_total }}
                        </div>
                        <div class="text-primary mb-3">Total articulos</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-4">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            <br>
                        </div>
                        <div class="h1 m-0">
                            {{ total }}
                        </div>
                        <div class="mb-3">Total facturado</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-4">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            <br>
                        </div>
                        <div class="h1 m-0">
                            {{ pendiente }}
                        </div>
                        <div class="mb-3">Pendiente</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-4">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            <br>
                        </div>
                        <div class="h1 m-0">
                            {{ tcosto }}
                        </div>
                        <div class="mb-3">Costo</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-4">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            {{ porcentaje }}%
                            <i class="fa fa-chevron-up"></i>
                        </div>
                        <div class="h1 m-0">
                            {{ acumulado }}
                        </div>
                        <div class="mb-3">Acumulado</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-4">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            {{ tporcentaje_ganancia }}%
                            <i class="fa fa-chevron-up"></i>
                        </div>
                        <div class="h1 m-0">
                            {{ tganancia }}
                        </div>
                        <div class="mb-3">Ganancia</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-body" :cargando="cargando_tabla">
                <div class="table-responsive">
                    <table class="display nowrap table table-striped table-hover dataTable" id="tabla_produccion">
                        <thead>
                            <tr>
                                <th class="text-left">Cliente</th>
                                <th class="text-center">Cant. Documentos</th>
                                <th class="text-center">Cant. Art</th>
                                <th class="text-right">Total</th>
                                <th class="text-right">Acumulado</th>
                                <th class="text-right">Pendiente</th>
                                <th class="text-right">Costo</th>
                                <th class="text-right">Ganancia</th>
                                <th class="text-right"></th>

                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in facturas">
                                <td class="text-left">{{ row.cli_razon_social }}</td>
                                <td class="text-center">{{ row.documentos }}</td>
                                <td class="text-center">{{ row.art_total }}</td>
                                <td class="text-right">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.costo, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.ganancia, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ decimal(row.porcentaje, row.div_locale) }}%</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    new Vue({
        el: '#AppTabProduccion',
        data: {
            facturas: [],
            total: 0,
            acumulado: 0,
            pendiente: 0,
            art_total: 0,
            porcentaje: 0,
            tcosto: 0,
            tganancia: 0,
            tporcentaje_ganancia: 0,
            fecha_desde: '',
            fecha_hasta: moment().format('YYYY-MM-DD'),
            errorForm: [],
            cargando: false,
            cargando_tabla: 'is-loading is-loading-lg',
        },
        created() {
            axios.get('ingresosegresos/obtenerProducccion', {
                params: {
                    fecha_desde: this.fecha_desde,
                    fecha_hasta: this.fecha_hasta
                }
            }).then(response => {
                if (response.data.errors == null) {
                    if (Object.keys(response.data.facturas).length > 0) {
                        this.facturas = response.data.facturas;
                        this.art_total = response.data.art_total
                        this.total = response.data.total;
                        this.acumulado = response.data.acumulado;
                        this.pendiente = response.data.pendiente;
                        this.porcentaje = response.data.porcentaje;
                        this.tcosto = response.data.tcosto;
                        this.tganancia = response.data.tganancia;
                        this.tporcentaje_ganancia = response.data.tporcentaje_ganancia;
                    }
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tabla = '';
                $("#tabla_produccion").DataTable({
                    order: []
                });
            });
        },
        methods: {
            resetearFormulario() {
                document.getElementById('form_produccion_busqueda').reset();
                this.fecha_desde = '';
                this.fecha_hasta = moment().format('YYYY-MM-DD');
                this.errorForm = [];
            },
            buscar(event) {

                this.errorForm = [];
                this.cargando = true;
                this.cargando_tabla = 'is-loading is-loading-lg';
                $("#tabla_produccion").DataTable().destroy();

                axios.get('ingresosegresos/obtenerProducccion', {
                    params: {
                        fecha_desde: this.fecha_desde,
                        fecha_hasta: this.fecha_hasta
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        this.facturas = response.data.facturas;
                        this.art_total = response.data.art_total
                        this.total = response.data.total;
                        this.acumulado = response.data.acumulado;
                        this.pendiente = response.data.pendiente;
                        this.porcentaje = response.data.porcentaje;
                        this.tcosto = response.data.tcosto;
                        this.tganancia = response.data.tganancia;
                        this.tporcentaje_ganancia = response.data.tporcentaje_ganancia;
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    this.cargando_tabla = '';
                    $("#tabla_produccion").DataTable({
                        order: []
                    });
                });
            },
            moneda(num, div_locale, div_simbolo, decimal = 2) {
                return monedaMoneda(num, div_locale, div_simbolo, decimal);
            },
            decimal(num, div_locale, decimal = 2) {
                return monedaDecimal(num, div_locale, decimal);
            }
        }
    });
</script>