<div id="AppTabComisiones" v-cloak>
    <div class="row">
        <div class="col-12">
            <ul id="pills-tab" role="tablist" class="nav nav-pills nav-secondary">
                <li class="nav-item submenu"><a data-toggle="pill" href="#pendiente" role="tab" aria-controls="pendiente" aria-selected="true" class="nav-link active show">Pendientes</a></li>
                <li class="nav-item submenu"><a data-toggle="pill" href="#pagadas" role="tab" aria-controls="pagadas" aria-selected="false" class="nav-link">Pagadas</a></li>
            </ul>
        </div>
    </div>
    <div class="tab-content mt-3">
        <div id="pendiente" class="tab-pane fade active show mb-3">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form @submit.prevent="obtenerComisionesEmpAgentePendiente()" id="form_proven_busqueda">
                                <div class="form-row">
                                    <div class="col-sm-4">
                                        <div class="form-group form-floating-label">
                                            <input id="pvfecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha_desde">
                                            <label for="pvfecha_desde" class="placeholder">Fecha desde</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group input-group form-floating-label">
                                            <input id="pvfecha_hasta" type="date" class="form-control input-border-bottom" v-model="fecha_hasta">
                                            <label for="pvfecha_hasta" class="placeholder">Fecha hasta</label>
                                            <div class="input-group-append">
                                                <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group input-group form-floating-label">
                                            <select id="vdagente" class="form-control input-border-bottom" v-model="agente">
                                                <option value="0">Todos</option>
                                                <?php foreach ($agentes as $row) : ?>
                                                    <option value="<?= $row['einfo_id'] ?>"><?= $row['einfo_nombres'] . ' ' . $row['einfo_apellidos'] ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="vdagente" class="placeholder">Agente</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group input-group form-floating-label">
                                            <select id="pvdivisas" class="form-control input-border-bottom" v-model="divisa">
                                                <?php foreach ($divisas as $row) : ?>
                                                    <option value="<?= $row['div_id'] ?>" <?= ($row['div_predeterminado'] == 1) ? 'selected' : '' ?>><?= $row['div_descripcion'] ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="pvdivisas" class="placeholder">Divisa</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group input-group form-floating-label">
                                            <select id="vdtipo" class="form-control input-border-bottom" v-model="comision">
                                                <option value="0">Todos</option>
                                                <?php foreach ($comisiones as $row) : ?>
                                                    <option value="<?= $row['com_id'] ?>"><?= $row['com_descripcion'] ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="vdtipo" class="placeholder">Tipo comisiones</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group input-group form-floating-label">
                                            <select id="vdtipo" class="form-control input-border-bottom" v-model="documentof">
                                                <option value="0">Todos</option>
                                                <option value="2">Pendientes</option>
                                                <option value="1">Pagadas</option>
                                            </select>
                                            <label for="vdtipo" class="placeholder">Estatus del documento</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                            {{ row }}
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="card">
                        <div class="table-responsive">
                            <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary">
                                <thead>
                                    <tr>
                                        <th class="text-center"> 
                                            <label for="checkbox-todos" class="form-check-label">
                                                <input class="form-check-input" type="checkbox" class="checkbox-todos" @change="checktodos($event)">
                                                <span class="form-check-sign"></span>
                                            </label>
                                        </th>
                                        <th>Fecha</th>
                                        <th>Documento</th>
                                        <th>Total</th>
                                        <th>Estatus</th>
                                        <th>Empleado</th>
                                        <th>Comision</th>
                                        <th>Porcentaje</th>
                                        <th>Monto</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in comisionesAgentependientes.pendientes" :key="row.id">
                                        <td class="text-center">
                                            <label :for="'check'+row.id" class="form-check-label">
                                                <input class="form-check-input" type="checkbox" v-model="row.checked" :id="'part'+row.id">
                                                <span class="form-check-sign"></span>
                                            </label>
                                        </td>
                                        <td>{{row.fecha_reg}}</td>
                                        <td class="text-center">
                                            <a :href="row.uri" title="Ver documento" target="_blank">
                                                {{ row.idnf }}
                                            </a>
                                        </td>
                                        <td>{{row.total_moneda}}</td>
                                        <th>{{row.estatusfn}}</th>
                                        <td>{{row.agente}}</td>
                                        <td>{{row.com_descripcion}}</td>
                                        <td>{{row.porcentaje}} %</td>
                                        <td>{{row.monto_moneda}}</td>
                                        <td>
                                            <div class="form-button-action">
                                                <button type="button" title="Pagar" @click="modalPagoPendienteId(row)" class="btn btn-link">
                                                    <i class="fa fa-coins text-warning"></i>
                                                </button>
                                                <button type="button" title="Editar" @click="modalPendienteeditar(row.porcentaje,row.monto,row.total,row.divisa,row.id)" class="btn btn-link btn-primary">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                                <button type="button" title="Eliminar" class="btn btn-link btn-danger" @click.prevent="eliminarComisionPendiente(row.id)">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td>TOTAL A PAGAR</td>
                                        <td>{{comisionesAgentependientes.total_pagar}}</td>
                                        <td></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col d-flex justify-content-end">
                    <a href="#" class="btn btn-info btn-sm btn-round mr-3" @click.prevent="modalPagarTodo()">Pagar comisiones seleccionadas</a>
                    <a href="#" class="btn btn-info btn-sm btn-round mr-3" @click.prevent="modalImprimir('0')">Imprimir</a>
                </div>
            </div>
        </div>
        <div id="pagadas" class="tab-pane fade">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form id="form_proven_busqueda" @submit.prevent="buscar()">
                                <div class="form-row">
                                    <div class="col-sm-3">
                                        <div class="form-group form-floating-label">
                                            <input id="vdfecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha_desde">
                                            <label for="vdfecha_desde" class="placeholder">Fecha desde</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group input-group form-floating-label">
                                            <input id="vdfecha_hasta" type="date" class="form-control input-border-bottom" v-model="fecha_hasta">
                                            <label for="vdfecha_hasta" class="placeholder">Fecha hasta</label>
                                            <div class="input-group-append">
                                                <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group input-group form-floating-label">
                                            <select id="pvdivisas" class="form-control input-border-bottom" v-model="divisas">
                                                <?php foreach ($divisas as $row) : ?>
                                                    <option value="<?= $row['div_id'] ?>" <?= ($row['div_predeterminado'] == 1) ? 'selected' : '' ?>><?= $row['div_descripcion'] ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="vdivisas" class="placeholder">Divisa</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group input-group form-floating-label">
                                            <select id="vdagente" class="form-control input-border-bottom" v-model="agente">
                                                <option value="0">Todos</option>
                                                <?php foreach ($agentes as $row) : ?>
                                                    <option value="<?= $row['einfo_id'] ?>"><?= $row['einfo_nombres'] . ' ' . $row['einfo_apellidos'] ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="vdagente" class="placeholder">Agente</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group input-group form-floating-label">
                                            <select id="vdtipo" class="form-control input-border-bottom" v-model="tipo_comision">
                                                <option value="0">Todos</option>
                                                <?php foreach ($comisiones as $row) : ?>
                                                    <option value="<?= $row['com_id'] ?>"><?= $row['com_descripcion'] ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="vdtipo" class="placeholder">Tipo comisiones</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12"></div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="card">
                        <div class="card-body table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_historico_com">
                                <thead>
                                    <tr>
                                        <th class="text-center">Cliente</th>
                                        <th class="text-center">Comisión</th>
                                        <th class="text-center">Agente</th>
                                        <th class="text-center">Fecha</th>
                                        <th class="text-center">Divisa Doc.</th>
                                        <th class="text-center">Total Doc.</th>
                                        <th class="text-center">Porcentaje%</th>
                                        <th class="text-center">Divisa</th>
                                        <th class="text-center">Monto</th>
                                        <th class="text-center">Fecha de pago</th>
                                        <th class="text-center">Estatus Com.</th>
                                        <th class="text-center">Estatus Doc.</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="fn in historial_comisiones">
                                        <td>{{ fn.cliente }}</td>
                                        <td>{{ fn.com_descripcion }}</td>
                                        <td>{{ fn.agente }}</td>
                                        <td>{{ fn.fecha_reg }}</td>
                                        <td>{{ fn.divisa_factura }}</td>
                                        <td>{{ fn.total_factura_moneda }}</td>
                                        <td>{{ fn.porcentaje }} %</td>
                                        <td>{{ fn.divisa_total }}</td>
                                        <td>{{ fn.monto_moneda }}</td>
                                        <td>{{ fn.fecha_pago }}</td>
                                        <td>{{ fn.estatuscom }}</td>
                                        <td>{{ fn.idnf }} {{ fn.estatusfn }}</td>
                                        <td class="text-center">
                                            <div class="form-button-action">
                                                <div class="input-group-append">
                                                    <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                    <div class="dropdown-menu">
                                                        <a class="dropdown-item" :href="fn.uri">Ver</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td>TOTAL PAGADO</td>
                                        <td style="width: 22%;">{{totalPagado}}</td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col d-flex justify-content-end">
                    <a href="#" class="btn btn-info btn-sm btn-round mr-3" @click.prevent="modalImprimirpagado('1')">Imprimir</a>
                </div>
            </div>
        </div>
    </div>
    <?php include 'app/empleados/vista/modal_pago_pendiente.php' ?>
    <?php include 'app/empleados/vista/modal_pagar_pendientes.php' ?>
    <?php include 'app/notasdeentregaeditar/vista/modal_editar_con_agente.php' ?>
    <?php include 'modal_imprimir_comisiones.php' ?>
</div>
<script>
    new Vue({
        el: '#AppTabComisiones',
        data: {
            comisionesAgentependientes: [],
            costo_total: 0,
            venta_total: 0,
            artic_total: 0,
            ganancia: 0,
            ganancia_porc: 0,
            fecha_desde: '',
            divisa: 2,
            comision: 0,
            fecha_hasta: '',
            errorForm: [],
            cargando: false,
            metodos_pg: [],
            cuentas_pg: [],
            cargando_tabla: 'is-loading is-loading-lg',
            dataPagoComisiones_id: '',
            dataEditar: {
                porcentaje: 0,
                monto: '',
                divisa: '',
                total: ''
            },
            money: {
                decimal: '.',
                thousands: ',',
                prefix: '',
                suffix: '',
                precision: 2,
                masked: false /* doesn't work with directive */
            },
            posicionDivisaApagar: '',
            agente: 0,
            divisas: 0,
            tipo_comision: 0,
            historial_comisiones: [],
            estatus: 0,
            totalPagado: 0,
            documentof:0
        },
        methods: {
            checktodos(event) {
                for (let row of this.comisionesAgentependientes.pendientes) {
                    row.checked = event.target.checked;
                }
            },
            resetearFormularioComisionUnico() {
                document.getElementById('modal_form_pagar').reset();
                this.metodos_pg = [];
                this.cuentas_pg = [];
                this.dataPagoComisiones_id = '';
            },
            modalPendienteeditar(porcentaje, monto, total, divisa, id) {
                this.dataEditar.id = id;
                this.dataEditar.porcentaje = porcentaje;
                this.dataEditar.total = total;
                this.dataEditar.monto = 0.00;
                this.dataEditar.monto = convertir_a_float(String(monto)).toFixed(2);
                this.dataEditar.divisa = divisa;
                $('#modal_pendiente').modal('show');
            },
            resetearFormularioComisionesSeleccionadas() {
                document.getElementById('modal_form_pagar_comisiones').reset();
                this.metodos_pg = [];
                this.cuentas_pg = [];
                this.posicionDivisaApagar = '';
            },
            modalPagoPendienteId(pendiente) {
                this.resetearFormularioComisionUnico();
                this.dataPagoComisiones_id = pendiente.id
                $('#modal_pagar_pendiente').modal('show');
            },
            async obtenerComisionesEmpAgentePendiente() {
                this.cargando_tabla = 'is-loading is-loading-lg';
                axios({
                    method: 'post',
                    url: 'ingresosegresos/obtenerComisionesEmpAgentePendiente',
                    data: {
                        fecha_desde: this.fecha_desde,
                        fecha_hasta: this.fecha_hasta,
                        id_divisa: this.divisa,
                        agente: this.agente,
                        tipo_comision: this.comision,
                        documento:this.documentof
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    this.comisionesAgentependientes = response.data;
                }).catch(e => notificacion());
            },
            obtenerMetodosDivisa(event) {
                this.metodos_pg = [];
                this.cuentas_pg = [];
                axios.get('ingresosegresos/obtenerMetodoPagoComisiones/' + event.target.value).then(response => {
                    if (response.data) {
                        this.metodos_pg = response.data
                        this.obtenerMontoApagar(event.target.value);
                    }
                }).catch(e => notificacion());
            },
            modalImprimir(estatus) {
                this.errorForm = [];
                $('#modal-imprimir-comisiones').modal();
                this.estatus = estatus;
            },
            modalImprimirpagado(estatus) {
                this.errorForm = [];
                $('#modal-imprimir-comisiones').modal();
                this.estatus = estatus;
                this.divisa = this.divisas;
            },
            Imprimir(id) {
                axios.get('ingresosegresos/imprimir_comisiones', {
                    params: {
                        fecha_desde: this.fecha_desde,
                        fecha_hasta: this.fecha_hasta,
                        agente: this.agente,
                        divisa: this.divisa,
                        tipo_comision: this.comision,
                        estatus: this.estatus,
                        id_impresora: id
                    }
                }).then(response => {
                    console.log(response.data);
                    if (response.data.data.errors == null) {
                        fetch(response.data.ip_puerto, {
                            method: 'POST',
                            body: JSON.stringify(response.data.data)
                        }).then((j) => {
                            if (j.ok) {
                                notificacion('fa fa-check', 'Impreso', 'Impresion exitosa', 'success');
                            } else {
                                notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
                            }
                        }).catch((error) => {
                            notificacion('fa fa-ban', 'Error', 'Hubo un problema con la petición Fetch:' + error.message, 'danger');
                        });
                    } else {
                        let total_errores = response.data.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            },
            obtenerCuentasSegunMetodo(event) {
                this.cuentas_pg = [];
                axios.get('ingresosegresos/obtenerCuentasSegunMetod/' + event.target.value).then(response => {
                    this.cuentas_pg = response.data;
                }).catch(e => notificacion());
            },
            async obtenerMetodosDivisaComisionesSeleccionadas(event) {
                this.metodos_pg = [];
                this.cuentas_pg = [];
                await axios.get('ingresosegresos/obtenerMetodoPagoComisiones/' + event.target.value).then(response => {
                    if (response.data) {
                        this.metodos_pg = response.data
                        this.obtenerMontoApagarDeComisionesSeleccionadas(event.target.value);
                    }
                }).catch(e => notificacion());
            },
            obtenerMontoApagar(divisa) {
                axios.get('ingresosegresos/obtenerPagoDivisa', {
                    params: {
                        id_divisa: divisa,
                        id_comision: this.dataPagoComisiones_id
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        document.getElementById('monto_sin_conversion').value = response.data.total_sin_conversion;
                        document.getElementById('monto_con_conversion').value = response.data.total_con_conversion;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            },
            async obtenerMontoApagarDeComisionesSeleccionadas(divisa) {

                let id_comisiones = [];

                for (let row of this.comisionesAgentependientes.pendientes) {
                    if (row.checked == true) {
                        id_comisiones.push(row.id);
                    }
                }

                await axios({
                    method: 'post',
                    url: 'ingresosegresos/obtenerMontoApagarDeComisionesSeleccionadas',
                    data: {
                        id_divisa: divisa,
                        id_comisiones: JSON.stringify(id_comisiones)
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        document.getElementById('monto_total_sin_conversion_comisiones').value = response.data.total_sin_conversion;
                        document.getElementById('monto_total_con_conversion_comisiones').value = response.data.total_con_conversion;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            },
            modalPagarTodo(indice) {
                this.resetearFormularioComisionesSeleccionadas();
                this.posicionDivisaApagar = indice;
                $('#modal-pagarComisiones').modal('show');
            },
            pagarComision() {
                let select_divisa = document.getElementById('pagardivisa');
                let select_metodo = document.getElementById('pagarmetodo');
                let select_cuenta = document.getElementById('pagarcuenta');
                select_divisa = select_divisa.options[select_divisa.selectedIndex];
                select_metodo = select_metodo.options[select_metodo.selectedIndex];
                select_cuenta = select_cuenta.options[select_cuenta.selectedIndex];
                axios({
                    method: 'post',
                    url: 'ingresosegresos/pagarComision',
                    data: {
                        id_divisa: select_divisa.value,
                        id_metodo: select_metodo.value,
                        id_cuenta: select_cuenta.value,
                        id_empleado: this.id_empleado,
                        id: this.dataPagoComisiones_id
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.resetearFormularioComisionUnico();
                            notificacion('fa fa-check', 'Actualizacion', 'Pago exitoso', 'success');
                            $('#modal_pagar_pendiente').modal('hide');
                            this.obtenerComisionesEmpAgentePendiente();
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            },
            pagarComisiones() {
                this.cargando = true;
                let select_divisa = document.getElementById('pagardivisa_comisiones');
                let select_metodo = document.getElementById('pagarmetodo_comisiones');
                let select_cuenta = document.getElementById('pagarcuenta_comisiones');
                select_divisa = select_divisa.options[select_divisa.selectedIndex];
                select_metodo = select_metodo.options[select_metodo.selectedIndex];
                select_cuenta = select_cuenta.options[select_cuenta.selectedIndex];

                let id_comisiones = [];

                for (let row of this.comisionesAgentependientes.pendientes) {
                    if (row.checked == true) {
                        id_comisiones.push(row.id);
                    }
                }

                axios({
                    method: 'post',
                    url: 'ingresosegresos/pagarComisiones',
                    data: {
                        id_divisa: select_divisa.value,
                        id_metodo: select_metodo.value,
                        id_cuenta: select_cuenta.value,
                        id_comisiones: JSON.stringify(id_comisiones)
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    console.log(response.data);
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            notificacion('fa fa-check', 'Actualizacion', 'Pago exitoso', 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.resetearFormularioComisionesSeleccionadas();
                    $('#modal_form_pagar_comisiones').modal('hide');
                    this.obtenerComisionesEmpAgentePendiente();
                    this.cargando = false;
                })
            },
            editarpendiente() {
                axios({
                    method: 'post',
                    url: 'ingresosegresos/editarpendiente',
                    data: {
                        id: this.dataEditar.id,
                        porcentaje: this.dataEditar.porcentaje,
                        monto: this.dataEditar.monto
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.obtenerComisionesEmpAgentePendiente();
                            this.dataEditar.monto = 0.00;
                            notificacion('fa fa-check', 'Actualizacion', 'Modificado exitosamente', 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            },
            eliminarComisionPendiente(id) {
                if (id > 0) {
                    Swal.fire({
                        title: 'Eliminar Comision',
                        text: "¿Estás seguro de querer eliminar esta comision pendiente ?",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#aaa',
                        confirmButtonText: 'Eliminar'
                    }).then((result) => {
                        if (result.value) {
                            axios.get('ingresosegresos/eliminarComisionPendiente/' + id).then(response => {
                                if (response.data == true) {
                                    this.obtenerComisionesEmpAgentePendiente();
                                    notificacion('fa fa-trash', 'Comision eliminada', '', 'danger');
                                } else {
                                    notificacion('fa fa-ban', 'Error al eliminar la comision', this.dataTipoCom.nombrecom.toUpperCase(), 'danger');
                                }
                            }).catch(e => notificacion());
                        }
                    });
                } else {
                    notificacion('fa fa-ban', 'Advertencia', 'Error en la seleccion.', 'warning');
                }
            },
            buscar() {
                this.cargando_tabla = "is-loading is-loading-lg";
                $("#tabla_historico_com").DataTable().destroy();
                axios({
                        method: "post",
                        url: "ingresosegresos/obtenerComisionesId",
                        data: {
                            fecha_desde: this.fecha_desde,
                            fecha_hasta: this.fecha_hasta,
                            agente: Number(this.agente),
                            comision: Number(this.tipo_comision),
                            divisa: Number(this.divisas),
                        },
                        transformRequest: serializar(),
                    })
                    .then((response) => {
                        if (response.data.errors == null) {
                            this.historial_comisiones = response.data.comisiones;
                            this.totalPagado = response.data.total_pagado;
                            console.log(this.agente);
                        } else {
                            notificacion("fa fa-ban", "Advertencia", response.data.errors, "warning");
                        }
                    })
                    .catch((e) => notificacion())
                    .finally(() => {
                        let buttonCommon = {
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
                                format: {
                                    body: function(data, row, column, node) {
                                        if (column === 5 || column === 6 || column === 8) {
                                            return convertir_a_float(data);
                                        } else {
                                            return data.replace(/<[^>]*>?/g, "");
                                        }
                                    },
                                },
                            },
                        };

                        $("#tabla_historico_com").DataTable({
                            retrieve: true,
                            order: [],
                            dom: "Bfrtip",
                            buttons: [
                                $.extend(true, {}, buttonCommon, {
                                    extend: "excelHtml5",
                                    title: `Comisiones desde ${this.fecha_desde} hasta ${this.fecha_hasta}`,
                                }),
                            ],
                        });
                    });
            }
        },
        computed: {
            porcentajemonto: function() {
                let total = convertir_a_float(String(this.dataEditar.total));
                let monto = convertir_a_float(String(this.dataEditar.monto));
                let Tcomision_ = (monto * 100) / total;
                Tcomision_ = (Tcomision_ >= 0) ? Tcomision_ : 0;
                this.dataEditar.porcentaje = convertir_a_float(String(Tcomision_).toString()).toFixed(2);
                return this.dataEditar.porcentaje;
            }
        }
    });
</script>