<div class="row" id="AppGeneral" v-cloak>
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="form-group form-group-default">
                            <label for="mes_divisas" class="placeholder">Año</label>
                            <select id="aniog" name="mes_anio" class="form-control input-border-bottom" onchange="obtenerIngresosGeneral()">
                                <option value="0" selected>Todos</option>
                                <?php for ($m = date('o'); $m >= 2018; $m--) {
                                    if ($m == date('o')) {
                                        echo '<option value="' . $m . '">' . $m . '</option>';
                                    } else {
                                        echo '<option value="' . $m . '">' . $m . '</option>';
                                    }
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="form-group form-group-default">
                            <label for="mes_divisas" class="placeholder">Divisa</label>
                            <select id="divisasgeneral" class="form-control input-border-bottom" ref="divisa" onchange="obtenerIngresosGeneral()">
                                <option value="0">Todas</option>
                                <?php foreach ($divisas as $row) : ?>
                                    <option value="<?= $row['div_id'] ?>" <?= ($row['div_predeterminado'] == 1) ? 'selected' : '' ?>><?= $row['div_descripcion'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="form-group form-group-default">
                            <label for="sucursal" class="placeholder">Sucursal</label>
                            <select id="sucursalgeneral" v-model="sucursal_predeterminada" class="form-control input-border-bottom" :disabled="disabled" onchange="obtenerIngresosGeneral()">
                                <option disabled value="">Seleccione un elemento</option>
                                <?php if ($todosucursales) : ?>
                                    <option value="0">Todas</option>
                                <?php endif; ?>
                                <option v-for="row in sucursales_empleado" :value="row.su_id"><span v-if="disabled==false"></span>{{row.su_nombre}}</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card">
            <div class="card-body">
                <canvas id="multipleLineChart" height="325"></canvas>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card">
            <div class="card-body">
                <canvas id="ventasSemanalescompraMes" height="325"></canvas>
            </div>
        </div>
    </div>
</div>
<script>
    new Vue({
        el: '#AppGeneral',
        data: {
            meses: [],
            anio: moment().format('YYYY'),
            divisa: '',
            art_total: 0,
            costo: 0,
            venta: 0,
            ganancia: 0,
            porcentaje: 0,
            errorForm: [],
            cargando: false,
            cargando_tabla: 'is-loading is-loading-lg',
            sucursal_predeterminada: '',
            sucursales_empleado: [],
            sucursals: '',
            disabled: false
        },
        created() {
            this.obtenerSucursalesEmpleado();
        },
        methods: {
            obtenerSucursalesEmpleado() {
                axios
                    .get("ingresosegresos/obtenerSucursalesEmpleado")
                    .then((response) => {
                        this.sucursales_empleado = response.data.sucursales;
                        this.sucursal_predeterminada = response.data.id;
                        if (response.data.desactivar == true) {
                            this.disabled = true
                        }
                    })
                    .catch((e) => notificacion());
            }
        }
    });
    /// $(function() {
    var myMultipleLineChart = '';
    var multipleLineChart = document.getElementById('multipleLineChart').getContext('2d');


    var chartVentasSemanalescompraMes = '';
    var ventasSemanalescompraMes = document.getElementById('ventasSemanalescompraMes').getContext('2d');

    function obtenerIngresosGeneral() {
        myMultipleLineChart.destroy();
        chartVentasSemanalescompraMes.destroy();

        _ingresosDiarioscompraMes();
        _ingresosGeneral();
        //}
    }

    function _ingresosGeneral() {

        let anio = document.getElementById('aniog').value;
        let sucursal = document.getElementById('sucursalgeneral').value;
        let divisa = document.getElementById('divisasgeneral').value;
        axios({
            method: 'post',
            url: 'ingresosegresos/produccionAnio',
            data: {
                anio: anio,
                divisa: divisa,
                sucursal: sucursal
            },
            transformRequest: serializar(),
        }).then(response => {
            let ingreso_dsm = response.data.anios;

            let dsm_venta = [0];
            let dsm_compra = [0];
            let dsm_label = [0];
            let i = 0;
            Object.keys(ingreso_dsm).forEach(function(k) {
                dsm_venta[i] = ingreso_dsm[k].venta;
                dsm_compra[i] = ingreso_dsm[k].compra;
                dsm_label[i] = ingreso_dsm[k].anio;
                i += 1;
            });

            myMultipleLineChart = new Chart(multipleLineChart, {
                type: 'line',
                data: {
                    labels: dsm_label,
                    datasets: [{
                        label: "Ventas",
                        borderColor: "#1d7af3",
                        pointBorderColor: "#FFF",
                        pointBackgroundColor: "#1d7af3",
                        pointBorderWidth: 2,
                        pointHoverRadius: 4,
                        pointHoverBorderWidth: 1,
                        pointRadius: 4,
                        backgroundColor: 'transparent',
                        fill: true,
                        borderWidth: 2,
                        data: dsm_venta
                    }, {
                        label: "Compras",
                        borderColor: "#59d05d",
                        pointBorderColor: "#FFF",
                        pointBackgroundColor: "#59d05d",
                        pointBorderWidth: 2,
                        pointHoverRadius: 4,
                        pointHoverBorderWidth: 1,
                        pointRadius: 4,
                        backgroundColor: 'transparent',
                        fill: true,
                        borderWidth: 2,
                        data: dsm_compra
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    title: {
                        display: true,
                        text: 'Compras/Ventas Anuales'
                    },
                    tooltips: {
                        bodySpacing: 2,
                        mode: "nearest",
                        intersect: 0,
                        position: "nearest",
                        xPadding: 20,
                        yPadding: 20,
                        caretPadding: 20,
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ' ' + monedaMoneda(tooltipItem.yLabel, response.data.div_locale, response.data.div_simbolo);
                            },
                        }
                    },
                    layout: {
                        padding: {
                            left: 5,
                            right: 5,
                            top: 5,
                            bottom: 5
                        }
                    }
                }
            });

        });

    }


    function _ingresosDiarioscompraMes() {

        let anio = document.getElementById("aniog").value;
        let sucursal = document.getElementById('sucursalgeneral').value;
        let divisa = document.getElementById('divisasgeneral').value;
        axios({
            method: 'post',
            url: 'ingresosegresos/produccionmes',
            data: {
                anio: anio,
                divisa: divisa,
                sucursal: sucursal
            },
            transformRequest: serializar(),
        }).then(response => {
            let ingreso_dsm = response.data.meses;

            let tit = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
            let dsm_ventas = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
            let dsm_compras = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
            let dsm_egreso = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
            let dsm_ingreso = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

            Object.keys(ingreso_dsm).forEach(function(k) {
                for (let i = 0; i < 12; i++) {
                    if (ingreso_dsm[k].mes == tit[i]) {
                        dsm_ventas[i] = ingreso_dsm[k].venta;
                        dsm_compras[i] = ingreso_dsm[k].compra;
                        dsm_egreso[i] = ingreso_dsm[k].egreso;
                        dsm_ingreso[i] = ingreso_dsm[k].ingreso;
                    }
                }
            });

            chartVentasSemanalescompraMes = new Chart(ventasSemanalescompraMes, {
                type: 'bar',
                scaleOverride: true,
                scaleStartValue: 1,
                data: {
                    labels: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
                    datasets: [{
                            label: "Ventas",
                            data: dsm_ventas,
                            backgroundColor: '#37ecff',
                            borderColor: '#37ecff6b',
                            borderWidth: 1
                        },
                        {
                            label: "Compras",
                            data: dsm_compras,
                            backgroundColor: '#f9972f',
                            borderColor: '#f9972f91',
                            borderWidth: 1
                        },
                        {
                            label: "Ingreso",
                            data: dsm_ingreso,
                            backgroundColor: '#49ec1b',
                            borderColor: '#49ec1b82',
                            borderWidth: 1
                        },
                        {
                            label: "Egreso",
                            data: dsm_egreso,
                            backgroundColor: '#ec2f1b',
                            borderColor: '#ec2f1b85',
                            borderWidth: 1
                        }
                    ]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    title: {
                        display: true,
                        text: 'Compras/Ventas mensuales'
                    },
                    tooltips: {
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ' ' + monedaMoneda(tooltipItem.yLabel, response.data.div_locale, response.data.div_simbolo);

                            },
                        }
                    },
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true,
                                callback: function(value, index, values) {
                                    return value;
                                }
                            }
                        }]
                    }
                }
            });

        });
    }
    window.onload = _ingresosGeneral();
    window.onload = _ingresosDiarioscompraMes();
    ///     });
</script>