<div class="row" id="AppDia" v-cloak>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form @submit.prevent="buscar($event)" id="form_dia_busqueda">
                    <div class="form-row">
                        <div class="col-sm-4">
                            <div class="form-group form-floating-label">
                                <input id="dia_anio" type="text" class="form-control input-border-bottom" v-model.number="anio">
                                <label for="dia_anio" class="placeholder">Año</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="dia_meses" class="form-control input-border-bottom" v-model="mes">
                                    <option value="01">Enero</option>
                                    <option value="02">Febrero</option>
                                    <option value="03">Marzo</option>
                                    <option value="04">Abril</option>
                                    <option value="05">Mayo</option>
                                    <option value="06">Junio</option>
                                    <option value="07">Julio</option>
                                    <option value="08">Agosto</option>
                                    <option value="09">Septiembre</option>
                                    <option value="10">Octubre</option>
                                    <option value="11">Noviembre</option>
                                    <option value="12">Diciembre</option>
                                </select>
                                <label for="dia_meses" class="placeholder">Mes</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="dia_divisas" class="form-control input-border-bottom" ref="divisa">
                                <option value="0">Todas</option>    
                                <?php foreach ($divisas as $row) : ?>
                                        <option value="<?= $row['div_id'] ?>" <?= ($row['div_predeterminado'] == 1) ? 'selected' : '' ?>><?= $row['div_descripcion'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="dia_divisas" class="placeholder">Divisa</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="sucursal" v-model="sucursal_predeterminada" class="form-control input-border-bottom" :disabled="disabled">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <?php if ($todosucursales) : ?>
                                        <option value="0">Todas</option>
                                    <?php endif; ?>
                                    <option v-for="row in sucursales_empleado" :value="row.su_id"><span v-if="disabled==false">Sucursal: </span>{{row.su_nombre}}</option>
                                </select>
                                <label for="sucursal" class="placeholder" v-if="disabled===false"> Sucursal</label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-12 text-right">
                            <button type="submit" class="btn btn-border btn-info btn-sm mr-2">Buscar</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-body" :cargando="cargando_tabla">
                <div class="table-responsive">
                    <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_dias">
                        <thead>
                            <tr>
                                <th class="text-center">Día</th>
                                <th class="text-center">Cant. Art</th>
                                <th class="text-center">Costo</th>
                                <th class="text-center">Venta</th>
                                <th class="text-center">Ganancia</th>
                                <th class="text-center">% Ganancia</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in dias">
                                <td class="text-center">{{ row.dia }}</td>
                                <td class="text-center">{{ row.cantidad }}</td>
                                <td class="text-right">{{ moneda(row.costo, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.venta, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.ganancia, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ decimal(row.porcentaje, row.div_locale) }}%</td>
                            </tr>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="text-center">Total</th>
                                <th class="text-center">{{ art_total }}</th>
                                <th class="text-right">{{ costo }}</th>
                                <th class="text-right">{{ venta }}</th>
                                <th class="text-right">{{ ganancia }}</th>
                                <th class="text-right">{{ porcentaje }}</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    new Vue({
        el: '#AppDia',
        data: {
            dias: [],
            anio: moment().format('YYYY'),
            mes: moment().format('MM'),
            divisa: '',
            art_total: 0,
            costo: 0,
            venta: 0,
            ganancia: 0,
            porcentaje: 0,
            errorForm: [],
            cargando: false,
            cargando_tabla: 'is-loading is-loading-lg',
            sucursal_predeterminada:'',
            sucursales_empleado: [],
            sucursals: '',
            disabled: false
        },
        created() {
            this.obtenerSucursalesEmpleado();
        },
        mounted() {},
        methods: {
            obtenerVentaDia() {
                let select_meses = document.getElementById('dia_meses');
                let select_divisa = document.getElementById('dia_divisas');
                let selectedOptionMes = select_meses.options[select_meses.selectedIndex];
                let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];

                axios.get('ingresosegresos/produccionDia', {
                    params: {
                        anio: this.anio,
                        mes: this.mes,
                        divisa: this.$refs.divisa.value,
                        sucursal: this.sucursal_predeterminada
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        if (Object.keys(response.data.dias).length > 0) {
                            this.dias = response.data.dias;
                            this.art_total = response.data.art_total
                            this.costo = response.data.costo;
                            this.venta = response.data.venta;
                            this.ganancia = response.data.ganancia;
                            this.porcentaje = response.data.porcentaje;
                        }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando_tabla = '';

                    let buttonCommon = {
                        exportOptions: {
                            format: {
                                body: function(data, row, column, node) {
                                    return convertir_a_float(data);
                                }
                            }
                        }
                    };

                    $("#tabla_dias").DataTable({
                        dom: 'Bfrtip',
                        buttons: [
                            $.extend(true, {}, buttonCommon, {
                                extend: 'excelHtml5',
                                title: 'Año (' + this.anio + ')' +
                                    ' Mes (' + selectedOptionMes.text + ')' +
                                    ' Divisa (' + selectedOptionDiv.text + ')',
                            }),
                        ]
                    });
                });
            },
            obtenerSucursalesEmpleado() {
                axios
                    .get("ingresosegresos/obtenerSucursalesEmpleado")
                    .then((response) => {
                        this.sucursales_empleado = response.data.sucursales;
                        this.sucursal_predeterminada = response.data.id;
                        if (response.data.desactivar == true) {
                            this.disabled = true
                        }
                        this.obtenerVentaDia();
                    })
                    .catch((e) => notificacion());
            },
            resetearFormulario() {
                document.getElementById('form_dia_busqueda').reset();
                this.anio = moment().format('YYYY');
                this.mes = moment().format('MM');
                this.errorForm = [];
            },
            buscar(event) {

                let select_meses = document.getElementById('dia_meses');
                let select_divisa = document.getElementById('dia_divisas');
                let selectedOptionMes = select_meses.options[select_meses.selectedIndex];
                let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];

                this.errorForm = [];
                this.cargando = true;
                this.cargando_tabla = 'is-loading is-loading-lg';
                $("#tabla_dias").DataTable().destroy();

                axios.get('ingresosegresos/produccionDia', {
                    params: {
                        anio: this.anio,
                        mes: this.mes,
                        divisa: this.$refs.divisa.value,
                        sucursal: this.sucursal_predeterminada
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        this.dias = response.data.dias;
                        this.art_total = response.data.art_total
                        this.costo = response.data.costo;
                        this.venta = response.data.venta;
                        this.ganancia = response.data.ganancia;
                        this.porcentaje = response.data.porcentaje;
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    this.cargando_tabla = '';

                    let buttonCommon = {
                        exportOptions: {
                            format: {
                                body: function(data, row, column, node) {
                                    return convertir_a_float(data);
                                }
                            }
                        }
                    };

                    $("#tabla_dias").DataTable({
                        dom: 'Bfrtip',
                        buttons: [
                            $.extend(true, {}, buttonCommon, {
                                extend: 'excelHtml5',
                                title: 'Año (' + this.anio + ')' +
                                    ' Mes (' + selectedOptionMes.text + ')' +
                                    ' Divisa (' + selectedOptionDiv.text + ')',
                            }),
                        ]
                    });
                });
            },
            moneda(num, div_locale, div_simbolo, decimal = 2) {
                return monedaMoneda(num, div_locale, div_simbolo, decimal);
            },
            decimal(num, div_locale, decimal = 2) {
                return monedaDecimal(num, div_locale, decimal);
            }
        }
    });
</script>