<div class="row" id="appCierreDia">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <input type="date" class="form-control" v-model="fecha" @change="buscarCierreDelDia">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group input-group form-floating-label">
                            <select id="sucursal" v-model="sucursal_predeterminada" class="form-control input-border-bottom" :disabled="disabled">
                                <option disabled value="">Seleccione un elemento</option>
                                <?php if ($todosucursales) : ?>
                                    <option value="0">Todas</option>
                                <?php endif; ?>
                                <option v-for="row in sucursales_empleado" :value="row.su_id"> Sucursal: {{row.su_nombre}}</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-4">

                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                            {{ row }}
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">

                <div class="card-title">Cierre de día Ingresos
                    <button @click="modalImprimir('positivo')" class="btn btn-info btn-round btn-border btn-sm mt-2" style="Float:right; max-height: 2rem;">Imprimir</button>
                    <button @click="modalImprimir('completo')" class="btn btn-info btn-round btn-border btn-sm mt-2" style="Float:right; max-height: 2rem;">Imprimir cierre completo</button>
                </div>

                <div class="table-responsive">
                    <table class="table table-striped table-hover table-head-bg-primary table-bordered-bd-primary" id="tabla_cierre_dia_ingreso">
                        <thead>
                            <tr>
                                <th>CAJERO</th>
                                <th>CUENTA</th>
                                <th>METODO</th>
                                <th>DIVISA</th>
                                <th>TOTAL</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in cierres_del_dia.positivo">
                                <td>{{ row.empleado.nombres + ' ' + row.empleado.apellidos }}</td>
                                <td>{{ row.banco.cuenta }} | {{ row.banco.alias }} </td>
                                <td>{{ row.banco.metodo }}</td>
                                <td>{{ row.divisa }}</td>
                                <td>{{ row.monto }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="row row-card-no-pd">
            <div class="col-sm-6 col-md-4" v-for="row in total_divisas_p">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-3">
                                <div class="icon-big text-center">
                                    <i class="flaticon-coins text-success"></i>
                                </div>
                            </div>
                            <div class="col-9 col-stats">
                                <div class="numbers">
                                    <p class="card-category">{{ row.divisa.divisa }}</p>
                                    <h4 class="card-title">
                                        {{ moneda(row.total, row.divisa.locale, row.divisa.symbol)  }}
                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <div class="card-title">Cierre de día Egresos <button @click="modalImprimir('negativo')" class="btn btn-info btn-round btn-border btn-sm mr-2" style="Float:right; max-height: 2rem;">Imprimir</button></div>
                <div class="table-responsive">
                    <table class="table table-striped table-hover table-head-bg-primary table-bordered-bd-primary" id="tabla_cierre_dia_egreso">
                        <thead>
                            <tr>
                                <th>CAJERO</th>
                                <th>CUENTA</th>
                                <th>METODO</th>
                                <th>DIVISA</th>
                                <th>TOTAL</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in cierres_del_dia.negativo">
                                <td>{{ row.empleado.nombres + ' ' + row.empleado.apellidos }}</td>
                                <td>{{ row.banco.codigo }} | {{ row.banco.cuenta }} | {{ row.banco.alias }} </td>
                                <td>{{ row.banco.metodo }}</td>
                                <td>{{ row.divisa }}</td>
                                <td>{{ row.monto }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="row row-card-no-pd">
            <div class="col-sm-6 col-md-4" v-for="row in total_divisas_n">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-3">
                                <div class="icon-big text-center">
                                    <i class="flaticon-coins text-success"></i>
                                </div>
                            </div>
                            <div class="col-9 col-stats">
                                <div class="numbers">
                                    <p class="card-category">{{ row.divisa.divisa }}</p>
                                    <h4 class="card-title">
                                        {{ moneda(row.total, row.divisa.locale, row.divisa.symbol)  }}
                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modal_imprimir.php' ?>
</div>
<script>
    new Vue({
        el: '#appCierreDia',
        data: {
            fecha: moment().format('YYYY-MM-DD'),
            cierres_del_dia: {
                positivo: [],
                negativo: [],
            },
            total_divisas_p: [],
            total_divisas_n: [],
            errorForm: [],
            cargando: false,
            cargando_tabla: 'is-loading is-loading-lg',
            estaus: '',
            sucursal_predeterminada: document.getElementById('sucursal').value,
            sucursales_empleado: [],
            sucursals: '',
            disabled: false
        },
        created() {
            this.obtenerSucursalesEmpleado();
        },
        methods: {
            obtenerSucursalesEmpleado() {
                axios
                    .get("ingresosegresos/obtenerSucursalesEmpleado")
                    .then((response) => {
                        this.sucursales_empleado = response.data.sucursales;
                        this.sucursal_predeterminada = response.data.id;
                        if (response.data.desactivar == true) {
                            this.disabled = true
                        }
                        this.buscarCierreDelDia();
                    })
                    .catch((e) => notificacion());
            },
            buscarCierreDelDia() {
                this.errorForm = [];
                $('#tabla_cierre_dia_ingreso, #tabla_cierre_dia_egreso').DataTable().destroy();
                axios.get('ingresosegresos/obtenerCierreDelDia', {
                    params: {
                        fecha: this.fecha,
                        sucursal: this.sucursal_predeterminada
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        this.cierres_del_dia.positivo = response.data.cierre_positivo;
                        this.cierres_del_dia.negativo = response.data.cierre_negativo;
                        this.total_divisas_p = response.data.total_divisas_p;
                        this.total_divisas_n = response.data.total_divisas_n;
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando_tabla = '';

                    let buttonCommon = {
                        exportOptions: {
                            format: {
                                body: function(data, row, column, node) {
                                    if (column === 4) {
                                        return convertir_a_float(data)
                                    } else {
                                        return data.replace(/<[^>]*>?/g, '');
                                    }
                                }
                            }
                        }
                    };

                    $("#tabla_cierre_dia_ingreso").DataTable({
                        order: [],
                        dom: 'Bfrtip',
                        buttons: [
                            $.extend(true, {}, buttonCommon, {
                                extend: 'excelHtml5',
                                title: 'Cierre del dia (INGRESO) ' + moment(this.fecha).format('DD-MM-YYYY'),
                            }),
                        ]
                    });

                    $("#tabla_cierre_dia_egreso").DataTable({
                        order: [],
                        dom: 'Bfrtip',
                        buttons: [
                            $.extend(true, {}, buttonCommon, {
                                extend: 'excelHtml5',
                                title: 'Cierre del dia (EGRESO) ' + moment(this.fecha).format('DD-MM-YYYY'),
                            }),
                        ]
                    });
                });
            },
            moneda(num, div_locale, div_simbolo, decimal = 2) {
                return monedaMoneda(num, div_locale, div_simbolo, decimal);
            },
            decimal(num, div_locale, decimal = 2) {
                return monedaDecimal(num, div_locale, decimal);
            },
            modalImprimir(estatus) {
                this.errorForm = [];
                $('#modal-imprimir').modal();
                this.estatus = estatus;
            },
            Imprimir(id) {
                axios.get('ingresosegresos/imprimir', {
                    params: {
                        fecha: this.fecha,
                        id: id,
                        estatus: this.estatus,
                        sucursal: this.sucursal_predeterminada
                    }
                }).then(response => {
                    console.log(response.data);
                    if (response.data.data.errors == null) {
                        fetch(response.data.ip_puerto, {
                            method: 'POST',
                            body: JSON.stringify(response.data.data)
                        }).then((j) => {
                            if (j.ok) {
                                notificacion('fa fa-check', 'Impreso', 'Impresion exitosa', 'success');
                            } else {
                                notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
                            }
                        }).catch((error) => {
                            notificacion('fa fa-ban', 'Error', 'Hubo un problema con la petición Fetch:' + error.message, 'danger');
                        });
                    } else {
                        let total_errores = response.data.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        }
    });
</script>