<?php

use Core\Helpers\Moneda;

?>
<script type="text/javascript">
function actualizar(){location.reload(true);}
//Función para actualizar cada 5 segundos(5000 milisegundos)
setInterval("actualizar()",500000);
</script>

<div class="container">
    <div class="page-inner">
        <div class="page-header ">
            <h4 class="page-title"><?= $empresa ?> <small class="text-primary">(Sucursal :<?php echo $_SESSION['sucursal']['nombre'] ?>)</small></h4>
            <div class="ml-md-auto" style="display: flex;">
                <a href="<?= url('clientes/crear'); ?>" class="btn btn-info btn-border btn-round btn-sm mr-2">Nuevo Cliente</a>
                <a href="#" class="btn btn-secondary btn-round btn-sm mr-2" data-toggle="modal" data-target="#modal-precio-global"> <span class="fas fa-question-circle"></span> Consultar Precio</a>
            </div>
        </div>
        <div class="row">
            <div class="col-8 col-sm-12 col-md-8">
                <div class="row">
                    <div class="col-sm-6 col-md-4">
                        <div class="card card-stats card-round">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-icon">
                                        <div class="icon-big text-center icon-primary bubble-shadow-small">
                                            <i class="flaticon-users"></i>
                                        </div>
                                    </div>
                                    <div class="col col-stats ml-3 ml-sm-0">
                                        <div class="numbers">
                                            <p class="card-category" style="line-height: 1;">Clientes</p>
                                            <h4 class="card-title"><?= $total_clientes; ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-md-4">
                        <div class="card card-stats card-round">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-icon">
                                        <div class="icon-big text-center icon-success bubble-shadow-small">
                                            <i class="far fa-chart-bar"></i>
                                        </div>
                                    </div>
                                    <div class="col col-stats ml-3 ml-sm-0">
                                        <div class="numbers">
                                            <p class="card-category" style="line-height: 1;">Ventas pendientes</p>
                                            <h4 class="card-title"> <?= $ventas_pendientes ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-md-4">
                        <div class="card card-stats card-round">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-icon">
                                        <div class="icon-big text-center icon-secondary bubble-shadow-small">
                                            <i class="far fa-chart-bar"></i>
                                        </div>
                                    </div>
                                    <div class="col col-stats ml-3 ml-sm-0">
                                        <div class="numbers">
                                            <p class="card-category" style="line-height: 1;">Notas de Entrega pendientes</p>
                                            <h4 class="card-title"><?= $notas_pendientes ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="card full-height">
                            <div class="card-body table-responsive">
                                <h6 class="op-7 text-center">Ventas del día</h6>
                                <table class="display nowrap table table-striped table-hover dataTable" id="tabla_ultimas_ventas">
                                    <thead>
                                        <tr>
                                            <th class="text-center">Documento</th>
                                            <th class="text-center">Total</th>
                                            <th class="text-center">Acumulado</th>
                                            <th class="text-center">Fecha</th>
                                            <th class="text-center">Estatus</th>
                                            <th class="text-center"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (is_countable($ultimas_ventas) && count($ultimas_ventas)) : ?>
                                            <?php foreach ($ultimas_ventas as $row) : ?>
                                                <tr>
                                                    <td class="text-center"><?= $row['documento'] . '' . $row['correlativo'] ?></td>
                                                    <td class="text-right"><?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']) ?></td>
                                                    <td class="text-right"><?= Moneda::moneda($row['acumulado'], $row['div_locale'], $row['div_simbolo']) ?></td>
                                                    <td class="text-center"><?= $row['fecha'] ?></td>
                                                    <td class="text-center">
                                                        <?php if ($row['estatus'] == 1) : ?>
                                                            <i title="Finalizado" class="text-success fas fa-check-circle"></i>
                                                            <span class="text-success">Pagado</span>
                                                        <?php elseif ($row['estatus'] == 0 || $row['estatus'] == 2) : ?>
                                                            <i title="Pendiente" class="text-warning fas fa-info-circle"></i>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if ($row['id_documento'] == 1) : ?>
                                                            <?php $ruta = 'notasdeentregaeditar/'; ?>
                                                        <?php elseif ($row['id_documento'] == 12) : ?>
                                                            <?php $ruta = 'ordendeentregaeditar/'; ?>
                                                        <?php else : ?>
                                                            <?php $ruta = 'poseditar/'; ?>
                                                        <?php endif; ?>
                                                        <div class="form-button-action">
                                                            <div class="input-group-append">
                                                                <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa fa-cogs"></i></button>
                                                                <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                                    <a class="dropdown-item" href="<?= ruta_base() . '' . $ruta ?>verFactura/<?= $row['id'] ?>" target="_blank">Abrir</a>
                                                                    <div role="separator" class="dropdown-divider"></div>
                                                                    <a class="dropdown-item" href="<?= ruta_base() . '' . $ruta ?>pdf/<?= $row['id'] ?>" target="_blank">PDF completo</a>
                                                                    <a class="dropdown-item" href="<?= ruta_base() . '' . $ruta ?>pdfMP/<?= $row['id'] ?>" target="_blank">PDF media pagina</a>
                                                                    <a class="dropdown-item" href="<?= ruta_base() . '' . $ruta ?>pdfFMP/<?= $row['id'] ?>" target="_blank">PDF pagos</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12 col-md-6">
                        <div class="card full-height">
                            <div class="card-title">
                                <div class="form-group form-group-default">
                                    <label for="divisas">Divisa</label>
                                    <select class="form-control" id="divisas" onchange="obtenerIngresosDiarios()">
                                        <?php foreach ($divisas as $divisa) :  ?>
                                            <option value="<?= $divisa['div_id'] ?>" <?= ($divisa['div_predeterminado']) ? 'selected' : '' ?>><?= $divisa['div_nombre'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="card-body">
                                <canvas id="ventasSemanales" height="350"></canvas>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-6">
                        <div class="card full-height">
                            <div class="card-body">
                                <canvas id="articulosSemanales" height="350"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-title">
                                <div class="form-group form-group-default">
                                    <label for="mdivisas">Divisa</label>
                                    <select class="form-control" id="mdivisas" onchange="obtenerVentasMensuales()">
                                        <?php foreach ($divisas as $divisa) :  ?>
                                            <option value="<?= $divisa['div_id'] ?>" <?= ($divisa['div_predeterminado']) ? 'selected' : '' ?>><?= $divisa['div_nombre'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="card-body">
                                <canvas id="ventasMensuales" height="400"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">Top 10 Productos del mes</div>
                            </div>
                            <div class="card-body pb-0">
                                <?php foreach ($top_productos as $top_pro) : ?>
                                    <div class="d-flex">
                                        <div class="avatar">
                                            <?php if ($top_pro['imagen']) : ?>
                                                <img src="<?= $top_pro['imagen'] ?>" alt="Imagen Producto" class="avatar-img rounded-circle" width="150" height="150">
                                            <?php else : ?>
                                                <span class="avatar-title rounded-circle border border-white bg-info"><?= strtoupper($top_pro['descripcion'][0]) ?></span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="flex-1 pt-1 ml-2">
                                            <h6 class="fw-bold mb-1"><?= $top_pro['descripcion'] ?></h6>
                                            <small class="text-muted"><?= $top_pro['categoria'] ?></small>
                                        </div>
                                        <div class="d-flex ml-auto align-items-center">
                                            <h3 class="text-info fw-bold">+<?= round($top_pro['cantidad']) ?></h3>
                                        </div>
                                    </div>
                                    <div class="separator-dashed"></div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">Top Clientes</div>
                            </div>
                            <div class="card-body pb-0">
                                <?php foreach ($top_clientes as $top_cli) : ?>
                                    <div class="d-flex">
                                        <div class="avatar">
                                            <span class="avatar-title rounded-circle border border-white bg-info"><?= strtoupper($top_cli['cliente'][0]) ?></span>
                                        </div>
                                        <div class="flex-1 pt-1 ml-2">
                                            <h6 class=" fw-bold mb-1"><?= $top_cli['cliente'] ?></h6>
                                            <small class="text-muted"><?= $top_cli['dni'] ?></small>
                                        </div>
                                        <div class="d-flex ml-auto align-items-center">
                                            <a href="<?= ruta_base() ?>clientes/ver/<?= $top_cli['id'] ?>" class="btn btn-link btn-xs">
                                                <span class="btn-label">
                                                    <i class="fa fa-link"></i>
                                                </span>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="separator-dashed"></div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="<?= asset('assets/js/plugin/chart.js/Chart.min.js') ?>"></script>
<script src="<?= asset('assetsvuejs/home/index.js') ?>"></script>
