<?php

namespace App\Controladores;

use App\Modelos\Generico;
use App\Modelos\IndexModel;
use App\Modelos\ProductoCategoria;
use App\Modelos\ProductosImagen;
use Core\Controller;
use Core\Helpers\Moneda;
use Core\Librerias\Http;
use Core\Vista;

final class IndexControlador extends Controller
{
    public $index_model;

    public function __construct()
    {
        parent::__construct();
        $this->index_model = new IndexModel();
    }

    public function index()
    {
        $pagina_principal = $this->index_model->consultar("SELECT * FROM app_empleado_pagina WHERE ep_empid = {$_SESSION['user_data']['emp_id']}")->row();

        if ($pagina_principal) {

            $metodo = 'index';

            $controlador = $pagina_principal['ep_modulo'];

            $ruta_index = 'app/' . strtolower($controlador) . '/controlador/' . ucfirst($controlador) . 'Controlador.php';

            $controladorNombre = ucwords($controlador) . 'Controlador';

            if (file_exists($ruta_index)) {

                $class = "App\\Controladores\\{$controladorNombre}";
                $obj = new $class();

                if (is_callable([$obj, $metodo]) and method_exists($obj, $metodo)) {
                    call_user_func([$obj, $metodo]);
                } else {
                    Http::exit_by_forbiden();
                }
            } else {
                Http::notFound();
            }
        } else {

            $acumulado_total = 0;
            $array_ventas = [];
            $ventas_pendientes = 0;
            $notas_pendientes = 0;

            $generico=new Generico();

            if(isset($_SESSION['sucursal']['id'])){
                $notas = $this->index_model->obtenerNotasdeentrega($_SESSION['sucursal']['id']);
                $ordenes = $this->index_model->obteneroOrdendeEnterga($_SESSION['sucursal']['id']);
                $facturas = $this->index_model->obtenerFacturas($_SESSION['sucursal']['id']);
            }else{
                $sucursal=$generico->obtenerSucursalespredeterminada($_SESSION['user_data']['emp_id']);
                $notas = $this->index_model->obtenerNotasdeentrega($sucursal['su_id']);
                $ordenes = $this->index_model->obteneroOrdendeEnterga($sucursal['su_id']);
                $facturas = $this->index_model->obtenerFacturas($sucursal['su_id']);
            }
            $documento = $this->index_model->obtenerDocumento(2);
            $data_empresa = $this->index_model->consultar("SELECT * FROM app_empresas")->row();

            if (is_countable($facturas) && count($facturas)) {

                foreach ($facturas as $row) {

                    $acumulado = $this->index_model->obtenerAcumulado($row['fm_id'], 2);
                    $acumulado_total = ($acumulado->total) ?? 0;

                    $array_ventas[] = [
                        'id_documento'  => $documento['doc_id'],
                        'documento'     => $documento['doc_prefijo'],
                        'id'            => $row['fm_id'],
                        'correlativo'   => $row['fm_correlativo'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['fm_total'],
                        'estatus'       => $row['fm_estatus'],
                        'fecha'         => $row['fecha'],
                        'acumulado'     => $acumulado_total,
                        'pendiente'     => $row['fm_total'] - $acumulado_total
                    ];

                    if ($row['fm_estatus'] == 0 || $row['fm_estatus'] == 2) {
                        $ventas_pendientes += 1;
                    }
                }
            }

            if (is_countable($notas) && count($notas)) {

                $documento = $this->index_model->obtenerDocumento(1);

                foreach ($notas as $row) {

                    $acumulado = $this->index_model->obtenerAcumulado($row['ne_id'], 1);
                    $acumulado_total = ($acumulado['total']) ?? 0;

                    $array_ventas[] = [
                        'id_documento'  => $documento['doc_id'],
                        'documento'     => $documento['doc_prefijo'],
                        'id'            => $row['ne_id'],
                        'correlativo'   => $row['ne_correlativo'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['ne_total'],
                        'estatus'       => $row['ne_estatus'],
                        'fecha'         => $row['fecha'],
                        'acumulado'     => $acumulado_total,
                        'pendiente'     => $row['ne_total'] - $acumulado_total
                    ];

                    if ($row['ne_estatus'] == 0 || $row['ne_estatus'] == 2) {
                        $ventas_pendientes += 1;
                        $notas_pendientes += 1;
                    }
                }
            }

            if (is_countable($ordenes) && count($ordenes)) {

                $documento = $this->index_model->obtenerDocumento(12);

                foreach ($ordenes as $row) {

                    $acumulado = $this->index_model->obtenerAcumulado($row['n_id'], 12);
                    $acumulado_total = ($acumulado['total']) ?? 0;

                    $array_ventas[] = [
                        'id_documento'  => $documento['doc_id'],
                        'documento'     => $documento['doc_prefijo'],
                        'id'            => $row['n_id'],
                        'correlativo'   => $row['n_correlativo'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['n_total'],
                        'estatus'       => $row['n_estatus'],
                        'fecha'         => $row['fecha'],
                        'acumulado'     => $acumulado_total,
                        'pendiente'     => $row['n_total'] - $acumulado_total
                    ];

                    if ($row['n_estatus'] == 0 || $row['n_estatus'] == 2) {
                        $ventas_pendientes += 1;
                        $notas_pendientes += 1;
                    }
                }
            }

            $empresa_nombre = 'Nombre de TÚ empresa C.A.';

            if ($data_empresa) {
                $empresa_nombre = $data_empresa['emp_nombre'] ?? 'Nombre de TÚ empresa C.A.';
            }

            return Vista::view('index/index', [
                'ultimas_ventas'    => $array_ventas,
                'ventas_pendientes' => $ventas_pendientes,
                'total_empleados'   => $this->index_model->empleados(),
                'total_clientes'    => $this->index_model->clientes(),
                'divisas'           => $this->index_model->obtenerDivisas(),
                'top_productos'     => $this->topProductos(),
                'top_clientes'      => $this->topClientes(),
                'empresa'           => $empresa_nombre,
                'notas_pendientes'  => $notas_pendientes
            ]);
        }
    }

    private function topProductos()
    {
        $new_pro_img = new ProductosImagen();
        $new_pro_cat = new ProductoCategoria();

        $array_top        = [];
        $array_top_id     = [];

        $notas = $this->index_model->obtenerTopArtProduccionNEVDia();
        $top_pro_facturas = $this->index_model->obtenerTopArtProduccionFACVDia();

        if (is_countable($notas) && count($notas)) {
            foreach ($notas as $row) {
                $array_top[$row['pro_id']] = [
                    'cantidad'      => $row['cantidad'],
                    'descripcion'   => $row['pro_descripcion'],
                    'id'            => $row['pro_id'],
                ];
            }
        }

        if (is_countable($top_pro_facturas) && count($top_pro_facturas)) {
            foreach ($top_pro_facturas as $row_dos) {
                if (!in_array($row_dos['pro_id'], $array_top_id)) {
                    $array_top[$row_dos['pro_id']] = [
                        'cantidad'      => $row_dos['cantidad'],
                        'descripcion'   => $row_dos['pro_descripcion'],
                        'id'            => $row_dos['pro_id'],
                    ];
                    $array_top_id[] = $row_dos['pro_id'];
                } else {
                    $array_top[$row_dos['pro_id']]['cantidad'] += $row_dos['cantidad'];
                }
            }
        }

        if ($array_top !== []) {
            rsort($array_top);
            $lista = array_slice($array_top, 0, 10);
        } else {
            $lista = [];
        }

        $list_top_pro = [];

        if (count($lista) > 0) {

            foreach ($lista as $pro) {

                $imagen = $new_pro_img->obtenerProductoImagen($pro['id']);
                $categoria = $new_pro_cat->obtenerCategoria($pro['id']);

                if ($imagen) {
                    if (file_exists(constant('UPLOADS_URI') . 'productos/' . $imagen['pi_imagen'])) {
                        $imagen = constant('IMG_URI') . 'productos/' . $imagen['pi_imagen'];
                    } else {
                        $imagen = null;
                    }
                } else {
                    $imagen = null;
                }

                $categoria = ($categoria) ? $categoria['cat_nombre'] : null;

                $list_top_pro[$pro['id']] = [
                    'cantidad'      => $pro['cantidad'],
                    'descripcion'   => $pro['descripcion'],
                    'id'            => $pro['id'],
                    'imagen'        => $imagen,
                    'categoria'     => $categoria,
                ];
            }
        }

        return $list_top_pro;
    }

    private function topClientes()
    {
        $array_top        = [];
        $array_top_id     = [];

        $cli_nev = $this->index_model->obtenerTopClientesNev();
        $cli_fac = $this->index_model->obtenerTopClientesFac();

        if (is_countable($cli_nev) && count($cli_nev)) {
            foreach ($cli_nev as $cli) {
                $array_top[$cli['cli_id']] = [
                    'cantidad'  => $cli['cantidad'],
                    'cliente'   => $cli['cli_razon_social'],
                    'id'        => $cli['cli_id'],
                    'dni'       => $cli['cli_dni']
                ];
            }
        }

        if (is_countable($cli_fac) && count($cli_fac)) {
            foreach ($cli_fac as $row_dos) {
                if (!in_array($row_dos['cli_id'], $array_top_id)) {
                    $array_top[$row_dos['cli_id']] = [
                        'cantidad'  => $row_dos['cantidad'],
                        'cliente'   => $row_dos['cli_razon_social'],
                        'id'        => $row_dos['cli_id'],
                        'dni'       => $row_dos['cli_dni']
                    ];
                    $array_top_id[] = $row_dos['cli_id'];
                } else {
                    $array_top[$row_dos['cli_id']]['cantidad'] += $row_dos['cantidad'];
                }
            }
        }

        if ($array_top !== []) {
            rsort($array_top);
            $lista = array_slice($array_top, 0, 10);
        } else {
            $lista = [];
        }

        return $lista;
    }

    public function obtenerVentasMensuales($divisa)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $div_id = filter_var($divisa, FILTER_SANITIZE_NUMBER_INT);

            if (empty($div_id)) {
                $div_master = $this->index_model->obtenerDivisaMaster();
                $div_id = $div_master['div_id'];
            }

            if (empty($this->array_errors)) {

                $array_notas        = [];
                $array_notas_id     = [];
                $artic_total        = 0;

                $notas = $this->index_model->obtenerProduccionNEVMes($div_id);
                $facturas = $this->index_model->obtenerProduccionFACVMes($div_id);
                $divisa = $this->index_model->obtenerDivisa($div_id);

                if (is_countable($notas) && count($notas)) {

                    foreach ($notas as $row) {

                        if (!in_array($row['mes'], $array_notas_id)) {
                            $array_notas[$row['mes']] = [
                                'mes'           => $row['mes'],
                                'cantidad'      => $row['cantidad'],
                                'costo'         => $row['total_costo'],
                                'venta'         => $row['total_venta'],
                                'ganancia'      => $row['total_venta'] - $row['total_costo'],
                            ];
                            $array_notas_id[] = $row['mes'];
                        } else {
                            $array_notas[$row['mes']]['cantidad']   += $row['cantidad'];
                            $array_notas[$row['mes']]['costo']      += $row['total_costo'];
                            $array_notas[$row['mes']]['venta']      += $row['total_venta'];
                            $array_notas[$row['mes']]['ganancia']   += $row['total_venta'] - $row['total_costo'];
                        }

                        $artic_total    += $row['cantidad'];
                    }
                }

                if (is_countable($facturas) && count($facturas)) {

                    foreach ($facturas as $row) {

                        if (!in_array($row['mes'], $array_notas_id)) {
                            $array_notas[$row['mes']] = [
                                'mes'           => $row['mes'],
                                'cantidad'      => $row['cantidad'],
                                'costo'         => $row['total_costo'],
                                'venta'         => $row['total_venta'],
                                'ganancia'      => $row['total_venta'] - $row['total_costo'],
                            ];
                            $array_notas_id[] = $row['mes'];
                        } else {
                            $array_notas[$row['mes']]['cantidad']   += $row['cantidad'];
                            $array_notas[$row['mes']]['costo']      += $row['total_costo'];
                            $array_notas[$row['mes']]['venta']      += $row['total_venta'];
                            $array_notas[$row['mes']]['ganancia']   += $row['total_venta'] - $row['total_costo'];
                        }

                        $artic_total    += $row['cantidad'];
                    }
                }

                Http::json_response([
                    'div_locale'    => $divisa['div_locale'],
                    'div_simbolo'  => $divisa['div_simbolo'],
                    'art_total'     => $artic_total,
                    'meses'         => $array_notas
                ]);
            }

            Http::json_response([
                'errors'   => $this->array_errors,
            ]);
        }
    }

    public function obtenerIngresosDiarios($divisa)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $div_id = filter_var($divisa, FILTER_SANITIZE_NUMBER_INT);

            if (empty($div_id)) {
                $div_master = $this->index_model->obtenerDivisaMaster();
                $div_id = $div_master['div_id'];
            }

            if (empty($this->array_errors)) {

                $array_notas        = [];
                $array_notas_id     = [];
                $artic_total        = 0;
                $costo              = 0;
                $venta              = 0;

                $notas = $this->index_model->obtenerProduccionNEVDia($div_id);
                $facturas = $this->index_model->obtenerProduccionFACVDia($div_id);
                $divisa = $this->index_model->obtenerDivisa($div_id);

                if (is_countable($notas) && count($notas)) {

                    foreach ($notas as $row) {

                        if (!in_array($row['n_dia_semana'], $array_notas_id)) {
                            $array_notas[$row['n_dia_semana']] = [
                                'n_dia_semana'  => $row['n_dia_semana'],
                                'cantidad'      => $row['cantidad'],
                                'costo'         => $row['total_costo'],
                                'venta'         => $row['total_venta'],
                            ];
                            $array_notas_id[] = $row['n_dia_semana'];
                        } else {
                            $array_notas[$row['n_dia_semana']]['cantidad']   += $row['cantidad'];
                            $array_notas[$row['n_dia_semana']]['costo']      += $row['total_costo'];
                            $array_notas[$row['n_dia_semana']]['venta']      += $row['total_venta'];
                        }

                        $artic_total    += $row['cantidad'];
                        $costo          += $row['total_costo'];
                        $venta          += $row['total_venta'];
                    }
                }

                if (is_countable($facturas) && count($facturas)) {

                    foreach ($facturas as $row_dos) {

                        if (!in_array($row_dos['n_dia_semana'], $array_notas_id)) {
                            $array_notas[$row_dos['n_dia_semana']] = [
                                'n_dia_semana'  => $row_dos['n_dia_semana'],
                                'cantidad'      => $row_dos['cantidad'],
                                'costo'         => $row_dos['total_costo'],
                                'venta'         => $row_dos['total_venta'],
                            ];
                            $array_notas_id[] = $row_dos['n_dia_semana'];
                        } else {
                            $array_notas[$row_dos['n_dia_semana']]['cantidad']   += $row_dos['cantidad'];
                            $array_notas[$row_dos['n_dia_semana']]['costo']      += $row_dos['total_costo'];
                            $array_notas[$row_dos['n_dia_semana']]['venta']      += $row_dos['total_venta'];
                        }

                        $artic_total    += $row_dos['cantidad'];
                        $costo          += $row_dos['total_costo'];
                        $venta          += $row_dos['total_venta'];
                    }
                }

                Http::json_response([
                    'div_locale'    => $divisa['div_locale'],
                    'div_simbolo'  => $divisa['div_simbolo'],
                    'costo'         => Moneda::moneda($costo, $divisa['div_locale'], $divisa['div_simbolo']),
                    'venta'         => Moneda::moneda($venta, $divisa['div_locale'], $divisa['div_simbolo']),
                    'art_total'     => $artic_total,
                    'dias_semana'   => $array_notas
                ]);
            }

            Http::json_response([
                'errors'   => $this->array_errors,
            ]);
        }
    }

    public function obtenerArticulosDiarios()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $array_notas        = [];
            $array_notas_id     = [];
            $artic_total        = 0;

            $notas = $this->index_model->obtenerArtProduccionNEVDia();
            $facturas = $this->index_model->obtenerArtProduccionFACVDia();

            if (is_countable($notas) && count($notas)) {

                foreach ($notas as $row) {

                    if (!in_array($row['n_dia_semana'], $array_notas_id)) {
                        $array_notas[$row['n_dia_semana']] = [
                            'n_dia_semana'  => $row['n_dia_semana'],
                            'cantidad'      => $row['cantidad'],
                        ];
                        $array_notas_id[] = $row['n_dia_semana'];
                    } else {
                        $array_notas[$row['n_dia_semana']]['cantidad']   += $row['cantidad'];
                    }

                    $artic_total    += $row['cantidad'];
                }
            }

            if (is_countable($facturas) && count($facturas)) {

                foreach ($facturas as $row_dos) {

                    if (!in_array($row_dos['n_dia_semana'], $array_notas_id)) {
                        $array_notas[$row_dos['n_dia_semana']] = [
                            'n_dia_semana'  => $row_dos['n_dia_semana'],
                            'cantidad'      => $row_dos['cantidad'],
                        ];
                        $array_notas_id[] = $row_dos['n_dia_semana'];
                    } else {
                        $array_notas[$row_dos['n_dia_semana']]['cantidad']   += $row_dos['cantidad'];
                    }

                    $artic_total    += $row_dos['cantidad'];
                }
            }

            Http::json_response([
                'art_total'     => $artic_total,
                'dias_semana'   => $array_notas
            ]);
        }
    }
}
