<div class="container" id="appGrupos" v-cloak>
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Grupos</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('grupos') ?>">Grupos</a>
                </li>
            </ul>
            <div class="ml-md-auto" style="display: flex;">
                <a href="<?= url('clientes'); ?>" class="btn btn-info btn-border btn-round mr-2"><span class="fa fa-flip-horizontal fa-share"></span> Clientes</a>
                <a href="" class="btn btn-info btn-border btn-round mr-2" @click.prevent="modalGuardar"><span class="fa fa-save"></span> Agregar</a>
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover table-sm" id="tabla_grupos">
                        <thead>
                            <tr>
                                <th>Código</th>
                                <th>Nombre</th>
                                <th>Descuento %</th>
                                <th>Descripción</th>
                                <th>Estatus</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in grupos">
                                <td>{{ row.grup_codigo }}</td>
                                <td>{{ row.grup_nombre }}</td>
                                <td>{{ row.grup_descuento }} %</td>
                                <td>{{ row.grup_descripcion}}</td>
                                <td class="text-center">
                                    <a href="#" title="Modificar estatus" @click.prevent="modificarEstatus(row.grup_id, 'status'+row.grup_id)">
                                        <i :class="row.grup_estatus == 1 ? 'fa fa-check text-success' : 'fa fa-times text-danger'" :id="'status'+row.grup_id"></i>
                                    </a>
                                </td>
                                <td class="text-center">
                                    <div class="form-button-action">
                                        <button type="button" title="Editar" class="btn btn-link btn-primary" @click="ver(row.grup_id, row.grup_codigo, row.grup_nombre, row.grup_descripcion, row.grup_descuento)">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button type="button" title="Eliminar" class="btn btn-link btn-danger" @click="eliminar(row.grup_id, row.grup_nombre)">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                        <a target="_blank" class="btn btn-link btn-info" :href="'<?= ruta_base() ?>grupos/pdf_clientes/'+row.grup_id">
                                            <i class="fas fa-file-pdf"></i>
                                        </a>
                                        <a target="_blank" class="btn btn-link btn-info" :href="'<?= ruta_base() ?>grupos/listadoclientesExcel/'+row.grup_id">
                                            <i class="fas fa-file-excel"></i>
                                        </a>
                                        
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modaleditarguardar.php'; ?>
</div>
<script src="<?= ruta_base() ?>public/assetsvuejs/grupos/grupos.js"></script>