<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | <?= constant('DEFAULT_TITLE'); ?></title>
    <link rel="icon" href="<?= asset('assets/img/imageninsta.ico'); ?>" type="image/x-icon" />
    <style>
        @font-face {
            font-family: Lato;
            src: url(<?= asset("assets/Lato/Lato-Regular.ttf") ?>);
            font-weight: 400;
            font-style: normal;

        }

        @font-face {
            font-family: Lato;
            src: url(<?= asset("assets/Lato/Lato-Bold.ttf") ?>);
            font-weight: 700;
            font-style: normal;
        }

        body {
            font-family: Lato;
            font-style: normal;
            line-height: 1;
            text-decoration: inherit;
            text-rendering: optimizeLegibility;
            text-transform: none;
        }

        .login1 {
            font-family: sans-serif !important;
            background: #fff;
            background-size: cover;
        }

        .section-box {
            float: right;
            width: 35%;
            height: 100vh;
        }

        .login-box {
            padding: 45px 20px 45px 20px;
            width: 375px;
            height: 90%;
            position: absolute;
            top: 5%;
            left: 65%;
            background: #1572E8;
            border-radius: 15px;
            box-shadow: 0px 0px 5px 5px rgb(229, 231, 252);
            text-align: center;
        }

        .card-header h4 {
            font-family: sans-serif !important;
            font-size: 18px !important;
            color: #fff;
            border-bottom: 3px solid #fff;
            width: 55%;
            margin-top: 5px;
            margin-left: 25%;
            padding: 20px;
        }

        .textbox {
            width: 70%;
            overflow: hidden;
            font-size: 20px;
            padding: 8px 0 4px 0;
            margin: 8px 0;
            margin-left: 15%;
            border-bottom: 1px solid #fff;
        }

        .textbox i {
            width: 26px;
            float: left;
            text-align: center;
            color: #fff;
            margin-right: 5px;
        }

        .textbox input {
            border: none;
            outline: none;
            background: none;
            color: #fff;
            font-size: 16px;
            width: 60%;
            float: left;
            margin-bottom: 5px;
        }

        .login-btn {
            width: 40%;
            background: transparent;
            font-family: sans-serif;
            border: 2px solid #fff;
            border-radius: 20px;
            color: #fff;
            padding: 5px;
            font-size: 12px;
            cursor: pointer;
            margin: 30px 20px 20px 25px;
            font-weight: bold;
        }

        .login-btn:hover {
            color: #1572E8;
            background: #fff;
        }

        ::placeholder {
            color: #fff;
        }

        .fondoderecho {
            float: left;
            width: 100%;
            margin-top: 150px;
            height: 500px;
            background: url(public/assets/img/imagen_login.jpg) no-repeat;
            background-size: cover;
            background-position: center;
        }

        .content {
            float: left;
            width: 100%;
            position: absolute;
            height: 100px;
            font-family: sans-serif !important;
            text-align: center;
            color: #6861CE !important;
            letter-spacing: 2px;
            border-radius: 5px;
            margin-top: 30px;
            padding: 5px;
        }

        .content>h2 {
            font-size: 2rem;
        }

        .content>h3 {
            color: #1572E8;
        }

        .logo {
            float: left;
            position: fixed;
            width: 150px;
            height: 45px;
            border-radius: 5px;
            left: 60%;
            top: 90%;
            padding: 5px;
            background: #6861CE;
            z-index: 1;
        }

        @media screen and (max-width: 576px) {
            .fondo {
                display: none;
            }
        }

        .login-brand {
            margin: 20px 0;
            margin-bottom: 20px;
            margin-bottom: 40px;
            font-size: 24px;
            text-transform: uppercase;
            letter-spacing: 4px;
            color: #666;
            text-align: center;
        }

        .login-brand {
            font-size: 24px;
            text-transform: uppercase;
            letter-spacing: 4px;
            color: #666;
            text-align: center;
        }

        .shadow-light {
            box-shadow: 0 2px 6px #e6ecf1;
        }

        .alert {
            color: #ffad46;
        }
    </style>
    <link rel="stylesheet" href="<?= asset('assets/css/bootstrap.min.css'); ?>">
    <link rel="stylesheet" href="<?= asset('assets/css/atlantis.css'); ?>">
    <link rel="stylesheet" href="<?= asset('assets/css/animate.min.css'); ?>">
    <link rel="stylesheet" href="<?= asset('assets/css/fontawesome.min.css'); ?>">
    <link rel="stylesheet" href="<?= asset('assets/css/animate.min.css'); ?>">
    <link rel="stylesheet" href="<?= asset('assets/style.css'); ?>">

    <script src="<?= asset('assets/vue.js'); ?>"></script>
    <script src="<?= asset('assets/axios.min.js'); ?>"></script>
    <script src="<?= asset('assets/js/lottie-player.js'); ?>"></script>

</head>


<body class="login1">
    <div id="app">
        <section class="section">
            <div class="container mt-5">
                <div class="row">
                    <div class="fondo col-lg-8">
                        <lottie-player src="<?= asset('assets/img/Code-google.json'); ?>"  background="transparent" speed="1"  style="width: 80%; height: 80%;"  loop  autoplay></lottie-player>
                    </div>
                    <div class="col-lg-4">
                        <div class="login-brand">
                            <img src="public/assets/img/imageninsta.ico" alt="logo" width="100" class="shadow-light rounded-circle">
                        </div>

                        <div class="card card-primary animate__animated animate__fadeInRight">
                            <div class="card-header">
                                <h4>CODIGO</h4>
                            </div>
                            <div style="color:#FFAD46;">
                                <?php echo session_mensaje(); ?>
                            </div>
                            <div class="card-body">
                                <form action="<?php url('google/acceso'); ?>" method="post">
                                     
                                    <div class="form-group" style="padding: 5px;">
                                        <input id="code" name="code" type="number" class="form-control input-border" placeholder="Ingrese su codigo de seguridad">
                                    </div>
                                    <div class="form-group text-center">
                                        <button type="submit" class="login-btn">
                                            Confirmar
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="simple-footer text-center">
                            Desarrollado por Firma Digital &copy; <?= date('Y'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</body>

</html>