<?php

namespace App\Modelos;

use Core\Database;

class Generico extends Database
{
    public function obtenerDivisas(): array
    {
        return $this->consultar("SELECT * FROM app_divisas WHERE div_status = 1")->all();
    }

    public function obtenerDivisaAlCambio(int $id_divisa_master, int $id_divisa_buscada)
    {
        return $this->consultar("SELECT * FROM app_divisas_factor WHERE df_divid_master=$id_divisa_master and df_divid=$id_divisa_buscada")->row();
    }

    public function obtenerDivisaAlCambioProducto(string $serial, int $id_divisa_master, int $id_divisa_buscada)
    {
        return $this->consultar("SELECT * FROM app_bitacora_factor 
        WHERE bitfac_relacion = '$serial' AND bifac_divid_uno=$id_divisa_master and bifac_divid_dos=$id_divisa_buscada")->row();
    }

    public function obtenerDivisasProducto(string $serial)
    {
        return $this->consultar("SELECT * FROM app_bitacora_factor WHERE bitfac_relacion = '$serial'")->all();
    }

    public function obtenerProductos(string $buscar)
    {
        $sqlproducto = '';

        $palabras = explode(' ', $buscar);
        if (count($palabras) > 1) {

            foreach ($palabras as $i => $pal) {
                if ($i == 0) {
                    $sqlproducto .= " (LOWER(p.pro_codigo) LIKE '%$pal%' OR LOWER(p.pro_descripcion) LIKE '%$pal%' OR LOWER(p.pro_precio) LIKE '%$pal%' OR LOWER(pc.pc_codigo) LIKE '%$pal%')";
                } else {
                    $sqlproducto .= " AND (LOWER(p.pro_codigo) LIKE '%$pal%' OR LOWER(p.pro_descripcion) LIKE '%$pal%' OR LOWER(p.pro_precio) LIKE '%$pal%' OR LOWER(pc.pc_codigo) LIKE '%$pal%')";
                }
            }
        } else {
            $sqlproducto .= " (LOWER(p.pro_codigo) LIKE '%$buscar%' OR LOWER(p.pro_descripcion) LIKE '%$buscar%' OR LOWER(p.pro_precio) LIKE '%$buscar%' OR LOWER(pc.pc_codigo) LIKE '%$buscar%')";
        }

        $sql = "SELECT DISTINCT(pro_id), p.*, pimg.*,fa.*,pc.*   
        FROM app_productos p
        LEFT JOIN app_productos_codbarra pc ON pc.pc_proid = p.pro_id 
        LEFT JOIN app_productos_imagen pimg ON pimg.pi_proid = p.pro_id 
        LEFT JOIN app_fabricantes fa ON fa.fa_id=p.pro_fabid 
            WHERE $sqlproducto GROUP BY p.pro_id";

        return $this->consultar("$sql")->all();
    }

    public function obtenerProducto(int $id_producto)
    {
        return $this->consultar("SELECT pro_id, pro_precio, ps_cantidad, alm_id, alm_nombre
        FROM app_productos p
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid = p.pro_id
        LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid
        WHERE pro_id = $id_producto")->all();
    }

    public function obtenerProductoAlmacen(int $id_producto, string $where_almacen)
    {
        return $this->consultar("SELECT pro_id, pro_precio, ps_cantidad, alm_id, alm_nombre
        FROM app_productos p
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid = p.pro_id
        LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid
        WHERE pro_id = $id_producto AND $where_almacen")->all();
    }

    public function obtenerProductoFactor(int $id_producto)
    {
        return $this->consultar("SELECT *
        FROM app_producto_factor p 
        WHERE p.profac_proid=$id_producto")->row();
    }

    public function obtenerNotasdeEntregaAnualesPendientes()
    {
        $ano = date('Y');
        return $this->consultar("SELECT ne.ne_id, ne.ne_correlativo, ne.ne_fecha, ne.ne_total, d.*, c.cli_id, c.cli_dni, c.cli_razon_social 
        FROM app_notas_de_entrega ne 
        JOIN app_divisas d ON d.div_id = ne.ne_divid
        JOIN app_clientes c ON c.cli_id = ne.ne_cliid 
        WHERE (ne.ne_estatus=0 OR ne.ne_estatus=2) AND YEAR(ne.ne_fecha)=$ano ORDER BY ne_id DESC")->all();
    }

    public function obtenerFacturasAnualesPendientes()
    {
        $ano = date('Y');
        return $this->consultar("SELECT fm.fm_id, fm.fm_correlativo, fm.fm_fecha, fm.fm_total, d.*, c.cli_id, c.cli_dni, c.cli_razon_social 
        FROM  app_factura_master fm 
        JOIN app_divisas d ON d.div_id = fm.fm_divid
        JOIN app_clientes c ON c.cli_id = fm.fm_cliid 
        WHERE (fm.fm_estatus=0 OR fm.fm_estatus=2) AND YEAR(fm.fm_fecha)=$ano ORDER BY fm_id DESC")->all();
    }

    public function obtenerPresupuestosAnualesPendientes()
    {
        $ano = date('Y');
        return $this->consultar("SELECT pre.pre_id, pre.pre_correlativo, pre.pre_fecha, pre.pre_total, d.*, c.cli_id, c.cli_dni, c.cli_razon_social 
        FROM app_presupuesto pre 
        JOIN app_divisas d ON d.div_id = pre.pre_divid
        JOIN app_clientes c ON c.cli_id = pre.pre_cliid 
        WHERE (pre.pre_estatus=0 OR pre.pre_estatus=2) AND YEAR(pre.pre_fecha)=$ano ORDER BY pre_id DESC")->all();
    }

    public function obtenerPedidosAnualesPendientes()
    {
        $ano = date('Y');
        return $this->consultar("SELECT pe.pe_id, pe.pe_correlativo, pe.pe_fecha, pe.pe_total, d.*, c.cli_id, c.cli_dni, c.cli_razon_social 
        FROM app_pedidos pe 
        JOIN app_divisas d ON d.div_id = pe.pe_divid
        JOIN app_clientes c ON c.cli_id = pe.pe_cliid 
        WHERE (pe.pe_estatus=0 OR pe.pe_estatus=2) AND YEAR(pe.pe_fecha)=$ano ORDER BY pe_id DESC")->all();
    }

    public function obtenerNotasdeEntregaAnualesPendientess($peticion)
    {
        return $this->consultar("SELECT ne.ne_id, ne.ne_correlativo, ne.ne_fecha, ne.ne_total, d.*, c.cli_id, c.cli_dni, c.cli_razon_social 
        FROM app_notas_de_entrega ne 
        JOIN app_divisas d ON d.div_id = ne.ne_divid
        JOIN app_clientes c ON c.cli_id = ne.ne_cliid 
        WHERE (ne.ne_estatus=0 OR ne.ne_estatus=2) AND $peticion ORDER BY ne_id DESC")->all();
    }

    public function obtenerSucursalespredeterminada($id_empleado)
    {
        return $this->consultar("SELECT * FROM app_empleados_sucursales s 
        JOIN app_sucursales su ON s.sucursal_id = su.su_id
        WHERE empleado_id=$id_empleado AND sucursal_predeterminado=1")->row();
    }

    public function obtenerSucursales($id)
    {
        return $this->consultar("SELECT * FROM app_sucursales 
        WHERE su_id=$id")->row();
    }

    public function obtenerEmpleadosObrero($cate)
    {
        return $this->consultar("SELECT * 
        FROM app_planilla_categorias_empleados ce 
        JOIN app_planilla_categorias c ON ce.catemp_catid = c.cat_id 
        JOIN app_empleados_info einfo ON einfo.einfo_id = ce.catemp_empid 
        JOIN app_empleados e ON e.emp_edatosid=einfo.einfo_id  
        WHERE ce.catemp_catid=$cate")->all();
    }

    public function obtenerEmpleadosObrero2($cate,$cate2)
    {
        return $this->consultar("SELECT DISTINCT(einfo.einfo_id),ce.*, c.*,einfo.*,e.* 
        FROM app_planilla_categorias_empleados ce 
        JOIN app_planilla_categorias c ON ce.catemp_catid = c.cat_id 
        JOIN app_empleados_info einfo ON einfo.einfo_id = ce.catemp_empid 
        JOIN app_empleados e ON e.emp_edatosid=einfo.einfo_id  
        WHERE ce.catemp_catid=$cate OR ce.catemp_catid=$cate2 GROUP BY einfo.einfo_id")->all();
    }

    public function getUserInfo(int $user)
    {
        return $this->consultar("SELECT * FROM app_empleados WHERE emp_id=$user")->row();
    }

    public function getUserInfoDa(int $user)
    {
        return $this->consultar("SELECT * FROM app_empleados e 
        JOIN app_empleados_info einfo ON einfo.einfo_id = e.emp_id  
        WHERE einfo.einfo_id=$user")->row();
    }

    public function obtenerSucursalesTodos($id_empleado)
    {
        return $this->consultar("SELECT * FROM app_empleados_sucursales s 
        JOIN app_sucursales su ON s.sucursal_id = su.su_id
        WHERE empleado_id=$id_empleado")->all();
    }

    public function obtenerFacturasAnualesPendientess($peticion)
    {
        return $this->consultar("SELECT fm.fm_id, fm.fm_correlativo, fm.fm_fecha, fm.fm_total, d.*, c.cli_id, c.cli_dni, c.cli_razon_social 
        FROM  app_factura_master fm 
        JOIN app_divisas d ON d.div_id = fm.fm_divid
        JOIN app_clientes c ON c.cli_id = fm.fm_cliid 
        WHERE (fm.fm_estatus=0 OR fm.fm_estatus=2) AND $peticion ORDER BY fm_id DESC")->all();
    }

    public function obtenerPedidosAnualesPendientess($peticion)
    {
        return $this->consultar("SELECT pe.pe_id, pe.pe_correlativo, pe.pe_fecha, pe.pe_total, d.*, c.cli_id, c.cli_dni, c.cli_razon_social 
        FROM app_pedidos pe 
        JOIN app_divisas d ON d.div_id = pe.pe_divid
        JOIN app_clientes c ON c.cli_id = pe.pe_cliid 
        WHERE (pe.pe_estatus=0 OR pe.pe_estatus=2) AND $peticion ORDER BY pe_id DESC")->all();
    }

    public function obtenerPresupuestosAnualesPendientess($peticion)
    {
        return $this->consultar("SELECT pre.pre_id, pre.pre_correlativo, pre.pre_fecha, pre.pre_total, d.*, c.cli_id, c.cli_dni, c.cli_razon_social 
        FROM app_presupuesto pre 
        JOIN app_divisas d ON d.div_id = pre.pre_divid
        JOIN app_clientes c ON c.cli_id = pre.pre_cliid 
        WHERE (pre.pre_estatus=0 OR pre.pre_estatus=2) AND $peticion ORDER BY pre_id DESC")->all();
    }

    public function obtenerPlanillas($id)
    {
        return $this->consultar("SELECT *  
        FROM app_planilla_orden_de_entrega o  
        JOIN app_preorden_master pre ON pre.pre_id = o.po_preid 
        WHERE o.po_nid=$id")->row();
    }

    public function totalPagos(int $id_factura, int $documento, int $categoria)
    {
        return $this->consultar("SELECT SUM(fab_conversion) as total, COUNT(fab_id) as cantidad FROM app_movimientos WHERE fab_idgenerico=$id_factura AND fab_doc = $documento AND fab_categoria=$categoria")->row();
    }
}
