<?php

namespace App\Controladores;

use App\Modelos\Comisiones;
use App\Modelos\EmpleadoInfo;
use App\Modelos\EmpleadosComisionesEmplAgente;
use App\Modelos\Generico;
use App\Modelos\Productos;
use Core\Controller;
use Core\Helpers\Moneda;
use Core\Librerias\Http;
use Automattic\WooCommerce\Client;
use Automattic\WooCommerce\HttpClient\HttpClientException;

final class GenericoControlador extends Controller
{
    private $array_errors = [];
    private $newModel;
    private $divisa_master;

    public function __construct()
    {
        parent::__construct();
        $this->newModel = new Generico();
        $this->divisa_master = Moneda::Predeterminada();
    }

    private function obtenerPrecioSegunDivisa(float $precio, int $id_divisa_master, int $id_divisa_buscada)
    {
        $divisa_factor = $this->newModel->obtenerDivisaAlCambio($id_divisa_master, $id_divisa_buscada);

        if ($divisa_factor) {
            $precio *= $divisa_factor['df_factor'];
            $factor = $divisa_factor['df_factor'];
        } else {
            $precio = $precio;
            $factor = 1;
        }

        return [
            'precio' => $precio,
            'factor' => $factor
        ];
    }

    public function woocommerce()
    {
        if (defined('WCURL') && defined('WCKEY') && defined('WCSECRECT') && defined('WCIMG')) {
            $woocom = new Client(
                constant('WCURL'),
                constant('WCKEY'),
                constant('WCSECRECT'),
                [
                    'wp_api'    => true,
                    'version'   => 'wc/v3',
                    'timeout'   => 30
                ]
            );
            $estatus = 'processing';
            $woocomm = [];
            try {
                $woocomm = $woocom->get('orders', ['per_page' => 100, 'status' => $estatus]);
                if (is_countable($woocomm) && count($woocomm) > 0) {
                    $pedidos_woocommerce = count($woocomm);
                } else {
                    return  $pedidos_woocommerce = 0;
                }
            } catch (HttpClientException $e) {
                return $e->getMessage();
            }
        } else {
            return $pedidos_woocommerce = 0;
        }
    }

    public function obtenerPrecioSegunDivisaFactorProducto(string $serial,  float $precio, int $id_divisa_master, int $id_divisa_buscada)
    {
        $divisa_factor = $this->newModel->obtenerDivisaAlCambioProducto($serial, $id_divisa_master, $id_divisa_buscada);

        if ($divisa_factor) {
            $precio *= $divisa_factor['bifac_factor'];
            $factor = $divisa_factor['bifac_factor'];
        } else {
            $precio = $precio;
            $factor = 1;
        }

        return [
            'precio' => $precio,
            'factor' => $factor
        ];
    }

    public function obtenerPrecioProducto()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $array_productos = [];

            if (!empty($_GET['buscar'])) {

                $buscar = $_GET['buscar'];
                $producto = $this->solicitud->sanitize($buscar, FILTER_SANITIZE_STRIPPED);
                $productos = $this->newModel->obtenerProductos($producto);

                if (is_countable($productos) && count($productos)) {

                    foreach ($productos as $pro) {

                        $imagen = null;

                        if (($pro['pi_imagen'] != null || $pro['pi_imagen'] != '') && file_exists(constant('UPLOADS_URI') . 'productos/' . $pro['pi_imagen'])) {
                            $imagen = constant('IMG_URI') . 'productos/' . $pro['pi_imagen'];
                        }

                        $array_productos[] = [
                            'id'                => $pro['pro_id'],
                            'nombre'            => $pro['pro_descripcion'],
                            'descripcion'       => "({$pro['pro_codigo']}) {$pro['pro_descripcion']}",
                            'fabricante'        => $pro['fa_nombre'],
                            'imagen'            => $imagen,
                            'precio'            => $pro['pro_precio']
                        ];
                    }
                }
            }

            Http::json_response($array_productos);
        }
    }

    public function obtenerProductoDetallado(int $id_producto)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_producto = filter_var($id_producto, FILTER_SANITIZE_NUMBER_INT);
            $where_alm = '';
            $almacenes = [];

            $p=new Productos();
            $empresa=$this->newModel->consultar("SELECT * FROM app_empresas")->row();
            $factCompra = $empresa['emp_iva'];

            if ($this->newModel->consultar("SELECT * FROM app_permissions WHERE  module_id = 'facturacion' AND emp_id = {$_SESSION['user_data']['emp_id']}")->row()) {
                $producto = $this->newModel->obtenerProducto($id_producto);
                if (is_countable($producto) && count($producto)) {
                    foreach ($producto as $pro) {
                        if ($pro['alm_id']) {
                            $almacenes[] = [
                                'nombre' => $pro['alm_nombre'],
                                'cantidad' => $pro['ps_cantidad'] > 0 ? round($pro['ps_cantidad'], 2)  : 'Sin existencia'
                            ];
                        }
                    }
                }
            } else {
                $almacenes_emp = $this->newModel->consultar("SELECT * FROM app_empleados_almacen WHERE  empalm_empid = {$_SESSION['user_data']['emp_id']}")->all();
                $i = 0;
                if (is_countable($almacenes_emp) && count($almacenes_emp)) {
                    foreach ($almacenes_emp as $row) {
                        if ($i == 0) {
                            $where_alm = "alm_id = {$row['empalm_almid']}";
                        } else {
                            $where_alm .= " OR alm_id = {$row['empalm_almid']}";
                        }
                        $i++;
                    }
                }
                $producto = $this->newModel->obtenerProductoAlmacen($id_producto, $where_alm);
                if (is_countable($producto) && count($producto)) {
                    foreach ($producto as $pro) {
                        if ($pro['alm_id']) {
                            $almacenes[] = [
                                'nombre' => $pro['alm_nombre'],
                                'cantidad' => $pro['ps_cantidad'] > 0 ? round($pro['ps_cantidad'], 2)  : 'Sin existencia'
                            ];
                        }
                    }
                }
            }

            $factor_producto = $this->newModel->obtenerProductoFactor($id_producto);
            $divisas = $this->newModel->obtenerDivisas();
            $precios = [];

            $impuesto=$p->obtenerproImp($id_producto);

            if (is_countable($producto) && count($producto)) {

                if ($factor_producto) {
                    $divisas = $this->newModel->obtenerDivisasProducto($factor_producto['profac_bifac_serial']);
                   
                    foreach ($divisas as $row) {
                        $precio = $this->obtenerPrecioSegunDivisaFactorProducto($factor_producto['profac_bifac_serial'], $producto[0]['pro_precio'], $this->divisa_master['id'], $row['bifac_divid_dos']);
                        $p=convertir_a_float($precio['precio']+($precio['precio'] * ($impuesto['imp_valor'] / 100)));
                        $div = Moneda::obtenerDivisa($row['bifac_divid_dos']);
                        $precios[] = [
                            'divisa' => [
                                'simbolo' => $div['symbol'],
                                'nombre' => $div['divisa']
                            ],
                            'precio' =>($factCompra==1)? Moneda::moneda($p, $div['locale'], $div['symbol']) : Moneda::moneda($precio['precio'], $div['locale'], $div['symbol'])
                        ];
                    }
                } else {
                    foreach ($divisas as $row) {
                        $precio = $this->obtenerPrecioSegunDivisa($producto[0]['pro_precio'], $this->divisa_master['id'], $row['div_id']);
                        $p=convertir_a_float($precio['precio']+($precio['precio'] * ($impuesto['imp_valor'] / 100)));
                        
                        $precios[] = [
                            'divisa' => [
                                'simbolo' => $row['div_simbolo'],
                                'nombre' => $row['div_nombre']
                            ],
                            'precio' => ($factCompra==1)? Moneda::moneda($p, $row['div_locale'], $row['div_simbolo']) : Moneda::moneda($precio['precio'], $row['div_locale'], $row['div_simbolo'])
                        ];
                    }
                }
            } else {
                $this->array_errors[] = 'Acción prophibida';
            }

            if (empty($this->array_errors)) {
                Http::json_response([
                    'almacenes' => $almacenes,
                    'precios' => $precios
                ]);
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function conversion()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_GET['div_p']) && !empty($_GET['div_s'])) {

                $div_p = filter_var($_GET['div_p'], FILTER_SANITIZE_NUMBER_INT);
                $div_s = filter_var($_GET['div_s'], FILTER_SANITIZE_NUMBER_INT);

                $divisa_factor = $this->newModel->obtenerDivisaAlCambio($div_p, $div_s);

                if ($divisa_factor) {
                    $conversion = [
                        'divisa_conv' => Moneda::obtenerDivisa($div_p),
                        'divisa_result' => Moneda::obtenerDivisa($div_s),
                        'factor' => $divisa_factor['df_factor']
                    ];
                } else {
                    $conversion = [
                        'divisa_conv' => Moneda::obtenerDivisa($div_p),
                        'divisa_result' => Moneda::obtenerDivisa($div_s),
                        'factor' => 1
                    ];
                }

                Http::json_response($conversion);
            } else {
                Http::json_response(false);
            }
        }
    }

    public function obtenerAgenteVenta()
    {
        $newAgent = new EmpleadoInfo();
        Http::json_response($newAgent->agentesventa());
    }

    public function obtenerComisiones()
    {
        $new_comisiones = new Comisiones();
        $comisiones = $new_comisiones->todos();
        Http::json_response($comisiones);
    }

    public function obtenerComisionesactivas()
    {
        $new_comisiones = new Comisiones();
        $comisiones = $new_comisiones->obtenerComisionesactivas();
        Http::json_response($comisiones);
    }

    public function eliminarComisionPendiente(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $new_comis = new EmpleadosComisionesEmplAgente();

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if ($new_comis->existe('comagentefn_id', $id)) {
                Http::json_response($new_comis->eliminar($id));
            } else {
                Http::json_response(false);
            }
        }
    }
}
