<div class="card" :class="cargando_tabla">
    <div class="card-body">
        <form @submit.prevent="buscarVentaProvee()" id="form_proven_busqueda">
            <div class="form-row">
                <div class="col-sm-4">
                    <div class="form-group form-floating-label">
                        <input id="pvfecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha_desde">
                        <label for="pvfecha_desde" class="placeholder">Fecha desde</label>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group input-group form-floating-label">
                        <input id="pvfecha_hasta" type="date" class="form-control input-border-bottom" v-model="fecha_hasta">
                        <label for="pvfecha_hasta" class="placeholder">Fecha hasta</label>
                        <div class="input-group-append">
                            <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                        </div>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group input-group form-floating-label">
                        <select id="proveedor" v-model="proveedor" class="form-control input-border-bottom">
                            <option disabled value="">Seleccione un elemento</option>
                            <option value="0">Todos</option>
                            <option v-for="row in proveedores" :value="row.prov_id">{{row.prov_razonsocial}}</option>
                        </select>
                        <label for="proveedor" class="placeholder">Proveedor</label>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                        {{ row }}
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card" :class="cargando_tabla">
    <div class="card-body">
        <div class="table-responsive">
            <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tab_provee">
                <thead>
                    <tr>
                        <th style="width: 25%;" class="text-left">Proveedor</th>
                        <th class="text-right">Costo</th>
                        <th class="text-right">Venta</th>
                        <th class="text-right">Ganancia</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <tr v-for="row in totalproveedores.proveedores">
                        <td class="text-left">{{ row.proveedor }}</td>
                        <td class="text-right">{{ moneda(row.costo, row.div_locale, row.div_simbolo) }}</td>
                        <td class="text-right">{{ moneda(row.venta, row.div_locale, row.div_simbolo) }}</td>
                        <td class="text-right">{{ moneda(row.ganancia, row.div_locale, row.div_simbolo) }}</td>
                        <td>
                            <button class="btn btn-border btn-info btn-sm btn-round" type="button" @click="lists_productos(row.proveedor_id)"><i class="fa fa-cubes"></i> Productos</button>
                        </td>
                    </tr>
                </tbody>
                <tfoot>
                    <tr>
                        <th class="text-center">Total</th>
                        <th class="text-right"></th>
                        <th class="text-right"></th>
                        <th class="text-right"></th>
                        <th class="text-right"></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>