<div class="row">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-body">
                <form @submit.prevent="buscarProductoVendidoSimple($event)" id="form_proven_busqueda">
                    <div class="form-row">
                        <div class="col-sm-6">
                            <div class="form-group form-floating-label">
                                <input id="pvfecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha_desde">
                                <label for="pvfecha_desde" class="placeholder">Fecha desde</label>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group input-group form-floating-label">
                                <input id="pvfecha_hasta" type="date" class="form-control input-border-bottom" v-model="fecha_hasta">
                                <label for="pvfecha_hasta" class="placeholder">Fecha hasta</label>
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <div class="form-group input-group form-floating-label">
                                <select id="pvdivisass" class="form-control input-border-bottom" v-model="divisa">
                                    <option value="0">Todas</option>
                                    <?php foreach ($divisas as $row) : ?>
                                        <option value="<?= $row['div_id'] ?>" <?= ($row['div_predeterminado'] == 1) ? 'selected' : '' ?>><?= $row['div_descripcion'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="pvdivisas" class="placeholder">Divisa</label>
                                <div class="input-group-append">
                                    <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="row row-card-no-pd">
            <div class="col-sm-6 col-md-4">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-success">
                            <br>
                        </div>
                        <div class="h2 m-0 text-primary">
                            <i class="loader loader-success" v-if="cargando"></i>
                            <span v-else> {{ cantidad_articulosS }} </span>
                        </div>
                        <div class="text-primary mb-3">Articulos</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-4">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-success">
                            <br>
                        </div>
                        <div class="h2 m-0">
                            <i class="loader loader-success" v-if="cargando"></i>
                            <span v-else> {{ artic_totalS }}</span>
                        </div>
                        <div class="mb-3">Articulos vendidos</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-4">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            <br>
                        </div>
                        <div class="h2 m-0">
                            <i class="loader loader-success" v-if="cargando"></i>
                            <span v-else>{{ venta_totalS }}</span>
                        </div>
                        <div class="mb-3">Total venta</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-body" :class="cargando_tabla">
                <div class="table-responsive">
                    <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tab_pro_ven_simpl">
                        <thead>
                            <tr>
                                <th style="width: 25%;" class="text-left">Producto</th>
                                <th class="text-center">Divisa</th>
                                <th class="text-center">Cantidad</th>
                                <th class="text-right">Pventa</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in productosVendidoSimples">
                                <td class="text-left">{{ row.pro_descripcion }}</td>
                                <td class="text-left">{{ row.div_nombre }}</td>
                                <td class="text-center">{{ row.cantidad }}</td>
                                <td class="text-right">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>