<div class="row">
    <div class="col-lg-12">
        <div class="row row-card-no-pd">
            <div class="col-sm-12 col-md-4" v-for="row in clipp.divisas_totales">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-4">
                                <div class="icon-big text-center">
                                    <i class="flaticon-coins text-success"></i>
                                </div>
                            </div>
                            <div class="col-8 col-stats">
                                <div class="numbers">
                                    <p class="card-category">Total pendiente</p>
                                    <h4 class="card-title">
                                        {{moneda(row.total, row.div_locale, row.div_simbolo)}}
                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-12">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <div class="card-head-row">
                            <div class="card-title">Notas de entrega pendientes</div>
                            <div class="card-tools" v-for="row in clipp.totales_divisas_not">
                                <div class="text-right">
                                    <h6 class="fw-bold text-uppercase text-success op-8">{{row.div_nombre}}</h6>
                                    <h3 class="fw-bold">{{moneda(row.total, row.div_locale, row.div_simbolo)}}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_notas_pendientes">
                                <thead>
                                    <tr>
                                        <th class="text-left">Documento</th>
                                        <th class="text-left">Agente</th>
                                        <th class="text-left">ID Cliente</th>
                                        <th class="text-left">Cliente</th>
                                        <th class="text-left">ID Grupo</th>
                                        <th class="text-left">Grupo</th>
                                        <th class="text-left">Divisa</th>
                                        <th class="text-right">Total</th>
                                        <th class="text-right">Acumulado</th>
                                        <th class="text-right">Pendiente</th>
                                        <th>Fecha</th>
                                        <th>Sucursal</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in clipp.notas_pendiente">
                                        <td class="text-left"><a :href="'<?= ruta_base(); ?>'+row.url">{{row.tipo}}</a></td>
                                        <td class="text-left">{{row.agente}}</td>
                                        <td class="text-left">{{row.id_cliente}}</td>
                                        <td class="text-left">{{row.nombrecompl}}</td>
                                        <td class="text-left">{{row.id_grupo}}</td>
                                        <td class="text-left">{{row.grupo}}</td>
                                        <td class="text-left">{{row.divisa}}</td>
                                        <td class="text-right">{{moneda(row.total,row.div_locale,row.div_simbolo)}}</td>
                                        <td class="text-right">{{moneda(row.acumulado,row.div_locale,row.div_simbolo)}}</td>
                                        <td class="text-right">{{moneda(row.pendiente,row.div_locale,row.div_simbolo)}}</td>
                                        <td>{{row.fecha}}</td>
                                        <td>{{row.sucursal}}</td>
                                        <td class="text-center">
                                            <div class="form-button-action">
                                                <div class="input-group-append">
                                                    <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                    <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                        <a class="dropdown-item" :href="'<?= ruta_base(); ?>'+'notasdeentregaeditar/verFactura/'+row.id" target="_blank">ver</a>
                                                        <div role="separator" class="dropdown-divider"></div>
                                                        <a class="dropdown-item" :href="'<?= ruta_base(); ?>'+'notasdeentregaeditar/pdf/'+row.id" target="_blank">PDF completo</a>
                                                        <a class="dropdown-item" :href="'<?= ruta_base(); ?>'+'notasdeentregaeditar/pdfMP/'+row.id" target="_blank">PDF media pagina</a>
                                                        <a class="dropdown-item" :href="'<?= ruta_base(); ?>'+'notasdeentregaeditar/pdfFMP/'+row.id" target="_blank">PDF pagos</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <div class="card-head-row">
                            <div class="card-title">Facturas pendientes</div>
                            <div class="card-tools" v-for="row in clipp.totales_divisas_fac">
                                <div class="text-right">
                                    <h6 class="fw-bold text-uppercase text-success op-8">{{row.div_nombre}}</h6>
                                    <h3 class="fw-bold">{{moneda(row.total, row.div_locale, row.div_simbolo)}}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_factura_pendientes">
                                <thead>
                                    <tr>
                                        <th class="text-left">Documento</th>
                                        <th class="text-left">Agente</th>
                                        <th class="text-left">ID Cliente</th>
                                        <th class="text-left">Cliente</th>
                                        <th class="text-left">ID Grupo</th>
                                        <th class="text-left">Grupo</th>
                                        <th class="text-left">Divisa</th>
                                        <th class="text-right">Total</th>
                                        <th class="text-right">Acumulado</th>
                                        <th class="text-right">Pendiente</th>
                                        <th>Fecha</th>
                                        <th>Sucursal</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in clipp.facturas_pendiente">
                                        <td class="text-left"><a :href="'<?= ruta_base(); ?>'+row.url">{{row.tipo}}</a></td>
                                        <td class="text-left">{{row.agente}}</td>
                                        <td class="text-left">{{row.id_cliente}}</td>
                                        <td class="text-left">{{row.nombrecompl}}</td>
                                        <td class="text-left">{{row.id_grupo}}</td>
                                        <td class="text-left">{{row.grupo}}</td>
                                        <td class="text-left">{{row.divisa}}</td>
                                        <td class="text-right">{{moneda(row.total,row.div_locale,row.div_simbolo)}}</td>
                                        <td class="text-right">{{moneda(row.acumulado,row.div_locale,row.div_simbolo)}}</td>
                                        <td class="text-right">{{moneda(row.pendiente,row.div_locale,row.div_simbolo)}}</td>
                                        <td>{{row.fecha}}</td>
                                        <td>{{row.sucursal}}</td>
                                        <td class="text-center">
                                            <div class="form-button-action">
                                                <div class="input-group-append">
                                                    <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                    <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                        <a class="dropdown-item" :href="'<?= ruta_base(); ?>'+'poseditar/verFactura/'+row.id" target="_blank">ver</a>
                                                        <div role="separator" class="dropdown-divider"></div>
                                                        <a class="dropdown-item" :href="'<?= ruta_base(); ?>'+'poseditar/pdf/'+row.id" target="_blank">PDF completo</a>
                                                        <a class="dropdown-item" :href="'<?= ruta_base(); ?>'+'poseditar/pdfMP/'+row.id" target="_blank">PDF media pagina</a>
                                                        <a class="dropdown-item" :href="'<?= ruta_base(); ?>'+'poseditar/pdfFMP/'+row.id" target="_blank">PDF pagos</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <div class="card-head-row">
                            <div class="card-title">Orden de entrega pendientes</div>
                            <div class="card-tools" v-for="row in clipp.totales_divisas_ord">
                                <div class="text-right">
                                    <h6 class="fw-bold text-uppercase text-success op-8">{{row.div_nombre}}</h6>
                                    <h3 class="fw-bold">{{moneda(row.total, row.div_locale, row.div_simbolo)}}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_ordenes_pendientes">
                                <thead>
                                    <tr>
                                        <th class="text-left">Documento</th>
                                        <th class="text-left">Agente</th>
                                        <th class="text-left">ID Cliente</th>
                                        <th class="text-left">Cliente</th>
                                        <th class="text-left">ID Grupo</th>
                                        <th class="text-left">Grupo</th>
                                        <th class="text-left">Divisa</th>
                                        <th class="text-right">Total</th>
                                        <th class="text-right">Acumulado</th>
                                        <th class="text-right">Pendiente</th>
                                        <th>Fecha</th>
                                        <th>Sucursal</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in clipp.ordenes_pendientes">
                                        <td class="text-left"><a :href="'<?= ruta_base(); ?>'+row.url">{{row.tipo}}</a></td>
                                        <td class="text-left">{{row.agente}}</td>
                                        <td class="text-left">{{row.id_cliente}}</td>
                                        <td class="text-left">{{row.nombrecompl}}</td>
                                        <td class="text-left">{{row.id_grupo}}</td>
                                        <td class="text-left">{{row.grupo}}</td>
                                        <td class="text-left">{{row.divisa}}</td>
                                        <td class="text-right">{{moneda(row.total,row.div_locale,row.div_simbolo)}}</td>
                                        <td class="text-right">{{moneda(row.acumulado,row.div_locale,row.div_simbolo)}}</td>
                                        <td class="text-right">{{moneda(row.pendiente,row.div_locale,row.div_simbolo)}}</td>
                                        <td>{{row.fecha}}</td>
                                        <td>{{row.sucursal}}</td>
                                        <td class="text-center">
                                            <div class="form-button-action">
                                                <div class="input-group-append">
                                                    <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                    <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                        <a class="dropdown-item" :href="'<?= ruta_base(); ?>'+'ordendeentregaeditar/verFactura/'+row.id" target="_blank">ver</a>
                                                        <div role="separator" class="dropdown-divider"></div>
                                                        <a class="dropdown-item" :href="'<?= ruta_base(); ?>'+'ordendeentregaeditar/pdf/'+row.id" target="_blank">PDF completo</a>
                                                        <a class="dropdown-item" :href="'<?= ruta_base(); ?>'+'ordendeentregaeditar/pdfMP/'+row.id" target="_blank">PDF media pagina</a>
                                                        <a class="dropdown-item" :href="'<?= ruta_base(); ?>'+'ordendeentregaeditar/pdfFMP/'+row.id" target="_blank">PDF pagos</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>