<?php

namespace App\Controladores;

use App\Modelos\Fabricantes;
use Core\Controller;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Vista;

final class FabricantesControlador extends Controller
{
    private $fabricantes_model;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->module = new Module('fabricantes');
        $this->fabricantes_model = new Fabricantes();
    }

    public function index()
    {
        return Vista::view('fabricantes/index');
    }

    public function obtenerFabricantes()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $list_fabri = [];
            $fabricantes = $this->fabricantes_model->obtenerFabricantes();
            if (is_countable($fabricantes) && count($fabricantes)) {
                foreach ($fabricantes as $row) {
                    $list_fabri[] = [
                        'id' => $row['fa_id'],
                        'codigo' => $row['fa_codigo'],
                        'nombre' => $row['fa_nombre']
                    ];
                }
            }
            Http::json_response($list_fabri);
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['codigo']))
                $this->array_errors[] = "El campo Código es obligatorio.";
            if (empty($_POST['descripcion']))
                $this->array_errors[] = "El campo Descripción es obligatorio.";

            if (empty($this->array_errors)) {

                $fa_codigo  = filter_input(INPUT_POST, 'codigo', FILTER_SANITIZE_STRING);
                $fa_nombre  = $this->solicitud->sanitize($_POST['descripcion'], FILTER_SANITIZE_STRING);

                if (!empty($_POST['id'])) {

                    $fa_id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);

                    if ($this->fabricantes_model->existe('fa_id', $fa_id)) {

                        if ($this->fabricantes_model->where(['fa_id<>' => $fa_id, 'fa_codigo' => $fa_codigo]))
                            $this->array_errors[] = 'Lo siento ya existe un fabricante con el mismo código';

                        if ($this->fabricantes_model->where(['fa_id<>' => $fa_id, 'fa_nombre' => $fa_nombre]))
                            $this->array_errors[] = 'Lo siento ya existe un fabricante con el mismo nombre';

                        if (empty($this->array_errors)) {
                            Http::json_response($this->fabricantes_model->editar($fa_id, [
                                'fa_codigo' => $fa_codigo,
                                'fa_nombre' => $fa_nombre
                            ]));
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {

                    if ($this->fabricantes_model->where(['fa_codigo' => $fa_codigo]))
                        $this->array_errors[] = 'Lo siento ya existe un fabricante con el mismo código';

                    if ($this->fabricantes_model->where(['fa_nombre' => $fa_nombre]))
                        $this->array_errors[] = 'Lo siento ya existe un fabricante con el mismo nombre';

                    if (empty($this->array_errors)) {
                        Http::json_response($this->fabricantes_model->guardar([
                            'fa_codigo' => $fa_codigo,
                            'fa_nombre' => $fa_nombre
                        ], true));
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminar(int $id_fab)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($id_fab, FILTER_SANITIZE_NUMBER_INT);

            if ($this->fabricantes_model->existe('fa_id', $id)) {
                if ($this->fabricantes_model->chequearForanea($id)) {
                    $this->array_errors[] = 'El fabricante no puede ser ELIMINADO ya que se encuentra relacionado con algun producto.';
                } else {
                    Http::json_response($this->fabricantes_model->eliminar($id));
                }
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }
}
