<form autocomplete="off" id="modal_form_pagar_comisiones" @submit.prevent="pagarComisiones">
    <div class="modal fade" id="modal-pagarComisiones" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header border-top-0 border-bottom-0">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col">
                            <div id="contenerdor_campos_pagar">
                                <div class="form-group form-floating-label">
                                    <select class="form-control input-border-bottom" id="pagardivisa_comisiones" @change="obtenerMetodosDivisaComisionesSeleccionadas">
                                        <option value="" disabled selected>SELECCIONAR UNA OPCIÓN</option>
                                        <?php foreach ($divisas as $row) : ?>
                                            <option value="<?= $row['div_id'] ?>"><?= $row['div_nombre'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <label for="pagardivisa_comisiones" class="placeholder">Divisa</label>
                                </div>
                                <div class="form-group form-floating-label">
                                    <select class="form-control input-border-bottom" id="pagarmetodo_comisiones" @change="obtenerCuentasSegunMetodo">
                                        <option value="" disabled selected>SELECCIONAR UNA OPCIÓN</option>
                                        <option v-for="metodo in metodos_pg" :value="metodo.md_id">{{metodo.mp_nombre}}</option>
                                    </select>
                                    <label for="pagarmetodo_comisiones" class="placeholder">Metodo de pago</label>
                                </div>
                                <div class="form-group form-floating-label">
                                    <select class="form-control input-border-bottom" id="pagarcuenta_comisiones">
                                        <option value="" disabled selected>SELECCIONAR UNA OPCIÓN</option>
                                        <option v-for="cuenta in cuentas_pg" :value="cuenta.cmp_id">{{ cuenta.bc_alias }} - {{ cuenta.bc_tipo }} - {{ cuenta.ban_codigo }}</option>
                                    </select>
                                    <label for="pagarcuenta_comisiones" class="placeholder">Cuenta</label>
                                </div>
                            </div>
                            <div class="form-group">
                                <input id="monto_total_sin_conversion_comisiones" type="text" class="form-control input-border-bottom text-right" disabled="true">
                                <label for="monto_total_sin_conversion_comisiones" class="placeholder">Monto</label>
                            </div>
                            <div class="form-group">
                                <input id="monto_total_con_conversion_comisiones" type="text" class="form-control input-border-bottom text-right" disabled="true">
                                <label for="monto_total_con_conversion_comisiones" class="placeholder">Monto a pagar</label>
                            </div>
                            <div class="col mt-3">
                                <button class="btn btn-primary btn-round btn-block" disabled v-if="cargando">
                                    <i class="loader loader-info"></i>
                                </button>
                                <button type="submit" class="btn btn-primary btn-round btn-block" v-else>pagar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>