<form action="#" autocomplete="off" @submit.prevent="guardarComisionEmpleadoDocumento" id="form_modal_documentos">
    <div class="modal fade" id="modal_documentos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Agregar documento</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="doc_asig" name="doc_asig">
                    <div class="form-group form-group-default">
                        <label for="documentos">Comisiones:</label>
                        <select id="documentos" name="documentos" class="form-control">
                            <option value="" disabled selected>Seleccione una opción</option>
                            <option :value="row.id" v-for="row in documentos">{{ row.prefijo }} - {{ row.descripcion }}</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="documentoFijo">Fijo</label>
                        <select id="documentoFijo" name="documentoFijo" class="form-control">
                            <option value="1" selected>SI</option>
                            <option value="2">NO</option>
                        </select>
                    </div>
                    <div v-for="row in errorFormComEmpDoc" class="alert alert-warning">
                        {{ row }}
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary  btn-sm" data-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary  btn-sm">Guardar</button>
                </div>
                <div class="modal-footer">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Documento</th>
                                    <th>Fijo</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="row in documentos_asignados">
                                    <td>{{ row.prefijo }} {{ row.descripcion }}</td>
                                    <td>
                                        <span v-if="row.fijo == 1">SI</span>
                                        <span v-else>NO</span>
                                    </td>
                                    <td class="text-center">
                                        <div class="form-button-action">
                                            <button type="button" title="Editar" class="btn btn-link btn-primary" @click="editarDocAsignado(row)">
                                                <i class="fa fa-edit text-info"></i>
                                            </button>
                                            <button type="button" title="Eliminar" class="btn btn-link btn-primary" @click="eliminarDocAsignado(row)">
                                                <i class="fa fa-trash text-dark"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>